/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.apputils.vim25;

import com.vmware.apputils.AppUtil;
import com.vmware.apputils.vim25.ServiceConnection;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.ObjectUpdate;
import com.vmware.vim25.ObjectUpdateKind;
import com.vmware.vim25.PropertyChange;
import com.vmware.vim25.PropertyChangeOp;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertyFilterUpdate;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.SelectionSpec;
import com.vmware.vim25.TaskInfo;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.TraversalSpec;
import com.vmware.vim25.UpdateSet;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.axis.AxisFault;
import org.w3c.dom.Element;

public class ServiceUtil {
    private AppUtil _cb;
    private ServiceConnection _connection;
    static String[] meTree = new String[]{"ManagedEntity", "ComputeResource", "ClusterComputeResource", "Datacenter", "Folder", "HostSystem", "ResourcePool", "VirtualMachine"};
    static String[] crTree = new String[]{"ComputeResource", "ClusterComputeResource"};
    static String[] hcTree = new String[]{"HistoryCollector", "EventHistoryCollector", "TaskHistoryCollector"};

    public static ServiceUtil CreateServiceUtil() {
        return new ServiceUtil();
    }

    public void init(AppUtil appUtil, ServiceConnection serviceConnection) throws Exception {
        this._cb = appUtil;
        this._connection = serviceConnection;
    }

    public void clientConnect() throws Exception {
        try {
            if (this._cb.option_is_set("ignorecert")) {
                this._connection.connect(this._cb.getServiceUrl(), this._cb.getUsername(), this._cb.getPassword(), true);
            } else {
                this._connection.connect(this._cb.getServiceUrl(), this._cb.getUsername(), this._cb.getPassword(), false);
            }
        }
        catch (Exception exception) {
            this._cb.getUtil().logException(exception);
            throw exception;
        }
    }

    public void clientLoadSession(String string) throws Exception {
        try {
            this._connection.loadSession(this._cb.getServiceUrl(), string);
        }
        catch (Exception exception) {
            this._cb.getUtil().logException(exception);
            throw exception;
        }
    }

    public void clientSaveSession(String string) throws Exception {
        try {
            this._connection.saveSession(string);
        }
        catch (Exception exception) {
            this._cb.getUtil().logException(exception);
            throw exception;
        }
    }

    public void clientDisconnect() throws Exception {
        try {
            this._connection.disconnect();
        }
        catch (Exception exception) {
            this._cb.getUtil().logException(exception);
            throw exception;
        }
    }

    boolean typeIsA(String string, String string2) {
        block5: {
            block6: {
                block4: {
                    if (string.equals(string2)) {
                        return true;
                    }
                    if (!string.equals("ManagedEntity")) break block4;
                    for (int i = 0; i < meTree.length; ++i) {
                        if (!meTree[i].equals(string2)) continue;
                        return true;
                    }
                    break block5;
                }
                if (!string.equals("ComputeResource")) break block6;
                for (int i = 0; i < crTree.length; ++i) {
                    if (!crTree[i].equals(string2)) continue;
                    return true;
                }
                break block5;
            }
            if (!string.equals("HistoryCollector")) break block5;
            for (int i = 0; i < hcTree.length; ++i) {
                if (!hcTree[i].equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public ManagedObjectReference getDecendentMoRef(ManagedObjectReference managedObjectReference, String string, String string2) throws Exception {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        String[][] stringArray = new String[][]{{string, "name"}};
        ObjectContent[] objectContentArray = this.getContentsRecursively(null, managedObjectReference, stringArray, true);
        if (objectContentArray == null || objectContentArray.length == 0) {
            return null;
        }
        ObjectContent objectContent = null;
        ManagedObjectReference managedObjectReference2 = null;
        DynamicProperty[] dynamicPropertyArray = null;
        String string3 = null;
        boolean bl = false;
        for (int i = 0; i < objectContentArray.length && !bl; ++i) {
            objectContent = objectContentArray[i];
            managedObjectReference2 = objectContent.getObj();
            dynamicPropertyArray = objectContent.getPropSet();
            string3 = null;
            if (string != null && !this.typeIsA(string, managedObjectReference2.getType())) continue;
            if (dynamicPropertyArray.length > 0) {
                string3 = (String)dynamicPropertyArray[0].getVal();
            }
            bl = string3 != null && string2.equals(string3);
        }
        if (!bl) {
            managedObjectReference2 = null;
        }
        return managedObjectReference2;
    }

    public ManagedObjectReference getFirstDecendentMoRef(ManagedObjectReference managedObjectReference, String string) throws Exception {
        ArrayList arrayList = this.getDecendentMoRefs(managedObjectReference, string);
        ManagedObjectReference managedObjectReference2 = null;
        if (arrayList.size() > 0) {
            managedObjectReference2 = (ManagedObjectReference)arrayList.get(0);
        }
        return managedObjectReference2;
    }

    public ArrayList getDecendentMoRefs(ManagedObjectReference managedObjectReference, String string) throws Exception {
        ArrayList arrayList = this.getDecendentMoRefs(managedObjectReference, string, null);
        return arrayList;
    }

    public ArrayList getDecendentMoRefs(ManagedObjectReference managedObjectReference, String string, String[][] stringArray) throws Exception {
        String[][] stringArray2 = new String[][]{{string, "name"}};
        ObjectContent[] objectContentArray = this.getContentsRecursively(null, managedObjectReference, stringArray2, true);
        ArrayList<ManagedObjectReference> arrayList = new ArrayList<ManagedObjectReference>();
        if (objectContentArray == null || objectContentArray.length == 0) {
            return arrayList;
        }
        for (int i = 0; i < objectContentArray.length; ++i) {
            arrayList.add(objectContentArray[i].getObj());
        }
        if (stringArray != null) {
            ArrayList arrayList2 = this.filterMOR(arrayList, stringArray);
            return arrayList2;
        }
        return arrayList;
    }

    private ArrayList filterMOR(ArrayList arrayList, String[][] stringArray) throws Exception {
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            boolean bl = true;
            Object var6_6 = null;
            for (int j = 0; j < stringArray.length; ++j) {
                String string = stringArray[j][0];
                String string2 = stringArray[j][1];
                String string3 = this.getProp((ManagedObjectReference)arrayList.get(i), string);
                if (string2 == null || string3 == null && string2 == null) continue;
                if (string3 == null && string2 != null) {
                    bl = false;
                    j = stringArray.length + 1;
                    continue;
                }
                if (string3.equalsIgnoreCase(string2)) continue;
                bl = false;
                j = stringArray.length + 1;
            }
            if (!bl) continue;
            arrayList2.add(arrayList.get(i));
        }
        return arrayList2;
    }

    private String getProp(ManagedObjectReference managedObjectReference, String string) {
        String string2 = null;
        try {
            string2 = (String)this.getDynamicProperty(managedObjectReference, string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public ObjectContent[] getAllContainerContents() throws Exception {
        ObjectContent[] objectContentArray = this.getContentsRecursively(null, true);
        return objectContentArray;
    }

    public ObjectContent[] getContentsRecursively(ManagedObjectReference managedObjectReference, boolean bl) throws Exception {
        String[][] stringArray = new String[][]{{"ManagedEntity"}};
        ObjectContent[] objectContentArray = this.getContentsRecursively(null, managedObjectReference, stringArray, bl);
        return objectContentArray;
    }

    public ObjectContent[] getContentsRecursively(ManagedObjectReference managedObjectReference, ManagedObjectReference managedObjectReference2, String[][] stringArray, boolean bl) throws Exception {
        ManagedObjectReference managedObjectReference3;
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        ManagedObjectReference managedObjectReference4 = managedObjectReference;
        if (managedObjectReference4 == null) {
            managedObjectReference4 = this._connection.getPropCol();
        }
        if ((managedObjectReference3 = managedObjectReference2) == null) {
            managedObjectReference3 = this._connection.getRootFolder();
        }
        SelectionSpec[] selectionSpecArray = null;
        if (bl) {
            selectionSpecArray = this.buildFullTraversal();
        }
        PropertySpec[] propertySpecArray = this.buildPropertySpecArray(stringArray);
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec(null, null, propertySpecArray, new ObjectSpec[]{new ObjectSpec(null, null, managedObjectReference3, Boolean.FALSE, selectionSpecArray)}, null);
        ObjectContent[] objectContentArray = this._connection.getService().retrieveProperties(managedObjectReference4, new PropertyFilterSpec[]{propertyFilterSpec});
        return objectContentArray;
    }

    public ManagedObjectReference getMoRefProp(ManagedObjectReference managedObjectReference, String string) throws Exception {
        Object object = this.getDynamicProperty(managedObjectReference, string);
        ManagedObjectReference managedObjectReference2 = null;
        if (!object.getClass().isArray()) {
            managedObjectReference2 = (ManagedObjectReference)object;
        }
        return managedObjectReference2;
    }

    public ObjectContent[] getObjectProperties(ManagedObjectReference managedObjectReference, ManagedObjectReference managedObjectReference2, String[] stringArray) throws Exception {
        if (managedObjectReference2 == null) {
            return null;
        }
        ManagedObjectReference managedObjectReference3 = managedObjectReference;
        if (managedObjectReference3 == null) {
            managedObjectReference3 = this._connection.getPropCol();
        }
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.setPropSet(new PropertySpec[]{new PropertySpec()});
        propertyFilterSpec.getPropSet(0).setAll(new Boolean(stringArray == null || stringArray.length == 0));
        propertyFilterSpec.getPropSet(0).setType(managedObjectReference2.getType());
        propertyFilterSpec.getPropSet(0).setPathSet(stringArray);
        propertyFilterSpec.setObjectSet(new ObjectSpec[]{new ObjectSpec()});
        propertyFilterSpec.getObjectSet(0).setObj(managedObjectReference2);
        propertyFilterSpec.getObjectSet(0).setSkip(Boolean.FALSE);
        return this._connection.getService().retrieveProperties(managedObjectReference3, new PropertyFilterSpec[]{propertyFilterSpec});
    }

    public Object getDynamicProperty(ManagedObjectReference managedObjectReference, String string) throws Exception {
        DynamicProperty[] dynamicPropertyArray;
        ObjectContent[] objectContentArray = this.getObjectProperties(null, managedObjectReference, new String[]{string});
        Object object = null;
        if (objectContentArray != null && (dynamicPropertyArray = objectContentArray[0].getPropSet()) != null) {
            Object object2 = dynamicPropertyArray[0].getVal();
            String string2 = object2.getClass().getName();
            if (string2.indexOf("ArrayOf") != -1) {
                String string3 = string2.substring(string2.indexOf("ArrayOf") + "ArrayOf".length(), string2.length());
                string3 = this.methodExists(object2, "get" + string3, null) ? "get" + string3 : "get_" + string3.toLowerCase();
                Method method = object2.getClass().getDeclaredMethod(string3, null);
                object = method.invoke(object2, (Object[])null);
            } else {
                object = object2.getClass().isArray() ? object2 : object2;
            }
        }
        return object;
    }

    public String waitForTask(ManagedObjectReference managedObjectReference) throws Exception {
        Object[] objectArray = this.waitForValues(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.success, TaskInfoState.error}});
        if (objectArray[0].equals(TaskInfoState.success)) {
            return "sucess";
        }
        TaskInfo taskInfo = (TaskInfo)this.getDynamicProperty(managedObjectReference, "info");
        LocalizedMethodFault localizedMethodFault = taskInfo.getError();
        String string = "Error Occured";
        if (localizedMethodFault != null) {
            string = localizedMethodFault.getFault().getFaultReason();
            System.out.println("Fault " + localizedMethodFault.getFault().getFaultCode());
            System.out.println("Message " + localizedMethodFault.getLocalizedMessage());
        }
        return string;
    }

    public Object[] waitForValues(ManagedObjectReference managedObjectReference, String[] stringArray, String[] stringArray2, Object[][] objectArray) throws Exception {
        String string = "";
        Object[] objectArray2 = new Object[stringArray2.length];
        Object[] objectArray3 = new Object[stringArray.length];
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.setObjectSet(new ObjectSpec[]{new ObjectSpec()});
        propertyFilterSpec.getObjectSet(0).setObj(managedObjectReference);
        propertyFilterSpec.setPropSet(new PropertySpec[]{new PropertySpec()});
        propertyFilterSpec.getPropSet(0).setPathSet(stringArray);
        propertyFilterSpec.getPropSet(0).setType(managedObjectReference.getType());
        propertyFilterSpec.getObjectSet(0).setSelectSet(null);
        propertyFilterSpec.getObjectSet(0).setSkip(Boolean.FALSE);
        ManagedObjectReference managedObjectReference2 = this._connection.getService().createFilter(this._connection.getPropCol(), propertyFilterSpec, true);
        boolean bl = false;
        UpdateSet updateSet = null;
        PropertyFilterUpdate[] propertyFilterUpdateArray = null;
        PropertyFilterUpdate propertyFilterUpdate = null;
        ObjectUpdate[] objectUpdateArray = null;
        ObjectUpdate objectUpdate = null;
        PropertyChange[] propertyChangeArray = null;
        PropertyChange propertyChange = null;
        while (!bl) {
            boolean bl2 = true;
            while (bl2) {
                try {
                    updateSet = this._connection.getService().waitForUpdates(this._connection.getPropCol(), string);
                    bl2 = false;
                }
                catch (Exception exception) {
                    if (!(exception instanceof AxisFault)) continue;
                    AxisFault axisFault = (AxisFault)exception;
                    Element[] elementArray = axisFault.getFaultDetails();
                    String string2 = axisFault.getFaultString();
                    if (string2.indexOf("java.net.SocketTimeoutException") != -1) {
                        System.out.println("Retrying2........");
                        bl2 = true;
                        continue;
                    }
                    throw exception;
                }
            }
            string = updateSet.getVersion();
            if (updateSet == null || updateSet.getFilterSet() == null) continue;
            propertyFilterUpdateArray = updateSet.getFilterSet();
            propertyFilterUpdate = null;
            for (int i = 0; i < propertyFilterUpdateArray.length; ++i) {
                propertyFilterUpdate = propertyFilterUpdateArray[i];
                objectUpdateArray = propertyFilterUpdate.getObjectSet();
                objectUpdate = null;
                propertyChangeArray = null;
                for (int j = 0; j < objectUpdateArray.length; ++j) {
                    objectUpdate = objectUpdateArray[j];
                    if (objectUpdate.getKind() != ObjectUpdateKind.modify && objectUpdate.getKind() != ObjectUpdateKind.enter && objectUpdate.getKind() != ObjectUpdateKind.leave) continue;
                    propertyChangeArray = objectUpdate.getChangeSet();
                    for (int k = 0; k < propertyChangeArray.length; ++k) {
                        propertyChange = propertyChangeArray[k];
                        this.updateValues(stringArray2, objectArray2, propertyChange);
                        this.updateValues(stringArray, objectArray3, propertyChange);
                    }
                }
            }
            Object object = null;
            for (int i = 0; i < objectArray2.length && !bl; ++i) {
                for (int j = 0; j < objectArray[i].length && !bl; ++j) {
                    object = objectArray[i][j];
                    bl = object.equals(objectArray2[i]) || bl;
                }
            }
        }
        this._connection.getService().destroyPropertyFilter(managedObjectReference2);
        return objectArray3;
    }

    protected void updateValues(String[] stringArray, Object[] objectArray, PropertyChange propertyChange) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (propertyChange.getName().lastIndexOf(stringArray[i]) < 0) continue;
            objectArray[i] = propertyChange.getOp() == PropertyChangeOp.remove ? "" : propertyChange.getVal();
        }
    }

    public SelectionSpec[] buildFullTraversal() {
        TraversalSpec traversalSpec = new TraversalSpec(null, null, null, "ResourcePool", "resourcePool", Boolean.FALSE, new SelectionSpec[]{new SelectionSpec(null, null, "rpToRp"), new SelectionSpec(null, null, "rpToVm")});
        traversalSpec.setName("rpToRp");
        TraversalSpec traversalSpec2 = new TraversalSpec(null, null, null, "ResourcePool", "vm", Boolean.FALSE, new SelectionSpec[0]);
        traversalSpec2.setName("rpToVm");
        TraversalSpec traversalSpec3 = new TraversalSpec(null, null, null, "ComputeResource", "resourcePool", Boolean.FALSE, new SelectionSpec[]{new SelectionSpec(null, null, "rpToRp"), new SelectionSpec(null, null, "rpToVm")});
        traversalSpec3.setName("crToRp");
        TraversalSpec traversalSpec4 = new TraversalSpec(null, null, null, "ComputeResource", "host", Boolean.FALSE, new SelectionSpec[0]);
        traversalSpec4.setName("crToH");
        TraversalSpec traversalSpec5 = new TraversalSpec(null, null, null, "Datacenter", "hostFolder", Boolean.FALSE, new SelectionSpec[]{new SelectionSpec(null, null, "visitFolders")});
        traversalSpec5.setName("dcToHf");
        TraversalSpec traversalSpec6 = new TraversalSpec(null, null, null, "Datacenter", "vmFolder", Boolean.FALSE, new SelectionSpec[]{new SelectionSpec(null, null, "visitFolders")});
        traversalSpec6.setName("dcToVmf");
        TraversalSpec traversalSpec7 = new TraversalSpec(null, null, null, "HostSystem", "vm", Boolean.FALSE, new SelectionSpec[]{new SelectionSpec(null, null, "visitFolders")});
        traversalSpec7.setName("HToVm");
        TraversalSpec traversalSpec8 = new TraversalSpec(null, null, null, "Folder", "childEntity", Boolean.FALSE, new SelectionSpec[]{new SelectionSpec(null, null, "visitFolders"), new SelectionSpec(null, null, "dcToHf"), new SelectionSpec(null, null, "dcToVmf"), new SelectionSpec(null, null, "crToH"), new SelectionSpec(null, null, "crToRp"), new SelectionSpec(null, null, "HToVm"), new SelectionSpec(null, null, "rpToVm")});
        traversalSpec8.setName("visitFolders");
        return new SelectionSpec[]{traversalSpec8, traversalSpec6, traversalSpec5, traversalSpec4, traversalSpec3, traversalSpec, traversalSpec7, traversalSpec2};
    }

    public PropertySpec[] buildPropertySpecArray(String[][] stringArray) {
        Object object;
        HashMap hashMap = new HashMap();
        for (int i = 0; i < stringArray.length; ++i) {
            Set<Object> set = (Set)hashMap.get(stringArray[i][0]);
            if (set == null) {
                set = new HashSet<Object>();
                hashMap.put(stringArray[i][0], set);
            }
            boolean bl = false;
            for (int j = 0; j < stringArray[i].length; ++j) {
                object = stringArray[i][j];
                if (bl) {
                    set.add(object);
                    continue;
                }
                bl = true;
            }
        }
        ArrayList<PropertySpec> arrayList = new ArrayList<PropertySpec>();
        for (String string : hashMap.keySet()) {
            PropertySpec propertySpec = new PropertySpec();
            object = (Set)hashMap.get(string);
            propertySpec.setType(string);
            propertySpec.setAll(object.isEmpty() ? Boolean.TRUE : Boolean.FALSE);
            propertySpec.setPathSet(new String[object.size()]);
            int n = 0;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                propertySpec.setPathSet(n++, string2);
            }
            arrayList.add(propertySpec);
        }
        return arrayList.toArray(new PropertySpec[0]);
    }

    boolean methodExists(Object object, String string, Class[] classArray) {
        boolean bl = false;
        try {
            Method method = object.getClass().getMethod(string, classArray);
            if (method != null) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }
}

