/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.apputils.vim25;

import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.VimPortType;
import com.vmware.vim25.VimServiceLocator;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import org.apache.axis.MessageContext;
import org.apache.axis.client.Call;
import org.apache.axis.client.Stub;

public class ServiceConnection {
    public static int ConnectionState_Connected = 0;
    public static int ConnectionState_Disconnected = 1;
    protected VimServiceLocator _locator;
    protected VimPortType _service;
    protected int _svcState = ConnectionState_Disconnected;
    protected ServiceContent _sic;
    protected ManagedObjectReference _svcRef = new ManagedObjectReference();

    public ServiceConnection(String string) {
        this._svcRef.setType("ServiceInstance");
        this._svcRef.set_value(string);
    }

    public static ServiceConnection CreateServiceConnection(String string) {
        return new ServiceConnection(string);
    }

    public void connect(String string, String string2, String string3, boolean bl) throws Exception {
        if (this._service != null) {
            this.disconnect();
        }
        if (bl) {
            this.ignoreCert();
        }
        this._locator = new VimServiceLocator();
        this._locator.setMaintainSession(true);
        this._service = this._locator.getVimPort(new URL(string));
        this._sic = this._service.retrieveServiceContent(this._svcRef);
        if (this._sic.getSessionManager() != null) {
            this._service.login(this._sic.getSessionManager(), string2, string3, null);
        }
        this._svcState = ConnectionState_Connected;
    }

    public void ignoreCert() {
        System.setProperty("org.apache.axis.components.net.SecureSocketFactory", "org.apache.axis.components.net.SunFakeTrustSocketFactory");
    }

    public void init(String string, String string2) throws Exception {
        if (this._service != null) {
            this.disconnect();
        }
        this._locator = new VimServiceLocator();
        this._locator.setMaintainSession(true);
        this._service = this._locator.getVimPort(new URL(string));
        this._sic = this._service.retrieveServiceContent(this._svcRef);
        Stub stub = (Stub)this._service;
        Call call = stub._getCall();
        MessageContext messageContext = call.getMessageContext();
        messageContext.setProperty("Cookie", (Object)string2);
        this._svcState = ConnectionState_Connected;
    }

    public void saveSession(String string) throws Exception {
        this.writeData(this._sic.getSessionManager(), string);
    }

    private void writeData(ManagedObjectReference managedObjectReference, String string) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(managedObjectReference);
        objectOutputStream.flush();
    }

    public void loadSession(String string, String string2) throws Exception {
        if (this._service != null) {
            this.disconnect();
        }
        this._locator = new VimServiceLocator();
        this._locator.setMaintainSession(true);
        this._service = this._locator.getVimPort(new URL(string));
        Stub stub = (Stub)this._service;
        stub._setProperty("Cookie", (Object)string2);
        this._locator.setMaintainSession(true);
        this._sic = this._service.retrieveServiceContent(this._svcRef);
    }

    private ManagedObjectReference readData(String string) throws IOException, ClassNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(string);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        ManagedObjectReference managedObjectReference = (ManagedObjectReference)objectInputStream.readObject();
        return managedObjectReference;
    }

    public boolean isConnected() {
        return this._svcState == ConnectionState_Connected;
    }

    public VimPortType getService() {
        return this._service;
    }

    public ManagedObjectReference getServiceInstanceRef() {
        return this._svcRef;
    }

    public ServiceContent getServiceContent() {
        return this._sic;
    }

    public ManagedObjectReference getPropCol() {
        return this._sic.getPropertyCollector();
    }

    public ManagedObjectReference getRootFolder() {
        return this._sic.getRootFolder();
    }

    public int ServiceState() {
        return this._svcState;
    }

    public void disconnect() throws Exception {
        if (this._service != null) {
            this._service.logout(this._sic.getSessionManager());
            this._service = null;
            this._sic = null;
            this._svcState = ConnectionState_Disconnected;
        }
    }
}

