/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.apputils;

import com.vmware.apputils.AppUtil;
import com.vmware.vim25.MethodFault;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class ClientUtil {
    private AppUtil _cb;

    public ClientUtil(AppUtil appUtil) {
        this._cb = appUtil;
    }

    public void printUsage() {
        this._cb.displayUsage();
    }

    public int getIntInput(String string, int n) throws Exception {
        String string2 = this.getStrInput(string);
        if (string2 == null || string2.length() == 0) {
            return n;
        }
        return Integer.parseInt(string2);
    }

    public long getLongInput(String string, long l) throws Exception {
        String string2 = this.getStrInput(string);
        if (string2 == null || string2.length() == 0) {
            return l;
        }
        return Long.parseLong(string2);
    }

    public String getStrInput(String string) throws Exception {
        System.out.print(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        return bufferedReader.readLine();
    }

    public void logException(Exception exception) {
        if (exception instanceof MethodFault) {
            MethodFault methodFault = (MethodFault)exception;
            this.logFault(methodFault);
        } else {
            this._cb.getLog().logLine("Caught Exception :  Exception : " + exception.getClass().getName() + " Message : " + exception.getMessage() + " StackTrace : ");
            exception.printStackTrace();
        }
    }

    public void logFault(MethodFault methodFault) {
        this._cb.getLog().logLine("Caught Fault - \n Type : " + methodFault.getClass().getName() + "\n Actor : " + methodFault.getFaultActor() + "\n Code : " + methodFault.getFaultNode() + "\n Reason : " + methodFault.getFaultReason() + "\n Fault String : " + methodFault.getFaultString());
    }
}

