/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.apputils;

import com.vmware.apputils.ArgumentHandlingException;
import com.vmware.apputils.ClientUtil;
import com.vmware.apputils.Log;
import com.vmware.apputils.OptionSpec;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class AppUtil {
    public Log log;
    private HashMap<String, String> optsEntered = new HashMap();
    private HashMap userOpts = new HashMap();
    private HashMap builtInOpts = new HashMap();
    private String logfilepath = "";
    private String _cname;
    private ClientUtil _util = new ClientUtil(this);
    private static Log gLog;

    public static AppUtil initialize(String string, OptionSpec[] optionSpecArray, String[] stringArray) throws Exception {
        AppUtil appUtil = new AppUtil(string);
        if (optionSpecArray != null) {
            appUtil.addOptions(optionSpecArray);
            appUtil.parseInput(stringArray);
            appUtil.validate();
        } else {
            appUtil.parseInput(stringArray);
            appUtil.validate();
        }
        return appUtil;
    }

    public static AppUtil initialize(String string, String[] stringArray) throws Exception {
        AppUtil appUtil = AppUtil.initialize(string, null, stringArray);
        return appUtil;
    }

    public static void ALog(Log log) {
        gLog = log;
    }

    public AppUtil(String string) {
        this.init(string);
    }

    public void init(String string) {
        this.builtinOptions();
        if (gLog == null) {
            String string2 = System.getProperty("java.io.tmpdir", "/tmp/");
            if (string2 == null || string2.length() == 0) {
                string2 = "";
            }
            this.logfilepath = string2 + "/" + string + "_";
            this.log = new Log();
            this.log.init(this.logfilepath, true, true);
        } else {
            this.log = gLog;
        }
        this._cname = string;
    }

    public void addOptions(OptionSpec[] optionSpecArray) throws Exception {
        for (int i = 0; i < optionSpecArray.length; ++i) {
            if (optionSpecArray[i].getOptionName() == null || optionSpecArray[i].getOptionName().length() <= 0 || optionSpecArray[i].getOptionDesc() == null || optionSpecArray[i].getOptionDesc().length() <= 0 || optionSpecArray[i].getOptionType() == null || optionSpecArray[i].getOptionType().length() <= 0 || optionSpecArray[i].getOptionRequired() != 0 && optionSpecArray[i].getOptionName().length() <= 1) {
                System.out.println("Option " + optionSpecArray[i].getOptionName() + " definition is not valid");
                throw new ArgumentHandlingException("Option " + optionSpecArray[i].getOptionName() + " definition is not valid");
            }
            this.userOpts.put(optionSpecArray[i].getOptionName(), optionSpecArray[i]);
        }
    }

    private void builtinOptions() {
        OptionSpec optionSpec = new OptionSpec("url", "String", 1, "Required. Complete URL for the VI API Web service to connect to", null);
        OptionSpec optionSpec2 = new OptionSpec("userName", "String", 1, "Required. User account with privileges to connect to the host", null);
        OptionSpec optionSpec3 = new OptionSpec("password", "String", 1, "Required. Password for the user account", null);
        OptionSpec optionSpec4 = new OptionSpec("config", "String", 0, "Location of the VI Perl Toolkit configuration file", null);
        OptionSpec optionSpec5 = new OptionSpec("protocol", "String", 0, "Protocol for the server connection (HTTP, HTTPS)", null);
        OptionSpec optionSpec6 = new OptionSpec("server", "String", 0, "Server to connect to", null);
        OptionSpec optionSpec7 = new OptionSpec("portNumber", "String", 0, "Port to connect to server", "443");
        OptionSpec optionSpec8 = new OptionSpec("servicePath", "String", 0, "Service path used to connect to server", null);
        OptionSpec optionSpec9 = new OptionSpec("sessionFile", "String", 0, "File containing previously saved session cookie", null);
        OptionSpec optionSpec10 = new OptionSpec("help", "String", 0, "Display usage information for the application or script", null);
        OptionSpec optionSpec11 = new OptionSpec("ignorecert", "String", 0, "Ignore the server certificate validation", null);
        this.builtInOpts.put("url", optionSpec);
        this.builtInOpts.put("username", optionSpec2);
        this.builtInOpts.put("password", optionSpec3);
        this.builtInOpts.put("password", optionSpec3);
        this.builtInOpts.put("config", optionSpec4);
        this.builtInOpts.put("protocol", optionSpec5);
        this.builtInOpts.put("server", optionSpec6);
        this.builtInOpts.put("portnumber", optionSpec7);
        this.builtInOpts.put("servicepath", optionSpec8);
        this.builtInOpts.put("sessionfile", optionSpec9);
        this.builtInOpts.put("help", optionSpec10);
        this.builtInOpts.put("ignorecert", optionSpec11);
    }

    public void parseInput(String[] stringArray) throws Exception {
        try {
            this.getCmdArguments(stringArray);
        }
        catch (Exception exception) {
            throw new ArgumentHandlingException("Exception running : " + exception);
        }
        Iterator<String> iterator = this.optsEntered.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            String string2 = this.optsEntered.get(string);
            boolean bl = this.checkInputOptions(this.builtInOpts, string);
            boolean bl2 = this.checkInputOptions(this.userOpts, string);
            if (!bl && !bl2) {
                System.out.println("Invalid Input Option '" + string + "'");
                this.displayUsage();
                throw new ArgumentHandlingException("Invalid Input Option '" + string + "'");
            }
            bl = this.checkDatatypes(this.builtInOpts, string, string2);
            bl2 = this.checkDatatypes(this.userOpts, string, string2);
            if (bl || bl2) continue;
            System.out.println("Invalid datatype for Input Option '" + string + "'");
            this.displayUsage();
            throw new ArgumentHandlingException("Invalid Input Option '" + string + "'");
        }
    }

    private void getCmdArguments(String[] stringArray) throws Exception {
        int n = stringArray.length;
        boolean bl = false;
        if (n == 0) {
            this.displayUsage();
            throw new ArgumentHandlingException("usage");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = "";
            String string2 = stringArray[i];
            if (string2.startsWith("--") && this.optsEntered.containsKey(string2.substring(2))) {
                System.out.println("key '" + string2.substring(2) + "' already exists ");
                this.displayUsage();
                throw new ArgumentHandlingException("key '" + string2.substring(2) + "' already exists ");
            }
            if (!stringArray[i].startsWith("--")) continue;
            if (stringArray.length > i + 1) {
                if (!stringArray[i + 1].startsWith("--")) {
                    string = stringArray[i + 1];
                    this.optsEntered.put(string2.substring(2), string);
                    continue;
                }
                this.optsEntered.put(string2.substring(2), null);
                continue;
            }
            this.optsEntered.put(string2.substring(2), null);
        }
    }

    private boolean checkDatatypes(HashMap hashMap, String string, String string2) {
        boolean bl = false;
        bl = hashMap.containsKey(string);
        if (bl) {
            OptionSpec optionSpec = (OptionSpec)hashMap.get(string);
            String string3 = optionSpec.getOptionType();
            boolean bl2 = this.validateDataType(string3, string2);
            return bl2;
        }
        return false;
    }

    private boolean validateDataType(String string, String string2) {
        try {
            if (string.equalsIgnoreCase("Boolean")) {
                return string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("false");
            }
            if (string.equalsIgnoreCase("Integer")) {
                int n = Integer.parseInt(string2);
                return true;
            }
            if (string.equalsIgnoreCase("Float")) {
                Float.parseFloat(string2);
                return true;
            }
            if (string.equalsIgnoreCase("Long")) {
                Long.parseLong(string2);
                return true;
            }
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean checkInputOptions(HashMap hashMap, String string) {
        boolean bl = false;
        bl = hashMap.containsKey(string);
        return bl;
    }

    public void validate() throws Exception {
        this.validate(null, null);
    }

    public void validate(Object object, String string) throws Exception {
        int n;
        boolean bl = false;
        if (this.optsEntered.isEmpty()) {
            this.displayUsage();
            throw new ArgumentHandlingException("---help");
        }
        if (this.optsEntered.get("help") != null) {
            this.displayUsage();
            System.exit(1);
        }
        if (this.option_is_set("help")) {
            this.displayUsage();
            System.exit(1);
        }
        Vector vector = this.getValue(this.builtInOpts);
        for (n = 0; n < vector.size(); ++n) {
            if (this.optsEntered.get(vector.get(n)) != null) continue;
            System.out.print("----ERROR: " + (String)vector.get(n) + " not specified \n");
            this.displayUsage();
            throw new ArgumentHandlingException("----ERROR: " + (String)vector.get(n) + " not specified \n");
        }
        vector = this.getValue(this.userOpts);
        for (n = 0; n < vector.size(); ++n) {
            if (this.optsEntered.get(vector.get(n)) != null) continue;
            System.out.print("----ERROR: " + (String)vector.get(n) + " not specified \n");
            this.displayUsage();
            throw new ArgumentHandlingException("----ERROR: " + (String)vector.get(n) + " not specified \n");
        }
        if (this.optsEntered.get("sessionfile") == null && this.optsEntered.get("username") == null && this.optsEntered.get("password") == null) {
            System.out.println("Must have one of command options 'sessionfile' or a 'username' and 'password' pair\n");
            this.displayUsage();
            throw new ArgumentHandlingException("Must have one of command options 'sessionfile' or a 'username' and 'password' pair\n");
        }
    }

    private Vector getValue(HashMap hashMap) {
        Iterator iterator = hashMap.keySet().iterator();
        Vector<String> vector = new Vector<String>();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            OptionSpec optionSpec = (OptionSpec)hashMap.get(string);
            if (optionSpec.getOptionRequired() != 1) continue;
            vector.add(string);
        }
        return vector;
    }

    public void displayUsage() {
        System.out.println("Common Java Options :");
        this.print_options(this.builtInOpts);
        System.out.println("\nCommand specific options: ");
        this.print_options(this.userOpts);
    }

    private void print_options(HashMap hashMap) {
        String string = "";
        String string2 = "";
        String string3 = "";
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string4 = iterator.next().toString();
            OptionSpec optionSpec = (OptionSpec)hashMap.get(string4);
            if (optionSpec.getOptionType() != null && optionSpec.getOptionDefault() != null) {
                string = optionSpec.getOptionType();
                string2 = optionSpec.getOptionDefault();
                System.out.println("   --" + string4 + " < type " + string + ", default " + string2 + ">");
            }
            if (optionSpec.getOptionDefault() != null && optionSpec.getOptionType() == null) {
                string2 = optionSpec.getOptionDefault();
                System.out.println("   --" + string4 + " < default " + string2 + " >");
            } else if (optionSpec.getOptionType() != null && optionSpec.getOptionDefault() == null) {
                string = optionSpec.getOptionType();
                System.out.println("   --" + string4 + " < type " + string + " >");
            } else if (optionSpec.getOptionType() == null && optionSpec.getOptionDefault() == null) {
                System.out.println("   --" + string4 + " ");
            }
            string3 = optionSpec.getOptionDesc();
            System.out.println("      " + string3);
        }
    }

    public boolean option_is_set(String string) {
        boolean bl = false;
        Iterator<String> iterator = this.optsEntered.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().toString();
            if (!string.equals(string2)) continue;
            bl = true;
        }
        return bl;
    }

    public String get_option(String string) {
        if (this.optsEntered.get(string) != null) {
            return this.optsEntered.get(string).toString();
        }
        if (this.checkInputOptions(this.builtInOpts, string)) {
            if (((OptionSpec)this.builtInOpts.get(string)).getOptionDefault() != null) {
                String string2 = ((OptionSpec)this.builtInOpts.get(string)).getOptionDefault();
                return string2;
            }
            return null;
        }
        if (this.checkInputOptions(this.userOpts, string)) {
            if (((OptionSpec)this.userOpts.get(string)).getOptionDefault() != null) {
                String string3 = ((OptionSpec)this.userOpts.get(string)).getOptionDefault();
                return string3;
            }
            return null;
        }
        System.out.println("undefined variable");
        return null;
    }

    public String getAppName() {
        return this._cname;
    }

    public Log getLog() {
        return this.log;
    }

    public ClientUtil getUtil() {
        return this._util;
    }

    public String getServiceUrl() throws Exception {
        return this.get_option("url");
    }

    public String getUsername() throws Exception {
        return this.get_option("username");
    }

    public String getPassword() throws Exception {
        return this.get_option("password");
    }

    private String readPassword(String string) {
        try {
            PasswordMask passwordMask = new PasswordMask();
            System.out.print(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            passwordMask.start();
            String string2 = bufferedReader.readLine();
            passwordMask.halt();
            System.out.print("\b");
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String readUsername(String string) {
        try {
            PasswordMask passwordMask = new PasswordMask();
            System.out.print(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            String string2 = bufferedReader.readLine();
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    class PasswordMask
    extends Thread {
        private boolean running = true;

        PasswordMask() {
        }

        @Override
        public void run() {
            while (this.running) {
                System.out.print("\b ");
            }
        }

        public synchronized void halt() {
            this.running = false;
        }
    }
}

