/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.slp.internal.msg;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.sblim.slp.ServiceLocationAttribute;
import org.sblim.slp.ServiceLocationException;
import org.sblim.slp.ServiceType;
import org.sblim.slp.ServiceURL;
import org.sblim.slp.internal.Convert;
import org.sblim.slp.internal.TRC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SLPInputStream {
    private InputStream iInStr;
    private final byte[] iBBuf = new byte[4];

    public SLPInputStream(byte[] pBytes) {
        this(pBytes, 0, pBytes.length);
    }

    public SLPInputStream(Socket pSock) throws IOException {
        this(pSock.getInputStream());
    }

    public SLPInputStream(InputStream pInStr) {
        this.iInStr = pInStr;
    }

    public SLPInputStream(DatagramPacket pPacket) {
        this(pPacket.getData(), pPacket.getOffset(), pPacket.getLength());
    }

    public SLPInputStream(byte[] pBytes, int pOffset, int pLength) {
        this.iInStr = new ByteArrayInputStream(pBytes, pOffset, pLength);
    }

    public String readString() throws ServiceLocationException, IOException {
        return Convert.unescape(this.readRawString());
    }

    public SortedSet<String> readStringSet() throws ServiceLocationException, IOException {
        TreeSet<String> set = new TreeSet<String>();
        this.readStringCollection(set);
        return set;
    }

    public List<String> readStringList() throws ServiceLocationException, IOException {
        ArrayList<String> strList = new ArrayList<String>();
        this.readStringCollection(strList);
        return strList;
    }

    public ServiceLocationAttribute readAttribute() throws ServiceLocationException, IOException {
        String str = this.readRawString();
        return str == null ? null : new ServiceLocationAttribute(str);
    }

    public List<ServiceLocationAttribute> readAttributeList() throws ServiceLocationException, IOException {
        String str = this.readRawString();
        return str == null ? null : new AttrListParser(str).getList();
    }

    public List<?> readAuthBlockList() throws ServiceLocationException, IOException {
        Integer blockCntInt = this.doRead8();
        if (blockCntInt == null) {
            return null;
        }
        int blockCnt = blockCntInt;
        if (blockCnt != 0) {
            throw new ServiceLocationException(16, "Handling of authentication blocks is not implemented! blockCount = " + blockCnt);
        }
        return null;
    }

    public ServiceURL readURL() throws ServiceLocationException, IOException {
        if (this.doRead8() == null) {
            return null;
        }
        Integer lifeTimeInt = this.doRead16();
        if (lifeTimeInt == null) {
            return null;
        }
        int lifeTime = lifeTimeInt;
        String urlStr = this.readString();
        if (urlStr == null) {
            return null;
        }
        Integer numOfAuthsInt = this.doRead8();
        if (numOfAuthsInt == null) {
            return null;
        }
        int numOfAuths = numOfAuthsInt;
        while (numOfAuths-- > 0) {
            TRC.warning("readAuth");
            this.readString();
        }
        return new ServiceURL(urlStr, lifeTime);
    }

    public List<ServiceURL> readUrlList(List<Exception> pURLExceptions) throws ServiceLocationException, IOException {
        Integer cntInt = this.doRead16();
        if (cntInt == null) {
            return null;
        }
        int cnt = cntInt;
        ArrayList<ServiceURL> urlList = new ArrayList<ServiceURL>(cnt);
        while (cnt-- > 0) {
            try {
                ServiceURL url = this.readURL();
                if (url == null) break;
                urlList.add(url);
            }
            catch (IllegalArgumentException e) {
                pURLExceptions.add(e);
                TRC.warning("Ignoring Invalid URL : " + e.getMessage());
            }
        }
        return urlList;
    }

    public ServiceType readServiceType() throws ServiceLocationException, IOException {
        String str = this.readString();
        return str == null ? null : new ServiceType(str);
    }

    public List<ServiceType> readServTypeList() throws ServiceLocationException, IOException {
        Iterator<String> strItr = this.readStringList().iterator();
        ArrayList<ServiceType> srvTypeList = new ArrayList<ServiceType>();
        while (strItr.hasNext()) {
            srvTypeList.add(new ServiceType(strItr.next()));
        }
        return srvTypeList;
    }

    public int read8() throws ServiceLocationException, IOException {
        Integer res = this.doRead8();
        if (res == null) {
            throw new ServiceLocationException(2, "Failed to read byte field!");
        }
        return res;
    }

    public int read16() throws ServiceLocationException, IOException {
        Integer res = this.doRead16();
        if (res == null) {
            throw new ServiceLocationException(2, "Failed to read 2-byte-long field!");
        }
        return res;
    }

    public int read24() throws ServiceLocationException, IOException {
        Integer res = this.doRead24();
        if (res == null) {
            throw new ServiceLocationException(2, "Failed to read 3-byte-long field!");
        }
        return res;
    }

    public long read32() throws ServiceLocationException, IOException {
        Long res = this.doRead32();
        if (res == null) {
            throw new ServiceLocationException(2, "Failed to read 4-byte-long field!");
        }
        return res;
    }

    private Integer doRead8() throws IOException {
        int res = this.iInStr.read();
        return res < 0 ? null : Integer.valueOf(res);
    }

    private Integer doRead16() throws IOException {
        int cnt = this.iInStr.read(this.iBBuf, 0, 2);
        if (cnt != 2) {
            return null;
        }
        return (this.iBBuf[0] & 0xFF) << 8 | this.iBBuf[1] & 0xFF;
    }

    private Integer doRead24() throws IOException {
        int cnt = this.iInStr.read(this.iBBuf, 0, 3);
        if (cnt != 3) {
            return null;
        }
        return (this.iBBuf[0] & 0xFF) << 16 | (this.iBBuf[1] & 0xFF) << 8 | this.iBBuf[2] & 0xFF;
    }

    private Long doRead32() throws IOException {
        int cnt = this.iInStr.read(this.iBBuf, 0, 4);
        if (cnt != 4) {
            return null;
        }
        long res = (this.iBBuf[0] & 0xFF) << 8;
        res |= (long)((this.iBBuf[1] & 0xFF) << 8);
        res |= (long)((this.iBBuf[2] & 0xFF) << 8);
        return res |= (long)(this.iBBuf[3] & 0xFF);
    }

    private String readRawString() throws ServiceLocationException, IOException {
        Integer lenInt = this.doRead16();
        if (lenInt == null) {
            return null;
        }
        int len = lenInt;
        if (len <= 0) {
            return null;
        }
        byte[] bytes = new byte[len];
        int read = this.iInStr.read(bytes, 0, len);
        if (read != len) {
            return null;
        }
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ServiceLocationException(20, (Throwable)e);
        }
    }

    private void readStringCollection(Collection<String> pCol) throws ServiceLocationException, IOException {
        String rawListStr = this.readRawString();
        if (rawListStr == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(rawListStr, ",");
        while (tokenizer.hasMoreElements()) {
            pCol.add(Convert.unescape(tokenizer.nextToken()));
        }
    }

    static void debug(String pMsg) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AttrListParser {
        private int iPos = 0;
        private String iAttrListStr;
        private ArrayList<ServiceLocationAttribute> iList = new ArrayList();

        public AttrListParser(String pAttrListStr) throws ServiceLocationException {
            String attrStr;
            SLPInputStream.debug("attrListStr=" + pAttrListStr);
            this.iAttrListStr = pAttrListStr;
            while ((attrStr = this.readEntry()) != null) {
                SLPInputStream.debug("attrStr=" + attrStr);
                this.iList.add(new ServiceLocationAttribute(attrStr));
            }
        }

        public List<ServiceLocationAttribute> getList() {
            return this.iList;
        }

        private String readEntry() throws ServiceLocationException {
            if (this.iAttrListStr == null) {
                return null;
            }
            int lastIdx = this.iAttrListStr.length() - 1;
            if (this.iPos == lastIdx) {
                return null;
            }
            boolean inBlock = false;
            int startPos = this.iPos;
            while (true) {
                char ch;
                if ((ch = this.iAttrListStr.charAt(this.iPos)) == '(') {
                    if (inBlock || this.iPos != startPos) {
                        throw new ServiceLocationException(2, this.invalidChar('('));
                    }
                    inBlock = true;
                } else if (ch == ')') {
                    if (!inBlock) {
                        throw new ServiceLocationException(2, this.invalidChar(')'));
                    }
                    if (this.iPos == lastIdx) {
                        return this.iAttrListStr.substring(startPos);
                    }
                    inBlock = false;
                } else if (inBlock) {
                    if (this.iPos == lastIdx) {
                        return this.iAttrListStr.substring(startPos);
                    }
                } else {
                    if (ch == ',') {
                        ++this.iPos;
                        return this.iAttrListStr.substring(startPos, this.iPos - 1);
                    }
                    if (this.iPos == lastIdx) {
                        return this.iAttrListStr.substring(startPos);
                    }
                }
                if (this.iPos == lastIdx) {
                    throw new ServiceLocationException(2, "Unexpected end of Attribute list:\n" + this.iAttrListStr);
                }
                ++this.iPos;
            }
        }

        private String invalidChar(char ch) {
            return "Invalid '(' character in Attribute list:\n" + this.iAttrListStr + "\nat position: " + this.iPos;
        }
    }
}

