/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.wbem.indications;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import javax.cim.CIMInstance;
import javax.wbem.WBEMException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.sblim.cimclient.internal.cimxml.CIMClientXML_HelperImpl;
import org.sblim.cimclient.internal.cimxml.CIMRequest;
import org.sblim.cimclient.internal.cimxml.CIMXMLBuilderImpl;
import org.sblim.cimclient.internal.cimxml.CIMXMLParserImpl;
import org.sblim.cimclient.internal.http.HttpContentHandler;
import org.sblim.cimclient.internal.http.HttpException;
import org.sblim.cimclient.internal.http.HttpHeader;
import org.sblim.cimclient.internal.http.HttpHeaderParser;
import org.sblim.cimclient.internal.http.MessageReader;
import org.sblim.cimclient.internal.http.MessageWriter;
import org.sblim.cimclient.internal.http.io.DebugInputStream;
import org.sblim.cimclient.internal.logging.LogAndTraceBroker;
import org.sblim.cimclient.internal.util.WBEMConfiguration;
import org.sblim.cimclient.internal.wbem.CIMError;
import org.sblim.cimclient.internal.wbem.indications.CIMEvent;
import org.sblim.cimclient.internal.wbem.indications.CIMEventDispatcher;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class CIMIndicationHandler
extends HttpContentHandler {
    private CIMEventDispatcher iDispatcher = null;
    private int iMessageId = 0;
    private LogAndTraceBroker iLogger = LogAndTraceBroker.getBroker();
    private WBEMConfiguration iSessionProperties;

    public CIMIndicationHandler(CIMEventDispatcher pDispatcher) {
        this.iDispatcher = pDispatcher;
        this.iSessionProperties = WBEMConfiguration.getGlobalConfiguration();
    }

    public CIMIndicationHandler(CIMEventDispatcher pDispatcher, WBEMConfiguration pProperties) {
        this.iDispatcher = pDispatcher;
        this.iSessionProperties = pProperties != null ? pProperties : WBEMConfiguration.getGlobalConfiguration();
    }

    public void close() {
        if (this.iDispatcher != null) {
            this.iDispatcher.close();
        }
    }

    public synchronized int getMsgID() {
        ++this.iMessageId;
        if (this.iMessageId > 1000000) {
            this.iMessageId = 0;
        }
        return this.iMessageId;
    }

    private static HttpHeader processHeader(HttpHeader pHeader, MessageWriter pWriter) throws HttpException {
        HttpHeader header = CIMIndicationHandler.processHttpExtensions(pHeader);
        String cimExport = header.getField("CIMExport");
        String cimOperation = header.getField("CIMOperation");
        if (cimOperation != null && !"METHODCALL".equalsIgnoreCase(cimOperation)) {
            pWriter.getHeader().addField("CIMError", "unsupported-operation");
            throw new HttpException(400, "Bad Request");
        }
        if (cimExport != null && !"METHODREQUEST".equalsIgnoreCase(cimExport) && !"EXPORTMETHODCALL".equalsIgnoreCase(cimExport)) {
            pWriter.getHeader().addField("CIMError", "unsupported-operation");
            throw new HttpException(400, "Bad Request");
        }
        if (cimOperation == null && cimExport == null) {
            pWriter.getHeader().addField("CIMError", "unsupported-operation");
            throw new HttpException(400, "Bad Request");
        }
        return header;
    }

    public void handleContent(MessageReader pReader, MessageWriter pWriter, InetAddress pInetAddress) throws HttpException, IOException {
        CIMError error = null;
        HttpHeader inputHeader = pReader.getHeader();
        inputHeader = CIMIndicationHandler.processHeader(inputHeader, pWriter);
        String cimMethod = inputHeader.getField("CIMMethod");
        String cimExport = inputHeader.getField("CIMExport");
        CIMRequest request = null;
        CIMClientXML_HelperImpl xmlHelper = null;
        try {
            xmlHelper = new CIMClientXML_HelperImpl();
        }
        catch (ParserConfigurationException e1) {
            IOException e = new IOException("ParserConfigurationException");
            e.initCause(e1);
            throw e;
        }
        InputStream inputstream = null;
        inputstream = this.iSessionProperties.isCimXmlTracingEnabled() && LogAndTraceBroker.getBroker().getXmlTraceStream() != null ? new DebugInputStream(pReader.getInputStream(), LogAndTraceBroker.getBroker().getXmlTraceStream()) : pReader.getInputStream();
        request = this.parseDocument(xmlHelper, pReader, inputstream);
        if (request == null) {
            throw new HttpException(400, "Bad Request");
        }
        if (cimExport == null && !cimMethod.equalsIgnoreCase("Indication") || !request.isCIMExport()) {
            throw new HttpException(400, "Bad Request");
        }
        error = this.dispatchIndications(pReader, pInetAddress, request);
        CIMIndicationHandler.buildResponse(xmlHelper, pWriter, request, error);
    }

    private CIMRequest parseDocument(CIMClientXML_HelperImpl xmlHelper, MessageReader pReader, InputStream inputstream) throws HttpException {
        Document doc = null;
        try {
            doc = xmlHelper.parse(new InputSource(new InputStreamReader(inputstream, pReader.getCharacterEncoding())));
            Element rootE = doc.getDocumentElement();
            return (CIMRequest)CIMXMLParserImpl.parseCIM(rootE);
        }
        catch (Exception e) {
            this.iLogger.trace(Level.WARNING, "exception while parsing the XML with DOM parser", e);
            throw new HttpException(400, "Bad Request");
        }
    }

    private CIMError dispatchIndications(MessageReader pReader, InetAddress pInetAddress, CIMRequest request) {
        try {
            Vector<Object> paramValue = request.getParamValue();
            for (Object cimEvent : paramValue) {
                if (!(cimEvent instanceof CIMInstance)) continue;
                CIMInstance indicationInst = (CIMInstance)cimEvent;
                String id = pReader.getMethod().getFile();
                if (id != null && id.startsWith("/") && id.length() > 1 && !id.equalsIgnoreCase("/cimom")) {
                    id = id.substring(1);
                }
                this.iDispatcher.dispatchEvent(new CIMEvent(indicationInst, id, pInetAddress));
            }
            return null;
        }
        catch (Exception e) {
            return new CIMError(new WBEMException(1, "CIM_ERR_FAILED", null, e));
        }
    }

    private static void buildResponse(CIMClientXML_HelperImpl xmlHelper, MessageWriter pWriter, CIMRequest request, CIMError error) throws HttpException, IOException {
        Document responseDoc = null;
        try {
            DocumentBuilder docBuilder = xmlHelper.getDocumentBuilder();
            responseDoc = docBuilder.newDocument();
            CIMXMLBuilderImpl.createIndication_response(responseDoc, request.getId(), error);
        }
        catch (Exception e) {
            throw new HttpException(400, "Bad Request");
        }
        CIMClientXML_HelperImpl.serialize(pWriter.getOutputStream(), responseDoc);
        pWriter.getHeader().addField("CIMExport", "MethodResponse");
    }

    private static HttpHeader processHttpExtensions(HttpHeader pOriginalHeader) {
        String man = pOriginalHeader.getField("Man");
        String opt = pOriginalHeader.getField("Opt");
        HttpHeader headers = new HttpHeader();
        String ns = null;
        HttpHeaderParser manOptHeader = null;
        if (man != null && man.length() > 0) {
            manOptHeader = new HttpHeaderParser(man);
        } else if (opt != null && opt.length() > 0) {
            manOptHeader = new HttpHeaderParser(opt);
        }
        if (manOptHeader != null) {
            ns = manOptHeader.getValue("ns");
        }
        if (ns != null) {
            Iterator<Map.Entry<HttpHeader.HeaderEntry, String>> iter = pOriginalHeader.iterator();
            while (iter.hasNext()) {
                Map.Entry<HttpHeader.HeaderEntry, String> entry = iter.next();
                if (entry == null) continue;
                String key = entry.getKey().toString();
                if (key.startsWith(ns + "-")) {
                    headers.addField(key.substring(3), entry.getValue().toString());
                    continue;
                }
                headers.addField(key, entry.getValue().toString());
            }
        } else {
            headers = pOriginalHeader;
        }
        return headers;
    }
}

