/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.wbem;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import javax.cim.CIMArgument;
import javax.cim.CIMObjectPath;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import org.sblim.cimclient.internal.cimxml.sax.XMLDefaultHandlerImpl;
import org.sblim.cimclient.internal.cimxml.sax.node.AbstractMessageNode;
import org.sblim.cimclient.internal.cimxml.sax.node.AbstractSimpleRspNode;
import org.sblim.cimclient.internal.cimxml.sax.node.CIMNode;
import org.sblim.cimclient.internal.cimxml.sax.node.MessageNode;
import org.sblim.cimclient.internal.http.io.TrailerException;
import org.sblim.cimclient.internal.logging.LogAndTraceBroker;
import org.sblim.cimclient.internal.pullparser.XMLPullParser;
import org.sblim.cimclient.internal.wbem.CIMError;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloseableIteratorPULL
implements CloseableIterator<Object> {
    private XMLPullParser iParser;
    private XMLDefaultHandlerImpl iHandler;
    private CIMNode iCIMNode;
    private MessageNode iMsgNode;
    private AbstractSimpleRspNode iAbsSimpRspNode;
    private Object iNextValue;
    private WBEMException iWBEMException;
    private static final String EMPTY = "";
    private CIMArgument<?>[] iCIMArgAL;

    public CloseableIteratorPULL(InputStreamReader pStream, CIMObjectPath pPath) throws RuntimeException {
        this(new XMLPullParser(pStream), new XMLDefaultHandlerImpl(pPath));
    }

    public CloseableIteratorPULL(XMLPullParser pParser, XMLDefaultHandlerImpl pHandler) {
        this.iParser = pParser;
        this.iHandler = pHandler;
    }

    @Override
    public void close() {
        try {
            this.iParser.close();
        }
        catch (IOException e) {
            throw new RuntimeException("IOException occurred at XMLPullParser.close()!", e);
        }
        this.iNextValue = null;
        this.iWBEMException = null;
        this.iCIMArgAL = null;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.hasNextImpl();
        }
        catch (TrailerException e) {
            this.iWBEMException = e.getWBEMException();
            throw new RuntimeException(this.iWBEMException);
        }
        catch (Exception e) {
            LogAndTraceBroker.getBroker().trace(Level.SEVERE, "Exception occurred during XML parsing!", e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object next() {
        Object value = this.iNextValue;
        this.iNextValue = null;
        return value;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WBEMException getWBEMException() {
        return this.iWBEMException;
    }

    private boolean hasNextImpl() throws Exception {
        if (this.iNextValue != null) {
            return true;
        }
        while (this.iParser.hasNext()) {
            int event = this.iParser.next();
            switch (event) {
                case 1: {
                    this.iHandler.startElement(EMPTY, EMPTY, this.iParser.getElementName(), this.iParser.getAttributes());
                    break;
                }
                case 4: {
                    char[] buf = this.iParser.getText().toCharArray();
                    this.iHandler.characters(buf, 0, buf.length);
                    break;
                }
                case 2: {
                    this.iHandler.endElement(EMPTY, EMPTY, this.iParser.getElementName());
                    AbstractSimpleRspNode absSimpRspNode = this.getAbstractSimpleRspNode();
                    if (absSimpRspNode == null) break;
                    if (absSimpRspNode.getReturnValueCount() > 0) {
                        this.iNextValue = absSimpRspNode.readReturnValue();
                        return true;
                    }
                    if (!absSimpRspNode.isCompleted()) break;
                    this.iCIMArgAL = absSimpRspNode.getCIMArguments();
                    CIMError cimErr = absSimpRspNode.getCIMError();
                    if (cimErr != null) {
                        throw new WBEMException(cimErr.getCode(), cimErr.getDescription(), cimErr.getCIMInstances());
                    }
                    return false;
                }
                case 8: {
                    return false;
                }
            }
        }
        return false;
    }

    private AbstractSimpleRspNode getAbstractSimpleRspNode() throws Exception {
        AbstractMessageNode absMsgNode;
        if (this.iAbsSimpRspNode != null) {
            return this.iAbsSimpRspNode;
        }
        if (this.iCIMNode == null) {
            this.iCIMNode = this.iHandler.getCIMNode();
            if (this.iCIMNode == null) {
                return null;
            }
        }
        if (this.iMsgNode == null) {
            this.iMsgNode = this.iCIMNode.getMessageNode();
            if (this.iMsgNode == null) {
                return null;
            }
        }
        if ((absMsgNode = this.iMsgNode.getAbstractMessageNode()) == null) {
            return null;
        }
        if (!(absMsgNode instanceof AbstractSimpleRspNode)) {
            throw new SAXException("Simple response child node expected for MESSAGE node!");
        }
        this.iAbsSimpRspNode = (AbstractSimpleRspNode)absMsgNode;
        this.iMsgNode = null;
        this.iCIMNode = null;
        return this.iAbsSimpRspNode;
    }

    public CIMArgument<?>[] getCIMArguments() {
        return this.iCIMArgAL;
    }
}

