/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.net.SocketFactory;
import org.sblim.cimclient.internal.logging.LogAndTraceBroker;
import org.sblim.cimclient.internal.util.WBEMConfigurationDefaults;

public class WBEMConfiguration {
    private static WBEMConfiguration cConfiguration;
    private static String cConfigURL;
    private static boolean cLoadSuccessful;
    private static Exception cLoadException;
    private final ThreadLocal<Object> iLocalProperties = new InheritableThreadLocal<Object>(){

        @Override
        protected Object childValue(Object parentValue) {
            if (parentValue instanceof Properties) {
                return ((Properties)parentValue).clone();
            }
            return super.childValue(parentValue);
        }
    };
    private Properties iDomainProperties = null;
    private SocketFactory iCustomSocketFactory = null;
    private boolean iIsGlobal = false;

    public static void loadGlobalConfiguration() {
        Properties wbemProperties = new Properties(new Properties());
        try {
            cConfigURL = null;
            cLoadSuccessful = false;
            cLoadException = null;
            InputStream inputstream = WBEMConfiguration.getConfigURLStream();
            if (inputstream != null) {
                wbemProperties.load(inputstream);
                cLoadSuccessful = true;
            }
            for (Map.Entry<Object, Object> entry : wbemProperties.entrySet()) {
                String value;
                String key = String.valueOf(entry.getKey());
                if (key.startsWith("sblim.wbem.") || key.startsWith("javax.net.ssl.") || key.startsWith("net.slp.")) {
                    value = String.valueOf(entry.getValue());
                    System.setProperty(key, value);
                    continue;
                }
                if (key.startsWith("ssl.")) {
                    value = String.valueOf(entry.getValue());
                    Security.setProperty(key, value);
                    continue;
                }
                if (!LogAndTraceBroker.isLoggingStarted()) continue;
                LogAndTraceBroker.getBroker().message("CIM1004W", key);
            }
        }
        catch (IOException e) {
            cLoadException = e;
        }
    }

    public static String getActiveConfigURL() {
        return cConfigURL;
    }

    public static boolean isConfigurationLoadSuccessful() {
        return cLoadSuccessful;
    }

    private static InputStream getConfigURLStream() {
        String configURL = System.getProperty("sblim.wbem.configURL");
        if (configURL != null) {
            if (configURL.trim().length() > 0) {
                try {
                    cConfigURL = configURL;
                    URL url = new URL(configURL);
                    InputStream inputstream = url.openStream();
                    return inputstream;
                }
                catch (Exception e) {
                    cLoadException = e;
                }
            }
        } else {
            for (int i = 0; i < WBEMConfigurationDefaults.CONFIG_URL.length; ++i) {
                configURL = WBEMConfigurationDefaults.CONFIG_URL[i];
                try {
                    cConfigURL = configURL;
                    URL url = new URL(configURL);
                    InputStream inputstream = url.openStream();
                    return inputstream;
                }
                catch (FileNotFoundException e) {
                    continue;
                }
                catch (Exception e) {
                    cLoadException = e;
                }
            }
            cConfigURL = Arrays.asList(WBEMConfigurationDefaults.CONFIG_URL).toString();
        }
        return null;
    }

    public static WBEMConfiguration getGlobalConfiguration() {
        return cConfiguration;
    }

    public static Exception getConfigurationLoadException() {
        return cLoadException;
    }

    private WBEMConfiguration() {
    }

    public WBEMConfiguration(Properties pDomainProperties) {
        if (pDomainProperties == null) {
            throw new NullPointerException("Domain properties shall not be null");
        }
        this.iDomainProperties = pDomainProperties;
    }

    public boolean isGlobal() {
        return this.iIsGlobal;
    }

    public synchronized Properties getDomainProperties() {
        return this.iDomainProperties;
    }

    public synchronized void setDomainProperties(Properties pDomainProperties) {
        if (this.isGlobal()) {
            throw new IllegalStateException("Global configuration cannot be modified by setDomainProperties()");
        }
        this.iDomainProperties = pDomainProperties;
    }

    public synchronized String getDomainProperty(String pKey) {
        return this.iDomainProperties != null ? this.iDomainProperties.getProperty(pKey) : null;
    }

    public synchronized void setDomainProperty(String pKey, String pValue) {
        if (this.isGlobal()) {
            throw new IllegalStateException("Global configuration cannot be modified by setDomainProperty()");
        }
        this.iDomainProperties.setProperty(pKey, pValue);
    }

    public Properties getLocalProperties() {
        return (Properties)this.iLocalProperties.get();
    }

    public void setLocalProperties(Properties pLocalProperties) {
        if (this.isGlobal()) {
            throw new IllegalStateException("Global configuration cannot be modified by setLocalProperties()");
        }
        this.iLocalProperties.set(pLocalProperties);
    }

    public String getLocalProperty(String pKey) {
        Properties localProperties = (Properties)this.iLocalProperties.get();
        return localProperties != null ? localProperties.getProperty(pKey) : null;
    }

    public void setLocalProperty(String pKey, String pValue) {
        if (this.isGlobal()) {
            throw new IllegalStateException("Global configuration cannot be modified by setLocalProperty()");
        }
        Properties localProperties = (Properties)this.iLocalProperties.get();
        if (localProperties == null) {
            localProperties = new Properties();
            this.iLocalProperties.set(localProperties);
        }
        localProperties.setProperty(pKey, pValue);
    }

    private String getProperty(String pProperty, String pDefault) {
        String globalProperty = System.getProperty(pProperty, pDefault);
        String domainProperty = this.getDomainProperty(pProperty);
        String localProperty = this.getLocalProperty(pProperty);
        return localProperty != null ? localProperty : (domainProperty != null ? domainProperty : (globalProperty != null ? globalProperty : pDefault));
    }

    private String getSecurityProperty(String pProperty, String pDefault) {
        String globalProperty = Security.getProperty(pProperty);
        String domainProperty = this.getDomainProperty(pProperty);
        String localProperty = this.getLocalProperty(pProperty);
        return localProperty != null ? localProperty : (domainProperty != null ? domainProperty : (globalProperty != null ? globalProperty : pDefault));
    }

    public synchronized void setCustomSocketFactory(SocketFactory pFactory) {
        this.iCustomSocketFactory = pFactory;
    }

    public synchronized SocketFactory getCustomSocketFactory() {
        return this.iCustomSocketFactory;
    }

    public Level getLogConsoleLevel() {
        return Level.parse(this.getProperty("sblim.wbem.logConsoleLevel", "OFF"));
    }

    public String getLogConsoleType() {
        return this.getProperty("sblim.wbem.logConsoleType", "MESSAGE");
    }

    public Level getLogFileLevel() {
        return Level.parse(this.getProperty("sblim.wbem.logFileLevel", "OFF"));
    }

    public String getLogFileLocation() {
        return this.getProperty("sblim.wbem.logFileLocation", "%t/cimclient_log_%g.txt");
    }

    public int getLogFileCount() {
        return Integer.parseInt(this.getProperty("sblim.wbem.logFileCount", "3"));
    }

    public int getLogFileSizeLimit() {
        return Integer.parseInt(this.getProperty("sblim.wbem.logFileSizeLimit", "5242880"));
    }

    public boolean isLogDebug() {
        return Boolean.valueOf(this.getProperty("sblim.wbem.logDebug", "false"));
    }

    public Level getTraceFileLevel() {
        return Level.parse(this.getProperty("sblim.wbem.traceFileLevel", "OFF"));
    }

    public String getTraceFileLocation() {
        return this.getProperty("sblim.wbem.traceFileLocation", "%t/cimclient_trace_%g.txt");
    }

    public int getTraceFileCount() {
        return Integer.parseInt(this.getProperty("sblim.wbem.traceFileCount", "5"));
    }

    public int getTraceFileSizeLimit() {
        return Integer.parseInt(this.getProperty("sblim.wbem.traceFileSizeLimit", "1000000"));
    }

    public int getHttpTimeout() {
        return Integer.parseInt(this.getProperty("sblim.wbem.httpTimeout", "0"));
    }

    public int getHttpPoolSize() {
        return Integer.parseInt(this.getProperty("sblim.wbem.httpPoolSize", "16"));
    }

    public String getHttpAuthenticationModule() {
        return this.getProperty("sblim.wbem.httpAuthModule", WBEMConfigurationDefaults.HTTP_AUTHENTICATION_MODULE);
    }

    public boolean isHttpMPost() {
        return Boolean.valueOf(this.getProperty("sblim.wbem.httpMPOST", "true"));
    }

    public boolean isHttpChunked() {
        return Boolean.valueOf(this.getProperty("sblim.wbem.httpChunking", "true"));
    }

    public String getHttpVersion() {
        return this.getProperty("sblim.wbem.httpVersion", "1.1");
    }

    public String getSslKeyStorePath() {
        return this.getProperty("javax.net.ssl.keyStore", null);
    }

    public String getSslKeyStoreType() {
        return this.getProperty("javax.net.ssl.keyStoreType", "JKS");
    }

    public String getSslKeyStorePassword() {
        return this.getProperty("javax.net.ssl.keyStorePassword", "");
    }

    public String getSslTrustStorePath() {
        return this.getProperty("javax.net.ssl.trustStore", null);
    }

    public String getSslTrustStoreType() {
        return this.getProperty("javax.net.ssl.trustStoreType", "JKS");
    }

    public String getSslTrustStorePassword() {
        return this.getProperty("javax.net.ssl.trustStorePassword", "");
    }

    public String getSslSocketProvider() {
        Provider[] providers = Security.getProviders("SSLContext.SSL");
        return this.getProperty("sblim.wbem.sslSocketProvider", providers != null && providers.length > 0 ? providers[0].getClass().getName() : null);
    }

    public String getSslServerSocketProvider() {
        Provider[] providers = Security.getProviders("SSLContext.SSL");
        return this.getProperty("sblim.wbem.sslServerSocketProvider", providers != null && providers.length > 0 ? providers[0].getClass().getName() : null);
    }

    public String getSslProtocol() {
        return this.getSecurityProperty("ssl.Protocol", "SSL");
    }

    public String getSslKeyManagerAlgorithm() {
        return this.getSecurityProperty("ssl.KeyManagerFactory.algorithm", null);
    }

    public String getSslTrustManagerAlgorithm() {
        return this.getSecurityProperty("ssl.TrustManagerFactory.algorithm", null);
    }

    public int getHttpConnectRetriesCount() {
        return Integer.parseInt(this.getProperty("sblim.wbem.httpConnectionRetries", "0"));
    }

    public boolean isHttpContentLengthRetryEnabled() {
        return Boolean.valueOf(this.getProperty("sblim.wbem.httpEnableContentLengthRetry", "false"));
    }

    public int getHttpContentLengthThreshold() {
        return Integer.parseInt(this.getProperty("sblim.wbem.httpContentLengthThreshold", "50"));
    }

    public String getCimXmlParser() {
        return this.getProperty("sblim.wbem.cimxmlParser", "SAX");
    }

    public String getCimXmlEmbObjBuilder() {
        return this.getProperty("sblim.wbem.cimxmlEmbObjBuilder", "AttribOnly");
    }

    public boolean strictEmbObjTypes() {
        return Boolean.valueOf(this.getProperty("sblim.wbem.cimxmlParser.strictEmbObjTypes", "true"));
    }

    public boolean upperCaseEmbObjEntities() {
        return Boolean.valueOf(this.getProperty("sblim.wbem.cimxmlBuilder.upperCaseEmbObjEntities", "true"));
    }

    public boolean synchronizedSslHandshake() {
        return Boolean.valueOf(this.getProperty("sblim.wbem.synchronizedSslHandshake", "false"));
    }

    public boolean socketConnectWithTimeout() {
        return Boolean.valueOf(this.getProperty("sblim.wbem.socketConnectWithTimeout", "true"));
    }

    public boolean isDefaultAuthorizationEnabled() {
        return Boolean.valueOf(this.getProperty("sblim.wbem.default.authorization.enabled", "false"));
    }

    public String getDefaultPrincipal() {
        return this.getProperty("sblim.wbem.default.principal", "default");
    }

    public String getDefaultCredentials() {
        return this.getProperty("sblim.wbem.default.credential", "default");
    }

    public boolean isCimXmlTracingEnabled() {
        return Boolean.valueOf(this.getProperty("sblim.wbem.cimxmlTracing", "false"));
    }

    public int getListenerBacklog() {
        return Integer.parseInt(this.getProperty("sblim.wbem.listenerBacklog", "2"));
    }

    public int getListenerHttpTimeout() {
        return Integer.parseInt(this.getProperty("sblim.wbem.listenerHttpTimeout", "10000"));
    }

    public int getListenerMaxPoolSize() {
        return Integer.parseInt(this.getProperty("sblim.wbem.listenerPoolMaxSize", "8"));
    }

    public int getListenerMinPoolSize() {
        return Integer.parseInt(this.getProperty("sblim.wbem.listenerPoolMinSize", "2"));
    }

    public long getListenerMaxIdle() {
        return Long.parseLong(this.getProperty("sblim.wbem.listenerHandlerMaxIdle", "30000"));
    }

    static {
        cConfigURL = null;
        cLoadSuccessful = false;
        cLoadException = null;
        WBEMConfiguration.loadGlobalConfiguration();
        cConfiguration = new WBEMConfiguration();
        WBEMConfiguration.cConfiguration.iIsGlobal = true;
    }
}

