/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.util;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.sblim.cimclient.internal.logging.LogAndTraceBroker;

public class ThreadPool {
    private ThreadGroup iGroup;
    private List<Worker> iIdleThreads = new LinkedList<Worker>();
    private List<Worker> iThreadPool = new LinkedList<Worker>();
    private List<Runnable> iQueue = new LinkedList<Runnable>();
    private long iIdleTimeout;
    private int iMaxPoolSize;
    private int iMinPoolSize;
    private int iToleratedBacklog;
    private int iCntr = 0;
    private boolean iShutdown = false;
    private String iWorkerName;

    public ThreadPool(int pMinPoolSize, int pMaxPoolSize, int pToleratedBacklog, long pToleratedIdle, ThreadGroup pGroup, String pWorkerName) {
        this.iGroup = pGroup != null ? pGroup : new ThreadGroup("TreadPool Group");
        this.iMinPoolSize = pMinPoolSize;
        this.iMaxPoolSize = pMaxPoolSize;
        this.iToleratedBacklog = pToleratedBacklog;
        this.iIdleTimeout = pToleratedIdle;
        this.iWorkerName = pWorkerName != null ? pWorkerName : "Worker ";
        for (int i = 0; i < pMinPoolSize; ++i) {
            Worker worker = new Worker(this, this.iWorkerName + this.getID());
            this.iThreadPool.add(worker);
            worker.start();
        }
    }

    public synchronized long getIdleTimeOutMs() {
        return this.iThreadPool.size() <= this.iMinPoolSize ? -1L : this.iIdleTimeout;
    }

    public synchronized boolean execute(Runnable task, boolean enqueue) {
        boolean mayCreateWorker;
        if (this.iShutdown) {
            return false;
        }
        int totalIdle = this.iIdleThreads.size();
        if (totalIdle > 0) {
            Worker worker = this.iIdleThreads.remove(totalIdle - 1);
            return worker.assignTask(task);
        }
        boolean bl = mayCreateWorker = this.iMaxPoolSize == -1 || this.iThreadPool.size() <= this.iMaxPoolSize;
        if (enqueue) {
            this.iQueue.add(task);
            if (mayCreateWorker && (this.iQueue.size() > this.iToleratedBacklog || this.iThreadPool.size() == 0)) {
                Worker worker = this.createWorker();
                worker.assignTask(this.iQueue.remove(0));
            }
            return true;
        }
        if (mayCreateWorker) {
            Worker worker = this.createWorker();
            return worker.assignTask(task);
        }
        return false;
    }

    private Worker createWorker() {
        Worker worker = new Worker(this, this.iWorkerName + this.getID());
        this.iThreadPool.add(worker);
        return worker;
    }

    protected ThreadGroup getGroup() {
        return this.iGroup;
    }

    public synchronized boolean taskCompleted(Worker worker, boolean timedOut) {
        if (this.iShutdown) {
            return false;
        }
        if (this.iQueue.size() > 0) {
            this.iIdleThreads.remove(worker);
            worker.assignTask(this.iQueue.remove(0));
            return true;
        }
        if (timedOut && this.iThreadPool.size() > this.iMinPoolSize) {
            this.iIdleThreads.remove(worker);
            this.iThreadPool.remove(worker);
            return false;
        }
        if (!this.iIdleThreads.contains(worker)) {
            this.iIdleThreads.add(worker);
        }
        worker.setIdleTimeout(this.getIdleTimeOutMs());
        return true;
    }

    protected synchronized void removeThread(Worker worker) {
        if (worker != null && this.iThreadPool != null) {
            this.iThreadPool.remove(worker);
        }
    }

    public synchronized void shutdown() {
        if (!this.iShutdown) {
            this.iShutdown = true;
            if (this.iIdleThreads != null) {
                for (Worker worker : this.iIdleThreads) {
                    worker.kill();
                }
                this.iIdleThreads = null;
            }
            if (this.iThreadPool != null) {
                for (Worker worker : this.iThreadPool) {
                    worker.kill();
                }
                this.iThreadPool = null;
            }
        }
    }

    private String getID() {
        if (++this.iCntr >= 10000) {
            this.iCntr = 1;
        }
        return String.valueOf(this.iCntr);
    }

    private static class Worker
    extends Thread {
        private boolean iAlive = true;
        private boolean iStarted;
        private ThreadPool iPool;
        private Runnable iTask;
        private long iIdleTimeout;
        private boolean iTimedOut = false;

        public Worker(ThreadPool pool, String name) {
            super(pool.getGroup(), name);
            this.iPool = pool;
            this.setDaemon(true);
        }

        public synchronized void start() {
            this.iStarted = true;
            this.iAlive = true;
            super.start();
        }

        public synchronized void kill() {
            this.iAlive = false;
            this.iStarted = false;
            this.notify();
        }

        public synchronized boolean assignTask(Runnable task) {
            if (this.iAlive) {
                this.iTask = task;
                if (!this.iStarted) {
                    this.start();
                } else {
                    this.notify();
                }
                return true;
            }
            return false;
        }

        public long getIdleTimeout() {
            return this.iIdleTimeout;
        }

        public void setIdleTimeout(long pIdleTimeout) {
            this.iIdleTimeout = pIdleTimeout;
        }

        private synchronized Runnable waitForTask() {
            if (this.iTask != null) {
                Runnable tsk = this.iTask;
                this.iTask = null;
                return tsk;
            }
            this.iAlive = this.iPool.taskCompleted(this, this.iTimedOut);
            if (this.iAlive && this.iTask == null) {
                try {
                    long idleTimeOut = this.getIdleTimeout();
                    if (idleTimeOut > 0L) {
                        this.wait(idleTimeOut);
                        this.iTimedOut = this.iTask == null;
                    } else {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return null;
        }

        public void run() {
            while (this.iAlive) {
                Runnable tsk = this.waitForTask();
                if (tsk == null) continue;
                try {
                    tsk.run();
                }
                catch (Throwable t) {
                    LogAndTraceBroker.getBroker().trace(Level.FINE, "Exception while executing task from thread pool", t);
                }
            }
            this.iStarted = false;
            this.iPool.removeThread(this);
        }
    }
}

