/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.uri;

import org.sblim.cimclient.internal.uri.URIString;
import org.sblim.cimclient.internal.uri.Value;

public class BooleanValue
extends Value {
    private boolean iValue;

    public static Value parse(URIString pUriStr, boolean pThrow) throws IllegalArgumentException {
        boolean value;
        URIString uriStr = pUriStr.deepCopy();
        if (uriStr.cutStarting("true", true)) {
            value = true;
        } else if (uriStr.cutStarting("false", true)) {
            value = false;
        } else {
            if (pThrow) {
                String msg = "Boolean value not found!\n" + uriStr.markPosition();
                throw new IllegalArgumentException(msg);
            }
            return null;
        }
        if (uriStr.length() != 0 && uriStr.charAt(0) != ',') {
            return null;
        }
        pUriStr.set(uriStr);
        return new BooleanValue(value);
    }

    public static Value parse(URIString pUriStr) {
        return BooleanValue.parse(pUriStr, false);
    }

    private BooleanValue(boolean pValue) {
        this.iValue = pValue;
    }

    public boolean getValue() {
        return this.iValue;
    }

    public Boolean getBoolean() {
        return this.iValue;
    }

    public String toString() {
        return Boolean.toString(this.iValue);
    }

    public String getTypeInfo() {
        return "boolean";
    }
}

