/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import org.sblim.cimclient.internal.http.HttpException;
import org.sblim.cimclient.internal.http.HttpHeader;
import org.sblim.cimclient.internal.http.HttpHeaderParser;
import org.sblim.cimclient.internal.http.HttpServerMethod;
import org.sblim.cimclient.internal.http.io.BoundedInputStream;
import org.sblim.cimclient.internal.http.io.ChunkedInputStream;
import org.sblim.cimclient.internal.http.io.PersistentInputStream;
import org.sblim.cimclient.internal.logging.LogAndTraceBroker;

public class MessageReader {
    HttpHeader iHeader;
    HttpServerMethod iMethod;
    private boolean iChunked = false;
    private String iEncoding = "UTF-8";
    InputStream iContent;

    public MessageReader(InputStream pStream) throws IOException, HttpException {
        String contentType;
        this.iMethod = new HttpServerMethod(pStream);
        this.iHeader = new HttpHeader(pStream);
        String encoding = this.iHeader.getField("Transfer-Encoding");
        if (encoding != null && encoding.toLowerCase().endsWith("chunked")) {
            this.iChunked = true;
        }
        String length = this.iHeader.getField("Content-Length");
        int contentLength = -1;
        if (length != null) {
            try {
                contentLength = Integer.parseInt(length);
            }
            catch (Exception e) {
                contentLength = -1;
                LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
                logger.trace(Level.FINER, "Exception while parsing http content-length", e);
            }
        }
        if ((contentType = this.iHeader.getField("Content-Type")) != null) {
            try {
                HttpHeaderParser contentTypeHeader = new HttpHeaderParser(contentType);
                encoding = contentTypeHeader.getValue("charset");
            }
            catch (Exception e) {
                encoding = "UTF-8";
                LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
                logger.trace(Level.FINER, "Exception while parsing http content-type", e);
            }
            this.iEncoding = encoding;
        }
        this.iContent = this.iChunked ? new ChunkedInputStream(new PersistentInputStream(pStream, this.isPersistentConnectionSupported())) : new BoundedInputStream(new PersistentInputStream(pStream, this.isPersistentConnectionSupported()), contentLength);
    }

    public String getCharacterEncoding() {
        return this.iEncoding;
    }

    public HttpHeader getHeader() {
        return this.iHeader;
    }

    public HttpServerMethod getMethod() {
        return this.iMethod;
    }

    public InputStream getInputStream() {
        return this.iContent;
    }

    public boolean isPersistentConnectionSupported() {
        String conn = this.iHeader.getField("Connection");
        if (conn != null) {
            if (conn.equalsIgnoreCase("close")) {
                return false;
            }
            if (conn.equalsIgnoreCase("Keep-Alive")) {
                return true;
            }
        }
        return this.iMethod.getMajorVersion() >= 1 && this.iMethod.getMinorVersion() >= 1;
    }

    public boolean isChunkSupported() {
        String TE;
        return this.iMethod.getMajorVersion() >= 1 && this.iMethod.getMinorVersion() >= 1 && (TE = this.iHeader.getField("TE")) != null && TE.equalsIgnoreCase("trailers");
    }

    public void close() throws IOException {
        this.iContent.close();
    }
}

