/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.http;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.logging.Level;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.sblim.cimclient.internal.http.AllTrustManager;
import org.sblim.cimclient.internal.http.EmptyKeyManager;
import org.sblim.cimclient.internal.logging.LogAndTraceBroker;
import org.sblim.cimclient.internal.util.WBEMConfiguration;

public class HttpSocketFactory {
    private static HttpSocketFactory cInstance = new HttpSocketFactory();

    private HttpSocketFactory() {
    }

    public static HttpSocketFactory getInstance() {
        return cInstance;
    }

    public ServerSocketFactory getServerSocketFactory(SSLContext pContext) {
        return pContext != null ? pContext.getServerSocketFactory() : ServerSocketFactory.getDefault();
    }

    public SocketFactory getClientSocketFactory(SSLContext pContext) {
        return pContext != null ? pContext.getSocketFactory() : SocketFactory.getDefault();
    }

    public SSLContext getClientSSLContext(WBEMConfiguration pProperties) {
        return this.getSSLContext(pProperties, false);
    }

    public SSLContext getServerSSLContext(WBEMConfiguration pProperties) {
        return this.getSSLContext(pProperties, true);
    }

    private SSLContext getSSLContext(WBEMConfiguration pProperties, boolean pIsServer) {
        Provider securityProvider;
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        String provider = pIsServer ? pProperties.getSslServerSocketProvider() : pProperties.getSslSocketProvider();
        logger.trace(Level.FINER, "Loading JSSE provider:" + provider);
        try {
            Class<?> providerClass = Class.forName(provider);
            securityProvider = (Provider)providerClass.newInstance();
            if (Security.getProvider(securityProvider.getName()) == null) {
                Security.addProvider(securityProvider);
            }
        }
        catch (Exception e) {
            logger.trace(Level.FINER, "Exception while loading JSSE provider", e);
            logger.message("CIM2100S", provider);
            logger.exit();
            throw new RuntimeException(e);
        }
        try {
            KeyManager[] keyManager = this.loadKeystore(pProperties, securityProvider);
            TrustManager[] trustManager = this.loadTruststore(pProperties, securityProvider);
            SSLContext sslContext = SSLContext.getInstance(pProperties.getSslProtocol(), securityProvider);
            sslContext.init(keyManager, trustManager, null);
            logger.exit();
            return sslContext;
        }
        catch (Exception e) {
            logger.trace(Level.FINER, "Exception while initializing SSL context (provider:" + provider + ")", e);
            logger.message("CIM2301S");
            logger.exit();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TrustManager[] loadTruststore(WBEMConfiguration pProperties, Provider pSecurityProvider) {
        TrustManager[] trustAll;
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        TrustManager[] trustManager = trustAll = new X509TrustManager[]{new AllTrustManager()};
        String truststorePath = pProperties.getSslTrustStorePath();
        char[] truststorePassword = pProperties.getSslTrustStorePassword().toCharArray();
        String truststoreType = pProperties.getSslTrustStoreType();
        String trustManagerAlgorithm = pProperties.getSslTrustManagerAlgorithm();
        logger.trace(Level.FINER, "Using SSL truststore \"" + truststorePath + "\" (" + truststoreType + "/" + trustManagerAlgorithm + ")");
        if (truststorePath == null || truststorePath.trim().length() == 0) {
            logger.message("CIM2210C");
        } else {
            FileInputStream fis = null;
            try {
                KeyStore trustStore = KeyStore.getInstance(truststoreType);
                fis = new FileInputStream(truststorePath);
                trustStore.load(fis, truststorePassword);
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(trustManagerAlgorithm, pSecurityProvider);
                trustManagerFactory.init(trustStore);
                trustManager = trustManagerFactory.getTrustManagers();
            }
            catch (FileNotFoundException e) {
                logger.trace(Level.FINER, "Exception while loading truststore", e);
                logger.message("CIM2201C", truststorePath);
            }
            catch (IOException e) {
                logger.trace(Level.FINER, "Exception while loading truststore", e);
                logger.message("CIM2202W", truststorePath);
            }
            catch (NoSuchAlgorithmException e) {
                logger.trace(Level.FINER, "Exception while loading truststore", e);
                logger.message("CIM2208W", trustManagerAlgorithm);
            }
            catch (CertificateException e) {
                logger.trace(Level.FINER, "Exception while loading truststore", e);
                logger.message("CIM2203W", truststorePath);
            }
            catch (KeyStoreException e) {
                logger.trace(Level.FINER, "Exception while loading truststore", e);
                logger.message("CIM2205W", truststoreType);
            }
            catch (Exception e) {
                logger.trace(Level.FINER, "Exception while loading truststore", e);
                logger.message("CIM2206W", truststorePath);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        logger.trace(Level.FINER, "Exception while closing truststore", e);
                    }
                }
            }
        }
        if (trustManager == trustAll) {
            logger.message("CIM2207C");
        } else {
            logger.message("CIM2209C");
        }
        logger.exit();
        return trustManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyManager[] loadKeystore(WBEMConfiguration pProperties, Provider pSecurityProvider) {
        KeyManager[] noKeys;
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        KeyManager[] keyManager = noKeys = new KeyManager[]{new EmptyKeyManager()};
        String keystorePath = pProperties.getSslKeyStorePath();
        char[] keystorePassword = pProperties.getSslKeyStorePassword().toCharArray();
        String keystoreType = pProperties.getSslKeyStoreType();
        String keyManagerAlgorithm = pProperties.getSslKeyManagerAlgorithm();
        logger.trace(Level.FINER, "Using SSL keystore \"" + keystorePath + "\" (" + keystoreType + "/" + keyManagerAlgorithm + ")");
        if (keystorePath == null || keystorePath.trim().length() == 0) {
            logger.message("CIM2110C");
        } else {
            FileInputStream fis = null;
            try {
                KeyStore keystore = KeyStore.getInstance(keystoreType);
                fis = new FileInputStream(keystorePath);
                keystore.load(fis, keystorePassword);
                KeyManagerFactory keymanagerfactory = KeyManagerFactory.getInstance(keyManagerAlgorithm, pSecurityProvider);
                keymanagerfactory.init(keystore, keystorePassword);
                keyManager = keymanagerfactory.getKeyManagers();
            }
            catch (FileNotFoundException e) {
                logger.trace(Level.FINER, "Exception while loading keystore", e);
                logger.message("CIM2101C", keystorePath);
            }
            catch (IOException e) {
                logger.trace(Level.FINER, "Exception while loading keystore", e);
                logger.message("CIM2102W", keystorePath);
            }
            catch (NoSuchAlgorithmException e) {
                logger.trace(Level.FINER, "Exception while loading keystore", e);
                logger.message("CIM2108W", keyManagerAlgorithm);
            }
            catch (CertificateException e) {
                logger.trace(Level.FINER, "Exception while loading keystore", e);
                logger.message("CIM2103W", keystorePath);
            }
            catch (UnrecoverableKeyException e) {
                logger.trace(Level.FINER, "Exception while loading keystore", e);
                logger.message("CIM2104W", keystorePath);
            }
            catch (KeyStoreException e) {
                logger.trace(Level.FINER, "Exception while loading keystore", e);
                logger.message("CIM2105W", keystoreType);
            }
            catch (Exception e) {
                logger.trace(Level.FINER, "Exception while loading keystore", e);
                logger.message("CIM2106W", keystorePath);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        logger.trace(Level.FINER, "Exception while closing keystore", e);
                    }
                }
            }
        }
        if (keyManager == noKeys) {
            logger.message("CIM2107C");
        }
        logger.exit();
        return keyManager;
    }
}

