/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import org.sblim.cimclient.internal.http.HttpConnectionHandler;
import org.sblim.cimclient.internal.http.HttpServerWorker;
import org.sblim.cimclient.internal.http.HttpSocketFactory;
import org.sblim.cimclient.internal.logging.LogAndTraceBroker;
import org.sblim.cimclient.internal.util.ThreadPool;
import org.sblim.cimclient.internal.util.WBEMConfiguration;

public class HttpServerConnection
implements Runnable {
    private int iPort;
    private ServerSocket iServerSocket;
    private HttpConnectionHandler iHandler;
    private HttpConnectionDispatcher iDispatcher;
    private boolean iClose = true;
    private String iServerName;
    private boolean iSsl;
    private Thread iRunner;
    private WBEMConfiguration iSessionProperties;
    private final int iTimeout;

    public HttpServerConnection(HttpConnectionHandler pHandler, String pLocalAddress, int pPort, boolean pSsl, WBEMConfiguration pProperties) throws IOException {
        this.iPort = pPort;
        this.iHandler = pHandler;
        this.iSsl = pSsl;
        this.iServerName = pSsl ? "HTTPS Server" : "HTTP Server";
        this.iSessionProperties = pProperties != null ? pProperties : WBEMConfiguration.getGlobalConfiguration();
        SSLContext sslContext = pSsl ? HttpSocketFactory.getInstance().getServerSSLContext(this.iSessionProperties) : null;
        ServerSocket serverSocket = this.iServerSocket = pLocalAddress != null && pLocalAddress.length() > 0 ? HttpSocketFactory.getInstance().getServerSocketFactory(sslContext).createServerSocket(pPort, 50, InetAddress.getByName(pLocalAddress)) : HttpSocketFactory.getInstance().getServerSocketFactory(sslContext).createServerSocket(pPort);
        if (this.iServerSocket instanceof SSLServerSocket && this.iSessionProperties.getSslTrustStorePath() != null && this.iSessionProperties.getSslTrustStorePath().length() > 1) {
            ((SSLServerSocket)this.iServerSocket).setNeedClientAuth(true);
        }
        this.iTimeout = this.iSessionProperties.getListenerHttpTimeout();
    }

    public void setName(String pName) {
        if (this.iRunner != null) {
            this.iRunner.setName(pName);
        }
    }

    public int getPort() {
        return this.iServerSocket.getLocalPort();
    }

    public String getLocalIp() throws UnknownHostException {
        String ip = this.iServerSocket.getInetAddress().getHostAddress();
        String localhost = InetAddress.getLocalHost().getHostAddress();
        return "0.0.0.0".equals(ip) ? localhost : ip;
    }

    public String getLocalHostName() throws UnknownHostException {
        String ip = this.iServerSocket.getInetAddress().getHostName();
        String localhost = InetAddress.getLocalHost().getHostName();
        return "0.0.0.0".equals(ip) ? localhost : ip;
    }

    public boolean isSSL() {
        return this.iSsl;
    }

    public void start() {
        if (this.iClose) {
            this.iClose = false;
            ThreadGroup group = new ThreadGroup("CIMListener on port " + String.valueOf(this.iPort));
            this.iDispatcher = new HttpConnectionDispatcher(group, this.iHandler, new ThreadPool(this.iSessionProperties.getListenerMinPoolSize(), this.iSessionProperties.getListenerMaxPoolSize(), this.iSessionProperties.getListenerBacklog(), this.iSessionProperties.getListenerMaxIdle(), group, "Handler "));
            this.iDispatcher.start();
            this.iRunner = new Thread(group, this, this.iServerName);
            this.iRunner.setDaemon(true);
            this.iRunner.start();
        }
    }

    public void run() {
        while (!this.iClose) {
            try {
                Socket socket = this.iServerSocket.accept();
                try {
                    socket.setTcpNoDelay(true);
                    socket.setSoTimeout(this.iTimeout);
                }
                catch (IOException e) {
                    LogAndTraceBroker.getBroker().trace(Level.FINE, "Exception while adjusting socket options", e);
                }
                this.iDispatcher.dispatch(socket);
            }
            catch (Throwable t) {
                if (t instanceof SocketException && this.iClose) break;
                try {
                    LogAndTraceBroker.getBroker().trace(Level.FINE, "Exception while waiting for incoming http connections");
                }
                catch (Throwable throwable) {}
            }
        }
        try {
            LogAndTraceBroker.getBroker().trace(Level.FINE, "Shutting down CIMListener on port " + this.iPort);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            this.iDispatcher.close();
        }
        catch (Exception e) {
            LogAndTraceBroker.getBroker().trace(Level.FINE, "Exception while closing http connection dispatcher", e);
        }
        this.iDispatcher = null;
        this.iRunner = null;
    }

    public void close() {
        if (!this.iClose) {
            this.iClose = true;
            try {
                this.iServerSocket.close();
                this.iServerSocket = null;
            }
            catch (Exception e) {
                LogAndTraceBroker.getBroker().trace(Level.FINE, "Exception while closing server socket", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HttpConnectionDispatcher
    extends Thread {
        private List<Socket> iConnectionPool = new LinkedList<Socket>();
        private boolean iAlive = true;
        private HttpConnectionHandler iHandler;
        private ThreadPool iThreadPool;

        public HttpConnectionDispatcher(ThreadGroup pGroup, HttpConnectionHandler pHandler, ThreadPool pPool) {
            super(pGroup, "Connection Dispatcher");
            this.setDaemon(true);
            this.iHandler = pHandler;
            this.iThreadPool = pPool;
        }

        public List<Socket> getConnectionPool() {
            return this.iConnectionPool;
        }

        public synchronized void dispatch(Socket pSocket) {
            this.iConnectionPool.add(pSocket);
            this.notify();
        }

        public synchronized Socket getConnection() {
            while (this.iConnectionPool.size() == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.iAlive) continue;
                return null;
            }
            return this.iConnectionPool.remove(0);
        }

        @Override
        public void run() {
            while (this.iAlive) {
                try {
                    Socket socket = this.getConnection();
                    if (socket == null) continue;
                    this.iThreadPool.execute(new HttpServerWorker(this.iHandler, socket), true);
                }
                catch (Throwable t) {
                    try {
                        LogAndTraceBroker.getBroker().trace(Level.FINE, "Exception while submitting worker to thread pool", t);
                    }
                    catch (Throwable throwable) {}
                }
            }
            try {
                this.iHandler.close();
            }
            catch (Exception e) {
                LogAndTraceBroker.getBroker().trace(Level.FINE, "Exception while closing http connection handler", e);
            }
            try {
                this.iThreadPool.shutdown();
            }
            catch (Exception e) {
                LogAndTraceBroker.getBroker().trace(Level.FINE, "Exception during shut down of thread pool", e);
            }
        }

        public synchronized void close() {
            this.iAlive = false;
            this.notifyAll();
        }
    }
}

