/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.discovery.slp;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.cim.CIMObjectPath;
import javax.security.auth.Subject;
import javax.wbem.client.WBEMClient;
import javax.wbem.client.WBEMClientFactory;
import org.sblim.cimclient.discovery.WBEMServiceAdvertisement;
import org.sblim.cimclient.internal.logging.LogAndTraceBroker;
import org.sblim.slp.ServiceURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WBEMServiceAdvertisementSLP
implements WBEMServiceAdvertisement {
    private static final Pattern ATTR_PATTERN = Pattern.compile("[(]?(.+)=([^)]+)[)]?");
    private String iDA;
    private ServiceURL iServiceUrl;
    private Map<String, String> iAttributeMap;
    private boolean iExpired = false;

    public WBEMServiceAdvertisementSLP(String pDA, ServiceURL pUrl, List<String> pAttributes) {
        if (pDA == null || pUrl == null) {
            throw new IllegalArgumentException("Directory and URL must not be null");
        }
        this.iDA = pDA;
        this.iServiceUrl = pUrl;
        this.parseAttributes(pAttributes);
    }

    private void parseAttributes(List<String> pAttributes) {
        this.iAttributeMap = new HashMap<String, String>();
        for (String attribute : pAttributes) {
            Matcher matcher = ATTR_PATTERN.matcher(attribute);
            if (matcher.matches()) {
                String key = matcher.group(1).trim();
                String value = matcher.group(2).trim();
                this.iAttributeMap.put(key, value);
                continue;
            }
            LogAndTraceBroker.getBroker().trace(Level.FINE, "SLP discovery returned invalid attribute: " + attribute);
        }
    }

    @Override
    public String getAttribute(String pAttributeName) {
        return this.iAttributeMap.get(pAttributeName);
    }

    @Override
    public Set<Map.Entry<String, String>> getAttributes() {
        return this.iAttributeMap.entrySet();
    }

    @Override
    public String getConcreteServiceType() {
        return this.iServiceUrl.getServiceType().getConcreteTypeName();
    }

    @Override
    public String getServiceUrl() {
        return this.getConcreteServiceType() + "://" + this.iServiceUrl.getHost() + ":" + String.valueOf(this.iServiceUrl.getPort());
    }

    @Override
    public WBEMClient createClient(Subject pSubject, Locale[] pLocales) throws Exception {
        String communication = this.getAttribute("CommunicationMechanism");
        if (communication.equalsIgnoreCase("OTHER")) {
            communication = this.getAttribute("OtherCommunicationMechanismDescription");
        }
        WBEMClient client = WBEMClientFactory.getClient(communication);
        CIMObjectPath path = new CIMObjectPath(this.iServiceUrl.getServiceType().getConcreteTypeName(), this.iServiceUrl.getHost(), String.valueOf(this.iServiceUrl.getPort()), null, null, null);
        client.initialize(path, pSubject, pLocales);
        return client;
    }

    @Override
    public String getDirectory() {
        return this.iDA;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getServiceUrl());
        buffer.append("{slp da=\"");
        buffer.append(this.iDA);
        buffer.append("\", attributes=[");
        Iterator<Map.Entry<String, String>> iter = this.iAttributeMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            buffer.append("\"");
            buffer.append(entry.getKey());
            buffer.append("=");
            buffer.append(entry.getValue());
            buffer.append("\"");
            if (!iter.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("]}");
        return buffer.toString();
    }

    @Override
    public String[] getInteropNamespaces() {
        return this.parseCommaSeparatedList(this.getAttribute("InteropSchemaNamespace"));
    }

    private String[] parseCommaSeparatedList(String pAttribute) {
        String[] split = pAttribute.split("[,\\n]");
        int emptyCount = 0;
        for (int i = 0; i < split.length; ++i) {
            split[i] = split[i].trim();
            if (split[i].length() != 0) continue;
            ++emptyCount;
        }
        if (emptyCount > 0) {
            String[] result = new String[split.length - emptyCount];
            int j = 0;
            for (int i = 0; i < split.length; ++i) {
                if (split[i].length() <= 0) continue;
                result[j++] = split[i];
            }
            return result;
        }
        return split;
    }

    @Override
    public String getServiceId() {
        return this.getAttribute("service-id");
    }

    @Override
    public boolean isExpired() {
        return this.iExpired;
    }

    @Override
    public void setExpired(boolean pExpired) {
        this.iExpired = pExpired;
    }

    public boolean equals(Object pObj) {
        if (pObj == this) {
            return true;
        }
        if (pObj != null && pObj instanceof WBEMServiceAdvertisement) {
            WBEMServiceAdvertisement that = (WBEMServiceAdvertisement)pObj;
            return this.getServiceUrl().equals(that.getServiceUrl()) && this.getDirectory().equals(that.getDirectory());
        }
        return false;
    }

    public int hashCode() {
        return this.iServiceUrl.hashCode() + this.iDA.hashCode();
    }
}

