/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.cimxml.sax.node;

import javax.cim.CIMDataType;
import javax.cim.CIMDateTimeAbsolute;
import javax.cim.CIMDateTimeInterval;
import javax.cim.UnsignedInteger64;
import org.sblim.cimclient.internal.cimxml.sax.CIMObjectFactory;
import org.sblim.cimclient.internal.cimxml.sax.SAXSession;
import org.sblim.cimclient.internal.cimxml.sax.node.AbstractScalarValueNode;
import org.sblim.cimclient.internal.cimxml.sax.node.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class KeyValueNode
extends AbstractScalarValueNode {
    private CIMDataType iType;
    private String iValueTypeStr;
    private Object iValue;

    public KeyValueNode() {
        super("KEYVALUE");
    }

    public void init(Attributes pAttribs, SAXSession pSession) throws SAXException {
        this.iType = KeyValueNode.getCIMType(pAttribs, true);
        this.iValue = null;
        if (this.iType != null) {
            if (this.iType.isArray()) {
                throw new SAXException("KEYVALUE node cannot be array typed!");
            }
            return;
        }
        this.iValueTypeStr = pAttribs.getValue("VALUETYPE");
    }

    public void parseData(String pData) throws SAXException {
        if (this.iType == null) {
            this.setTypeAndValue(pData);
        } else {
            this.iValue = CIMObjectFactory.getObject(this.iType, pData);
        }
    }

    public void testChild(String pNodeNameEnum) throws SAXException {
        throw new SAXException("KEYVALUE node cannot have any child nodes!");
    }

    public void childParsed(Node pChild) {
    }

    public void testCompletness() {
    }

    public Object getValue() {
        return this.iValue == null ? "" : this.iValue;
    }

    public CIMDataType getType() {
        return this.iType;
    }

    private void setTypeAndValue(String pValue) throws SAXException {
        if (this.iType != null) {
            return;
        }
        if (this.iValueTypeStr == null) {
            throw new SAXException("KEYVALUE node must have a VALUETYPE attribute!");
        }
        if (this.iValueTypeStr.equals("numeric")) {
            if (!(this.setUInt64(pValue) || this.setSInt64(pValue) || this.setReal64(pValue))) {
                throw new SAXException("Unparseable \"number\" value: " + pValue + " !");
            }
        } else if (this.iValueTypeStr.equals("string")) {
            if (!this.setDTAbsolute(pValue) && !this.setDTInterval(pValue)) {
                this.iValue = pValue;
                this.iType = CIMDataType.STRING_T;
            }
        } else if (this.iValueTypeStr.equals("boolean")) {
            if (!this.setBoolean(pValue)) {
                throw new SAXException("Unparseable \"boolean\" value: " + pValue + " !");
            }
        } else {
            throw new SAXException("KEYVALUE node's VALUETYPE attribute must be string, boolean or numeric! " + pValue + " is not allowed!");
        }
    }

    private boolean setUInt64(String pValue) {
        try {
            this.iValue = new UnsignedInteger64(pValue);
        }
        catch (NumberFormatException e) {
            return false;
        }
        this.iType = CIMDataType.UINT64_T;
        return true;
    }

    private boolean setSInt64(String pValue) {
        try {
            this.iValue = new Long(pValue);
        }
        catch (NumberFormatException e) {
            return false;
        }
        this.iType = CIMDataType.SINT64_T;
        return true;
    }

    private boolean setReal64(String pValue) {
        try {
            this.iValue = new Double(pValue);
        }
        catch (NumberFormatException e) {
            return false;
        }
        this.iType = CIMDataType.REAL64_T;
        return true;
    }

    private boolean setBoolean(String pValue) {
        try {
            this.iValue = Boolean.valueOf(pValue);
        }
        catch (NumberFormatException e) {
            return false;
        }
        this.iType = CIMDataType.BOOLEAN_T;
        return true;
    }

    private boolean setDTAbsolute(String pValue) {
        try {
            this.iValue = new CIMDateTimeAbsolute(pValue);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        this.iType = CIMDataType.DATETIME_T;
        return true;
    }

    private boolean setDTInterval(String pValue) {
        try {
            this.iValue = new CIMDateTimeInterval(pValue);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        this.iType = CIMDataType.DATETIME_T;
        return true;
    }
}

