/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.cimxml;

import java.io.StringReader;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import javax.cim.CIMArgument;
import javax.cim.CIMClass;
import javax.cim.CIMClassProperty;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTime;
import javax.cim.CIMDateTimeAbsolute;
import javax.cim.CIMDateTimeInterval;
import javax.cim.CIMInstance;
import javax.cim.CIMMethod;
import javax.cim.CIMNamedElementInterface;
import javax.cim.CIMObjectPath;
import javax.cim.CIMParameter;
import javax.cim.CIMProperty;
import javax.cim.CIMQualifier;
import javax.cim.CIMQualifierType;
import javax.cim.CIMTypedElement;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger64;
import javax.cim.UnsignedInteger8;
import javax.wbem.WBEMException;
import org.sblim.cimclient.internal.cim.CIMQualifiedElementInterfaceImpl;
import org.sblim.cimclient.internal.cimxml.CIMClientXML_HelperImpl;
import org.sblim.cimclient.internal.cimxml.CIMMessage;
import org.sblim.cimclient.internal.cimxml.CIMRequest;
import org.sblim.cimclient.internal.cimxml.CIMResponse;
import org.sblim.cimclient.internal.cimxml.CIMXMLParseException;
import org.sblim.cimclient.internal.cimxml.LocalPathBuilder;
import org.sblim.cimclient.internal.cimxml.TypedValue;
import org.sblim.cimclient.internal.logging.LogAndTraceBroker;
import org.sblim.cimclient.internal.util.WBEMConfiguration;
import org.sblim.cimclient.internal.util.XMLHostStr;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CIMXMLParserImpl {
    private static LocalPathBuilder cLocalPathBuilder = new LocalPathBuilder(null);
    private static final TreeMap<String, CIMDataType> TYPESTR_MAP = new TreeMap(new Comparator<Object>(){

        @Override
        public int compare(Object pO1, Object pO2) {
            return ((String)pO1).compareToIgnoreCase((String)pO2);
        }
    });
    private static final int VALUE = 1;
    private static final int VALUEA = 2;
    private static final int VALUEREF = 4;
    private static final int VALUEREFA = 8;

    public static void setLocalObjectPath(CIMObjectPath pLocalOp) {
        cLocalPathBuilder = new LocalPathBuilder(pLocalOp);
    }

    public static CIMMessage parseCIM(Element pCimE) throws CIMXMLParseException {
        Attr cim_cimversionA = (Attr)CIMXMLParserImpl.searchAttribute(pCimE, "CIMVERSION");
        String cimversion = cim_cimversionA.getNodeValue();
        Attr cim_dtdversionA = (Attr)CIMXMLParserImpl.searchAttribute(pCimE, "DTDVERSION");
        String dtdversion = cim_dtdversionA.getNodeValue();
        Element messageE = (Element)CIMXMLParserImpl.searchFirstNode(pCimE, "MESSAGE");
        if (messageE != null) {
            CIMMessage message = CIMXMLParserImpl.parseMESSAGE(cimversion, dtdversion, messageE);
            message.setCIMVersion(cimversion);
            message.setDTDVersion(dtdversion);
            return message;
        }
        throw new CIMXMLParseException();
    }

    public static TypedValue parseVALUE(Element pValueE) throws CIMXMLParseException {
        String nodeValue;
        String typeStr = CIMXMLParserImpl.attribute(pValueE, "TYPE");
        CIMDataType type = typeStr == null ? null : CIMXMLParserImpl.parseScalarTypeStr(typeStr);
        Text t = (Text)pValueE.getFirstChild();
        String valueStr = t != null ? ((nodeValue = t.getNodeValue()) == null ? "" : nodeValue) : "";
        return new TypedValue(type, valueStr);
    }

    public static TypedValue parseVALUEARRAY(Element pValueArrayE) throws CIMXMLParseException {
        String typeStr = CIMXMLParserImpl.attribute(pValueArrayE, "TYPE");
        CIMDataType type = typeStr == null ? null : CIMXMLParserImpl.parseArrayTypeStr(typeStr);
        Element[] valueEA = CIMXMLParserImpl.searchNodes(pValueArrayE, "VALUE");
        String[] strA = new String[valueEA == null ? 0 : valueEA.length];
        for (int i = 0; i < strA.length; ++i) {
            String valueStr;
            Element valueE = valueEA[i];
            strA[i] = valueStr = (String)CIMXMLParserImpl.parseVALUE(valueE).getValue();
        }
        return new TypedValue(type, strA);
    }

    public static CIMObjectPath parseVALUEREFERENCE(Element pValuereferenceE) throws CIMXMLParseException {
        Element classpathE = (Element)CIMXMLParserImpl.searchFirstNode(pValuereferenceE, "CLASSPATH");
        if (classpathE != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseCLASSPATH(classpathE);
            return op;
        }
        Element localclasspathE = (Element)CIMXMLParserImpl.searchFirstNode(pValuereferenceE, "LOCALCLASSPATH");
        if (localclasspathE != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseLOCALCLASSPATH(localclasspathE);
            return op;
        }
        Element classnameE = (Element)CIMXMLParserImpl.searchFirstNode(pValuereferenceE, "CLASSNAME");
        if (classnameE != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseCLASSNAME(classnameE);
            return op;
        }
        Element instancepathE = (Element)CIMXMLParserImpl.searchFirstNode(pValuereferenceE, "INSTANCEPATH");
        if (instancepathE != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseINSTANCEPATH(instancepathE);
            return op;
        }
        Element localinstancepathE = (Element)CIMXMLParserImpl.searchFirstNode(pValuereferenceE, "LOCALINSTANCEPATH");
        if (localinstancepathE != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseLOCALINSTANCEPATH(localinstancepathE);
            return op;
        }
        Element instancenameE = (Element)CIMXMLParserImpl.searchFirstNode(pValuereferenceE, "INSTANCENAME");
        if (instancenameE != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseINSTANCENAME(instancenameE);
            return op;
        }
        throw new CIMXMLParseException();
    }

    public static CIMObjectPath[] parseVALUEREFARRAY(Element pValueRefArrayE) throws CIMXMLParseException {
        Element[] valueRefElementA = CIMXMLParserImpl.searchNodes(pValueRefArrayE, "VALUE.REFERENCE");
        CIMObjectPath[] resA = new CIMObjectPath[valueRefElementA == null ? 0 : valueRefElementA.length];
        for (int i = 0; i < resA.length; ++i) {
            Element valueRefE = valueRefElementA[i];
            resA[i] = CIMXMLParserImpl.parseVALUEREFERENCE(valueRefE);
        }
        return resA;
    }

    public static CIMNamedElementInterface parseVALUEOBJECT(Element pValueObjectE) throws CIMXMLParseException {
        Element classE = (Element)CIMXMLParserImpl.searchFirstNode(pValueObjectE, "CLASS");
        if (classE != null) {
            CIMClass obj = CIMXMLParserImpl.parseCLASS(classE);
            return obj;
        }
        Element instanceE = (Element)CIMXMLParserImpl.searchFirstNode(pValueObjectE, "INSTANCE");
        if (instanceE != null) {
            CIMInstance obj = CIMXMLParserImpl.parseINSTANCE(instanceE);
            return obj;
        }
        throw new CIMXMLParseException();
    }

    public static CIMInstance parseVALUENAMEDINSTANCE(Element pValueNamedInstanceE) throws CIMXMLParseException {
        Element instancenameE = (Element)CIMXMLParserImpl.searchFirstNode(pValueNamedInstanceE, "INSTANCENAME");
        if (instancenameE == null) {
            throw new CIMXMLParseException();
        }
        CIMObjectPath op = CIMXMLParserImpl.parseINSTANCENAME(instancenameE);
        Element instanceE = (Element)CIMXMLParserImpl.searchFirstNode(pValueNamedInstanceE, "INSTANCE");
        if (instanceE == null) {
            throw new CIMXMLParseException();
        }
        CIMInstance inst = CIMXMLParserImpl.parseINSTANCE(instanceE, op);
        return inst;
    }

    public static CIMInstance parseVALUEINSTANCEWITHPATH(Element pValueNamedInstanceE) throws CIMXMLParseException {
        Element instancepathE = (Element)CIMXMLParserImpl.searchFirstNode(pValueNamedInstanceE, "INSTANCEPATH");
        if (instancepathE == null) {
            throw new CIMXMLParseException();
        }
        CIMObjectPath op = CIMXMLParserImpl.parseINSTANCEPATH(instancepathE);
        Element instanceE = (Element)CIMXMLParserImpl.searchFirstNode(pValueNamedInstanceE, "INSTANCE");
        if (instanceE == null) {
            throw new CIMXMLParseException();
        }
        CIMInstance inst = CIMXMLParserImpl.parseINSTANCE(instanceE, op);
        return inst;
    }

    public static CIMNamedElementInterface parseVALUENAMEDOBJECT(Element pValueNamedObjectE) throws CIMXMLParseException {
        Element classE = (Element)CIMXMLParserImpl.searchFirstNode(pValueNamedObjectE, "CLASS");
        if (classE != null) {
            CIMClass obj = CIMXMLParserImpl.parseCLASS(classE);
            return obj;
        }
        Element instancenameE = (Element)CIMXMLParserImpl.searchFirstNode(pValueNamedObjectE, "INSTANCENAME");
        if (instancenameE != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseINSTANCENAME(instancenameE);
            Element instanceE = (Element)CIMXMLParserImpl.searchFirstNode(pValueNamedObjectE, "INSTANCE");
            if (instanceE == null) {
                throw new CIMXMLParseException();
            }
            CIMInstance inst = CIMXMLParserImpl.parseINSTANCE(instanceE, op);
            return inst;
        }
        throw new CIMXMLParseException();
    }

    public static CIMNamedElementInterface parseVALUEOBJECTWITHPATH(Element pValueObjectWithPathE) throws CIMXMLParseException {
        Element classpathE = (Element)CIMXMLParserImpl.searchFirstNode(pValueObjectWithPathE, "CLASSPATH");
        if (classpathE != null) {
            Element classE = (Element)CIMXMLParserImpl.searchFirstNode(pValueObjectWithPathE, "CLASS");
            if (classE == null) {
                throw new CIMXMLParseException();
            }
            CIMClass obj = CIMXMLParserImpl.parseCLASS(classE);
            return obj;
        }
        Element instancepathE = (Element)CIMXMLParserImpl.searchFirstNode(pValueObjectWithPathE, "INSTANCEPATH");
        if (instancepathE != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseINSTANCEPATH(instancepathE);
            Element instanceE = (Element)CIMXMLParserImpl.searchFirstNode(pValueObjectWithPathE, "INSTANCE");
            if (instanceE == null) {
                throw new CIMXMLParseException();
            }
            CIMInstance inst = CIMXMLParserImpl.parseINSTANCE(instanceE, op);
            return inst;
        }
        throw new CIMXMLParseException();
    }

    public static CIMNamedElementInterface parseVALUEOBJECTWITHLOCALPATH(Element pValueObjectWithLocalPathE) throws CIMXMLParseException {
        Element localclasspathE = (Element)CIMXMLParserImpl.searchFirstNode(pValueObjectWithLocalPathE, "LOCALCLASSPATH");
        if (localclasspathE != null) {
            Element classE = (Element)CIMXMLParserImpl.searchFirstNode(pValueObjectWithLocalPathE, "CLASS");
            if (classE == null) {
                throw new CIMXMLParseException();
            }
            CIMClass obj = CIMXMLParserImpl.parseCLASS(classE);
            return obj;
        }
        Element localinstancepathE = (Element)CIMXMLParserImpl.searchFirstNode(pValueObjectWithLocalPathE, "LOCALINSTANCEPATH");
        if (localinstancepathE != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseLOCALINSTANCEPATH(localinstancepathE);
            Element instanceE = (Element)CIMXMLParserImpl.searchFirstNode(pValueObjectWithLocalPathE, "INSTANCE");
            if (instanceE == null) {
                throw new CIMXMLParseException();
            }
            CIMInstance inst = CIMXMLParserImpl.parseINSTANCE(instanceE, op);
            return inst;
        }
        throw new CIMXMLParseException();
    }

    public static CIMObjectPath parseNAMESPACEPATH(Element pNameSpacePathE) throws CIMXMLParseException {
        Element hostE = (Element)CIMXMLParserImpl.searchFirstNode(pNameSpacePathE, "HOST");
        if (hostE == null) {
            throw new CIMXMLParseException();
        }
        XMLHostStr xmlHostStr = new XMLHostStr(CIMXMLParserImpl.parseHOST(hostE));
        Element localnamespacepathE = (Element)CIMXMLParserImpl.searchFirstNode(pNameSpacePathE, "LOCALNAMESPACEPATH");
        if (localnamespacepathE == null) {
            throw new CIMXMLParseException();
        }
        String nameSpace = CIMXMLParserImpl.parseLOCALNAMESPACEPATH(localnamespacepathE);
        return new CIMObjectPath(xmlHostStr.getProtocol(), xmlHostStr.getHost(), xmlHostStr.getPort(), nameSpace, null, null);
    }

    public static String parseLOCALNAMESPACEPATH(Element pLocalNameSpaceE) throws CIMXMLParseException {
        Element[] nameSpaceElementA = CIMXMLParserImpl.searchNodes(pLocalNameSpaceE, "NAMESPACE");
        if (nameSpaceElementA == null) {
            if (cLocalPathBuilder == null) {
                throw new CIMXMLParseException("NAMESPACE child element is mandatory for LOCALNAMESPACEPATH element!");
            }
            return cLocalPathBuilder.getBasePath().getNamespace();
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < nameSpaceElementA.length; ++i) {
            Element namespaceE = nameSpaceElementA[i];
            String s = CIMXMLParserImpl.parseNAMESPACE(namespaceE);
            if (i > 0) {
                sb.append("/" + s);
                continue;
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static String parseHOST(Element pHostE) {
        Text valueT = (Text)CIMXMLParserImpl.searchFirstChild(pHostE);
        String host = valueT.getNodeValue();
        return host;
    }

    public static String parseNAMESPACE(Element pNameSpaceE) {
        Attr namespace_nameA = (Attr)CIMXMLParserImpl.searchAttribute(pNameSpaceE, "NAME");
        String n = namespace_nameA.getValue();
        return n;
    }

    public static CIMObjectPath parseCLASSPATH(Element pClassPathE) throws CIMXMLParseException {
        Element namespacepathE = (Element)CIMXMLParserImpl.searchFirstNode(pClassPathE, "NAMESPACEPATH");
        if (namespacepathE == null) {
            throw new CIMXMLParseException();
        }
        CIMObjectPath nsPath = CIMXMLParserImpl.parseNAMESPACEPATH(namespacepathE);
        Element classnameE = (Element)CIMXMLParserImpl.searchFirstNode(pClassPathE, "CLASSNAME");
        if (classnameE == null) {
            throw new CIMXMLParseException();
        }
        String className = CIMXMLParserImpl.parseClassName(classnameE);
        return new CIMObjectPath(nsPath.getScheme(), nsPath.getHost(), nsPath.getPort(), nsPath.getNamespace(), className, null);
    }

    public static CIMObjectPath parseLOCALCLASSPATH(Element pClassPathE) throws CIMXMLParseException {
        Element localnamespacepathE = (Element)CIMXMLParserImpl.searchFirstNode(pClassPathE, "LOCALNAMESPACEPATH");
        if (localnamespacepathE == null) {
            throw new CIMXMLParseException();
        }
        String nameSpace = CIMXMLParserImpl.parseLOCALNAMESPACEPATH(localnamespacepathE);
        Element classnameE = (Element)CIMXMLParserImpl.searchFirstNode(pClassPathE, "CLASSNAME");
        if (classnameE == null) {
            throw new CIMXMLParseException();
        }
        CIMObjectPath op = CIMXMLParserImpl.parseCLASSNAME(classnameE);
        return cLocalPathBuilder.build(op.getObjectName(), nameSpace);
    }

    public static String parseClassName(Element pClassNameE) {
        Attr classname_nameA = (Attr)CIMXMLParserImpl.searchAttribute(pClassNameE, "NAME");
        return classname_nameA.getNodeValue();
    }

    public static CIMObjectPath parseCLASSNAME(Element pClassNameE) {
        return cLocalPathBuilder.build(CIMXMLParserImpl.parseClassName(pClassNameE), null);
    }

    public static CIMObjectPath parseINSTANCEPATH(Element pInstancePathE) throws CIMXMLParseException {
        Element namespacepathE = (Element)CIMXMLParserImpl.searchFirstNode(pInstancePathE, "NAMESPACEPATH");
        if (namespacepathE == null) {
            throw new CIMXMLParseException();
        }
        CIMObjectPath nsPath = CIMXMLParserImpl.parseNAMESPACEPATH(namespacepathE);
        Element instancenameE = (Element)CIMXMLParserImpl.searchFirstNode(pInstancePathE, "INSTANCENAME");
        if (instancenameE == null) {
            throw new CIMXMLParseException();
        }
        CIMObjectPath op = CIMXMLParserImpl.parseINSTANCENAME(instancenameE);
        return new CIMObjectPath(nsPath.getScheme(), nsPath.getHost(), nsPath.getPort(), nsPath.getNamespace(), op.getObjectName(), op.getKeys());
    }

    public static CIMObjectPath parseLOCALINSTANCEPATH(Element pLocalInstancePathE) throws CIMXMLParseException {
        Element localnamespacepathE = (Element)CIMXMLParserImpl.searchFirstNode(pLocalInstancePathE, "LOCALNAMESPACEPATH");
        if (localnamespacepathE == null) {
            throw new CIMXMLParseException();
        }
        String nameSpace = CIMXMLParserImpl.parseLOCALNAMESPACEPATH(localnamespacepathE);
        Element instancenameE = (Element)CIMXMLParserImpl.searchFirstNode(pLocalInstancePathE, "INSTANCENAME");
        if (instancenameE == null) {
            throw new CIMXMLParseException();
        }
        CIMObjectPath op = CIMXMLParserImpl.parseINSTANCENAME(instancenameE);
        return cLocalPathBuilder.build(op.getObjectName(), nameSpace, op.getKeys());
    }

    public static CIMObjectPath parseINSTANCENAME(Element pInstanceNameE) throws CIMXMLParseException {
        Attr instance_classnameA = (Attr)CIMXMLParserImpl.searchAttribute(pInstanceNameE, "CLASSNAME");
        String opClassName = instance_classnameA.getNodeValue();
        Element[] keyBindingElementA = CIMXMLParserImpl.searchNodes(pInstanceNameE, "KEYBINDING");
        if (keyBindingElementA != null && keyBindingElementA.length > 0) {
            CIMProperty[] keys = new CIMProperty[keyBindingElementA.length];
            for (int i = 0; i < keyBindingElementA.length; ++i) {
                Element keybindingE = keyBindingElementA[i];
                keys[i] = CIMXMLParserImpl.parseKEYBINDING(keybindingE);
            }
            return cLocalPathBuilder.build(opClassName, null, keys);
        }
        return new CIMObjectPath(opClassName, null);
    }

    public static CIMObjectPath parseOBJECTPATH(Element pObjectPathE) throws CIMXMLParseException {
        Element instancepathE = (Element)CIMXMLParserImpl.searchFirstNode(pObjectPathE, "INSTANCEPATH");
        if (instancepathE != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseINSTANCEPATH(instancepathE);
            return op;
        }
        Element classpathE = (Element)CIMXMLParserImpl.searchFirstNode(pObjectPathE, "CLASSPATH");
        if (classpathE != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseCLASSPATH(classpathE);
            return op;
        }
        throw new CIMXMLParseException();
    }

    public static CIMProperty<?> parseKEYBINDING(Element pKeyBindingE) throws CIMXMLParseException {
        Attr keybinding_nameA = (Attr)CIMXMLParserImpl.searchAttribute(pKeyBindingE, "NAME");
        String propName = keybinding_nameA.getValue();
        Element keyvalueE = (Element)CIMXMLParserImpl.searchFirstNode(pKeyBindingE, "KEYVALUE");
        if (keyvalueE != null) {
            TypedValue propTypedVal = CIMXMLParserImpl.parseKEYVALUE(keyvalueE);
            return new CIMProperty<Object>(propName, propTypedVal.getType(), propTypedVal.getValue(), true, false, null);
        }
        Element valuereferenceE = (Element)CIMXMLParserImpl.searchFirstNode(pKeyBindingE, "VALUE.REFERENCE");
        if (valuereferenceE != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseVALUEREFERENCE(valuereferenceE);
            return new CIMProperty<CIMObjectPath>(propName, new CIMDataType(op.getObjectName()), op, true, false, null);
        }
        throw new CIMXMLParseException();
    }

    public static CIMDataType parseScalarTypeStr(String pTypeStr) throws CIMXMLParseException {
        return CIMXMLParserImpl.parseTypeStr(pTypeStr, false);
    }

    public static CIMDataType parseArrayTypeStr(String pTypeStr) throws CIMXMLParseException {
        return CIMXMLParserImpl.parseTypeStr(pTypeStr, true);
    }

    public static CIMDataType parseTypeStr(String pTypeStr, boolean pArray) throws CIMXMLParseException {
        if (pTypeStr == null) {
            return pArray ? CIMDataType.STRING_ARRAY_T : CIMDataType.STRING_T;
        }
        CIMDataType type = TYPESTR_MAP.get(pTypeStr);
        if (type == null) {
            throw new CIMXMLParseException("Unknown type string:" + pTypeStr);
        }
        if (pArray) {
            if (type.getType() == 14) {
                return new CIMDataType(type.getRefClassName(), 0);
            }
            return new CIMDataType(type.getType(), 0);
        }
        return type;
    }

    public static TypedValue parseKEYVALUE(Element pKeyValueE) throws CIMXMLParseException {
        String valueStr;
        String typeStr = CIMXMLParserImpl.attribute(pKeyValueE, "TYPE");
        Text valueT = (Text)CIMXMLParserImpl.searchFirstChild(pKeyValueE);
        String string = valueStr = valueT == null ? null : valueT.getNodeValue();
        if (typeStr == null) {
            String valueTypeStr = CIMXMLParserImpl.attribute(pKeyValueE, "VALUETYPE");
            ValueTypeHandler vtHandler = new ValueTypeHandler(valueTypeStr, valueStr);
            return new TypedValue(vtHandler.getType(), vtHandler.getValue());
        }
        String value = valueStr == null ? "" : CIMXMLParserImpl.createJavaObject(typeStr, valueStr);
        return new TypedValue(CIMXMLParserImpl.parseScalarTypeStr(typeStr), value);
    }

    private static String attribute(Element pElement, String pName) {
        String attrib = pElement.getAttribute(pName);
        if (attrib == null || attrib.length() == 0) {
            return null;
        }
        return attrib;
    }

    public static CIMClass parseCLASS(Element pClassE) throws CIMXMLParseException {
        CIMMethod[] methods;
        Attr class_nameA = (Attr)CIMXMLParserImpl.searchAttribute(pClassE, "NAME");
        String name = class_nameA.getNodeValue();
        String superClass = CIMXMLParserImpl.attribute(pClassE, "SUPERCLASS");
        CIMQualifier<?>[] qualis = CIMXMLParserImpl.parseQUALIFIERS(pClassE);
        CIMClassProperty<?>[] props = CIMXMLParserImpl.parseCLASSPROPERTIES(pClassE);
        Element[] methodElementA = CIMXMLParserImpl.searchNodes(pClassE, "METHOD");
        if (methodElementA != null) {
            methods = new CIMMethod[methodElementA.length];
            for (int i = 0; i < methodElementA.length; ++i) {
                Element methodE = methodElementA[i];
                methods[i] = CIMXMLParserImpl.parseMETHOD(methodE);
            }
        } else {
            methods = null;
        }
        return new CIMClass(cLocalPathBuilder.build(name, null), superClass, qualis, props, methods, CIMXMLParserImpl.hasAssocQuali(qualis), CIMXMLParserImpl.hasKeyProp(props));
    }

    private static boolean hasAssocQuali(CIMQualifier<?>[] pQualis) {
        if (pQualis == null) {
            return false;
        }
        for (int i = 0; i < pQualis.length; ++i) {
            CIMQualifier<?> quali = pQualis[i];
            if (!"ASSOCIATION".equalsIgnoreCase(quali.getName()) || !Boolean.TRUE.equals(quali.getValue())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasKeyProp(CIMProperty<?>[] pProps) {
        if (pProps == null) {
            return false;
        }
        for (int i = 0; i < pProps.length; ++i) {
            if (!pProps[i].isKey()) continue;
            return true;
        }
        return false;
    }

    private static CIMParameter<?>[] parseParameters(Element pMethodE) throws CIMXMLParseException {
        Element[] paramRefArrayElementA;
        Element[] paramArrayElementA;
        Element[] paramRefElementA;
        Vector<CIMParameter<Object>> paramV = new Vector<CIMParameter<Object>>();
        Element[] paramElementA = CIMXMLParserImpl.searchNodes(pMethodE, "PARAMETER");
        if (paramElementA != null) {
            for (int i = 0; i < paramElementA.length; ++i) {
                Element parameterE = paramElementA[i];
                CIMParameter<Object> p = CIMXMLParserImpl.parsePARAMETER(parameterE);
                paramV.add(p);
            }
        }
        if ((paramRefElementA = CIMXMLParserImpl.searchNodes(pMethodE, "PARAMETER.REFERENCE")) != null) {
            for (int i = 0; i < paramRefElementA.length; ++i) {
                Element parameterE = paramRefElementA[i];
                CIMParameter<Object> p = CIMXMLParserImpl.parsePARAMETERREFERENCE(parameterE);
                paramV.add(p);
            }
        }
        if ((paramArrayElementA = CIMXMLParserImpl.searchNodes(pMethodE, "PARAMETER.ARRAY")) != null) {
            for (int i = 0; i < paramArrayElementA.length; ++i) {
                Element parameterE = paramArrayElementA[i];
                CIMParameter<Object> p = CIMXMLParserImpl.parsePARAMETERARRAY(parameterE);
                paramV.add(p);
            }
        }
        if ((paramRefArrayElementA = CIMXMLParserImpl.searchNodes(pMethodE, "PARAMETER.REFARRAY")) != null) {
            for (int i = 0; i < paramRefArrayElementA.length; ++i) {
                Element parameterE = paramRefArrayElementA[i];
                CIMParameter<Object> p = CIMXMLParserImpl.parsePARAMETERREFARRAY(parameterE);
                paramV.add(p);
            }
        }
        return paramV.toArray(new CIMParameter[0]);
    }

    public static CIMMethod<Object> parseMETHOD(Element pMethodE) throws CIMXMLParseException {
        String name = CIMXMLParserImpl.attribute(pMethodE, "NAME");
        EmbObjHandler embObjHandler = new EmbObjHandler(pMethodE);
        CIMDataType type = embObjHandler.getType();
        if (type.isArray()) {
            throw new CIMXMLParseException("Method's type cannot be Array!");
        }
        String classOrigin = CIMXMLParserImpl.attribute(pMethodE, "CLASSORIGIN");
        String propagatedStr = pMethodE.getAttribute("PROPAGATED");
        boolean propagated = "true".equalsIgnoreCase(propagatedStr);
        CIMParameter<?>[] params = CIMXMLParserImpl.parseParameters(pMethodE);
        return new CIMMethod<Object>(name, type, embObjHandler.getQualifiers(), params, propagated, classOrigin);
    }

    public static CIMParameter<Object> parsePARAMETER(Element pParamE) throws CIMXMLParseException {
        String name = CIMXMLParserImpl.attribute(pParamE, "NAME");
        EmbObjHandler iEmbObjHandler = new EmbObjHandler(pParamE);
        return new CIMParameter<Object>(name, iEmbObjHandler.getType(), iEmbObjHandler.getQualifiers());
    }

    public static CIMParameter<Object> parsePARAMETERREFERENCE(Element pParamE) throws CIMXMLParseException {
        String name = CIMXMLParserImpl.attribute(pParamE, "NAME");
        String referenceClass = CIMXMLParserImpl.attribute(pParamE, "REFERENCECLASS");
        CIMDataType type = new CIMDataType(referenceClass);
        CIMQualifier<?>[] qualis = CIMXMLParserImpl.parseQUALIFIERS(pParamE);
        return new CIMParameter<Object>(name, type, qualis);
    }

    public static CIMParameter<Object> parsePARAMETERARRAY(Element pParamE) throws CIMXMLParseException {
        String name = CIMXMLParserImpl.attribute(pParamE, "NAME");
        EmbObjHandler iEmbObjHandler = new EmbObjHandler(pParamE);
        return new CIMParameter<Object>(name, iEmbObjHandler.getArrayType(), iEmbObjHandler.getQualifiers());
    }

    public static CIMParameter<Object> parsePARAMETERREFARRAY(Element pParamE) throws CIMXMLParseException {
        String name = CIMXMLParserImpl.attribute(pParamE, "NAME");
        String referenceClass = CIMXMLParserImpl.attribute(pParamE, "REFERENCECLASS");
        int arraySize = 0;
        String arraySizeStr = pParamE.getAttribute("ARRAYSIZE");
        try {
            if (arraySizeStr.length() > 0) {
                arraySize = Integer.parseInt(arraySizeStr);
            }
        }
        catch (Exception e) {
            LogAndTraceBroker.getBroker().trace(Level.WARNING, "exception while parsing parameter array reference size", e);
        }
        CIMDataType type = new CIMDataType(referenceClass != null ? referenceClass : "", arraySize);
        CIMQualifier<?>[] qualis = CIMXMLParserImpl.parseQUALIFIERS(pParamE);
        return new CIMParameter<Object>(name, type, qualis);
    }

    public static CIMInstance parseINSTANCE(Element pInstanceE) throws CIMXMLParseException {
        return CIMXMLParserImpl.parseINSTANCE(pInstanceE, null);
    }

    public static CIMInstance parseINSTANCE(Element pInstanceE, CIMObjectPath pObjPath) throws CIMXMLParseException {
        String className = CIMXMLParserImpl.attribute(pInstanceE, "CLASSNAME");
        CIMProperty<?>[] props = CIMXMLParserImpl.parsePROPERTIES(pInstanceE);
        return new CIMInstance(pObjPath == null ? cLocalPathBuilder.build(className, null) : pObjPath, props);
    }

    public static CIMQualifier<?>[] parseQUALIFIERS(Element pElement) throws CIMXMLParseException {
        CIMQualifier[] qualis;
        Element[] qualiElementA = CIMXMLParserImpl.searchNodes(pElement, "QUALIFIER");
        if (qualiElementA != null) {
            qualis = new CIMQualifier[qualiElementA.length];
            for (int i = 0; i < qualiElementA.length; ++i) {
                Element qualifierE = qualiElementA[i];
                qualis[i] = CIMXMLParserImpl.parseQUALIFIER(qualifierE);
            }
        } else {
            qualis = null;
        }
        return qualis;
    }

    private static int parseFLAVORS(Element pElement) {
        int flavors = 0;
        if (!CIMXMLParserImpl.getBoolAttribute(pElement, "OVERRIDABLE", true)) {
            flavors |= 1;
        }
        if (!CIMXMLParserImpl.getBoolAttribute(pElement, "TOSUBCLASS", true)) {
            flavors |= 2;
        }
        if (CIMXMLParserImpl.getBoolAttribute(pElement, "TRANSLATABLE", false)) {
            flavors |= 4;
        }
        return flavors;
    }

    private static TypedValue parseSingleValue(Element pElement) throws CIMXMLParseException {
        return CIMXMLParserImpl.parseSingleValue(pElement, 3);
    }

    private static TypedValue parseSingleValue(Element pElement, int pMask) throws CIMXMLParseException {
        Element valueRefArrayE;
        Element valuearrayE;
        Element valuereferenceE;
        Element valueE;
        String typeStr = CIMXMLParserImpl.attribute(pElement, "TYPE");
        if (typeStr == null) {
            typeStr = CIMXMLParserImpl.attribute(pElement, "PARAMTYPE");
        }
        CIMDataType type = null;
        Object[] value = null;
        if ((pMask & 1) > 0 && (valueE = (Element)CIMXMLParserImpl.searchFirstNode(pElement, "VALUE")) != null) {
            TypedValue tVal = CIMXMLParserImpl.parseVALUE(valueE);
            String valueStr = (String)tVal.getValue();
            type = typeStr == null ? tVal.getType() : CIMXMLParserImpl.parseScalarTypeStr(typeStr);
            value = CIMXMLParserImpl.createJavaObject(type.toString(), valueStr);
        }
        if (type == null && (pMask & 4) > 0 && (valuereferenceE = (Element)CIMXMLParserImpl.searchFirstNode(pElement, "VALUE.REFERENCE")) != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseVALUEREFERENCE(valuereferenceE);
            value = op;
            type = new CIMDataType(op.getObjectName());
        }
        if (type == null && (pMask & 2) > 0 && (valuearrayE = (Element)CIMXMLParserImpl.searchFirstNode(pElement, "VALUE.ARRAY")) != null) {
            TypedValue tValA = CIMXMLParserImpl.parseVALUEARRAY(valuearrayE);
            type = typeStr == null ? tValA.getType() : CIMXMLParserImpl.parseArrayTypeStr(typeStr);
            String[] valStrA = (String[])tValA.getValue();
            if (valStrA != null) {
                Object[] values = new Object[valStrA.length];
                for (int i = 0; i < valStrA.length; ++i) {
                    values[i] = CIMXMLParserImpl.createJavaObject(type.toString(), valStrA[i]);
                }
                value = values;
            }
        }
        if (type == null && (pMask & 8) > 0 && (valueRefArrayE = (Element)CIMXMLParserImpl.searchFirstNode(pElement, "VALUE.REFARRAY")) != null) {
            type = CIMXMLParserImpl.parseArrayTypeStr(typeStr);
            CIMObjectPath[] opA = CIMXMLParserImpl.parseVALUEREFARRAY(valueRefArrayE);
            value = opA;
        }
        if (type == null) {
            type = value instanceof Object[] ? CIMDataType.STRING_ARRAY_T : (value != null ? CIMDataType.STRING_T : CIMDataType.STRING_T);
        }
        return new TypedValue(type, value);
    }

    public static CIMQualifier<?> parseQUALIFIER(Element pQualifierE) throws CIMXMLParseException {
        String name = CIMXMLParserImpl.attribute(pQualifierE, "NAME");
        boolean propagated = "true".equalsIgnoreCase(pQualifierE.getAttribute("PROPAGATED"));
        int flavors = CIMXMLParserImpl.parseFLAVORS(pQualifierE);
        TypedValue typedValue = CIMXMLParserImpl.parseSingleValue(pQualifierE);
        if (typedValue.getType() == null) {
            throw new CIMXMLParseException("Qualifier's type is null!");
        }
        return new CIMQualifier<Object>(name, typedValue.getType(), typedValue.getValue(), flavors, propagated);
    }

    public static CIMQualifierType<Object> parseQUALIFIERDECLARATION(Element pQualifierTypeE) throws CIMXMLParseException {
        String arraySizeStr;
        String name = CIMXMLParserImpl.attribute(pQualifierTypeE, "NAME");
        Element scopeElement = (Element)CIMXMLParserImpl.searchFirstNode(pQualifierTypeE, "SCOPE");
        int scopes = scopeElement == null ? 0 : CIMXMLParserImpl.parseSCOPES(scopeElement);
        TypedValue typedValue = CIMXMLParserImpl.parseSingleValue(pQualifierTypeE);
        CIMDataType type = typedValue.getType();
        if ("true".equalsIgnoreCase(CIMXMLParserImpl.attribute(pQualifierTypeE, "ISARRAY")) && (arraySizeStr = CIMXMLParserImpl.attribute(pQualifierTypeE, "ARRAYSIZE")) != null) {
            try {
                int arraySize = Integer.parseInt(arraySizeStr);
                type = new CIMDataType(type.getType(), arraySize);
            }
            catch (Exception e) {
                LogAndTraceBroker.getBroker().trace(Level.WARNING, "exception while parsing array size", e);
            }
        }
        return new CIMQualifierType<Object>(new CIMObjectPath(name, null), type, typedValue.getValue(), scopes, 0);
    }

    private static boolean hasTrueAttribute(Element pElement, String pName) {
        String valueStr = pElement.getAttribute(pName);
        return "true".equalsIgnoreCase(valueStr);
    }

    private static boolean getBoolAttribute(Element pElement, String pName, boolean pDefVal) {
        String val = pElement.getAttribute(pName);
        if ("true".equalsIgnoreCase(val)) {
            return true;
        }
        if ("false".equalsIgnoreCase(val)) {
            return false;
        }
        return pDefVal;
    }

    public static int parseSCOPES(Element pScopeE) {
        int scopes = 0;
        if (CIMXMLParserImpl.hasTrueAttribute(pScopeE, "CLASS")) {
            scopes |= 1;
        }
        if (CIMXMLParserImpl.hasTrueAttribute(pScopeE, "ASSOCIATION")) {
            scopes |= 2;
        }
        if (CIMXMLParserImpl.hasTrueAttribute(pScopeE, "REFERENCE")) {
            scopes |= 0x10;
        }
        if (CIMXMLParserImpl.hasTrueAttribute(pScopeE, "PROPERTY")) {
            scopes |= 8;
        }
        if (CIMXMLParserImpl.hasTrueAttribute(pScopeE, "METHOD")) {
            scopes |= 0x20;
        }
        if (CIMXMLParserImpl.hasTrueAttribute(pScopeE, "PARAMETER")) {
            scopes |= 0x40;
        }
        if (CIMXMLParserImpl.hasTrueAttribute(pScopeE, "INDICATION")) {
            scopes |= 4;
        }
        return scopes;
    }

    private static Vector<CIMClassProperty<?>> parseClassPropsToVec(Element pElement) throws CIMXMLParseException {
        Element[] propRefElementA;
        Element[] propArrayElementA;
        Element[] propElementA = CIMXMLParserImpl.searchNodes(pElement, "PROPERTY");
        Vector propVec = new Vector();
        if (propElementA != null) {
            for (int i = 0; i < propElementA.length; ++i) {
                Element propertyE = propElementA[i];
                propVec.add(CIMXMLParserImpl.parseCLASSPROPERTY(propertyE));
            }
        }
        if ((propArrayElementA = CIMXMLParserImpl.searchNodes(pElement, "PROPERTY.ARRAY")) != null) {
            for (int i = 0; i < propArrayElementA.length; ++i) {
                Element propertyarrayE = propArrayElementA[i];
                propVec.add(CIMXMLParserImpl.parseCLASSPROPERTYARRAY(propertyarrayE));
            }
        }
        if ((propRefElementA = CIMXMLParserImpl.searchNodes(pElement, "PROPERTY.REFERENCE")) != null) {
            for (int i = 0; i < propRefElementA.length; ++i) {
                Element propertyreferenceE = propRefElementA[i];
                propVec.add(CIMXMLParserImpl.parseCLASSPROPERTYREFERENCE(propertyreferenceE));
            }
        }
        return propVec;
    }

    public static CIMProperty<?>[] parsePROPERTIES(Element pElement) throws CIMXMLParseException {
        Vector<CIMClassProperty<?>> classPropVec = CIMXMLParserImpl.parseClassPropsToVec(pElement);
        return classPropVec.toArray(new CIMProperty[0]);
    }

    public static CIMClassProperty<?>[] parseCLASSPROPERTIES(Element pElement) throws CIMXMLParseException {
        Vector<CIMClassProperty<?>> classPropVec = CIMXMLParserImpl.parseClassPropsToVec(pElement);
        return classPropVec.toArray(new CIMClassProperty[0]);
    }

    public static CIMProperty<?> parsePROPERTY(Element pPropertyE) throws CIMXMLParseException {
        return CIMXMLParserImpl.parseCLASSPROPERTY(pPropertyE);
    }

    public static CIMClassProperty<Object> parseCLASSPROPERTY(Element pPropertyE) throws CIMXMLParseException {
        Attr property_nameA = (Attr)CIMXMLParserImpl.searchAttribute(pPropertyE, "NAME");
        String name = property_nameA.getNodeValue();
        String classOrigin = pPropertyE.getAttribute("CLASSORIGIN");
        if (classOrigin != null && classOrigin.length() == 0) {
            classOrigin = null;
        }
        String propagatedStr = pPropertyE.getAttribute("PROPAGATED");
        boolean propagated = "true".equalsIgnoreCase(propagatedStr);
        EmbObjHandler embObjHandler = new EmbObjHandler(pPropertyE);
        return new CIMClassProperty<Object>(name, embObjHandler.getType(), embObjHandler.getValue(), embObjHandler.getQualifiers(), embObjHandler.isKeyed(), propagated, classOrigin);
    }

    public static CIMProperty<Object> parsePROPERTYARRAY(Element pPropertyArrayE) throws CIMXMLParseException {
        return CIMXMLParserImpl.parseCLASSPROPERTYARRAY(pPropertyArrayE);
    }

    public static CIMClassProperty<Object> parseCLASSPROPERTYARRAY(Element pPropArrayE) throws CIMXMLParseException {
        String valuePropagatedStr;
        String name = pPropArrayE.getAttribute("NAME");
        String classOrigin = pPropArrayE.getAttribute("CLASSORIGIN");
        if (classOrigin != null && classOrigin.length() == 0) {
            classOrigin = null;
        }
        boolean propagated = (valuePropagatedStr = pPropArrayE.getAttribute("PROPAGATED")) != null && valuePropagatedStr.equalsIgnoreCase("true");
        EmbObjHandler embObjHandler = new EmbObjHandler(pPropArrayE);
        return new CIMClassProperty<Object>(name, embObjHandler.getArrayType(), embObjHandler.getValue(), embObjHandler.getQualifiers(), embObjHandler.isKeyed(), propagated, classOrigin);
    }

    public static CIMProperty<Object> parsePROPERTYREFERENCE(Element pPropRefE) throws CIMXMLParseException {
        return CIMXMLParserImpl.parseCLASSPROPERTYREFERENCE(pPropRefE);
    }

    public static CIMClassProperty<Object> parseCLASSPROPERTYREFERENCE(Element pPropRefE) throws CIMXMLParseException {
        String referenceClass;
        String name = pPropRefE.getAttribute("NAME");
        String classOrigin = pPropRefE.getAttribute("CLASSORIGIN");
        if (classOrigin != null && classOrigin.length() == 0) {
            classOrigin = null;
        }
        if ((referenceClass = pPropRefE.getAttribute("REFERENCECLASS")) != null && referenceClass.length() == 0) {
            referenceClass = null;
        }
        String propagatedStr = pPropRefE.getAttribute("PROPAGATED");
        boolean propagated = "true".equalsIgnoreCase(propagatedStr);
        CIMQualifier<?>[] qualis = CIMXMLParserImpl.parseQUALIFIERS(pPropRefE);
        CIMDataType type = new CIMDataType(referenceClass);
        Element valueRefE = (Element)CIMXMLParserImpl.searchFirstNode(pPropRefE, "VALUE.REFERENCE");
        CIMObjectPath value = valueRefE != null ? CIMXMLParserImpl.parseVALUEREFERENCE(valueRefE) : null;
        CIMQualifiedElementInterfaceImpl qualiImpl = new CIMQualifiedElementInterfaceImpl(qualis);
        return new CIMClassProperty<Object>(name, type, value, qualis, qualiImpl.isKeyed(), propagated, classOrigin);
    }

    public static CIMMessage parseMESSAGE(String pCimVersion, String pDtdVersion, Element pMessageE) throws CIMXMLParseException {
        Attr idA = (Attr)CIMXMLParserImpl.searchAttribute(pMessageE, "ID");
        String id = idA.getNodeValue();
        if (pCimVersion.equals("2.0") && pDtdVersion.equals("2.0")) {
            Element simplerspE = (Element)CIMXMLParserImpl.searchFirstNode(pMessageE, "SIMPLERSP");
            if (simplerspE != null) {
                CIMResponse response = CIMXMLParserImpl.parseSIMPLERSP(simplerspE);
                response.setMethod("SIMPLERSP");
                response.setId(id);
                return response;
            }
            Element multirspE = (Element)CIMXMLParserImpl.searchFirstNode(pMessageE, "MULTIRSP");
            if (multirspE != null) {
                CIMResponse response = CIMXMLParserImpl.parseMULTIRSP(multirspE);
                response.setMethod("MULTIRSP");
                response.setId(id);
                return response;
            }
            Element simpleexpreqE = (Element)CIMXMLParserImpl.searchFirstNode(pMessageE, "SIMPLEEXPREQ");
            if (simpleexpreqE != null) {
                CIMRequest request = CIMXMLParserImpl.parseSIMPLEEXPREQ(simpleexpreqE);
                request.setMethod("SIMPLEEXPREQ");
                request.setId(id);
                return request;
            }
            Element multiexpreqE = (Element)CIMXMLParserImpl.searchFirstNode(pMessageE, "MULTIEXPREQ");
            if (multiexpreqE != null) {
                CIMRequest request = CIMXMLParserImpl.parseMULTIEXPREQ(multiexpreqE);
                request.setMethod("MULTIEXPREQ");
                request.setId(id);
                return request;
            }
            Element simplereqE = (Element)CIMXMLParserImpl.searchFirstNode(pMessageE, "SIMPLEREQ");
            if (simplereqE != null) {
                CIMRequest request = CIMXMLParserImpl.parseSIMPLEREQ(simplereqE);
                request.setMethod("SIMPLEREQ");
                request.setId(id);
                return request;
            }
            Element multireqE = (Element)CIMXMLParserImpl.searchFirstNode(pMessageE, "MULTIREQ");
            if (multireqE != null) {
                CIMRequest request = CIMXMLParserImpl.parseMULTIREQ(multireqE);
                request.setMethod("MULTIREQ");
                request.setId(id);
                return request;
            }
            throw new CIMXMLParseException();
        }
        throw new CIMXMLParseException("DTD not supported");
    }

    public static CIMArgument<Object> parsePARAMVALUE(Element pParamValueE) throws CIMXMLParseException {
        String name = CIMXMLParserImpl.attribute(pParamValueE, "NAME");
        if (CIMXMLParserImpl.searchFirstNode(pParamValueE, "VALUE.REFERENCE") != null || CIMXMLParserImpl.searchFirstNode(pParamValueE, "VALUE.REFARRAY") != null) {
            TypedValue typedValue = CIMXMLParserImpl.parseSingleValue(pParamValueE, 4);
            CIMDataType type = typedValue.getType();
            Object value = typedValue.getValue();
            if (type == null) {
                throw new CIMXMLParseException("Type is null!");
            }
            return new CIMArgument<Object>(name, type, value);
        }
        EmbObjHandler embObjHandler = new EmbObjHandler(pParamValueE);
        return new CIMArgument<Object>(name, embObjHandler.getType(), embObjHandler.getValue());
    }

    public static CIMArgument<Object> parseIPARAMVALUE(Element pParamValueE) throws CIMXMLParseException {
        String name = CIMXMLParserImpl.attribute(pParamValueE, "NAME");
        TypedValue typedValue = CIMXMLParserImpl.parseSingleValue(pParamValueE, 7);
        if (typedValue.getType() != null) {
            return new CIMArgument<Object>(name, typedValue.getType(), typedValue.getValue());
        }
        Element instNameE = (Element)CIMXMLParserImpl.searchFirstNode(pParamValueE, "INSTANCENAME");
        if (instNameE != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseINSTANCENAME(instNameE);
            CIMDataType type = new CIMDataType(op.getObjectName());
            return new CIMArgument<Object>(name, type, op);
        }
        Element qualiDeclarationE = (Element)CIMXMLParserImpl.searchFirstNode(pParamValueE, "QUALIFIER.DECLARATION");
        if (qualiDeclarationE != null) {
            CIMQualifierType<Object> qualiType = CIMXMLParserImpl.parseQUALIFIERDECLARATION(qualiDeclarationE);
            return new CIMArgument<Object>(name, new CIMDataType(qualiType.getName()), qualiType);
        }
        Element classE = (Element)CIMXMLParserImpl.searchFirstNode(pParamValueE, "CLASS");
        if (classE != null) {
            CIMClass cl = CIMXMLParserImpl.parseCLASS(classE);
            return new CIMArgument<Object>(name, new CIMDataType(cl.getName()), cl);
        }
        Element instanceE = (Element)CIMXMLParserImpl.searchFirstNode(pParamValueE, "INSTANCE");
        if (instanceE != null) {
            CIMInstance inst = CIMXMLParserImpl.parseINSTANCE(instanceE);
            return new CIMArgument<Object>(name, new CIMDataType(inst.getClassName()), inst);
        }
        Element valuenamedisntanceE = (Element)CIMXMLParserImpl.searchFirstNode(pParamValueE, "VALUE.NAMEDINSTANCE");
        if (valuenamedisntanceE != null) {
            CIMInstance inst = CIMXMLParserImpl.parseVALUENAMEDINSTANCE(valuenamedisntanceE);
            return new CIMArgument<Object>(name, new CIMDataType(inst.getClassName()), inst);
        }
        return null;
    }

    public static CIMResponse parseSIMPLERSP(Element pSimpleRspE) throws CIMXMLParseException {
        Element methodresponseE = (Element)CIMXMLParserImpl.searchFirstNode(pSimpleRspE, "METHODRESPONSE");
        if (methodresponseE != null) {
            return CIMXMLParserImpl.parseMETHODRESPONSE(methodresponseE);
        }
        Element imethodresponseE = (Element)CIMXMLParserImpl.searchFirstNode(pSimpleRspE, "IMETHODRESPONSE");
        if (imethodresponseE != null) {
            return CIMXMLParserImpl.parseIMETHODRESPONSE(imethodresponseE);
        }
        throw new CIMXMLParseException();
    }

    public static CIMResponse parseMULTIRSP(Element pSimpleRspE) throws CIMXMLParseException {
        Element[] multiRespElementA = CIMXMLParserImpl.searchNodes(pSimpleRspE, "SIMPLERSP");
        if (multiRespElementA != null && multiRespElementA.length > 0) {
            CIMResponse multiRsp = new CIMResponse();
            for (int i = 0; i < multiRespElementA.length; ++i) {
                Element methodresponseE = multiRespElementA[i];
                CIMResponse rsp = CIMXMLParserImpl.parseSIMPLERSP(methodresponseE);
                rsp.setMethod("SIMPLERSP");
                multiRsp.addResponse(rsp);
            }
            return multiRsp;
        }
        throw new CIMXMLParseException("SIMPLRESP nodes aren't found!");
    }

    public static CIMRequest parseSIMPLEREQ(Element pSimpleReqE) throws CIMXMLParseException {
        Element methodcallE = (Element)CIMXMLParserImpl.searchFirstNode(pSimpleReqE, "METHODCALL");
        if (methodcallE != null) {
            return CIMXMLParserImpl.parseMETHODCALL(methodcallE);
        }
        Element imethodcallE = (Element)CIMXMLParserImpl.searchFirstNode(pSimpleReqE, "IMETHODCALL");
        if (imethodcallE != null) {
            return CIMXMLParserImpl.parseIMETHODCALL(imethodcallE);
        }
        throw new CIMXMLParseException("METHODCALL or IMETHODCALL nodes aren't found!");
    }

    public static CIMRequest parseMULTIREQ(Element pMultiReqE) throws CIMXMLParseException {
        Element[] methodReqElementA = CIMXMLParserImpl.searchNodes(pMultiReqE, "MULTIREQ");
        if (methodReqElementA != null && methodReqElementA.length > 0) {
            CIMRequest multiReq = new CIMRequest();
            for (int i = 0; i < methodReqElementA.length; ++i) {
                Element methodrequestE = methodReqElementA[i];
                CIMRequest req = CIMXMLParserImpl.parseSIMPLEREQ(methodrequestE);
                req.setMethod("MULTIPREQ");
                multiReq.addRequest(req);
            }
            return multiReq;
        }
        throw new CIMXMLParseException("MULTIREQ nodes aren't found!");
    }

    public static CIMRequest parseMETHODCALL(Element pMethodCallE) throws CIMXMLParseException {
        Element localinstancepathE;
        CIMRequest request = new CIMRequest();
        String methodname = pMethodCallE.getAttribute("CIMName");
        request.setMethodName(methodname);
        boolean localclasspathFound = false;
        Element localclasspathE = (Element)CIMXMLParserImpl.searchFirstNode(pMethodCallE, "LOCALCLASSPATH");
        if (localclasspathE != null) {
            CIMObjectPath path = CIMXMLParserImpl.parseLOCALCLASSPATH(localclasspathE);
            request.setObjectPath(path);
            localclasspathFound = true;
        }
        if ((localinstancepathE = (Element)CIMXMLParserImpl.searchFirstNode(pMethodCallE, "LOCALINSTANCEPATH")) != null) {
            CIMObjectPath path = CIMXMLParserImpl.parseLOCALINSTANCEPATH(localinstancepathE);
            request.setObjectPath(path);
        } else if (!localclasspathFound) {
            throw new CIMXMLParseException("LOCALCLASSPATH or LOCALINSTANCEPATH not found!");
        }
        Element[] paramValueElementA = CIMXMLParserImpl.searchNodes(pMethodCallE, "PARAMVALUE");
        if (paramValueElementA != null && paramValueElementA.length > 0) {
            CIMArgument[] argA = new CIMArgument[paramValueElementA.length];
            for (int i = 0; i < paramValueElementA.length; ++i) {
                Element paramvalueE = paramValueElementA[i];
                argA[i] = CIMXMLParserImpl.parsePARAMVALUE(paramvalueE);
            }
            request.addParamValue(argA);
        }
        return request;
    }

    public static CIMRequest parseIMETHODCALL(Element pIMethodCallE) throws CIMXMLParseException {
        Element[] iParamValElementA;
        CIMRequest request = new CIMRequest();
        String methodname = pIMethodCallE.getAttribute("NAME");
        request.setMethodName(methodname);
        Element localnamespacepathE = (Element)CIMXMLParserImpl.searchFirstNode(pIMethodCallE, "LOCALNAMESPACEPATH");
        if (localnamespacepathE != null) {
            String nameSpace = CIMXMLParserImpl.parseLOCALNAMESPACEPATH(localnamespacepathE);
            request.setNameSpace(nameSpace);
        }
        if ((iParamValElementA = CIMXMLParserImpl.searchNodes(pIMethodCallE, "IPARAMVALUE")) != null && iParamValElementA.length > 0) {
            CIMArgument[] argA = new CIMArgument[iParamValElementA.length];
            for (int i = 0; i < iParamValElementA.length; ++i) {
                CIMObjectPath op;
                Element paramvalueE = iParamValElementA[i];
                CIMArgument<Object> arg = CIMXMLParserImpl.parseIPARAMVALUE(paramvalueE);
                Object value = arg.getValue();
                if (value instanceof CIMObjectPath && ((op = (CIMObjectPath)value).getNamespace() == null || op.getNamespace().length() == 0)) {
                    arg = new CIMArgument<CIMObjectPath>(arg.getName(), arg.getDataType(), new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), request.getNameSpace(), op.getObjectName(), op.getKeys()));
                }
                argA[i] = arg;
            }
            request.addParamValue(argA);
            return request;
        }
        throw new CIMXMLParseException("IPARAMVALUE node not found!");
    }

    public static CIMRequest parseSIMPLEEXPREQ(Element pSimpleExpReqE) throws CIMXMLParseException {
        Element expmethodcallE = (Element)CIMXMLParserImpl.searchFirstNode(pSimpleExpReqE, "EXPMETHODCALL");
        if (expmethodcallE != null) {
            return CIMXMLParserImpl.parseEXPMETHODCALL(expmethodcallE);
        }
        throw new CIMXMLParseException("EXPMETHODCALL node not found!");
    }

    public static CIMRequest parseMULTIEXPREQ(Element pMultiExpReqE) throws CIMXMLParseException {
        Element[] methodReqElementA = CIMXMLParserImpl.searchNodes(pMultiExpReqE, "SIMPLEEXREQ");
        if (methodReqElementA != null && methodReqElementA.length > 0) {
            CIMRequest multiReq = new CIMRequest();
            for (int i = 0; i < methodReqElementA.length; ++i) {
                Element methodrequestE = methodReqElementA[i];
                CIMRequest req = CIMXMLParserImpl.parseSIMPLEEXPREQ(methodrequestE);
                req.setMethod("SIMPLEEXPREQ");
                multiReq.addRequest(req);
            }
            return multiReq;
        }
        throw new CIMXMLParseException("SIMPLEEXREQ node not found!");
    }

    public static CIMRequest parseEXPMETHODCALL(Element pExpMethodCallE) throws CIMXMLParseException {
        CIMRequest request = new CIMRequest();
        Element[] paramValElementA = CIMXMLParserImpl.searchNodes(pExpMethodCallE, "EXPPARAMVALUE");
        Vector<CIMInstance> v = new Vector<CIMInstance>();
        if (paramValElementA != null) {
            for (int i = 0; i < paramValElementA.length; ++i) {
                Element expparamvalueE = paramValElementA[i];
                CIMInstance inst = CIMXMLParserImpl.parseEXPPARAMVALUE(expparamvalueE);
                v.add(inst);
            }
        }
        request.addParamValue(v);
        return request;
    }

    public static CIMInstance parseEXPPARAMVALUE(Element pExpParamValueE) throws CIMXMLParseException {
        Element instanceE = (Element)CIMXMLParserImpl.searchFirstNode(pExpParamValueE, "INSTANCE");
        if (instanceE != null) {
            CIMInstance inst = CIMXMLParserImpl.parseINSTANCE(instanceE);
            return inst;
        }
        throw new CIMXMLParseException("INSTANCE node not found!");
    }

    public static CIMResponse parseMETHODRESPONSE(Element pMethodResponseE) throws CIMXMLParseException {
        Element[] paramValElementA;
        int i;
        CIMResponse response = new CIMResponse();
        Element errorE = (Element)CIMXMLParserImpl.searchFirstNode(pMethodResponseE, "ERROR");
        if (errorE != null) {
            WBEMException exception = CIMXMLParserImpl.parseERROR(errorE);
            response.setError(exception);
            return response;
        }
        Element[] retValElementA = CIMXMLParserImpl.searchNodes(pMethodResponseE, "RETURNVALUE");
        if (retValElementA != null && retValElementA.length > 0) {
            Vector<Object> v = new Vector<Object>();
            for (i = 0; i < retValElementA.length; ++i) {
                Element returnvalueE = retValElementA[i];
                v.add(CIMXMLParserImpl.parseRETURNVALUE(returnvalueE));
            }
            response.setReturnValue(v);
        }
        if ((paramValElementA = CIMXMLParserImpl.searchNodes(pMethodResponseE, "PARAMVALUE")) != null && paramValElementA.length > 0) {
            Vector<Object> v = new Vector<Object>();
            for (int i2 = 0; i2 < paramValElementA.length; ++i2) {
                Element paramvalueE = paramValElementA[i2];
                CIMArgument<Object> arg = CIMXMLParserImpl.parsePARAMVALUE(paramvalueE);
                v.add(arg);
            }
            response.addParamValue(v);
        }
        if (retValElementA != null && retValElementA.length > 0) {
            for (i = 0; i < retValElementA.length; ++i) {
                Element retValE = retValElementA[i];
                paramValElementA = CIMXMLParserImpl.searchNodes(retValE, "PARAMVALUE");
                if (paramValElementA == null || paramValElementA.length <= 0) continue;
                Vector<CIMArgument<Object>> v = new Vector<CIMArgument<Object>>();
                for (int j = 0; j < paramValElementA.length; ++j) {
                    Element paramvalueE = paramValElementA[j];
                    CIMArgument<Object> arg = CIMXMLParserImpl.parsePARAMVALUE(paramvalueE);
                    v.add(arg);
                }
                response.addParamValue(v);
            }
        }
        return response;
    }

    public static CIMResponse parseIMETHODRESPONSE(Element pIMethodResponseE) throws CIMXMLParseException {
        Element[] paramValElementA;
        CIMResponse response = new CIMResponse();
        Element errorE = (Element)CIMXMLParserImpl.searchFirstNode(pIMethodResponseE, "ERROR");
        if (errorE != null) {
            WBEMException exception = CIMXMLParserImpl.parseERROR(errorE);
            response.setError(exception);
            return response;
        }
        Element[] retValElementA = CIMXMLParserImpl.searchNodes(pIMethodResponseE, "IRETURNVALUE");
        if (retValElementA != null && retValElementA.length > 0) {
            for (int i = 0; i < retValElementA.length; ++i) {
                Element ireturnvalueE = retValElementA[i];
                Vector<Object> rtnV = CIMXMLParserImpl.parseIRETURNVALUE(ireturnvalueE);
                response.setReturnValue(rtnV);
            }
        }
        if ((paramValElementA = CIMXMLParserImpl.searchNodes(pIMethodResponseE, "PARAMVALUE")) != null && paramValElementA.length > 0) {
            Vector<Object> v = new Vector<Object>();
            for (int i = 0; i < paramValElementA.length; ++i) {
                Element paramvalueE = paramValElementA[i];
                CIMArgument<Object> arg = CIMXMLParserImpl.parsePARAMVALUE(paramvalueE);
                v.add(arg);
            }
            response.addParamValue(v);
        }
        return response;
    }

    public static WBEMException parseERROR(Element pErrorE) {
        Attr error_codeA = (Attr)CIMXMLParserImpl.searchAttribute(pErrorE, "CODE");
        String code = error_codeA.getNodeValue();
        int errorCode = 0;
        try {
            if (code.length() > 0) {
                errorCode = Integer.parseInt(code);
            }
        }
        catch (Exception e) {
            LogAndTraceBroker.getBroker().trace(Level.WARNING, "exception while parsing error code from XML", e);
        }
        Attr error_descriptionA = (Attr)CIMXMLParserImpl.searchAttribute(pErrorE, "DESCRIPTION");
        String description = "";
        if (error_descriptionA != null) {
            description = error_descriptionA.getNodeValue();
        }
        return new WBEMException("ErrorCode:" + errorCode + " description:" + description);
    }

    public static Object parseRETURNVALUE(Element pRetValE) throws CIMXMLParseException {
        if (CIMXMLParserImpl.searchFirstNode(pRetValE, "VALUE") != null) {
            EmbObjHandler embObjHandler = new EmbObjHandler(pRetValE);
            return embObjHandler.getValue();
        }
        TypedValue typedVal = CIMXMLParserImpl.parseSingleValue(pRetValE, 4);
        if (typedVal.getType() == null) {
            throw new CIMXMLParseException("VALUE or VALUE.REFERENCE nodes not found!");
        }
        Object value = typedVal.getValue();
        return value;
    }

    public static Vector<Object> parseIRETURNVALUE(Element pIRetValE) throws CIMXMLParseException {
        Element[] qualiDeclElementA;
        Element[] valObjWithLocalPathElementA;
        Element[] valObjWithPathElementA;
        Element[] valInstWithPathElementA;
        Element[] valNamedInstElementA;
        Element[] valObjElementA;
        Element[] valRefElementA;
        Element[] objPathElementA;
        Element[] instpathElementA;
        Element[] instNameElementA;
        Element[] classNameElementA;
        Element[] instElementA;
        Vector<Object> rtnV = new Vector<Object>();
        Element[] classElementA = CIMXMLParserImpl.searchNodes(pIRetValE, "CLASS");
        if (classElementA != null && classElementA.length > 0) {
            for (int i = 0; i < classElementA.length; ++i) {
                Element classE = classElementA[i];
                CIMClass c = CIMXMLParserImpl.parseCLASS(classE);
                rtnV.add(c);
            }
        }
        if ((instElementA = CIMXMLParserImpl.searchNodes(pIRetValE, "INSTANCE")) != null && instElementA.length > 0) {
            for (int i = 0; i < instElementA.length; ++i) {
                Element instanceE = instElementA[i];
                CIMInstance inst = CIMXMLParserImpl.parseINSTANCE(instanceE);
                rtnV.add(inst);
            }
        }
        if ((classNameElementA = CIMXMLParserImpl.searchNodes(pIRetValE, "CLASSNAME")) != null && classNameElementA.length > 0) {
            for (int i = 0; i < classNameElementA.length; ++i) {
                Element classnameE = classNameElementA[i];
                CIMObjectPath op = CIMXMLParserImpl.parseCLASSNAME(classnameE);
                rtnV.add(op);
            }
        }
        if ((instNameElementA = CIMXMLParserImpl.searchNodes(pIRetValE, "INSTANCENAME")) != null && instNameElementA.length > 0) {
            for (int i = 0; i < instNameElementA.length; ++i) {
                Element instancenameE = instNameElementA[i];
                CIMObjectPath op = CIMXMLParserImpl.parseINSTANCENAME(instancenameE);
                rtnV.add(op);
            }
        }
        if ((instpathElementA = CIMXMLParserImpl.searchNodes(pIRetValE, "INSTANCEPATH")) != null && instpathElementA.length > 0) {
            for (int i = 0; i < instpathElementA.length; ++i) {
                Element instancePathE = instpathElementA[i];
                CIMObjectPath op = CIMXMLParserImpl.parseINSTANCEPATH(instancePathE);
                rtnV.add(op);
            }
        }
        if ((objPathElementA = CIMXMLParserImpl.searchNodes(pIRetValE, "OBJECTPATH")) != null && objPathElementA.length > 0) {
            for (int i = 0; i < objPathElementA.length; ++i) {
                Element objectpathE = objPathElementA[i];
                CIMObjectPath op = CIMXMLParserImpl.parseOBJECTPATH(objectpathE);
                rtnV.add(op);
            }
        }
        if ((valRefElementA = CIMXMLParserImpl.searchNodes(pIRetValE, "VALUE.REFERENCE")) != null && valRefElementA.length > 0) {
            for (int i = 0; i < valRefElementA.length; ++i) {
                Element valuereferenceE = valRefElementA[i];
                CIMObjectPath op = CIMXMLParserImpl.parseVALUEREFERENCE(valuereferenceE);
                rtnV.add(op);
            }
        }
        if ((valObjElementA = CIMXMLParserImpl.searchNodes(pIRetValE, "VALUE.OBJECT")) != null && valObjElementA.length > 0) {
            for (int i = 0; i < valObjElementA.length; ++i) {
                Element valueobjectE = valObjElementA[i];
                CIMNamedElementInterface obj = CIMXMLParserImpl.parseVALUEOBJECT(valueobjectE);
                rtnV.add(obj);
            }
        }
        if ((valNamedInstElementA = CIMXMLParserImpl.searchNodes(pIRetValE, "VALUE.NAMEDINSTANCE")) != null && valNamedInstElementA.length > 0) {
            for (int i = 0; i < valNamedInstElementA.length; ++i) {
                Element valuenamedisntanceE = valNamedInstElementA[i];
                CIMInstance inst = CIMXMLParserImpl.parseVALUENAMEDINSTANCE(valuenamedisntanceE);
                rtnV.add(inst);
            }
        }
        if ((valInstWithPathElementA = CIMXMLParserImpl.searchNodes(pIRetValE, "VALUE.INSTANCEWITHPATH")) != null && valInstWithPathElementA.length > 0) {
            for (int i = 0; i < valInstWithPathElementA.length; ++i) {
                Element valueinstancewithpathE = valInstWithPathElementA[i];
                CIMInstance inst = CIMXMLParserImpl.parseVALUEINSTANCEWITHPATH(valueinstancewithpathE);
                rtnV.add(inst);
            }
        }
        if ((valObjWithPathElementA = CIMXMLParserImpl.searchNodes(pIRetValE, "VALUE.OBJECTWITHPATH")) != null && valObjWithPathElementA.length > 0) {
            for (int i = 0; i < valObjWithPathElementA.length; ++i) {
                Element valueobjectwithpathE = valObjWithPathElementA[i];
                CIMNamedElementInterface namedIF = CIMXMLParserImpl.parseVALUEOBJECTWITHPATH(valueobjectwithpathE);
                rtnV.add(namedIF);
            }
        }
        if ((valObjWithLocalPathElementA = CIMXMLParserImpl.searchNodes(pIRetValE, "VALUE.OBJECTWITHLOCALPATH")) != null && valObjWithLocalPathElementA.length > 0) {
            for (int i = 0; i < valObjWithLocalPathElementA.length; ++i) {
                Element valueobjectwithlocalpathE = valObjWithLocalPathElementA[i];
                CIMNamedElementInterface namedIF = CIMXMLParserImpl.parseVALUEOBJECTWITHLOCALPATH(valueobjectwithlocalpathE);
                rtnV.add(namedIF);
            }
        }
        if ((qualiDeclElementA = CIMXMLParserImpl.searchNodes(pIRetValE, "QUALIFIER.DECLARATION")) != null && qualiDeclElementA.length > 0) {
            for (int i = 0; i < qualiDeclElementA.length; ++i) {
                Element qualifierdeclarationE = qualiDeclElementA[i];
                CIMQualifierType<Object> o = CIMXMLParserImpl.parseQUALIFIERDECLARATION(qualifierdeclarationE);
                rtnV.add(o);
            }
        }
        return rtnV;
    }

    public static Object parseObject(Element pRootE) throws CIMXMLParseException {
        CIMTypedElement o = null;
        String nodeName = pRootE.getNodeName();
        if (nodeName.equalsIgnoreCase("INSTANCE")) {
            o = CIMXMLParserImpl.parseINSTANCE(pRootE);
        } else if (nodeName.equalsIgnoreCase("VALUE.NAMEDINSTANCE")) {
            o = CIMXMLParserImpl.parseVALUENAMEDINSTANCE(pRootE);
        } else if (nodeName.equalsIgnoreCase("VALUE.NAMEDOBJECT")) {
            o = CIMXMLParserImpl.parseVALUENAMEDOBJECT(pRootE);
        } else if (nodeName.equalsIgnoreCase("VALUE.OBJECTWITHPATH")) {
            o = CIMXMLParserImpl.parseVALUEOBJECTWITHPATH(pRootE);
        } else if (nodeName.equalsIgnoreCase("VALUE.OBJECTWITHLOCALPATH")) {
            o = CIMXMLParserImpl.parseVALUEOBJECTWITHLOCALPATH(pRootE);
        } else if (nodeName.equalsIgnoreCase("CLASS")) {
            o = CIMXMLParserImpl.parseCLASS(pRootE);
        } else if (nodeName.equalsIgnoreCase("CLASSPATH")) {
            o = CIMXMLParserImpl.parseCLASSPATH(pRootE);
        } else if (nodeName.equalsIgnoreCase("LOCALCLASSPATH")) {
            o = CIMXMLParserImpl.parseLOCALCLASSPATH(pRootE);
        } else if (nodeName.equalsIgnoreCase("OBJECTPATH")) {
            o = CIMXMLParserImpl.parseOBJECTPATH(pRootE);
        } else if (nodeName.equalsIgnoreCase("CLASSNAME")) {
            o = CIMXMLParserImpl.parseCLASSNAME(pRootE);
        } else if (nodeName.equalsIgnoreCase("INSTANCEPATH")) {
            o = CIMXMLParserImpl.parseINSTANCEPATH(pRootE);
        } else if (nodeName.equalsIgnoreCase("LOCALINSTANCEPATH")) {
            o = CIMXMLParserImpl.parseLOCALINSTANCEPATH(pRootE);
        } else if (nodeName.equalsIgnoreCase("INSTANCENAME")) {
            o = CIMXMLParserImpl.parseINSTANCENAME(pRootE);
        } else if (nodeName.equalsIgnoreCase("QUALIFIER")) {
            o = CIMXMLParserImpl.parseQUALIFIER(pRootE);
        } else if (nodeName.equalsIgnoreCase("PROPERTY")) {
            o = CIMXMLParserImpl.parsePROPERTY(pRootE);
        } else if (nodeName.equalsIgnoreCase("PROPERTY.ARRAY")) {
            o = CIMXMLParserImpl.parsePROPERTYARRAY(pRootE);
        } else if (nodeName.equalsIgnoreCase("PROPERTY.REFERENCE")) {
            o = CIMXMLParserImpl.parsePROPERTYREFERENCE(pRootE);
        } else if (nodeName.equalsIgnoreCase("METHOD")) {
            o = CIMXMLParserImpl.parseMETHOD(pRootE);
        } else if (nodeName.equalsIgnoreCase("PARAMETER")) {
            o = CIMXMLParserImpl.parsePARAMETER(pRootE);
        } else if (nodeName.equalsIgnoreCase("PARAMETER.REFERENCE")) {
            o = CIMXMLParserImpl.parsePARAMETERREFERENCE(pRootE);
        } else if (nodeName.equalsIgnoreCase("PARAMETER.ARRAY")) {
            o = CIMXMLParserImpl.parsePARAMETERARRAY(pRootE);
        } else if (nodeName.equalsIgnoreCase("PARAMETER.REFARRAY")) {
            o = CIMXMLParserImpl.parsePARAMETERREFARRAY(pRootE);
        }
        return o;
    }

    public static Element[] searchNodes(Element pParentE, String pTagName) {
        NodeList nl = pParentE.getChildNodes();
        if (nl == null || nl.getLength() == 0) {
            return null;
        }
        Vector<Node> resElementV = new Vector<Node>();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!n.getNodeName().equals(pTagName)) continue;
            resElementV.add(n);
        }
        return resElementV.toArray(new Element[0]);
    }

    public static Node searchFirstNode(Element pParentE, String pTagName) {
        NodeList nl = pParentE.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!n.getNodeName().equals(pTagName)) continue;
            return n;
        }
        return null;
    }

    public static Node searchAttribute(Node pParentN, String pAttrName) {
        NamedNodeMap nnm = pParentN.getAttributes();
        return nnm.getNamedItem(pAttrName);
    }

    public static Node searchFirstChild(Element pParentE) {
        return pParentE.getFirstChild();
    }

    public static Object createJavaObject(String pTypeStr, String pValue) throws CIMXMLParseException {
        if (pTypeStr == null) {
            pTypeStr = "string";
        }
        if ("null".equalsIgnoreCase(pTypeStr)) {
            return null;
        }
        Object o = null;
        CIMDataType cimType = CIMXMLParserImpl.parseTypeStr(pTypeStr, false);
        int radix = 10;
        if ((pTypeStr.toLowerCase().startsWith("sint") || pTypeStr.toLowerCase().startsWith("int")) && ((pValue = pValue.toLowerCase()).startsWith("0x") || pValue.startsWith("+0x") || pValue.startsWith("-0x"))) {
            radix = 16;
            pValue = pValue.startsWith("-") ? "-" + pValue.substring(3) : pValue.substring(pValue.indexOf(120) + 1);
        }
        switch (cimType.getType()) {
            case 0: {
                o = new UnsignedInteger8(Short.parseShort(pValue, radix));
                break;
            }
            case 2: {
                o = new UnsignedInteger16(Integer.parseInt(pValue, radix));
                break;
            }
            case 4: {
                o = new UnsignedInteger32(Long.parseLong(pValue, radix));
                break;
            }
            case 6: {
                o = new UnsignedInteger64(new BigInteger(pValue, radix));
                break;
            }
            case 1: {
                o = Byte.valueOf(pValue, radix);
                break;
            }
            case 3: {
                o = Short.valueOf(pValue, radix);
                break;
            }
            case 5: {
                o = Integer.valueOf(pValue, radix);
                break;
            }
            case 7: {
                o = Long.valueOf(pValue, radix);
                break;
            }
            case 8: {
                o = pValue;
                break;
            }
            case 9: {
                o = Boolean.valueOf(pValue);
                break;
            }
            case 10: {
                o = new Float(pValue);
                break;
            }
            case 11: {
                o = new Double(pValue);
                break;
            }
            case 12: {
                o = CIMXMLParserImpl.getDateTime(pValue);
                break;
            }
            case 14: {
                o = new CIMObjectPath(pValue);
                break;
            }
            case 13: {
                o = Character.valueOf(pValue.charAt(0));
            }
        }
        return o;
    }

    private static CIMDateTime getDateTime(String pValue) throws CIMXMLParseException {
        try {
            return new CIMDateTimeAbsolute(pValue);
        }
        catch (IllegalArgumentException eAbs) {
            try {
                return new CIMDateTimeInterval(pValue);
            }
            catch (IllegalArgumentException eInt) {
                throw new CIMXMLParseException("Failed to parse dateTime string: " + pValue + "!\n" + "CIMDateTimeAbsolute parsing error:\n" + eAbs.getMessage() + "\n" + "CIMDateTimeInterval parsing error:\n" + eInt.getMessage());
            }
        }
    }

    static {
        TYPESTR_MAP.put("uint8", CIMDataType.UINT8_T);
        TYPESTR_MAP.put("uint16", CIMDataType.UINT16_T);
        TYPESTR_MAP.put("uint32", CIMDataType.UINT32_T);
        TYPESTR_MAP.put("uint64", CIMDataType.UINT64_T);
        TYPESTR_MAP.put("sint8", CIMDataType.SINT8_T);
        TYPESTR_MAP.put("sint16", CIMDataType.SINT16_T);
        TYPESTR_MAP.put("sint32", CIMDataType.SINT32_T);
        TYPESTR_MAP.put("sint64", CIMDataType.SINT64_T);
        TYPESTR_MAP.put("real32", CIMDataType.REAL32_T);
        TYPESTR_MAP.put("real64", CIMDataType.REAL64_T);
        TYPESTR_MAP.put("char16 ", CIMDataType.CHAR16_T);
        TYPESTR_MAP.put("string", CIMDataType.STRING_T);
        TYPESTR_MAP.put("boolean", CIMDataType.BOOLEAN_T);
        TYPESTR_MAP.put("datetime", CIMDataType.DATETIME_T);
        TYPESTR_MAP.put("invalid", CIMDataType.INVALID_T);
        TYPESTR_MAP.put("object", CIMDataType.OBJECT_T);
        TYPESTR_MAP.put("class", CIMDataType.CLASS_T);
        TYPESTR_MAP.put("reference", new CIMDataType(null));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmbObjHandler {
        private CIMQualifier<?>[] iQualiA;
        private boolean iHasEmbObjAttr;
        private boolean iHasEmbInstAttr;
        private boolean iHasEmbObjQuali;
        private boolean iHasEmbInstQuali;
        private boolean iKeyed;
        private CIMDataType iRawType;
        private CIMDataType iType;
        private Object iRawValue;
        private Object iValue;
        private Element iElement;
        private boolean iStrictParsing = WBEMConfiguration.getGlobalConfiguration().strictEmbObjTypes();

        public EmbObjHandler(Element pElement) throws CIMXMLParseException {
            this.iElement = pElement;
            this.handleQualis();
            this.handleAttribs();
            Element valueE = (Element)CIMXMLParserImpl.searchFirstNode(pElement, "VALUE");
            if (valueE != null) {
                TypedValue tv = CIMXMLParserImpl.parseVALUE(valueE);
                if (this.iRawType == null) {
                    this.iRawType = tv.getType();
                }
                this.iRawValue = tv.getValue();
            } else {
                valueE = (Element)CIMXMLParserImpl.searchFirstNode(pElement, "VALUE.ARRAY");
                if (valueE != null) {
                    TypedValue tv = CIMXMLParserImpl.parseVALUEARRAY(valueE);
                    if (this.iRawType == null) {
                        this.iRawType = tv.getType();
                    }
                    this.iRawValue = tv.getValue();
                }
            }
        }

        private void handleQualis() throws CIMXMLParseException {
            this.iQualiA = CIMXMLParserImpl.parseQUALIFIERS(this.iElement);
            if (this.iQualiA != null) {
                for (int idx = 0; idx < this.iQualiA.length; ++idx) {
                    String qualiName = this.iQualiA[idx].getName();
                    if ("EmbeddedObject".equalsIgnoreCase(qualiName)) {
                        this.iHasEmbObjQuali = true;
                    } else if ("EMBEDDEDINSTANCE".equalsIgnoreCase(qualiName)) {
                        this.iHasEmbInstQuali = true;
                    } else if ("KEY".equalsIgnoreCase(qualiName)) {
                        this.iKeyed = true;
                    }
                    if (!this.iHasEmbObjQuali && !this.iHasEmbInstQuali || !this.iKeyed) continue;
                    return;
                }
            }
        }

        private void handleAttribs() throws CIMXMLParseException {
            String embObjAttrStr;
            String typeStr = this.iElement.getAttribute("TYPE");
            if (!(typeStr != null && typeStr.length() != 0 || (typeStr = this.iElement.getAttribute("PARAMTYPE")) != null && typeStr.length() != 0)) {
                typeStr = null;
            }
            if (typeStr != null) {
                this.iRawType = CIMXMLParserImpl.parseScalarTypeStr(typeStr);
            }
            if ((embObjAttrStr = this.iElement.getAttribute("EmbeddedObject")) == null || embObjAttrStr.length() == 0) {
                embObjAttrStr = this.iElement.getAttribute("EMBEDDEDOBJECT");
            }
            if (embObjAttrStr == null || embObjAttrStr.length() == 0) {
                this.iHasEmbInstAttr = false;
                this.iHasEmbObjAttr = false;
            } else if ("object".equalsIgnoreCase(embObjAttrStr)) {
                this.iHasEmbObjAttr = true;
                this.iHasEmbInstAttr = false;
            } else if ("instance".equalsIgnoreCase(embObjAttrStr)) {
                this.iHasEmbObjAttr = false;
                this.iHasEmbInstAttr = true;
            } else {
                throw new CIMXMLParseException("EmbeddedObject attribute cannot contain \"" + embObjAttrStr + "\" value!");
            }
        }

        public CIMQualifier<?>[] getQualifiers() throws CIMXMLParseException {
            this.transform();
            CIMQualifiedElementInterfaceImpl qualiImpl = new CIMQualifiedElementInterfaceImpl(this.iQualiA, this.isKeyed(), this.iType.getType() == 8);
            return qualiImpl.getQualifiers();
        }

        public boolean isKeyed() {
            return this.iKeyed;
        }

        private boolean isEmbeddedObject() {
            return this.iHasEmbObjAttr || this.iHasEmbInstAttr || this.iHasEmbObjQuali || this.iHasEmbInstQuali;
        }

        private boolean isEmbeddedClass() {
            return this.iHasEmbObjAttr || this.iHasEmbObjQuali;
        }

        private boolean isEmbeddedInstance() {
            return this.iHasEmbInstAttr || this.iHasEmbInstQuali;
        }

        public CIMDataType getType() throws CIMXMLParseException {
            this.transform();
            return this.iType;
        }

        public CIMDataType getArrayType() throws CIMXMLParseException {
            this.transform();
            return this.iType.isArray() ? this.iType : new CIMDataType(this.iType.getType(), 0);
        }

        public Object getValue() throws CIMXMLParseException {
            this.transform();
            return this.iValue;
        }

        private void transform() throws CIMXMLParseException {
            if (this.iType != null) {
                return;
            }
            if (this.iRawValue == null) {
                if (this.isEmbeddedObject()) {
                    if (this.iRawType != CIMDataType.STRING_T) {
                        throw new CIMXMLParseException("Embedded Object CIM-XML element's type must be string. " + this.iRawType + " is invalid!");
                    }
                    this.iType = this.iStrictParsing ? (this.isEmbeddedInstance() ? CIMDataType.OBJECT_T : CIMDataType.CLASS_T) : (this.isEmbeddedInstance() ? CIMDataType.OBJECT_T : CIMDataType.STRING_T);
                } else {
                    this.iType = this.iRawType;
                }
                this.iValue = null;
            } else if (this.isEmbeddedObject()) {
                this.transformEmbObj();
            } else {
                this.transformNormObj();
            }
        }

        private void transformEmbObj() throws CIMXMLParseException {
            if (this.iRawValue instanceof String) {
                this.iValue = EmbObjHandler.parseXmlStr((String)this.iRawValue);
                this.iType = EmbObjHandler.getCIMObjType(this.iValue);
            } else {
                this.iValue = EmbObjHandler.parseXmlStrA((String[])this.iRawValue);
                this.iType = EmbObjHandler.getCIMObjAType((Object[])this.iValue);
            }
            if (this.isEmbeddedInstance() && this.iType.getType() != 15) {
                throw new CIMXMLParseException(this.iElement.getNodeName() + " element is an EmbeddedInstance with non INSTANCE value. " + "It's not valid!");
            }
            if (this.isEmbeddedClass() && this.iType.getType() != 17 && this.iType.getType() != 15) {
                throw new CIMXMLParseException(this.iElement.getNodeName() + " element is an EmbeddedObject with non CLASS/INSTANCE value. It's not valid!");
            }
        }

        private void transformNormObj() throws CIMXMLParseException {
            if (this.iRawValue instanceof String) {
                this.iType = this.iRawType;
                this.iValue = CIMXMLParserImpl.createJavaObject(this.iType.toString(), (String)this.iRawValue);
            } else {
                String[] rawValueA = (String[])this.iRawValue;
                String typeStr = this.iRawType.toString();
                Object[] objA = new Object[rawValueA.length];
                for (int i = 0; i < objA.length; ++i) {
                    objA[i] = CIMXMLParserImpl.createJavaObject(typeStr, rawValueA[i]);
                }
                this.iType = new CIMDataType(this.iRawType.getType(), 0);
                this.iValue = objA;
            }
        }

        public static Object parseXmlStr(String pXmlStr) throws CIMXMLParseException {
            if (pXmlStr == null || pXmlStr.length() == 0) {
                return null;
            }
            try {
                CIMClientXML_HelperImpl builder = new CIMClientXML_HelperImpl();
                Document doc = builder.parse(new InputSource(new StringReader(pXmlStr)));
                return CIMXMLParserImpl.parseObject(doc.getDocumentElement());
            }
            catch (CIMXMLParseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMXMLParseException(e.getMessage() + "\npXmlStr=" + pXmlStr);
            }
        }

        public static Object[] parseXmlStrA(String[] pXmlStrA) throws CIMXMLParseException {
            if (pXmlStrA == null || pXmlStrA.length == 0) {
                return null;
            }
            Object[] objA = new Object[pXmlStrA.length];
            for (int i = 0; i < objA.length; ++i) {
                String xmlStr = pXmlStrA[i];
                objA[i] = xmlStr == null ? null : EmbObjHandler.parseXmlStr(xmlStr);
            }
            return objA;
        }

        public static CIMDataType getCIMObjType(Object pCIMObj) throws CIMXMLParseException {
            if (pCIMObj == null) {
                throw new CIMXMLParseException("cannot have null CIM object! (CIMClass or CIMInstance)");
            }
            if (pCIMObj instanceof CIMInstance) {
                return CIMDataType.OBJECT_T;
            }
            if (pCIMObj instanceof CIMClass) {
                return CIMDataType.CLASS_T;
            }
            throw new CIMXMLParseException(pCIMObj.getClass().getName() + " is not a CIM object! (CIMClass or CIMInstance)");
        }

        public static CIMDataType getCIMObjAType(Object[] pCIMObjA) throws CIMXMLParseException {
            if (pCIMObjA == null || pCIMObjA.length == 0) {
                return CIMDataType.STRING_ARRAY_T;
            }
            CIMDataType type = null;
            for (int i = 0; i < pCIMObjA.length; ++i) {
                if (pCIMObjA[i] == null) continue;
                CIMDataType currType = EmbObjHandler.getCIMObjType(pCIMObjA[i]);
                if (type == null) {
                    type = currType;
                    continue;
                }
                if (type == currType) continue;
                throw new CIMXMLParseException("Embedded Object arrays with different types are not supported");
            }
            if (type == CIMDataType.OBJECT_T) {
                return CIMDataType.OBJECT_ARRAY_T;
            }
            if (type == CIMDataType.CLASS_T) {
                return CIMDataType.CLASS_ARRAY_T;
            }
            return CIMDataType.STRING_ARRAY_T;
        }
    }

    private static class ValueTypeHandler {
        private CIMDataType iType;
        private Object iValue;

        public ValueTypeHandler(String pValueTypeStr, String pValueStr) throws CIMXMLParseException {
            if (pValueTypeStr == null) {
                throw new CIMXMLParseException("KEYVALUE node must have a VALUETYPE attribute!");
            }
            if (pValueTypeStr.equals("numeric")) {
                if (!(this.setUInt64(pValueStr) || this.setSInt64(pValueStr) || this.setReal64(pValueStr))) {
                    throw new CIMXMLParseException("Unparseable \"number\" value: " + pValueStr + " !");
                }
            } else if (pValueTypeStr.equals("string")) {
                if (!this.setDTAbsolute(pValueStr) && !this.setDTInterval(pValueStr)) {
                    this.iValue = pValueStr;
                    this.iType = CIMDataType.STRING_T;
                }
            } else if (pValueTypeStr.equals("boolean")) {
                if (!this.setBoolean(pValueStr)) {
                    throw new CIMXMLParseException("Unparsable \"boolean\" value: " + pValueStr + " !");
                }
            } else {
                throw new CIMXMLParseException("KEYVALUE node's VALUETYPE attribute must be string, boolean or numeric! " + pValueStr + " is not allowed!");
            }
        }

        public CIMDataType getType() {
            return this.iType;
        }

        public Object getValue() {
            return this.iValue;
        }

        private boolean setUInt64(String pValue) {
            try {
                this.iValue = new UnsignedInteger64(pValue);
            }
            catch (NumberFormatException e) {
                return false;
            }
            this.iType = CIMDataType.UINT64_T;
            return true;
        }

        private boolean setSInt64(String pValue) {
            try {
                this.iValue = new Long(pValue);
            }
            catch (NumberFormatException e) {
                return false;
            }
            this.iType = CIMDataType.SINT64_T;
            return true;
        }

        private boolean setReal64(String pValue) {
            try {
                this.iValue = new Double(pValue);
            }
            catch (NumberFormatException e) {
                return false;
            }
            this.iType = CIMDataType.REAL64_T;
            return true;
        }

        private boolean setBoolean(String pValue) {
            try {
                this.iValue = Boolean.valueOf(pValue);
            }
            catch (NumberFormatException e) {
                return false;
            }
            this.iType = CIMDataType.BOOLEAN_T;
            return true;
        }

        private boolean setDTAbsolute(String pValue) {
            try {
                this.iValue = new CIMDateTimeAbsolute(pValue);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            this.iType = CIMDataType.DATETIME_T;
            return true;
        }

        private boolean setDTInterval(String pValue) {
            try {
                this.iValue = new CIMDateTimeInterval(pValue);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            this.iType = CIMDataType.DATETIME_T;
            return true;
        }
    }
}

