/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.discovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.wbem.client.WBEMClient;
import org.sblim.cimclient.discovery.WBEMProtocol;
import org.sblim.cimclient.discovery.WBEMServiceAdvertisement;
import org.sblim.cimclient.internal.logging.LogAndTraceBroker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvertisementCatalog {
    public static int EVENT_ADD = 1;
    public static int EVENT_REMOVE = 2;
    public static int EVENT_EXPIRE = 4;
    public static int EVENT_RENEW = 8;
    private List<EventListener> iListeners = new LinkedList<EventListener>();
    private HashMap<String, List<AdvertisementDecorator>> iCatalogByDirectory = new HashMap();
    private Map<String, Map<WBEMProtocol, WBEMServiceAdvertisement>> iCatalogById = new HashMap<String, Map<WBEMProtocol, WBEMServiceAdvertisement>>();

    public void addEventListener(EventListener pListener) {
        this.iListeners.add(pListener);
    }

    public void addAdvertisements(WBEMServiceAdvertisement[] pAdvertisements) {
        for (int i = 0; i < pAdvertisements.length; ++i) {
            String url = "";
            try {
                AdvertisementDecorator entry;
                WBEMServiceAdvertisement advertisement = pAdvertisements[i];
                url = advertisement.getServiceUrl();
                WBEMProtocol protocol = this.makeProtocol(advertisement);
                String serviceId = advertisement.getAttribute("service-id");
                List<AdvertisementDecorator> innerList = this.iCatalogByDirectory.get(advertisement.getDirectory());
                if (innerList == null) {
                    innerList = new ArrayList<AdvertisementDecorator>();
                    this.iCatalogByDirectory.put(advertisement.getDirectory(), innerList);
                }
                if ((entry = this.findAdvertisement(innerList, advertisement)) != null) {
                    boolean wasExpired = entry.isExpired();
                    entry.setAdvertisement(advertisement);
                    entry.setRefresh(false);
                    entry.setExpired(false);
                    if (wasExpired) {
                        this.notifyEventListeners(EVENT_RENEW, advertisement);
                    }
                } else {
                    innerList.add(new AdvertisementDecorator(advertisement));
                    this.notifyEventListeners(EVENT_ADD, advertisement);
                }
                Map<WBEMProtocol, WBEMServiceAdvertisement> innerMap = this.iCatalogById.get(serviceId);
                if (innerMap == null) {
                    innerMap = new HashMap<WBEMProtocol, WBEMServiceAdvertisement>();
                    this.iCatalogById.put(serviceId, innerMap);
                }
                innerMap.put(protocol, advertisement);
                continue;
            }
            catch (Exception e) {
                LogAndTraceBroker.getBroker().trace(Level.FINE, "Incomplete advertisement for" + url, e);
            }
        }
    }

    public WBEMServiceAdvertisement getAdvertisement(String pId, WBEMProtocol[] pProtocols) {
        Map<WBEMProtocol, WBEMServiceAdvertisement> innerMap = this.iCatalogById.get(pId);
        if (innerMap == null) {
            return null;
        }
        for (int i = 0; i < pProtocols.length; ++i) {
            WBEMServiceAdvertisement advertisement = innerMap.get(pProtocols[i]);
            if (advertisement == null) continue;
            return advertisement;
        }
        return null;
    }

    public WBEMServiceAdvertisement[] getAdvertisementsByDirectory(String pDirectory) {
        List<AdvertisementDecorator> result = this.iCatalogByDirectory.get(pDirectory);
        return result != null ? result.toArray(new WBEMServiceAdvertisement[result.size()]) : new WBEMServiceAdvertisement[]{};
    }

    public WBEMServiceAdvertisement[] getAdvertisementsById(String pId) {
        Map<WBEMProtocol, WBEMServiceAdvertisement> innerMap = this.iCatalogById.get(pId);
        if (innerMap == null) {
            return null;
        }
        Collection<WBEMServiceAdvertisement> advertisements = innerMap.values();
        return advertisements.toArray(new WBEMServiceAdvertisement[advertisements.size()]);
    }

    public String[] getKnownIds() {
        Set<String> ids = this.iCatalogById.keySet();
        return ids.toArray(new String[ids.size()]);
    }

    public void refreshAdvertisements(String[] pDirectory, WBEMServiceAdvertisement[] pAdvertisements) {
        int i;
        for (i = 0; i < pDirectory.length; ++i) {
            this.markRefresh(pDirectory[i]);
        }
        this.addAdvertisements(pAdvertisements);
        for (i = 0; i < pDirectory.length; ++i) {
            this.expire(pDirectory[i]);
        }
    }

    public void removeEventListener(EventListener pListener) {
        this.iListeners.remove(pListener);
    }

    public void removeExpired(String pDirectory) {
        if (pDirectory == null) {
            Iterator<String> iter = this.iCatalogByDirectory.keySet().iterator();
            while (iter.hasNext()) {
                this.removeExpired(iter.next());
            }
            return;
        }
        List<AdvertisementDecorator> advertisementList = this.iCatalogByDirectory.get(pDirectory);
        Iterator<AdvertisementDecorator> iter = advertisementList.iterator();
        while (iter.hasNext()) {
            AdvertisementDecorator decorator = iter.next();
            if (!decorator.isExpired()) continue;
            iter.remove();
            this.notifyEventListeners(EVENT_REMOVE, decorator);
            Map<WBEMProtocol, WBEMServiceAdvertisement> innerMap = this.iCatalogById.get(decorator.getServiceId());
            innerMap.remove(this.makeProtocol(decorator));
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("AdvertisementCatalog:");
        for (Map.Entry<String, Map<WBEMProtocol, WBEMServiceAdvertisement>> entry : this.iCatalogById.entrySet()) {
            if (entry.getValue() == null) continue;
            result.append("[service-id:\"");
            result.append(entry.getKey());
            result.append("\"");
            Map<WBEMProtocol, WBEMServiceAdvertisement> innerMap = entry.getValue();
            for (Map.Entry<WBEMProtocol, WBEMServiceAdvertisement> innerEntry : innerMap.entrySet()) {
                result.append("[");
                result.append(innerEntry.getKey().toString());
                result.append("]");
            }
            result.append("]");
        }
        return result.toString();
    }

    private void expire(String pDirectory) {
        List<AdvertisementDecorator> advertisementList = this.iCatalogByDirectory.get(pDirectory);
        if (advertisementList == null) {
            return;
        }
        for (AdvertisementDecorator advertisement : advertisementList) {
            if (!advertisement.isRefresh()) continue;
            advertisement.setRefresh(false);
            advertisement.setExpired(true);
            this.notifyEventListeners(EVENT_EXPIRE, advertisement);
        }
    }

    private AdvertisementDecorator findAdvertisement(List<AdvertisementDecorator> pList, WBEMServiceAdvertisement pAdvertisement) {
        for (AdvertisementDecorator entry : pList) {
            if (!entry.getServiceUrl().equals(pAdvertisement.getServiceUrl())) continue;
            return entry;
        }
        return null;
    }

    private WBEMProtocol makeProtocol(WBEMServiceAdvertisement advertisement) {
        String presentation = advertisement.getAttribute("CommunicationMechanism");
        if ("OTHER".equalsIgnoreCase(presentation)) {
            presentation = advertisement.getAttribute("OtherCommunicationMechanismDescription");
        }
        String transport = advertisement.getServiceUrl().split(":", 2)[0];
        WBEMProtocol protocol = new WBEMProtocol(transport, presentation);
        return protocol;
    }

    private void markRefresh(String pDirectory) {
        List<AdvertisementDecorator> advertisementList = this.iCatalogByDirectory.get(pDirectory);
        if (advertisementList == null) {
            return;
        }
        for (AdvertisementDecorator advertisement : advertisementList) {
            advertisement.setRefresh(true);
        }
    }

    private void notifyEventListeners(int pEvent, WBEMServiceAdvertisement pAdvertisement) {
        Iterator<EventListener> iter = this.iListeners.iterator();
        while (iter.hasNext()) {
            iter.next().advertisementEvent(pEvent, pAdvertisement);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AdvertisementDecorator
    implements WBEMServiceAdvertisement {
        private WBEMServiceAdvertisement iAdvertisement;
        private boolean iRefresh = false;

        protected AdvertisementDecorator(WBEMServiceAdvertisement pAdvertisement) {
            if (pAdvertisement == null) {
                throw new IllegalArgumentException("Advertisement is null");
            }
            this.iAdvertisement = pAdvertisement;
        }

        protected WBEMServiceAdvertisement getAdvertisementXXX() {
            return this.iAdvertisement;
        }

        protected boolean isRefresh() {
            return this.iRefresh;
        }

        protected void setAdvertisement(WBEMServiceAdvertisement pAdvertisement) {
            this.iAdvertisement = pAdvertisement;
        }

        protected void setRefresh(boolean pRefresh) {
            this.iRefresh = pRefresh;
        }

        public boolean equals(Object pObj) {
            return this.iAdvertisement.equals(pObj);
        }

        public int hashCode() {
            return this.iAdvertisement.hashCode();
        }

        @Override
        public WBEMClient createClient(Subject pSubject, Locale[] pLocales) throws Exception {
            return this.iAdvertisement.createClient(pSubject, pLocales);
        }

        @Override
        public String getAttribute(String pAttributeName) {
            return this.iAdvertisement.getAttribute(pAttributeName);
        }

        @Override
        public Set<Map.Entry<String, String>> getAttributes() {
            return this.iAdvertisement.getAttributes();
        }

        @Override
        public String getConcreteServiceType() {
            return this.iAdvertisement.getConcreteServiceType();
        }

        @Override
        public String getDirectory() {
            return this.iAdvertisement.getDirectory();
        }

        @Override
        public String[] getInteropNamespaces() {
            return this.iAdvertisement.getInteropNamespaces();
        }

        @Override
        public String getServiceId() {
            return this.iAdvertisement.getServiceId();
        }

        @Override
        public String getServiceUrl() {
            return this.iAdvertisement.getServiceUrl();
        }

        @Override
        public boolean isExpired() {
            return this.iAdvertisement.isExpired();
        }

        @Override
        public void setExpired(boolean pExpired) {
            this.iAdvertisement.setExpired(pExpired);
        }
    }

    public static interface EventListener {
        public void advertisementEvent(int var1, WBEMServiceAdvertisement var2);
    }
}

