/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient;

import java.io.IOException;
import java.net.BindException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.wbem.listener.IndicationListener;
import javax.wbem.listener.WBEMListener;
import org.sblim.cimclient.internal.http.HttpConnectionHandler;
import org.sblim.cimclient.internal.http.HttpServerConnection;
import org.sblim.cimclient.internal.util.WBEMConfiguration;
import org.sblim.cimclient.internal.wbem.indications.CIMEventDispatcher;
import org.sblim.cimclient.internal.wbem.indications.CIMIndicationHandler;

public class WBEMListenerSBLIM
implements WBEMListener {
    private static final WBEMListenerSBLIM INSTANCE = new WBEMListenerSBLIM();
    private Map<Integer, WBEMListenerImpl> iPortMap = new HashMap<Integer, WBEMListenerImpl>();

    public static WBEMListenerSBLIM getInstance() {
        return INSTANCE;
    }

    private WBEMListenerSBLIM() {
    }

    public int addListener(IndicationListener pListener, int pPort, String pTransport) throws IOException {
        return this.addListener(pListener, pPort, pTransport, null, null);
    }

    public int addListener(IndicationListener pListener, int pPort, String pTransport, String pLocalAddr) throws IOException {
        return this.addListener(pListener, pPort, pTransport, pLocalAddr, null);
    }

    public synchronized int addListener(IndicationListener pListener, int pPort, String pTransport, String pLocalAddr, Properties pConfigurationProperties) throws IOException {
        boolean ssl;
        if (pPort > 0 && this.iPortMap.containsKey(pPort)) {
            throw new BindException("Port already in use.");
        }
        if (pTransport.equalsIgnoreCase("HTTP")) {
            ssl = false;
        } else if (pTransport.equalsIgnoreCase("HTTPS")) {
            ssl = true;
        } else {
            throw new IllegalArgumentException("Unknown transport: " + pTransport + "! Valid values are http and https.");
        }
        WBEMListenerImpl listener = new WBEMListenerImpl(pLocalAddr, pPort, ssl, pListener, pConfigurationProperties);
        listener.start();
        this.iPortMap.put(listener.getListenerPort(), listener);
        return listener.getListenerPort();
    }

    public synchronized void removeListener(int pPort) {
        WBEMListenerImpl listener = this.iPortMap.remove(pPort);
        if (listener != null) {
            listener.stop();
        }
    }

    public static class WBEMListenerImpl {
        private IndicationListener iIndicationListener;
        private HttpServerConnection iConnection;

        public WBEMListenerImpl(String pLocalAddress, int pPort, boolean pSSL, IndicationListener pIndicationListener, Properties pProperties) throws IOException {
            this.iIndicationListener = pIndicationListener;
            CIMEventDispatcher eventDispatcher = new CIMEventDispatcher(this.iIndicationListener);
            CIMIndicationHandler indicationHandler = new CIMIndicationHandler(eventDispatcher);
            this.iConnection = new HttpServerConnection(new HttpConnectionHandler(indicationHandler), pLocalAddress, pPort, pSSL, pProperties != null ? new WBEMConfiguration(pProperties) : WBEMConfiguration.getGlobalConfiguration());
        }

        protected void finalize() {
            this.stop();
        }

        public void start() {
            this.iConnection.start();
        }

        public void stop() {
            this.iConnection.close();
        }

        public IndicationListener getIndicationListener() {
            return this.iIndicationListener;
        }

        public int getListenerPort() {
            return this.iConnection.getPort();
        }
    }
}

