/*
 * Decompiled with CFR 0.152.
 */
package javax.cim;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMElement;
import javax.cim.CIMNamedElementInterface;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import org.sblim.cimclient.internal.cim.CIMElementSorter;
import org.sblim.cimclient.internal.cim.CIMInstanceBuilder;
import org.sblim.cimclient.internal.logging.LogAndTraceBroker;
import org.sblim.cimclient.internal.util.MOF;
import org.sblim.cimclient.internal.util.StringSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CIMInstance
implements CIMNamedElementInterface,
Serializable {
    private static final long serialVersionUID = -249160087013230559L;
    private static final CIMProperty<?>[] EMPTY_PROP_A = new CIMProperty[0];
    private CIMObjectPath iObjPath;
    private CIMProperty<?>[] iProps;

    public CIMInstance(CIMObjectPath pName, CIMProperty<?>[] pProps) throws IllegalArgumentException {
        if (pName == null) {
            String msg = "CIMObjectPath parameter cannot be null!";
            throw new IllegalArgumentException(msg);
        }
        if (pName.getObjectName() == null) {
            String msg = "ObjectName cannot be null!";
            throw new IllegalArgumentException(msg);
        }
        CIMInstanceBuilder instBuilder = new CIMInstanceBuilder(pName, pProps);
        this.iObjPath = instBuilder.setKeys(pName);
        this.iProps = instBuilder.getAllPropertis();
    }

    public CIMInstance deriveInstance(CIMObjectPath pPath) {
        return new CIMInstance(pPath, this.iProps);
    }

    public CIMInstance deriveInstance(CIMProperty<?>[] pPropA) {
        int i;
        if (pPropA == null) {
            return this;
        }
        CIMElement[] newPropA = new CIMProperty[this.getPropertyCount()];
        for (i = 0; i < newPropA.length; ++i) {
            newPropA[i] = this.iProps[i];
        }
        for (i = 0; i < pPropA.length; ++i) {
            CIMProperty<?> newProp = pPropA[i];
            int idx = CIMElementSorter.findIdx(newPropA, newProp.getName());
            if (idx < 0) continue;
            CIMElement oldProp = newPropA[idx];
            if (!CIMInstance.typesEqual(oldProp, newProp)) {
                LogAndTraceBroker.getBroker().trace(Level.FINE, "CIMInstance.deriveInstance() can update only property values but not property types!\noriginal property: " + oldProp + "\nnew property: " + newProp);
                continue;
            }
            newPropA[idx] = new CIMProperty(oldProp.getName(), newProp.getDataType(), newProp.getValue(), ((CIMProperty)oldProp).isKey(), ((CIMProperty)oldProp).isPropagated(), ((CIMProperty)oldProp).getOriginClass());
        }
        return new CIMInstance(new CIMObjectPath(this.iObjPath.getScheme(), this.iObjPath.getHost(), this.iObjPath.getPort(), this.iObjPath.getNamespace(), this.iObjPath.getObjectName(), null), (CIMProperty<?>[])newPropA);
    }

    public boolean equals(Object pObj) {
        if (!(pObj instanceof CIMInstance)) {
            return false;
        }
        CIMInstance that = (CIMInstance)pObj;
        return this.iObjPath.equals(that.iObjPath) && Arrays.equals(this.iProps, that.iProps);
    }

    public CIMInstance filterProperties(boolean pLocalOnly, boolean pIncludeClassOrigin, String[] pPropertyList) {
        StringSorter.sort(pPropertyList);
        ArrayList propAList = new ArrayList();
        for (int i = 0; i < this.getPropertyCount(); ++i) {
            CIMProperty<?> prop = this.getProperty(i);
            if (pLocalOnly && prop.isPropagated() || pPropertyList != null && !StringSorter.find(pPropertyList, prop.getName())) continue;
            propAList.add(new CIMProperty(prop.getName(), prop.getDataType(), prop.getValue(), prop.isKey(), prop.isPropagated(), pIncludeClassOrigin ? prop.getOriginClass() : null));
        }
        return new CIMInstance(new CIMObjectPath(this.iObjPath.getScheme(), this.iObjPath.getHost(), this.iObjPath.getPort(), this.iObjPath.getNamespace(), this.iObjPath.getObjectName(), null), propAList.toArray(EMPTY_PROP_A));
    }

    public String getClassName() {
        return this.iObjPath.getObjectName();
    }

    public CIMProperty<?>[] getKeys() {
        ArrayList keyALst = new ArrayList();
        for (int i = 0; i < this.iProps.length; ++i) {
            CIMProperty<?> prop = this.iProps[i];
            if (!prop.isKey()) continue;
            keyALst.add(prop);
        }
        return keyALst.toArray(EMPTY_PROP_A);
    }

    @Override
    public CIMObjectPath getObjectPath() {
        return this.iObjPath;
    }

    public CIMProperty<?>[] getProperties() {
        return this.iProps == null ? new CIMProperty[]{} : this.iProps;
    }

    public CIMProperty<?> getProperty(int pIndex) throws ArrayIndexOutOfBoundsException {
        return this.iProps[pIndex];
    }

    public CIMProperty<?> getProperty(String pName) {
        return this.getProperty(pName, null);
    }

    public CIMProperty<?> getProperty(String pName, String pOriginClass) {
        CIMProperty prop = (CIMProperty)CIMElementSorter.find(this.iProps, pName);
        if (prop == null) {
            return null;
        }
        if (pOriginClass == null) {
            return prop;
        }
        if (pOriginClass.equalsIgnoreCase(prop.getOriginClass())) {
            return prop;
        }
        return null;
    }

    public int getPropertyCount() {
        return this.iProps == null ? 0 : this.iProps.length;
    }

    public Object getPropertyValue(String name) {
        CIMProperty<?> prop = this.getProperty(name);
        return prop == null ? null : prop.getValue();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return MOF.instanceDeclaration(this, "");
    }

    private static boolean typesEqual(CIMProperty<?> pProp0, CIMProperty<?> pProp1) {
        CIMDataType type0 = pProp0.getDataType();
        CIMDataType type1 = pProp0.getDataType();
        return type0.getType() == type1.getType() && type0.isArray() == type1.isArray();
    }
}

