/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.apputils.vim25;

import com.vmware.apputils.AppUtil;
import com.vmware.apputils.vim25.ServiceConnection;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.ObjectUpdate;
import com.vmware.vim25.ObjectUpdateKind;
import com.vmware.vim25.PropertyChange;
import com.vmware.vim25.PropertyChangeOp;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertyFilterUpdate;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.SelectionSpec;
import com.vmware.vim25.TaskInfo;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.TraversalSpec;
import com.vmware.vim25.UpdateSet;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.axis.AxisFault;
import org.w3c.dom.Element;

public class ServiceUtil {
    private AppUtil _cb;
    private ServiceConnection _connection;
    static String[] meTree = new String[]{"ManagedEntity", "ComputeResource", "ClusterComputeResource", "Datacenter", "Folder", "HostSystem", "ResourcePool", "VirtualMachine"};
    static String[] crTree = new String[]{"ComputeResource", "ClusterComputeResource"};
    static String[] hcTree = new String[]{"HistoryCollector", "EventHistoryCollector", "TaskHistoryCollector"};

    public static ServiceUtil CreateServiceUtil() {
        return new ServiceUtil();
    }

    public void init(AppUtil cb, ServiceConnection svc) throws Exception {
        this._cb = cb;
        this._connection = svc;
    }

    public void clientConnect() throws Exception {
        try {
            if (this._cb.option_is_set("ignorecert")) {
                this._connection.connect(this._cb.getServiceUrl(), this._cb.getUsername(), this._cb.getPassword(), true);
            } else {
                this._connection.connect(this._cb.getServiceUrl(), this._cb.getUsername(), this._cb.getPassword(), false);
            }
        }
        catch (Exception e) {
            this._cb.getUtil().logException(e);
            throw e;
        }
    }

    public void clientLoadSession(String cookieString) throws Exception {
        try {
            this._connection.loadSession(this._cb.getServiceUrl(), cookieString);
        }
        catch (Exception e) {
            this._cb.getUtil().logException(e);
            throw e;
        }
    }

    public void clientSaveSession(String fileName) throws Exception {
        try {
            this._connection.saveSession(fileName);
        }
        catch (Exception e) {
            this._cb.getUtil().logException(e);
            throw e;
        }
    }

    public void clientDisconnect() throws Exception {
        try {
            this._connection.disconnect();
        }
        catch (Exception e) {
            this._cb.getUtil().logException(e);
            throw e;
        }
    }

    boolean typeIsA(String searchType, String foundType) {
        block8: {
            block9: {
                block7: {
                    if (searchType.equals(foundType)) {
                        return true;
                    }
                    if (!searchType.equals("ManagedEntity")) break block7;
                    int i = 0;
                    while (i < meTree.length) {
                        if (meTree[i].equals(foundType)) {
                            return true;
                        }
                        ++i;
                    }
                    break block8;
                }
                if (!searchType.equals("ComputeResource")) break block9;
                int i = 0;
                while (i < crTree.length) {
                    if (crTree[i].equals(foundType)) {
                        return true;
                    }
                    ++i;
                }
                break block8;
            }
            if (!searchType.equals("HistoryCollector")) break block8;
            int i = 0;
            while (i < hcTree.length) {
                if (hcTree[i].equals(foundType)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public ManagedObjectReference getDecendentMoRef(ManagedObjectReference root, String type, String name) throws Exception {
        if (name == null || name.length() == 0) {
            return null;
        }
        String[][] typeinfo = new String[][]{{type, "name"}};
        ObjectContent[] ocary = this.getContentsRecursively(null, root, typeinfo, true);
        if (ocary == null || ocary.length == 0) {
            return null;
        }
        ObjectContent oc = null;
        ManagedObjectReference mor = null;
        DynamicProperty[] propary = null;
        String propval = null;
        boolean found = false;
        int oci = 0;
        while (oci < ocary.length && !found) {
            oc = ocary[oci];
            mor = oc.getObj();
            propary = oc.getPropSet();
            propval = null;
            if (type == null || this.typeIsA(type, mor.getType())) {
                if (propary.length > 0) {
                    propval = (String)propary[0].getVal();
                }
                found = propval != null && name.equals(propval);
            }
            ++oci;
        }
        if (!found) {
            mor = null;
        }
        return mor;
    }

    public ManagedObjectReference getFirstDecendentMoRef(ManagedObjectReference root, String type) throws Exception {
        ArrayList morlist = this.getDecendentMoRefs(root, type);
        ManagedObjectReference mor = null;
        if (morlist.size() > 0) {
            mor = (ManagedObjectReference)morlist.get(0);
        }
        return mor;
    }

    public ArrayList getDecendentMoRefs(ManagedObjectReference root, String type) throws Exception {
        ArrayList mors = this.getDecendentMoRefs(root, type, null);
        return mors;
    }

    public ArrayList getDecendentMoRefs(ManagedObjectReference root, String type, String[][] filter) throws Exception {
        String[][] typeinfo = new String[][]{{type, "name"}};
        ObjectContent[] ocary = this.getContentsRecursively(null, root, typeinfo, true);
        ArrayList<ManagedObjectReference> refs = new ArrayList<ManagedObjectReference>();
        if (ocary == null || ocary.length == 0) {
            return refs;
        }
        int oci = 0;
        while (oci < ocary.length) {
            refs.add(ocary[oci].getObj());
            ++oci;
        }
        if (filter != null) {
            ArrayList filtermors = this.filterMOR(refs, filter);
            return filtermors;
        }
        return refs;
    }

    private ArrayList filterMOR(ArrayList mors, String[][] filter) throws Exception {
        ArrayList filteredmors = new ArrayList();
        int i = 0;
        while (i < mors.size()) {
            boolean flag = true;
            Object guest = null;
            int k = 0;
            while (k < filter.length) {
                String prop = filter[k][0];
                String reqVal = filter[k][1];
                String value = this.getProp((ManagedObjectReference)mors.get(i), prop);
                if (reqVal != null) {
                    if (value != null || reqVal == null) {
                        // empty if block
                    }
                    if (value == null && reqVal != null) {
                        flag = false;
                        k = filter.length + 1;
                    } else if (!value.equalsIgnoreCase(reqVal)) {
                        flag = false;
                        k = filter.length + 1;
                    }
                }
                ++k;
            }
            if (flag) {
                filteredmors.add(mors.get(i));
            }
            ++i;
        }
        return filteredmors;
    }

    private String getProp(ManagedObjectReference obj, String prop) {
        String propVal = null;
        try {
            propVal = (String)this.getDynamicProperty(obj, prop);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return propVal;
    }

    public ObjectContent[] getAllContainerContents() throws Exception {
        ObjectContent[] ocary = this.getContentsRecursively(null, true);
        return ocary;
    }

    public ObjectContent[] getContentsRecursively(ManagedObjectReference root, boolean recurse) throws Exception {
        String[][] typeinfo = new String[][]{{"ManagedEntity"}};
        ObjectContent[] ocary = this.getContentsRecursively(null, root, typeinfo, recurse);
        return ocary;
    }

    public ObjectContent[] getContentsRecursively(ManagedObjectReference collector, ManagedObjectReference root, String[][] typeinfo, boolean recurse) throws Exception {
        ManagedObjectReference useroot;
        if (typeinfo == null || typeinfo.length == 0) {
            return null;
        }
        ManagedObjectReference usecoll = collector;
        if (usecoll == null) {
            usecoll = this._connection.getPropCol();
        }
        if ((useroot = root) == null) {
            useroot = this._connection.getRootFolder();
        }
        SelectionSpec[] selectionSpecs = null;
        if (recurse) {
            selectionSpecs = this.buildFullTraversal();
        }
        PropertySpec[] propspecary = this.buildPropertySpecArray(typeinfo);
        PropertyFilterSpec spec = new PropertyFilterSpec(null, null, propspecary, new ObjectSpec[]{new ObjectSpec(null, null, useroot, Boolean.FALSE, selectionSpecs)}, null);
        ObjectContent[] retoc = this._connection.getService().retrieveProperties(usecoll, new PropertyFilterSpec[]{spec});
        return retoc;
    }

    public ManagedObjectReference getMoRefProp(ManagedObjectReference objMor, String propName) throws Exception {
        Object props = this.getDynamicProperty(objMor, propName);
        ManagedObjectReference propmor = null;
        if (!props.getClass().isArray()) {
            propmor = (ManagedObjectReference)props;
        }
        return propmor;
    }

    public ObjectContent[] getObjectProperties(ManagedObjectReference collector, ManagedObjectReference mobj, String[] properties) throws Exception {
        if (mobj == null) {
            return null;
        }
        ManagedObjectReference usecoll = collector;
        if (usecoll == null) {
            usecoll = this._connection.getPropCol();
        }
        PropertyFilterSpec spec = new PropertyFilterSpec();
        spec.setPropSet(new PropertySpec[]{new PropertySpec()});
        spec.getPropSet(0).setAll(new Boolean(properties == null || properties.length == 0));
        spec.getPropSet(0).setType(mobj.getType());
        spec.getPropSet(0).setPathSet(properties);
        spec.setObjectSet(new ObjectSpec[]{new ObjectSpec()});
        spec.getObjectSet(0).setObj(mobj);
        spec.getObjectSet(0).setSkip(Boolean.FALSE);
        return this._connection.getService().retrieveProperties(usecoll, new PropertyFilterSpec[]{spec});
    }

    public Object getDynamicProperty(ManagedObjectReference mor, String propertyName) throws Exception {
        DynamicProperty[] dynamicProperty;
        ObjectContent[] objContent = this.getObjectProperties(null, mor, new String[]{propertyName});
        Object propertyValue = null;
        if (objContent != null && (dynamicProperty = objContent[0].getPropSet()) != null) {
            Object dynamicPropertyVal = dynamicProperty[0].getVal();
            String dynamicPropertyName = dynamicPropertyVal.getClass().getName();
            if (dynamicPropertyName.indexOf("ArrayOf") != -1) {
                String methodName = dynamicPropertyName.substring(dynamicPropertyName.indexOf("ArrayOf") + "ArrayOf".length(), dynamicPropertyName.length());
                methodName = this.methodExists(dynamicPropertyVal, "get" + methodName, null) ? "get" + methodName : "get_" + methodName.toLowerCase();
                Method getMorMethod = dynamicPropertyVal.getClass().getDeclaredMethod(methodName, null);
                propertyValue = getMorMethod.invoke(dynamicPropertyVal, null);
            } else {
                propertyValue = dynamicPropertyVal.getClass().isArray() ? dynamicPropertyVal : dynamicPropertyVal;
            }
        }
        return propertyValue;
    }

    public String waitForTask(ManagedObjectReference taskmor) throws Exception {
        Object[] result = this.waitForValues(taskmor, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.success, TaskInfoState.error}});
        if (result[0].equals(TaskInfoState.success)) {
            return "sucess";
        }
        TaskInfo tinfo = (TaskInfo)this.getDynamicProperty(taskmor, "info");
        LocalizedMethodFault fault = tinfo.getError();
        String error = "Error Occured";
        if (fault != null) {
            error = fault.getFault().getFaultReason();
            System.out.println("Fault " + fault.getFault().getFaultCode());
            System.out.println("Message " + fault.getLocalizedMessage());
        }
        return error;
    }

    public Object[] waitForValues(ManagedObjectReference objmor, String[] filterProps, String[] endWaitProps, Object[][] expectedVals) throws Exception {
        String version = "";
        Object[] endVals = new Object[endWaitProps.length];
        Object[] filterVals = new Object[filterProps.length];
        PropertyFilterSpec spec = new PropertyFilterSpec();
        spec.setObjectSet(new ObjectSpec[]{new ObjectSpec()});
        spec.getObjectSet(0).setObj(objmor);
        spec.setPropSet(new PropertySpec[]{new PropertySpec()});
        spec.getPropSet(0).setPathSet(filterProps);
        spec.getPropSet(0).setType(objmor.getType());
        spec.getObjectSet(0).setSelectSet(null);
        spec.getObjectSet(0).setSkip(Boolean.FALSE);
        ManagedObjectReference filterSpecRef = this._connection.getService().createFilter(this._connection.getPropCol(), spec, true);
        boolean reached = false;
        UpdateSet updateset = null;
        PropertyFilterUpdate[] filtupary = null;
        PropertyFilterUpdate filtup = null;
        ObjectUpdate[] objupary = null;
        ObjectUpdate objup = null;
        PropertyChange[] propchgary = null;
        PropertyChange propchg = null;
        while (!reached) {
            boolean retry = true;
            while (retry) {
                try {
                    updateset = this._connection.getService().waitForUpdates(this._connection.getPropCol(), version);
                    retry = false;
                }
                catch (Exception e) {
                    if (!(e instanceof AxisFault)) continue;
                    AxisFault fault = (AxisFault)e;
                    Element[] errors = fault.getFaultDetails();
                    String faultString = fault.getFaultString();
                    if (faultString.indexOf("java.net.SocketTimeoutException") != -1) {
                        System.out.println("Retrying2........");
                        retry = true;
                        continue;
                    }
                    throw e;
                }
            }
            version = updateset.getVersion();
            if (updateset == null || updateset.getFilterSet() == null) continue;
            filtupary = updateset.getFilterSet();
            filtup = null;
            int fi = 0;
            while (fi < filtupary.length) {
                filtup = filtupary[fi];
                objupary = filtup.getObjectSet();
                objup = null;
                propchgary = null;
                int oi = 0;
                while (oi < objupary.length) {
                    objup = objupary[oi];
                    if (objup.getKind() == ObjectUpdateKind.modify || objup.getKind() == ObjectUpdateKind.enter || objup.getKind() == ObjectUpdateKind.leave) {
                        propchgary = objup.getChangeSet();
                        int ci = 0;
                        while (ci < propchgary.length) {
                            propchg = propchgary[ci];
                            this.updateValues(endWaitProps, endVals, propchg);
                            this.updateValues(filterProps, filterVals, propchg);
                            ++ci;
                        }
                    }
                    ++oi;
                }
                ++fi;
            }
            Object expctdval = null;
            int chgi = 0;
            while (chgi < endVals.length && !reached) {
                int vali = 0;
                while (vali < expectedVals[chgi].length && !reached) {
                    expctdval = expectedVals[chgi][vali];
                    reached = expctdval.equals(endVals[chgi]) || reached;
                    ++vali;
                }
                ++chgi;
            }
        }
        this._connection.getService().destroyPropertyFilter(filterSpecRef);
        return filterVals;
    }

    protected void updateValues(String[] props, Object[] vals, PropertyChange propchg) {
        int findi = 0;
        while (findi < props.length) {
            if (propchg.getName().lastIndexOf(props[findi]) >= 0) {
                vals[findi] = propchg.getOp() == PropertyChangeOp.remove ? "" : propchg.getVal();
            }
            ++findi;
        }
    }

    public SelectionSpec[] buildFullTraversal() {
        TraversalSpec rpToRp = new TraversalSpec(null, null, null, "ResourcePool", "resourcePool", Boolean.FALSE, new SelectionSpec[]{new SelectionSpec(null, null, "rpToRp"), new SelectionSpec(null, null, "rpToVm")});
        rpToRp.setName("rpToRp");
        TraversalSpec rpToVm = new TraversalSpec(null, null, null, "ResourcePool", "vm", Boolean.FALSE, new SelectionSpec[0]);
        rpToVm.setName("rpToVm");
        TraversalSpec crToRp = new TraversalSpec(null, null, null, "ComputeResource", "resourcePool", Boolean.FALSE, new SelectionSpec[]{new SelectionSpec(null, null, "rpToRp"), new SelectionSpec(null, null, "rpToVm")});
        crToRp.setName("crToRp");
        TraversalSpec crToH = new TraversalSpec(null, null, null, "ComputeResource", "host", Boolean.FALSE, new SelectionSpec[0]);
        crToH.setName("crToH");
        TraversalSpec dcToHf = new TraversalSpec(null, null, null, "Datacenter", "hostFolder", Boolean.FALSE, new SelectionSpec[]{new SelectionSpec(null, null, "visitFolders")});
        dcToHf.setName("dcToHf");
        TraversalSpec dcToVmf = new TraversalSpec(null, null, null, "Datacenter", "vmFolder", Boolean.FALSE, new SelectionSpec[]{new SelectionSpec(null, null, "visitFolders")});
        dcToVmf.setName("dcToVmf");
        TraversalSpec HToVm = new TraversalSpec(null, null, null, "HostSystem", "vm", Boolean.FALSE, new SelectionSpec[]{new SelectionSpec(null, null, "visitFolders")});
        HToVm.setName("HToVm");
        TraversalSpec visitFolders = new TraversalSpec(null, null, null, "Folder", "childEntity", Boolean.FALSE, new SelectionSpec[]{new SelectionSpec(null, null, "visitFolders"), new SelectionSpec(null, null, "dcToHf"), new SelectionSpec(null, null, "dcToVmf"), new SelectionSpec(null, null, "crToH"), new SelectionSpec(null, null, "crToRp"), new SelectionSpec(null, null, "HToVm"), new SelectionSpec(null, null, "rpToVm")});
        visitFolders.setName("visitFolders");
        return new SelectionSpec[]{visitFolders, dcToVmf, dcToHf, crToH, crToRp, rpToRp, HToVm, rpToVm};
    }

    public PropertySpec[] buildPropertySpecArray(String[][] typeinfo) {
        HashMap tInfo = new HashMap();
        int ti = 0;
        while (ti < typeinfo.length) {
            HashSet<String> props = (HashSet<String>)tInfo.get(typeinfo[ti][0]);
            if (props == null) {
                props = new HashSet<String>();
                tInfo.put(typeinfo[ti][0], props);
            }
            boolean typeSkipped = false;
            int pi = 0;
            while (pi < typeinfo[ti].length) {
                String prop = typeinfo[ti][pi];
                if (typeSkipped) {
                    props.add(prop);
                } else {
                    typeSkipped = true;
                }
                ++pi;
            }
            ++ti;
        }
        ArrayList<PropertySpec> pSpecs = new ArrayList<PropertySpec>();
        for (String type : tInfo.keySet()) {
            PropertySpec pSpec = new PropertySpec();
            Set props = (Set)tInfo.get(type);
            pSpec.setType(type);
            pSpec.setAll(props.isEmpty() ? Boolean.TRUE : Boolean.FALSE);
            pSpec.setPathSet(new String[props.size()]);
            int index = 0;
            for (String prop : props) {
                pSpec.setPathSet(index++, prop);
            }
            pSpecs.add(pSpec);
        }
        return pSpecs.toArray(new PropertySpec[0]);
    }

    boolean methodExists(Object obj, String methodName, Class[] parameterTypes) {
        boolean exists = false;
        try {
            Method method = obj.getClass().getMethod(methodName, parameterTypes);
            if (method != null) {
                exists = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return exists;
    }
}

