/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.apputils.vim25;

import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.VimPortType;
import com.vmware.vim25.VimServiceLocator;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import org.apache.axis.MessageContext;
import org.apache.axis.client.Call;
import org.apache.axis.client.Stub;

public class ServiceConnection {
    public static int ConnectionState_Connected = 0;
    public static int ConnectionState_Disconnected = 1;
    protected VimServiceLocator _locator;
    protected VimPortType _service;
    protected int _svcState = ConnectionState_Disconnected;
    protected ServiceContent _sic;
    protected ManagedObjectReference _svcRef = new ManagedObjectReference();

    public ServiceConnection(String svcRefVal) {
        this._svcRef.setType("ServiceInstance");
        this._svcRef.set_value(svcRefVal);
    }

    public static ServiceConnection CreateServiceConnection(String inst) {
        return new ServiceConnection(inst);
    }

    public void connect(String urlStr, String username, String password, boolean ignoreCerts) throws Exception {
        if (this._service != null) {
            this.disconnect();
        }
        if (ignoreCerts) {
            this.ignoreCert();
        }
        this._locator = new VimServiceLocator();
        this._locator.setMaintainSession(true);
        this._service = this._locator.getVimPort(new URL(urlStr));
        this._sic = this._service.retrieveServiceContent(this._svcRef);
        if (this._sic.getSessionManager() != null) {
            this._service.login(this._sic.getSessionManager(), username, password, null);
        }
        this._svcState = ConnectionState_Connected;
    }

    public void ignoreCert() {
        System.setProperty("org.apache.axis.components.net.SecureSocketFactory", "org.apache.axis.components.net.SunFakeTrustSocketFactory");
    }

    public void init(String urlStr, String cookieString) throws Exception {
        if (this._service != null) {
            this.disconnect();
        }
        this._locator = new VimServiceLocator();
        this._locator.setMaintainSession(true);
        this._service = this._locator.getVimPort(new URL(urlStr));
        this._sic = this._service.retrieveServiceContent(this._svcRef);
        Stub st = (Stub)this._service;
        Call callObj = st._getCall();
        MessageContext msgContext = callObj.getMessageContext();
        msgContext.setProperty("Cookie", (Object)cookieString);
        this._svcState = ConnectionState_Connected;
    }

    public void saveSession(String fileName) throws Exception {
        this.writeData(this._sic.getSessionManager(), fileName);
    }

    private void writeData(ManagedObjectReference moref, String fileName) throws Exception {
        FileOutputStream fos = new FileOutputStream(fileName);
        ObjectOutputStream s = new ObjectOutputStream(fos);
        s.writeObject(moref);
        s.flush();
    }

    public void loadSession(String url, String cookieString) throws Exception {
        if (this._service != null) {
            this.disconnect();
        }
        this._locator = new VimServiceLocator();
        this._locator.setMaintainSession(true);
        this._service = this._locator.getVimPort(new URL(url));
        Stub st = (Stub)this._service;
        st._setProperty("Cookie", (Object)cookieString);
        this._locator.setMaintainSession(true);
        this._sic = this._service.retrieveServiceContent(this._svcRef);
    }

    private ManagedObjectReference readData(String fileName) throws IOException, ClassNotFoundException {
        FileInputStream in = new FileInputStream(fileName);
        ObjectInputStream s = new ObjectInputStream(in);
        ManagedObjectReference U2 = (ManagedObjectReference)s.readObject();
        return U2;
    }

    public boolean isConnected() {
        return this._svcState == ConnectionState_Connected;
    }

    public VimPortType getService() {
        return this._service;
    }

    public ManagedObjectReference getServiceInstanceRef() {
        return this._svcRef;
    }

    public ServiceContent getServiceContent() {
        return this._sic;
    }

    public ManagedObjectReference getPropCol() {
        return this._sic.getPropertyCollector();
    }

    public ManagedObjectReference getRootFolder() {
        return this._sic.getRootFolder();
    }

    public int ServiceState() {
        return this._svcState;
    }

    public void disconnect() throws Exception {
        if (this._service != null) {
            this._service.logout(this._sic.getSessionManager());
            this._service = null;
            this._sic = null;
            this._svcState = ConnectionState_Disconnected;
        }
    }
}

