/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.apputils.version;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VersionUtil {
    public static ArrayList getSupportedVersions(String urlString) {
        String targetNameSpace = "";
        ArrayList apiVersions = new ArrayList();
        try {
            String line;
            String data;
            BufferedReader in;
            HttpURLConnection conn;
            URL url;
            String wsdlUrlString = "";
            String vimServiceXmlUrlString = "";
            if (urlString.indexOf("https://") != -1 || urlString.indexOf("http://") != -1) {
                wsdlUrlString = String.valueOf(urlString.substring(0, urlString.indexOf("/sdk") + 4)) + "/vimService?wsdl";
                vimServiceXmlUrlString = String.valueOf(urlString.substring(0, urlString.indexOf("/sdk") + 4)) + "/vimServiceVersions.xml";
            } else {
                wsdlUrlString = "https://" + urlString + "/sdk/vimService?wsdl";
                vimServiceXmlUrlString = "https://" + urlString + "/sdk/vimServiceVersions.xml";
            }
            VersionUtil.trustAllHttpsCertificates();
            HostnameVerifier hv = new HostnameVerifier(){

                @Override
                public boolean verify(String urlHostName, SSLSession session) {
                    return true;
                }
            };
            boolean isServiceXmlExists = true;
            try {
                HttpsURLConnection.setDefaultHostnameVerifier(hv);
                url = new URL(vimServiceXmlUrlString);
                conn = (HttpURLConnection)url.openConnection();
                conn.connect();
                in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                data = "";
                line = "";
                while ((line = in.readLine()) != null) {
                    data = String.valueOf(data) + line;
                }
                targetNameSpace = "urn:vim25Service";
                apiVersions = VersionUtil.getAPIVersions(data);
            }
            catch (FileNotFoundException e) {
                isServiceXmlExists = false;
            }
            if (!isServiceXmlExists) {
                HttpsURLConnection.setDefaultHostnameVerifier(hv);
                url = new URL(wsdlUrlString);
                conn = (HttpURLConnection)url.openConnection();
                conn.connect();
                in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                data = "";
                line = "";
                while ((line = in.readLine()) != null) {
                    data = String.valueOf(data) + line;
                }
                targetNameSpace = VersionUtil.getTargetNamespace(data).trim();
                if (targetNameSpace.equalsIgnoreCase("urn:vim25Service")) {
                    apiVersions.add("2.5");
                } else {
                    apiVersions.add("2.0");
                }
            }
        }
        catch (MalformedURLException e) {
            System.out.println("Error in SSL Connetion");
        }
        catch (SSLException e) {
            System.out.println("SSL-error: unable to find valid certification path to requested target");
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found");
        }
        catch (Exception e) {
            System.out.println("error" + e);
            e.printStackTrace();
        }
        return apiVersions;
    }

    public static boolean isApiVersionSupported(ArrayList apiVersions, String version) {
        boolean flag = false;
        int i = 0;
        while (i < apiVersions.size()) {
            String ver = (String)apiVersions.get(i);
            if (ver.equalsIgnoreCase(version)) {
                flag = true;
                break;
            }
            ++i;
        }
        return flag;
    }

    private static ArrayList getAPIVersions(String data) {
        ArrayList<String> priorVersions = new ArrayList<String>();
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            byte[] xmlData = data.getBytes();
            ByteArrayInputStream byteArray = new ByteArrayInputStream(xmlData);
            Document doc = docBuilder.parse(byteArray);
            XPath xpath = XPathFactory.newInstance().newXPath();
            String expression = "/namespaces/namespace";
            NodeList nsNodes = (NodeList)xpath.evaluate(expression, doc, XPathConstants.NODESET);
            int i = 0;
            while (i < nsNodes.getLength()) {
                Node nsNode = nsNodes.item(i);
                xpath = XPathFactory.newInstance().newXPath();
                Node nameNode = (Node)xpath.evaluate(expression = "name", nsNode, XPathConstants.NODE);
                if (nameNode.getTextContent().equalsIgnoreCase("urn:vim25")) {
                    expression = "priorVersions";
                    Node priorVersionsNode = (Node)xpath.evaluate(expression, nsNode, XPathConstants.NODE);
                    expression = "version";
                    NodeList priorVersionsNodeList = (NodeList)xpath.evaluate(expression, priorVersionsNode, XPathConstants.NODESET);
                    int j = 0;
                    while (j < priorVersionsNodeList.getLength()) {
                        Node versionNode = priorVersionsNodeList.item(j);
                        priorVersions.add(versionNode.getTextContent());
                        ++j;
                    }
                    expression = "version";
                    Node versionNode = (Node)xpath.evaluate(expression, nsNode, XPathConstants.NODE);
                    priorVersions.add(versionNode.getTextContent());
                }
                ++i;
            }
            return priorVersions;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getTargetNamespace(String data) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            byte[] xmlData = data.getBytes();
            ByteArrayInputStream byteArray = new ByteArrayInputStream(xmlData);
            Document doc = docBuilder.parse(byteArray);
            Element test = doc.getDocumentElement();
            String version = test.getAttribute("targetNamespace");
            return version;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void trustAllHttpsCertificates() throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[1];
        miTM tm = new miTM();
        trustAllCerts[0] = tm;
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, null);
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }

    private static class miTM
    implements TrustManager,
    X509TrustManager {
        private miTM() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public boolean isServerTrusted(X509Certificate[] certs) {
            return true;
        }

        public boolean isClientTrusted(X509Certificate[] certs) {
            return true;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }
}

