/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.apputils.version;

import com.vmware.apputils.AppUtil;
import com.vmware.apputils.ArgumentHandlingException;
import com.vmware.apputils.OptionSpec;
import com.vmware.apputils.vim25.ServiceConnection;
import com.vmware.apputils.vim25.ServiceUtil;

public class ExtendedAppUtil
extends AppUtil {
    private ServiceConnection _connection;
    private ServiceUtil _svcUtil;

    public static ExtendedAppUtil initialize(String name, OptionSpec[] userOptions, String[] args) throws Exception {
        ExtendedAppUtil cb = new ExtendedAppUtil(name);
        if (userOptions != null) {
            cb.addOptions(userOptions);
            cb.parseInput(args);
            cb.validate();
        } else {
            cb.parseInput(args);
            cb.validate();
        }
        return cb;
    }

    public static ExtendedAppUtil initialize(String name, String[] args) throws Exception {
        ExtendedAppUtil cb = ExtendedAppUtil.initialize(name, null, args);
        return cb;
    }

    public ExtendedAppUtil(String name) {
        super(name);
        this.setup(name);
    }

    public void setup(String name) {
        this._svcUtil = ServiceUtil.CreateServiceUtil();
        this._connection = ServiceConnection.CreateServiceConnection("ServiceInstance");
    }

    public void connect() throws Exception {
        try {
            this.initConnection();
            this.getServiceUtil3().clientConnect();
        }
        catch (Exception e) {
            this.log.logLine("Exception running : " + this.getAppName());
            this.getUtil().logException(e);
            this.log.close();
            throw e;
        }
    }

    public void connect(String cookieString) throws Exception {
        try {
            this.initConnection();
            this.getServiceUtil3().clientLoadSession(cookieString);
        }
        catch (Exception e) {
            this.log.logLine("Exception running : " + this.getAppName());
            this.getUtil().logException(e);
            this.log.close();
            throw new ArgumentHandlingException("Exception running : " + this.getAppName());
        }
    }

    public void initConnection() throws Exception {
        this.getServiceUtil3().init(this, this._connection);
    }

    public ServiceUtil getServiceUtil3() {
        return this._svcUtil;
    }

    public ServiceConnection getServiceConnection3() {
        return this._connection;
    }

    public void disConnect() throws Exception {
        try {
            this.getServiceUtil3().clientDisconnect();
        }
        catch (Exception e) {
            this.log.logLine("Exception running : " + this.getAppName());
            this.getUtil().logException(e);
            this.log.close();
            throw new ArgumentHandlingException("Exception running : " + this.getAppName());
        }
    }

    public static /* bridge */ /* synthetic */ AppUtil initialize(String string, String[] stringArray) throws Exception {
        return ExtendedAppUtil.initialize(string, stringArray);
    }

    public static /* bridge */ /* synthetic */ AppUtil initialize(String string, OptionSpec[] optionSpecArray, String[] stringArray) throws Exception {
        return ExtendedAppUtil.initialize(string, optionSpecArray, stringArray);
    }
}

