/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.apputils;

import java.util.Date;
import java.util.logging.Logger;

public class Log {
    private Logger _logger;
    private boolean _toConsole;
    private String _lineSep;

    public void init(String logfilepath, boolean appendlog, boolean toConsole) {
        String finlog = logfilepath;
        if (logfilepath.lastIndexOf(".") < 0) {
            finlog = String.valueOf(logfilepath) + ".txt";
        }
        this._lineSep = System.getProperty("line.separator");
        this._logger = Logger.getLogger("com.hitachi.hfc.vmutil");
        if (this._lineSep == null || this._lineSep.length() == 0) {
            this._lineSep = "\n";
        }
        this._toConsole = toConsole;
    }

    public synchronized void close() {
        Date dt = new Date();
        this.internalLogLine(dt, "End Log.");
        this.internalLogLine(null, "");
    }

    public synchronized void logLine(String strmsg) {
        this._logger.severe(String.valueOf(strmsg) + this._lineSep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalLogLine(Date dt, String msg) {
        Log log = this;
        synchronized (log) {
            String strmsg = msg;
            if (dt != null) {
                strmsg = "[ " + dt.toString() + " ] " + msg;
            }
            this._logger.severe(String.valueOf(strmsg) + this._lineSep);
        }
    }
}

