/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.apputils;

import com.vmware.apputils.AppUtil;
import com.vmware.vim25.MethodFault;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class ClientUtil {
    private AppUtil _cb;

    public ClientUtil(AppUtil c) {
        this._cb = c;
    }

    public void printUsage() {
        this._cb.displayUsage();
    }

    public int getIntInput(String prompt, int defaultVal) throws Exception {
        String input = this.getStrInput(prompt);
        if (input == null || input.length() == 0) {
            return defaultVal;
        }
        return Integer.parseInt(input);
    }

    public long getLongInput(String prompt, long defaultVal) throws Exception {
        String input = this.getStrInput(prompt);
        if (input == null || input.length() == 0) {
            return defaultVal;
        }
        return Long.parseLong(input);
    }

    public String getStrInput(String prompt) throws Exception {
        System.out.print(prompt);
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        return reader.readLine();
    }

    public void logException(Exception e) {
        if (e instanceof MethodFault) {
            MethodFault mf = (MethodFault)e;
            this.logFault(mf);
        } else {
            this._cb.getLog().logLine("Caught Exception :  Exception : " + e.getClass().getName() + " Message : " + e.getMessage() + " StackTrace : ");
            e.printStackTrace();
        }
    }

    public void logFault(MethodFault mf) {
        this._cb.getLog().logLine("Caught Fault - \n Type : " + mf.getClass().getName() + "\n Actor : " + mf.getFaultActor() + "\n Code : " + mf.getFaultNode() + "\n Reason : " + mf.getFaultReason() + "\n Fault String : " + mf.getFaultString());
    }
}

