/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.hfc.vmutil;

import com.hitachi.hfc.CimWrapper.HFCCimClientException;
import com.hitachi.hfc.CimWrapper.HFCCimClientWrapper;
import com.hitachi.hfc.WSWrapper.HFCWSAPIException;
import com.hitachi.hfc.WSWrapper.HFCWSAPIWrapper;
import com.hitachi.hfc.vmutil.HFCVMUtilCom;
import com.hitachi.hfc.vmutil.HFCVMUtilException;
import com.hitachi.hfc.vmutil.HFCVMUtilFunc;
import com.hitachi.hfc.vmutil.HFCVMUtilInvalidArgException;
import com.hitachi.hfc.vmutil.HFCVMUtilInvalidArgExceptionType;
import com.hitachi.hfc.vmutil.HFCVMUtilOperationException;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.UnsignedInteger8;

class HFCVMUtilUpdateFunc
implements HFCVMUtilFunc {
    private HFCWSAPIWrapper wsApi;
    private HFCCimClientWrapper cimClient;
    private HFCVMUtilCom vmutilCom;
    private SubCommand subCmd = SubCommand.CHECKUPDATE;
    private boolean executeForce = false;
    private String targetVmhbaNo;
    private int vmhbaNoInt;
    private CIMObjectPath installServ;
    private CIMArgument<?>[] checkUpdateOutputArg;
    private Logger logger = HFCVMUtilCom.getLogger();

    public HFCVMUtilUpdateFunc() {
        this.logger.finest("called");
        this.vmutilCom = HFCVMUtilCom.getInstance();
    }

    @Override
    public void checkParam(String[] args, int paramIndex) throws HFCVMUtilInvalidArgException {
        this.logger.finest("start");
        if (args.length == paramIndex) {
            this.subCmd = SubCommand.CHECKUPDATE;
            return;
        }
        if (args.length != paramIndex + 1 && args.length != paramIndex + 2) {
            this.logger.severe("param num err:" + args.length);
            throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
        }
        this.vmhbaNoInt = this.vmutilCom.getVmhbaNo(args[paramIndex]);
        this.targetVmhbaNo = args[paramIndex];
        this.subCmd = SubCommand.ONLINEUPDATE;
        if (args.length == ++paramIndex + 1) {
            if (args[paramIndex].equals("force")) {
                this.executeForce = true;
            } else {
                this.logger.severe("unknown parameter:" + args[paramIndex]);
                throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
            }
        }
        this.logger.finest("end");
    }

    @Override
    public void execCommand(URL pWbemUrl, String pUser, String pPassword, boolean ignorecert) throws HFCVMUtilException, HFCCimClientException, HFCWSAPIException {
        this.logger.finest("start");
        this.wsApi = new HFCWSAPIWrapper();
        this.wsApi.Connect(pWbemUrl, pUser, pPassword, ignorecert);
        this.cimClient = new HFCCimClientWrapper(pWbemUrl, pUser, pPassword);
        try {
            this.execUpdateCommand();
        }
        catch (HFCVMUtilException e) {
            this.vmutilCom.doErrEndProc(this.wsApi, this.cimClient, e);
        }
        catch (HFCCimClientException e) {
            this.vmutilCom.doErrEndProc(this.wsApi, this.cimClient, e);
        }
        this.cimClient.close();
        this.wsApi.DisConnect();
        this.logger.finest("end");
    }

    private void execUpdateCommand() throws HFCVMUtilException, HFCCimClientException {
        this.logger.finest("start");
        switch (this.subCmd) {
            case CHECKUPDATE: {
                this.checkUpdate();
                break;
            }
            case ONLINEUPDATE: {
                this.onlineUpdate();
            }
        }
        this.logger.finest("end");
    }

    private void checkUpdate() throws HFCVMUtilOperationException, HFCCimClientException {
        this.logger.finest("start");
        HFCVMUtilCom.printTime();
        List<CIMInstance> fcPortList = this.cimClient.enumerateInstances(HFCCimClientWrapper.getHfcnamespace(), "HFC_FCPort");
        if (fcPortList.isEmpty()) {
            return;
        }
        Object retval = this.invokeChechkUpdateMethod();
        if (retval.toString().equals("0")) {
            CIMArgument<?>[] cIMArgumentArray = this.checkUpdateOutputArg;
            int n = this.checkUpdateOutputArg.length;
            int n2 = 0;
            while (n2 < n) {
                CIMArgument<?> outArg = cIMArgumentArray[n2];
                if (outArg != null && outArg.getName().equals("CheckResult")) {
                    String[] checkResultOut = (String[])outArg.getValue();
                    System.out.println("vmhba   hfcldd    BUS/DEV/FUNC Flash    Current  Update-Status(Flash -> Current)");
                    String[] stringArray = checkResultOut;
                    int n3 = checkResultOut.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String checkResult = stringArray[n4];
                        String[] resultInfo = checkResult.split(":");
                        if (resultInfo.length != 7) {
                            this.logger.severe("check result format error:" + checkResult);
                            throw new HFCVMUtilOperationException();
                        }
                        String vmhbaNo = this.getVmhbaNo(resultInfo[0], fcPortList);
                        if (vmhbaNo == null) {
                            this.logger.severe("there is no vmhbaNo correspont with " + resultInfo[0]);
                            throw new HFCVMUtilOperationException();
                        }
                        System.out.printf("%-7s %-9s %-3s %-3s %-3s  %-8s %-8s %s", vmhbaNo, resultInfo[0], resultInfo[1], resultInfo[2], resultInfo[3], resultInfo[4], resultInfo[5], resultInfo[6]);
                        ++n4;
                    }
                }
                ++n2;
            }
        } else {
            CIMArgument<?>[] cIMArgumentArray = this.checkUpdateOutputArg;
            int n = this.checkUpdateOutputArg.length;
            int n5 = 0;
            while (n5 < n) {
                CIMArgument<?> outArg = cIMArgumentArray[n5];
                if (outArg != null && outArg.getName().equals("ErrorMessage")) {
                    this.logger.severe(outArg.getValue().toString());
                    throw new HFCVMUtilOperationException("Failed.(" + outArg.getValue().toString().replaceAll("\n", "") + ")");
                }
                ++n5;
            }
            this.logger.severe("check result error:" + retval.toString());
            throw new HFCVMUtilOperationException("Failed.(Operation Failed)");
        }
        this.logger.finest("end");
    }

    private void onlineUpdate() throws HFCVMUtilException, HFCCimClientException {
        this.logger.finest("start");
        HFCVMUtilCom.printTime();
        System.out.println("PORT NO : " + this.targetVmhbaNo);
        CIMInstance fcPort = this.vmutilCom.getFCPortInstance(this.cimClient, this.vmhbaNoInt);
        if (fcPort == null) {
            this.logger.severe(String.valueOf(this.targetVmhbaNo) + " is not exist");
            throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_NO_VMHBA);
        }
        String minorNo = fcPort.getProperty("Minor").getValue().toString();
        Object retval = this.invokeChechkUpdateMethod();
        int i = 0;
        String[] checkResultOut = null;
        if (retval.toString().equals("0")) {
            CIMArgument<?>[] cIMArgumentArray = this.checkUpdateOutputArg;
            int n = this.checkUpdateOutputArg.length;
            int n2 = 0;
            while (n2 < n) {
                CIMArgument<?> outArg = cIMArgumentArray[n2];
                if (outArg != null && outArg.getName().equals("CheckResult")) {
                    checkResultOut = (String[])outArg.getValue();
                    while (i < checkResultOut.length) {
                        String[] resultInfo = checkResultOut[i].split(":");
                        if (resultInfo.length != 7) {
                            this.logger.severe("check result format error:" + checkResultOut[i]);
                            throw new HFCVMUtilOperationException();
                        }
                        if (resultInfo[0].equals("hfcldd" + minorNo)) {
                            System.out.println("FLASH   SYSREV:" + resultInfo[4]);
                            System.out.println("CURRENT SYSREV:" + resultInfo[5]);
                            break;
                        }
                        ++i;
                    }
                }
                ++n2;
            }
        } else {
            CIMArgument<?>[] cIMArgumentArray = this.checkUpdateOutputArg;
            int n = this.checkUpdateOutputArg.length;
            int n3 = 0;
            while (n3 < n) {
                CIMArgument<?> outArg = cIMArgumentArray[n3];
                if (outArg != null && outArg.getName().equals("ErrorMessage")) {
                    this.logger.severe(outArg.getValue().toString());
                    throw new HFCVMUtilOperationException("Failed.(" + outArg.getValue().toString().replaceAll("\n", "") + ")");
                }
                ++n3;
            }
            this.logger.severe("check result error:" + retval.toString());
            throw new HFCVMUtilOperationException("Failed.(Operation Failed)");
        }
        if (checkResultOut == null || i == checkResultOut.length) {
            this.logger.severe("there is no " + this.targetVmhbaNo);
            throw new HFCVMUtilOperationException();
        }
        if (!this.executeForce && !this.vmutilCom.confirmExecute("FLASH-> CURRENT Update is OK?")) {
            return;
        }
        CIMArgument[] pInputArg = new CIMArgument[1];
        CIMArgument[] pOutputArg = new CIMArgument[1];
        pInputArg[0] = new CIMArgument("DeviceName", CIMDataType.STRING_T, (Object)minorNo);
        retval = this.cimClient.invokeMethod(this.installServ, "InitiateOnlineUpdate", pInputArg, pOutputArg);
        if (!retval.toString().equals("0")) {
            if (pOutputArg[0] != null) {
                this.logger.severe(pOutputArg[0].getValue().toString());
                throw new HFCVMUtilOperationException("Failed.(" + pOutputArg[0].getValue().toString().replaceAll("\n", "") + ")");
            }
            this.logger.severe("InitiateOnlineUpdate error:" + retval.toString());
            throw new HFCVMUtilOperationException("Failed.(Operation Failed)");
        }
        System.out.printf("Update command finished (Port %s). please check the F/W update status.\n", this.targetVmhbaNo);
        this.logger.finest("end");
    }

    private Object invokeChechkUpdateMethod() throws HFCVMUtilOperationException, HFCCimClientException {
        this.logger.finest("start");
        List<CIMObjectPath> installServList = this.cimClient.enumerateInstanceNames(HFCCimClientWrapper.getHfcnamespace(), "HFC_SoftwareInstallationService");
        if (installServList.isEmpty()) {
            this.logger.severe("there is no HFC_SoftwareInstallationService instance");
            throw new HFCVMUtilOperationException();
        }
        this.installServ = installServList.get(0);
        this.checkUpdateOutputArg = new CIMArgument[2];
        Object retval = this.cimClient.invokeMethod(this.installServ, "CheckUpdateAvailability", null, this.checkUpdateOutputArg);
        this.logger.finest("end");
        return retval;
    }

    private String getVmhbaNo(String pMinorNo, List<CIMInstance> pFcPortList) throws HFCVMUtilOperationException {
        this.logger.finest("start");
        int pMinorNoInt = this.vmutilCom.getMinorNo(pMinorNo);
        for (CIMInstance fcPort : pFcPortList) {
            UnsignedInteger8 minorNoInt = (UnsignedInteger8)fcPort.getProperty("Minor").getValue();
            int minorNo = minorNoInt.intValue();
            if (minorNo != pMinorNoInt) continue;
            String vmhbaNum = fcPort.getProperty("VmhbaNo").getValue().toString();
            this.logger.finest("end");
            return String.valueOf(HFCVMUtilCom.getHfcVmhbaNoPrefix()) + vmhbaNum;
        }
        return null;
    }

    private static enum SubCommand {
        CHECKUPDATE,
        ONLINEUPDATE;

    }
}

