/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.hfc.vmutil;

import com.hitachi.hfc.CimWrapper.HFCCimClientException;
import com.hitachi.hfc.CimWrapper.HFCCimClientWrapper;
import com.hitachi.hfc.WSWrapper.HFCWSAPIException;
import com.hitachi.hfc.WSWrapper.HFCWSAPIWrapper;
import com.hitachi.hfc.vmutil.HFCVMUtilCom;
import com.hitachi.hfc.vmutil.HFCVMUtilException;
import com.hitachi.hfc.vmutil.HFCVMUtilFunc;
import com.hitachi.hfc.vmutil.HFCVMUtilInvalidArgException;
import com.hitachi.hfc.vmutil.HFCVMUtilInvalidArgExceptionType;
import com.hitachi.hfc.vmutil.HFCVMUtilOperationException;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.UnsignedInteger8;

class HFCVMUtilTargetScanFunc
implements HFCVMUtilFunc {
    private int targetVmhbaNo;
    private boolean scanAllPort = false;
    private CIMObjectPath installServ = null;
    private HFCWSAPIWrapper wsApi;
    private HFCCimClientWrapper cimClient;
    private HFCVMUtilCom vmutilCom;
    private Logger logger = HFCVMUtilCom.getLogger();

    public HFCVMUtilTargetScanFunc() {
        this.logger.finest("called");
        this.vmutilCom = HFCVMUtilCom.getInstance();
    }

    @Override
    public void checkParam(String[] args, int paramIndex) throws HFCVMUtilInvalidArgException {
        this.logger.finest("start");
        if (args.length != paramIndex + 1) {
            this.logger.severe("param num err:" + args.length);
            throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
        }
        if (args[paramIndex].equals("all")) {
            this.scanAllPort = true;
        } else if (args[paramIndex].matches(String.valueOf(HFCVMUtilCom.getHfcVmhbaNoPrefix()) + "\\d+")) {
            this.targetVmhbaNo = this.vmutilCom.getVmhbaNo(args[paramIndex]);
        } else {
            this.logger.severe("NONE device or all:" + args[paramIndex]);
            throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
        }
        this.logger.finest("end");
    }

    @Override
    public void execCommand(URL pWbemUrl, String pUser, String pPassword, boolean ignorecert) throws HFCVMUtilException, HFCCimClientException, HFCWSAPIException {
        this.logger.finest("start");
        HFCVMUtilCom.printTime();
        this.wsApi = new HFCWSAPIWrapper();
        this.wsApi.Connect(pWbemUrl, pUser, pPassword, ignorecert);
        this.cimClient = new HFCCimClientWrapper(pWbemUrl, pUser, pPassword);
        try {
            this.execTargetScanCommand();
        }
        catch (HFCVMUtilException e) {
            this.vmutilCom.doErrEndProc(this.wsApi, this.cimClient, e);
        }
        catch (HFCCimClientException e) {
            this.vmutilCom.doErrEndProc(this.wsApi, this.cimClient, e);
        }
        this.cimClient.close();
        this.wsApi.DisConnect();
        this.logger.finest("end");
    }

    private void execTargetScanCommand() throws HFCVMUtilException, HFCCimClientException {
        List<CIMObjectPath> portCtrlServList;
        this.logger.finest("start");
        this.logger.finest("argetVmhbaNo:" + this.targetVmhbaNo);
        CIMInstance fcPort = this.vmutilCom.getFCPortInstance(this.cimClient, this.targetVmhbaNo);
        UnsignedInteger8 minorNo = null;
        if (fcPort == null && !this.scanAllPort) {
            this.logger.severe(String.valueOf(this.targetVmhbaNo) + " is not exist");
            throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_NO_VMHBA);
        }
        HFCVMUtilCom.printTime();
        if (fcPort != null) {
            minorNo = (UnsignedInteger8)fcPort.getProperty("Minor").getValue();
        }
        if ((portCtrlServList = this.cimClient.enumerateInstanceNames(HFCCimClientWrapper.getHfcnamespace(), "HFC_PortControlService")).isEmpty()) {
            this.logger.severe("there is no HFC_PortControlService instance");
            throw new HFCVMUtilOperationException();
        }
        CIMObjectPath portCtrlServ = portCtrlServList.get(0);
        CIMArgument[] pInputArg = new CIMArgument[2];
        CIMArgument[] pOutputArg = new CIMArgument[2];
        if (this.scanAllPort) {
            short sDeviceNo = 0;
            short sAll = 1;
            pInputArg[0] = new CIMArgument("DeviceNo", CIMDataType.UINT8_T, (Object)new UnsignedInteger8(sDeviceNo));
            pInputArg[1] = new CIMArgument("All", CIMDataType.UINT8_T, (Object)new UnsignedInteger8(sAll));
        } else {
            short sAll = 0;
            pInputArg[0] = new CIMArgument("DeviceNo", CIMDataType.UINT8_T, (Object)minorNo);
            pInputArg[1] = new CIMArgument("All", CIMDataType.UINT8_T, (Object)new UnsignedInteger8(sAll));
        }
        Object retval = this.cimClient.invokeMethod(portCtrlServ, "TargetScan", pInputArg, pOutputArg);
        if (!retval.toString().equals("0")) {
            CIMArgument[] cIMArgumentArray = pOutputArg;
            int n = pOutputArg.length;
            int n2 = 0;
            while (n2 < n) {
                CIMArgument outArg = cIMArgumentArray[n2];
                if (outArg != null) {
                    if (outArg.getName().equals("ErrorMessage")) {
                        this.logger.severe(outArg.getValue().toString());
                        throw new HFCVMUtilOperationException("Failed.(" + outArg.getValue().toString().replaceAll("\n", "") + ")");
                    }
                    if (outArg.getName().equals("DetailedMessage")) {
                        String[] DetailedMessage;
                        String[] stringArray = DetailedMessage = (String[])outArg.getValue();
                        int n3 = DetailedMessage.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String errMsg = stringArray[n4];
                            System.out.println(errMsg);
                            this.logger.severe(errMsg);
                            ++n4;
                        }
                        System.out.println("");
                        throw new HFCVMUtilOperationException("Failed.");
                    }
                }
                ++n2;
            }
            this.logger.severe("Target Scan error:" + retval.toString());
            throw new HFCVMUtilOperationException("Failed.(Operation Failed)");
        }
        System.out.println("Succeeded.");
        this.logger.finest("end");
    }
}

