/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.hfc.vmutil;

import com.hitachi.hfc.CimWrapper.HFCCimClientException;
import com.hitachi.hfc.CimWrapper.HFCCimClientWrapper;
import com.hitachi.hfc.WSWrapper.HFCWSAPIException;
import com.hitachi.hfc.WSWrapper.HFCWSAPIWrapper;
import com.hitachi.hfc.vmutil.HFCVMUtilCom;
import com.hitachi.hfc.vmutil.HFCVMUtilException;
import com.hitachi.hfc.vmutil.HFCVMUtilFunc;
import com.hitachi.hfc.vmutil.HFCVMUtilInvalidArgException;
import com.hitachi.hfc.vmutil.HFCVMUtilInvalidArgExceptionType;
import com.hitachi.hfc.vmutil.HFCVMUtilOperationException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.cim.CIMInstance;
import javax.cim.UnsignedInteger64;

class HFCVMUtilTargetFunc
implements HFCVMUtilFunc {
    private static final int VendorIDStartIndex = 0;
    private static final int VendorIDEndIndex = 8;
    private static final int ProductIDStartIndex = 8;
    private static final int ProductIDEndIndex = 24;
    private HFCWSAPIWrapper wsApi;
    private HFCCimClientWrapper cimClient;
    private HFCVMUtilCom vmutilCom;
    private Logger logger = HFCVMUtilCom.getLogger();

    public HFCVMUtilTargetFunc() {
        this.logger.finest("called");
    }

    @Override
    public void checkParam(String[] args, int paramIndex) throws HFCVMUtilInvalidArgException {
        this.logger.finest("start");
        if (args.length != paramIndex) {
            this.logger.severe("param num err:" + args.length);
            throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
        }
        this.logger.finest("end");
    }

    @Override
    public void execCommand(URL pWbemUrl, String pUser, String pPassword, boolean ignorecert) throws HFCVMUtilException, HFCCimClientException, HFCWSAPIException {
        this.logger.finest("start");
        HFCVMUtilCom.printTime();
        this.wsApi = new HFCWSAPIWrapper();
        this.wsApi.Connect(pWbemUrl, pUser, pPassword, ignorecert);
        this.cimClient = new HFCCimClientWrapper(pWbemUrl, pUser, pPassword);
        this.vmutilCom = HFCVMUtilCom.getInstance();
        try {
            this.execDisplay();
        }
        catch (HFCVMUtilOperationException e) {
            this.vmutilCom.doErrEndProc(this.wsApi, this.cimClient, e);
        }
        catch (HFCCimClientException e) {
            this.vmutilCom.doErrEndProc(this.wsApi, this.cimClient, e);
        }
        this.cimClient.close();
        this.wsApi.DisConnect();
        this.logger.finest("end");
    }

    private void execDisplay() throws HFCVMUtilOperationException, HFCCimClientException {
        this.logger.finest("start");
        List<CIMInstance> fcPortList = this.cimClient.enumerateInstances(HFCCimClientWrapper.getHfcnamespace(), "HFC_FCPort");
        for (CIMInstance fcPort : fcPortList) {
            this.vmutilCom.displayInstanceInfo(fcPort);
            List<CIMInstance> scsiInitiatorList = this.cimClient.associators(fcPort.getObjectPath(), "HFC_DeviceSAPImplementation", "HFC_SCSIProtocolEndpoint");
            if (scsiInitiatorList.isEmpty()) {
                this.logger.severe("there is no HFC_SCSIProtocolEndpoint instance");
                throw new HFCVMUtilOperationException();
            }
            CIMInstance scsiInitiator = scsiInitiatorList.get(0);
            List<CIMInstance> storageVolList = this.cimClient.associators(scsiInitiator.getObjectPath(), "HFC_SCSIInitiatorTargetStorageVolumePath", "HFC_StorageVolume", "Initiator", "LogicalUnit");
            if (storageVolList.isEmpty()) {
                System.out.println("  No Target");
            }
            HashSet<String> targetWWNList = new HashSet<String>();
            for (CIMInstance storageVol : storageVolList) {
                String storageID = storageVol.getProperty("DeviceID").getValue().toString();
                String[] storageIDInfo = storageID.split("_");
                if (storageIDInfo.length != 4) {
                    this.logger.severe("HFC_StorageVolume DeviceID property format error:" + storageID);
                    throw new HFCVMUtilOperationException();
                }
                targetWWNList.add(storageIDInfo[1]);
            }
            Iterator it = targetWWNList.iterator();
            while (it.hasNext()) {
                int lunNum = 0;
                String targetWWN = (String)it.next();
                for (CIMInstance storageVol : storageVolList) {
                    int lunInt;
                    String storageID = storageVol.getProperty("DeviceID").getValue().toString();
                    String[] storageIDInfo = storageID.split("_");
                    if (storageIDInfo.length != 4 || storageIDInfo[3].length() < 4) {
                        this.logger.severe("HFC_StorageVolume DeviceID property format error:" + storageID);
                        throw new HFCVMUtilOperationException();
                    }
                    if (!targetWWN.equals(storageIDInfo[1])) continue;
                    String lun = storageIDInfo[3].substring(0, 4);
                    try {
                        lunInt = Integer.parseInt(lun, 16);
                    }
                    catch (NumberFormatException e) {
                        this.logger.severe(String.valueOf(lun) + " is not numeral");
                        throw new HFCVMUtilOperationException();
                    }
                    String[] otherID = (String[])storageVol.getProperty("OtherIdentifyingInfo").getValue();
                    if (otherID.length == 0) {
                        this.logger.severe("there is no HFC_StorageVolume OtherIdentifyingInfo property");
                        throw new HFCVMUtilOperationException();
                    }
                    int startIndex = 0;
                    int endIndex = otherID[0].length() < 8 ? otherID[0].length() : 8;
                    String vendorID = otherID[0].substring(startIndex, endIndex);
                    String productID = "";
                    if (otherID[0].length() > 8) {
                        endIndex = otherID[0].length() < 24 ? otherID[0].length() : 24;
                        startIndex = 8;
                        productID = otherID[0].substring(startIndex, endIndex);
                    }
                    UnsignedInteger64 numOfBlocks = (UnsignedInteger64)storageVol.getProperty("NumberOfBlocks").getValue();
                    UnsignedInteger64 blockSize = (UnsignedInteger64)storageVol.getProperty("BlockSize").getValue();
                    BigInteger numOfBlocksInt = numOfBlocks.bigIntegerValue();
                    BigInteger blockSizeInt = blockSize.bigIntegerValue();
                    BigDecimal numOfBlocksDec = new BigDecimal(numOfBlocksInt.multiply(blockSizeInt));
                    String lunMBSize = numOfBlocksDec.divide(new BigDecimal("1048576"), 0, RoundingMode.HALF_UP).toString();
                    if (lunNum == 0) {
                        System.out.println("TargetWWPN: " + storageIDInfo[1]);
                    }
                    ++lunNum;
                    System.out.printf("  LUN:%04d VENDOR:%s MODEL:%s SIZE:%sMB\n", lunInt, vendorID, productID, lunMBSize);
                }
            }
        }
        this.logger.finest("end");
    }
}

