/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.hfc.vmutil;

import com.hitachi.hfc.CimWrapper.HFCCimClientException;
import com.hitachi.hfc.CimWrapper.HFCCimClientWrapper;
import com.hitachi.hfc.WSWrapper.HFCWSAPIException;
import com.hitachi.hfc.WSWrapper.HFCWSAPIWrapper;
import com.hitachi.hfc.vmutil.HFCVMUtilCom;
import com.hitachi.hfc.vmutil.HFCVMUtilDriverParam;
import com.hitachi.hfc.vmutil.HFCVMUtilDriverParamType;
import com.hitachi.hfc.vmutil.HFCVMUtilException;
import com.hitachi.hfc.vmutil.HFCVMUtilFunc;
import com.hitachi.hfc.vmutil.HFCVMUtilInvalidArgException;
import com.hitachi.hfc.vmutil.HFCVMUtilInvalidArgExceptionType;
import com.hitachi.hfc.vmutil.HFCVMUtilOperationException;
import java.math.BigInteger;
import java.net.URL;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.cim.CIMInstance;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger64;
import javax.cim.UnsignedInteger8;

class HFCVMUtilPortFunc
implements HFCVMUtilFunc {
    private static final String ParamUnsetting = "-";
    private boolean deleteForce = false;
    private boolean debugDisp = false;
    private int targetVmhbaNo;
    private SubCommand subCmd = SubCommand.DISP;
    private Map<HFCVMUtilDriverParamType, String> SetOptionList;
    private Set<HFCVMUtilDriverParamType> DeleteOptionList;
    private HFCWSAPIWrapper wsApi;
    private HFCCimClientWrapper cimClient;
    private HFCVMUtilCom vmutilCom;
    private Logger logger = HFCVMUtilCom.getLogger();
    private boolean changeFilterTarget = false;
    private short filterTargetValue;
    private boolean changeLimitLog = false;
    private short limitLogValue;

    public HFCVMUtilPortFunc() {
        this.logger.finest("called");
        this.vmutilCom = HFCVMUtilCom.getInstance();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void checkParam(String[] args, int paramIndex) throws HFCVMUtilInvalidArgException {
        block48: {
            this.logger.finest("start");
            if (args.length == paramIndex) {
                this.logger.severe("param num err:" + args.length);
                throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
            }
            if (args[paramIndex].equals("all")) {
                this.subCmd = SubCommand.DISPALL;
                if (args.length != ++paramIndex) {
                    this.logger.severe("param num err:" + args.length);
                    throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
                }
            } else if (args[paramIndex].matches(String.valueOf(HFCVMUtilCom.getHfcVmhbaNoPrefix()) + "\\d+")) {
                this.subCmd = SubCommand.DISP;
                this.targetVmhbaNo = this.vmutilCom.getVmhbaNo(args[paramIndex]);
                if (args.length != ++paramIndex) {
                    if (args[paramIndex].equals("debug") && args.length == paramIndex + 1) {
                        this.debugDisp = true;
                    } else {
                        this.logger.severe("param debug format err");
                        throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
                    }
                }
            } else if (args[paramIndex].equals("delete")) {
                this.subCmd = SubCommand.DELETE;
                if (args.length == ++paramIndex) {
                    this.logger.severe("there is no delete parameter:" + args.length);
                    throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
                }
                this.DeleteOptionList = EnumSet.noneOf(HFCVMUtilDriverParamType.class);
            } else {
                this.subCmd = SubCommand.SET;
                this.SetOptionList = new EnumMap<HFCVMUtilDriverParamType, String>(HFCVMUtilDriverParamType.class);
            }
            if (this.subCmd != SubCommand.DELETE && this.subCmd != SubCommand.SET) break block48;
            while (paramIndex < args.length) {
                block47: {
                    block59: {
                        block58: {
                            block56: {
                                block57: {
                                    block55: {
                                        block54: {
                                            block53: {
                                                block52: {
                                                    block51: {
                                                        block50: {
                                                            block49: {
                                                                if (this.subCmd == SubCommand.SET && paramIndex + 1 == args.length) {
                                                                    this.logger.severe("there is no value:" + args.length);
                                                                    throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
                                                                }
                                                                if (!args[paramIndex].equals("mt")) break block49;
                                                                if (this.subCmd == SubCommand.DELETE) {
                                                                    this.DeleteOptionList.add(HFCVMUtilDriverParamType.MaxTrans);
                                                                    break block47;
                                                                } else {
                                                                    if (!(args[++paramIndex].equals("1") || args[paramIndex].equals("4") || args[paramIndex].equals("8") || args[paramIndex].equals("16") || args[paramIndex].equals("32"))) {
                                                                        this.logger.severe("mt value out of range:" + args[paramIndex]);
                                                                        throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
                                                                    }
                                                                    this.SetOptionList.put(HFCVMUtilDriverParamType.MaxTrans, args[paramIndex]);
                                                                }
                                                                break block47;
                                                            }
                                                            if (!args[paramIndex].equals("ld")) break block50;
                                                            if (this.subCmd == SubCommand.DELETE) {
                                                                this.DeleteOptionList.add(HFCVMUtilDriverParamType.LinkDown);
                                                                break block47;
                                                            } else {
                                                                this.vmutilCom.chkStrValRange(args[++paramIndex], 10, 0, 60);
                                                                this.SetOptionList.put(HFCVMUtilDriverParamType.LinkDown, args[paramIndex]);
                                                            }
                                                            break block47;
                                                        }
                                                        if (!args[paramIndex].equals("rd")) break block51;
                                                        if (this.subCmd == SubCommand.DELETE) {
                                                            this.DeleteOptionList.add(HFCVMUtilDriverParamType.ResetDelay);
                                                            break block47;
                                                        } else {
                                                            this.vmutilCom.chkStrValRange(args[++paramIndex], 10, 0, 60);
                                                            this.SetOptionList.put(HFCVMUtilDriverParamType.ResetDelay, args[paramIndex]);
                                                        }
                                                        break block47;
                                                    }
                                                    if (!args[paramIndex].equals("mc")) break block52;
                                                    if (this.subCmd == SubCommand.DELETE) {
                                                        this.DeleteOptionList.add(HFCVMUtilDriverParamType.MckRetry);
                                                        break block47;
                                                    } else {
                                                        this.vmutilCom.chkStrValRange(args[++paramIndex], 10, 0, 10);
                                                        this.SetOptionList.put(HFCVMUtilDriverParamType.MckRetry, args[paramIndex]);
                                                    }
                                                    break block47;
                                                }
                                                if (!args[paramIndex].equals("rt")) break block53;
                                                if (this.subCmd == SubCommand.DELETE) {
                                                    this.DeleteOptionList.add(HFCVMUtilDriverParamType.ResetTimeout);
                                                    break block47;
                                                } else {
                                                    this.vmutilCom.chkStrValRange(args[++paramIndex], 10, 0, 60);
                                                    this.SetOptionList.put(HFCVMUtilDriverParamType.ResetTimeout, args[paramIndex]);
                                                }
                                                break block47;
                                            }
                                            if (!args[paramIndex].equals("at")) break block54;
                                            if (this.subCmd == SubCommand.DELETE) {
                                                this.DeleteOptionList.add(HFCVMUtilDriverParamType.AbortTimeout);
                                                break block47;
                                            } else {
                                                this.vmutilCom.chkStrValRange(args[++paramIndex], 10, 0, 60);
                                                this.SetOptionList.put(HFCVMUtilDriverParamType.AbortTimeout, args[paramIndex]);
                                            }
                                            break block47;
                                        }
                                        if (!args[paramIndex].equals("qd")) break block55;
                                        if (this.subCmd == SubCommand.DELETE) {
                                            this.DeleteOptionList.add(HFCVMUtilDriverParamType.Queuedepth);
                                            break block47;
                                        } else {
                                            this.vmutilCom.chkStrValRange(args[++paramIndex], 10, 1, 256);
                                            this.SetOptionList.put(HFCVMUtilDriverParamType.Queuedepth, args[paramIndex]);
                                        }
                                        break block47;
                                    }
                                    if (!args[paramIndex].equals("ir")) break block56;
                                    if (this.subCmd != SubCommand.DELETE) break block57;
                                    this.DeleteOptionList.add(HFCVMUtilDriverParamType.MsiEnable);
                                    break block47;
                                }
                                if (args[++paramIndex].equals("int")) {
                                    this.SetOptionList.put(HFCVMUtilDriverParamType.MsiEnable, "0");
                                    break block47;
                                } else if (args[paramIndex].equals("msi")) {
                                    this.SetOptionList.put(HFCVMUtilDriverParamType.MsiEnable, "1");
                                    break block47;
                                } else {
                                    if (!args[paramIndex].equals("msix")) {
                                        this.logger.severe("ir value out of range:" + args[paramIndex]);
                                        throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
                                    }
                                    this.SetOptionList.put(HFCVMUtilDriverParamType.MsiEnable, "2");
                                }
                                break block47;
                            }
                            if (!args[paramIndex].equals("lm")) break block58;
                            if (this.subCmd == SubCommand.DELETE) {
                                this.DeleteOptionList.add(HFCVMUtilDriverParamType.LimitLog);
                                this.changeLimitLog = true;
                                break block47;
                            } else if (args[++paramIndex].equals("def")) {
                                this.SetOptionList.put(HFCVMUtilDriverParamType.LimitLog, "0");
                                this.changeLimitLog = true;
                                this.limitLogValue = 0;
                                break block47;
                            } else {
                                if (!args[paramIndex].equals("disable")) {
                                    this.logger.severe("lm value out of range:" + args[paramIndex]);
                                    throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
                                }
                                this.SetOptionList.put(HFCVMUtilDriverParamType.LimitLog, "1");
                                this.changeLimitLog = true;
                                this.limitLogValue = 1;
                            }
                            break block47;
                        }
                        if (!args[paramIndex].equals("tf")) break block59;
                        if (this.subCmd == SubCommand.DELETE) {
                            this.DeleteOptionList.add(HFCVMUtilDriverParamType.FilterTarget);
                            this.changeFilterTarget = true;
                            break block47;
                        } else if (args[++paramIndex].equals("no")) {
                            this.SetOptionList.put(HFCVMUtilDriverParamType.FilterTarget, "0");
                            this.changeFilterTarget = true;
                            this.filterTargetValue = 0;
                            break block47;
                        } else {
                            if (!args[paramIndex].equals("pid")) {
                                this.logger.severe("tf value out of range:" + args[paramIndex]);
                                throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
                            }
                            this.SetOptionList.put(HFCVMUtilDriverParamType.FilterTarget, "1");
                            this.changeFilterTarget = true;
                            this.filterTargetValue = 1;
                        }
                        break block47;
                    }
                    if (!args[paramIndex].equals("force")) {
                        this.logger.severe("unknown parameter:" + args[paramIndex]);
                        throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
                    }
                    if (this.subCmd != SubCommand.DELETE || args.length != paramIndex + 1 || this.DeleteOptionList.isEmpty()) {
                        this.logger.severe("force option format error");
                        throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
                    }
                    this.deleteForce = true;
                }
                ++paramIndex;
            }
        }
        this.logger.finest("end");
    }

    @Override
    public void execCommand(URL pWbemUrl, String pUser, String pPassword, boolean ignorecert) throws HFCVMUtilException, HFCCimClientException, HFCWSAPIException {
        this.logger.finest("start");
        HFCVMUtilCom.printTime();
        this.wsApi = new HFCWSAPIWrapper();
        this.wsApi.Connect(pWbemUrl, pUser, pPassword, ignorecert);
        this.cimClient = new HFCCimClientWrapper(pWbemUrl, pUser, pPassword);
        try {
            this.execPortCommand();
        }
        catch (HFCVMUtilException e) {
            this.vmutilCom.doErrEndProc(this.wsApi, this.cimClient, e);
        }
        catch (HFCCimClientException e) {
            this.vmutilCom.doErrEndProc(this.wsApi, this.cimClient, e);
        }
        this.cimClient.close();
        this.wsApi.DisConnect();
        this.logger.finest("end");
    }

    private void execPortCommand() throws HFCVMUtilException, HFCCimClientException {
        this.logger.finest("start");
        switch (this.subCmd) {
            case DISP: {
                this.dispPortState();
                break;
            }
            case DISPALL: {
                this.dispDriverParam();
                break;
            }
            case SET: {
                this.setDriverParam();
                break;
            }
            case DELETE: {
                this.deleteDriverParam();
            }
        }
        this.logger.finest("end");
    }

    private void dispPortState() throws HFCVMUtilInvalidArgException, HFCCimClientException {
        this.logger.finest("start");
        CIMInstance fcPort = this.vmutilCom.getFCPortInstance(this.cimClient, this.targetVmhbaNo);
        if (fcPort == null) {
            this.logger.severe(String.valueOf(HFCVMUtilCom.getHfcVmhbaNoPrefix()) + this.targetVmhbaNo + " is not exist");
            throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_NO_VMHBA);
        }
        this.vmutilCom.displayInstanceInfo(fcPort);
        UnsignedInteger8 conTypInt = (UnsignedInteger8)fcPort.getProperty("ConnectionType").getValue();
        int conTyp = conTypInt.intValue();
        UnsignedInteger64 speedBps = (UnsignedInteger64)fcPort.getProperty("Speed").getValue();
        BigInteger speedGBpsInt = speedBps.bigIntegerValue().divide(new BigInteger("1000000000"));
        String speedGBps = speedGBpsInt.toString();
        String loginDelay = fcPort.getProperty("LoginDelay").getValue().toString();
        UnsignedInteger32 maxTransByte = (UnsignedInteger32)fcPort.getProperty("MaxTransferSize").getValue();
        long maxTransGByte = maxTransByte.longValue() / 0x100000L;
        String linkDownTime = fcPort.getProperty("LinkDownTime").getValue().toString();
        String resetDelayTime = fcPort.getProperty("ResetDelayTime").getValue().toString();
        String machinCheck = fcPort.getProperty("MachineCheckRetryCount").getValue().toString();
        String resetTimeout = fcPort.getProperty("ResetTimeout").getValue().toString();
        String abortTimeout = fcPort.getProperty("AbortTimeout").getValue().toString();
        String queueDepth = fcPort.getProperty("QueueDepth").getValue().toString();
        UnsignedInteger8 interruptInt = (UnsignedInteger8)fcPort.getProperty("CurrentInterruptType").getValue();
        String interruptType = this.vmutilCom.getInterruptType(interruptInt.intValue());
        UnsignedInteger8 LoggingModeInt = (UnsignedInteger8)fcPort.getProperty("LimitLog").getValue();
        String loggingMode = this.vmutilCom.getLoggingMode(LoggingModeInt.intValue());
        UnsignedInteger8 FilteringModeInt = (UnsignedInteger8)fcPort.getProperty("FilterTarget").getValue();
        String filteringMode = this.vmutilCom.getFilteringMode(FilteringModeInt.intValue());
        System.out.printf("Connection Type        : %s\n", this.vmutilCom.getConnectionType(conTyp));
        boolean CON_TYP_NONE = false;
        if (conTyp == 0) {
            System.out.printf("Link Speed             : -\n", new Object[0]);
        } else {
            System.out.printf("Link Speed             : %sGbps\n", speedGBps);
        }
        System.out.printf("Login Delay Time       : %s sec\n", loginDelay);
        System.out.printf("Max Transfer Size      : %d MB\n", maxTransGByte);
        System.out.printf("Link Down Time         : %s sec\n", linkDownTime);
        System.out.printf("Reset Delay Time       : %s sec\n", resetDelayTime);
        System.out.printf("Machine Check          : %s\n", machinCheck);
        System.out.printf("Reset Timeout          : %s sec\n", resetTimeout);
        System.out.printf("Abort Timeout          : %s sec\n", abortTimeout);
        System.out.printf("Queue Depth            : %s\n", queueDepth);
        System.out.printf("Interrupt type         : %s\n", interruptType);
        System.out.printf("Logging Mode           : %s\n", loggingMode);
        System.out.printf("Login Target Filter    : %s\n", filteringMode);
        if (this.debugDisp) {
            UnsignedInteger8 alpaNumInt = (UnsignedInteger8)fcPort.getProperty("PreferredALPANumber").getValue();
            int alpaNum = alpaNumInt.intValue();
            String enableMsg = fcPort.getProperty("EnableMessage").getValue().toString();
            String loginDelayMck = fcPort.getProperty("LinkDownTimeMCK").getValue().toString();
            String maxTargetNum = fcPort.getProperty("MaxTargetNumber").getValue().toString();
            String maxXobNum = fcPort.getProperty("MaxXobNumber").getValue().toString();
            String maxXrbNum = fcPort.getProperty("MaxXrbNumber").getValue().toString();
            String maxSoftLogNum = fcPort.getProperty("MaxSoftLogNumber").getValue().toString();
            String maxTraceNum = fcPort.getProperty("MaxTraceNumber").getValue().toString();
            String maxPktNum = fcPort.getProperty("MaxPktNumber").getValue().toString();
            String maxCanQueue = fcPort.getProperty("MaxCanQueue").getValue().toString();
            String maxSgTblSize = fcPort.getProperty("MaxSgTablesize").getValue().toString();
            String maxCmndNum = fcPort.getProperty("MaxCmndNumber").getValue().toString();
            String minusTimeout = fcPort.getProperty("MinusTimeout").getValue().toString();
            String scsiAllowed = fcPort.getProperty("ScsiAllowed").getValue().toString();
            String maxCmdPerLun = fcPort.getProperty("MaxCmdPerLun").getValue().toString();
            String maxSectors = fcPort.getProperty("MaxSectors").getValue().toString();
            String targetRest = fcPort.getProperty("TargetResetFlag").getValue().toString();
            String scsiTimeoutParam = fcPort.getProperty("ScsiTimeoutParameter").getValue().toString();
            System.out.printf("Preferred AL-PA Number : %02x\n", alpaNum);
            System.out.printf("Enable Message         : %s\n", enableMsg);
            System.out.printf("Link Down Time (MCK)   : %s sec\n", loginDelayMck);
            System.out.printf("Max target number      : %s\n", maxTargetNum);
            System.out.printf("Max xob number         : %s\n", maxXobNum);
            System.out.printf("Max xrb number         : %s\n", maxXrbNum);
            System.out.printf("Max soft log number    : %s\n", maxSoftLogNum);
            System.out.printf("Max trace number       : %s\n", maxTraceNum);
            System.out.printf("Max pkt number         : %s\n", maxPktNum);
            System.out.printf("Max can queue          : %s\n", maxCanQueue);
            System.out.printf("Max sg tablesize       : %s\n", maxSgTblSize);
            System.out.printf("Max cmnd number        : %s\n", maxCmndNum);
            System.out.printf("Minus timeout          : %s\n", minusTimeout);
            System.out.printf("Scsi allowed           : %s\n", scsiAllowed);
            System.out.printf("Max cmd per lun        : %s\n", maxCmdPerLun);
            System.out.printf("Max sectors            : %s\n", maxSectors);
            System.out.printf("Target reset flag      : %s\n", targetRest);
            System.out.printf("Scsi timeout parameter : %s\n", scsiTimeoutParam);
        }
        this.logger.finest("end");
    }

    private void dispDriverParam() throws HFCVMUtilOperationException, HFCCimClientException {
        String loggingMode;
        String interuptType;
        String msiEnable;
        String queueDepth;
        String abortTimeout;
        String resetTimeout;
        String mckRetry;
        String resetDelay;
        String linkDown;
        this.logger.finest("start");
        CIMInstance driverSID = this.vmutilCom.getDriverSIDInstance(this.cimClient);
        if (driverSID == null) {
            this.logger.severe("there is no HFCSoftwareIdentity driver instance");
            throw new HFCVMUtilOperationException("No hfcldd port");
        }
        String maxTrans = (String)driverSID.getProperty("MaxTransfer").getValue();
        if (maxTrans.isEmpty()) {
            maxTrans = ParamUnsetting;
        }
        if ((linkDown = (String)driverSID.getProperty("LinkDown").getValue()).isEmpty()) {
            linkDown = ParamUnsetting;
        }
        if ((resetDelay = (String)driverSID.getProperty("ResetDelay").getValue()).isEmpty()) {
            resetDelay = ParamUnsetting;
        }
        if ((mckRetry = (String)driverSID.getProperty("MckRetry").getValue()).isEmpty()) {
            mckRetry = ParamUnsetting;
        }
        if ((resetTimeout = (String)driverSID.getProperty("ResetTimeout").getValue()).isEmpty()) {
            resetTimeout = ParamUnsetting;
        }
        if ((abortTimeout = (String)driverSID.getProperty("AbortTimeout").getValue()).isEmpty()) {
            abortTimeout = ParamUnsetting;
        }
        if ((queueDepth = (String)driverSID.getProperty("QueueDepth").getValue()).isEmpty()) {
            queueDepth = ParamUnsetting;
        }
        if ((msiEnable = (String)driverSID.getProperty("MsiEnable").getValue()).isEmpty()) {
            interuptType = ParamUnsetting;
        } else {
            try {
                int interuptInt = Integer.parseInt(msiEnable);
                interuptType = this.vmutilCom.getInterruptType(interuptInt);
            }
            catch (NumberFormatException e) {
                this.logger.severe("msiEnable value format error :" + msiEnable);
                throw new HFCVMUtilOperationException();
            }
        }
        String limitLogMode = (String)driverSID.getProperty("LimitLog").getValue();
        if (limitLogMode.isEmpty()) {
            loggingMode = ParamUnsetting;
        } else {
            try {
                int loggingModeInt = Integer.parseInt(limitLogMode);
                loggingMode = this.vmutilCom.getLoggingMode(loggingModeInt);
            }
            catch (NumberFormatException e) {
                this.logger.severe("Logging Mode value format error :" + limitLogMode);
                throw new HFCVMUtilOperationException();
            }
        }
        String filteringMode = (String)driverSID.getProperty("FilterTarget").getValue();
        if (filteringMode.isEmpty()) {
            filteringMode = ParamUnsetting;
        } else {
            try {
                int filteringModeInt = Integer.parseInt(filteringMode);
                filteringMode = this.vmutilCom.getFilteringMode(filteringModeInt);
            }
            catch (NumberFormatException e) {
                this.logger.severe("Login Target Filter value format error :" + filteringMode);
                throw new HFCVMUtilOperationException();
            }
        }
        System.out.println("--------------------------------------------------------");
        System.out.println("Settings for all HBA ports");
        System.out.println("--------------------------------------------------------");
        System.out.println("Max Transfer Size     : " + maxTrans + " MB");
        System.out.println("Link Down Time        : " + linkDown + " sec");
        System.out.println("Reset Delay Time      : " + resetDelay + " sec");
        System.out.println("Machine Check         : " + mckRetry);
        System.out.println("Reset Timeout         : " + resetTimeout + " sec");
        System.out.println("Abort Timeout         : " + abortTimeout + " sec");
        System.out.println("Queue Depth           : " + queueDepth);
        System.out.println("Interrupt type        : " + interuptType);
        System.out.println("Logging Mode          : " + loggingMode);
        System.out.println("Login Target Filter   : " + filteringMode);
        this.logger.finest("end");
    }

    private void setDriverParam() throws HFCVMUtilOperationException, HFCCimClientException {
        this.logger.finest("start");
        HFCVMUtilDriverParam driverParam = new HFCVMUtilDriverParam();
        driverParam.setDriverParam(this.cimClient, this.SetOptionList);
        System.out.println("Succeeded.");
        Set<HFCVMUtilDriverParamType> setParamKeySet = this.SetOptionList.keySet();
        Iterator<HFCVMUtilDriverParamType> setParamKeyIte = setParamKeySet.iterator();
        boolean reboot_msg_flg = false;
        int i = 0;
        while (i < this.SetOptionList.size() && setParamKeyIte.hasNext()) {
            String prm_name = setParamKeyIte.next().toString();
            if (!prm_name.equals("LimitLog") && !prm_name.equals("FilterTarget")) {
                reboot_msg_flg = true;
                break;
            }
            ++i;
        }
        if (reboot_msg_flg) {
            System.out.println("You must reboot your host for the changes to take effect.");
        }
        if (this.changeLimitLog) {
            System.out.println("Applying Logging Mode setting to the driver....");
            driverParam.immediateApply(this.cimClient, (short)0, (short)1, this.limitLogValue);
        }
        if (this.changeFilterTarget) {
            System.out.println("Applying Login Target Filter setting to the driver....");
            driverParam.immediateApply(this.cimClient, (short)1, (short)1, this.filterTargetValue);
        }
        this.logger.finest("end");
    }

    private void deleteDriverParam() throws HFCVMUtilException, HFCCimClientException {
        this.logger.finest("start");
        if (!this.deleteForce && !this.vmutilCom.confirmExecute("Do you execute it?")) {
            return;
        }
        HFCVMUtilDriverParam driverParam = new HFCVMUtilDriverParam();
        driverParam.deleteDriverParam(this.cimClient, this.DeleteOptionList);
        System.out.println("Succeeded.");
        Iterator<HFCVMUtilDriverParamType> deleteParamIte = this.DeleteOptionList.iterator();
        boolean reboot_msg_flg = false;
        int i = 0;
        while (i < this.DeleteOptionList.size() && deleteParamIte.hasNext()) {
            String prm_name = deleteParamIte.next().toString();
            if (!prm_name.equals("LimitLog") && !prm_name.equals("FilterTarget")) {
                reboot_msg_flg = true;
                break;
            }
            ++i;
        }
        if (reboot_msg_flg) {
            System.out.println("You must reboot your host for the changes to take effect.");
        }
        if (this.changeLimitLog) {
            System.out.println("Applying Logging Mode setting to the driver....");
            driverParam.immediateApply(this.cimClient, (short)0, (short)2, (short)0);
        }
        if (this.changeFilterTarget) {
            System.out.println("Applying Login Target Filter setting to the driver....");
            driverParam.immediateApply(this.cimClient, (short)1, (short)2, (short)0);
        }
        this.logger.finest("end");
    }

    private static enum SubCommand {
        DISP,
        DISPALL,
        SET,
        DELETE;

    }
}

