/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.hfc.vmutil;

import com.hitachi.hfc.CimWrapper.HFCCimClientException;
import com.hitachi.hfc.CimWrapper.HFCCimClientWrapper;
import com.hitachi.hfc.WSWrapper.HFCWSAPIException;
import com.hitachi.hfc.WSWrapper.HFCWSAPIWrapper;
import com.hitachi.hfc.vmutil.HFCVMUtilCom;
import com.hitachi.hfc.vmutil.HFCVMUtilException;
import com.hitachi.hfc.vmutil.HFCVMUtilFunc;
import com.hitachi.hfc.vmutil.HFCVMUtilInvalidArgException;
import com.hitachi.hfc.vmutil.HFCVMUtilInvalidArgExceptionType;
import com.hitachi.hfc.vmutil.HFCVMUtilOperationException;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import javax.cim.CIMInstance;

class HFCVMUtilPortDefinitionFunc
implements HFCVMUtilFunc {
    private HFCWSAPIWrapper wsApi;
    private HFCCimClientWrapper cimClient;
    private HFCVMUtilCom vmutilCom;
    private Logger logger = HFCVMUtilCom.getLogger();

    public HFCVMUtilPortDefinitionFunc() {
        this.logger.finest("called");
    }

    @Override
    public void checkParam(String[] args, int paramIndex) throws HFCVMUtilInvalidArgException {
        this.logger.finest("start");
        if (args.length != paramIndex) {
            this.logger.severe("param num err:" + args.length);
            throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
        }
        this.logger.finest("end");
    }

    @Override
    public void execCommand(URL pWbemUrl, String pUser, String pPassword, boolean ignorecert) throws HFCVMUtilException, HFCCimClientException, HFCWSAPIException {
        this.logger.finest("start");
        HFCVMUtilCom.printTime();
        this.wsApi = new HFCWSAPIWrapper();
        this.wsApi.Connect(pWbemUrl, pUser, pPassword, ignorecert);
        this.cimClient = new HFCCimClientWrapper(pWbemUrl, pUser, pPassword);
        this.vmutilCom = HFCVMUtilCom.getInstance();
        try {
            this.execDisplay();
        }
        catch (HFCVMUtilOperationException e) {
            this.vmutilCom.doErrEndProc(this.wsApi, this.cimClient, e);
        }
        catch (HFCCimClientException e) {
            this.vmutilCom.doErrEndProc(this.wsApi, this.cimClient, e);
        }
        this.cimClient.close();
        this.wsApi.DisConnect();
        this.logger.finest("end");
    }

    private void execDisplay() throws HFCVMUtilOperationException, HFCCimClientException {
        this.logger.finest("start");
        List<CIMInstance> fcPortList = this.cimClient.enumerateInstances(HFCCimClientWrapper.getHfcnamespace(), "HFC_FCPort");
        for (CIMInstance fcPort : fcPortList) {
            this.vmutilCom.displayInstanceInfo(fcPort);
            System.out.println("Connected targets and Lus:");
            List<CIMInstance> scsiInitiatorList = this.cimClient.associators(fcPort.getObjectPath(), "HFC_DeviceSAPImplementation", "HFC_SCSIProtocolEndpoint");
            if (scsiInitiatorList.isEmpty()) {
                this.logger.severe("there is no HFC_SCSIProtocolEndpoint initiator instance");
                throw new HFCVMUtilOperationException();
            }
            CIMInstance scsiInitiator = scsiInitiatorList.get(0);
            List<CIMInstance> scsiTargetList = this.cimClient.associators(scsiInitiator.getObjectPath(), "HFC_SCSIInitiatorTargetStorageVolumePath", "HFC_SCSIProtocolEndpoint", "Initiator", "Target");
            if (scsiTargetList.isEmpty()) {
                System.out.println("  No Target");
            }
            for (CIMInstance scsiTarget : scsiTargetList) {
                int lunInt;
                String targetName = scsiTarget.getProperty("Name").getValue().toString();
                String[] targetInfo = targetName.split(":");
                if (targetInfo.length != 3 || targetInfo[2].length() < 4) {
                    this.logger.severe("HFC_SCSIProtocolEndpoint target name property format error:" + targetName);
                    throw new HFCVMUtilOperationException();
                }
                String lun = targetInfo[2].substring(0, 4);
                try {
                    lunInt = Integer.parseInt(lun, 16);
                }
                catch (NumberFormatException e) {
                    this.logger.severe(String.valueOf(lun) + " is not numeral");
                    throw new HFCVMUtilOperationException();
                }
                System.out.printf("  %s:%04d\n", targetInfo[1], lunInt);
            }
        }
        this.logger.finest("end");
    }
}

