/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.hfc.vmutil;

import com.hitachi.hfc.CimWrapper.HFCCimClientException;
import com.hitachi.hfc.CimWrapper.HFCCimClientWrapper;
import com.hitachi.hfc.WSWrapper.HFCWSAPIException;
import com.hitachi.hfc.WSWrapper.HFCWSAPIWrapper;
import com.hitachi.hfc.vmutil.HFCVMUtilCom;
import com.hitachi.hfc.vmutil.HFCVMUtilException;
import com.hitachi.hfc.vmutil.HFCVMUtilFunc;
import com.hitachi.hfc.vmutil.HFCVMUtilInvalidArgException;
import com.hitachi.hfc.vmutil.HFCVMUtilInvalidArgExceptionType;
import com.hitachi.hfc.vmutil.HFCVMUtilOperationException;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import javax.cim.CIMArgument;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.UnsignedInteger8;

class HFCVMUtilIsolateStatusFunc
implements HFCVMUtilFunc {
    private static final String SetOnConfirmMsg = "Error monitoring service is going to be restarted.\n";
    private static final String SetOnConfirmYNMsg = "Do you execute it?";
    private static final String SetOffConfirmMsg = "Error monitoring service is going to be stopped.\n";
    private static final String SetOffConfirmYNMsg = "Do you execute it?";
    private HFCWSAPIWrapper wsApi;
    private HFCCimClientWrapper cimClient;
    private HFCVMUtilCom vmutilCom;
    private SubCommand subCmd = SubCommand.PRINT_ALL_VMHBA;
    private boolean executeForce = false;
    private String targetVmhbaNo;
    private int vmhbaNoInt;
    private Logger logger = HFCVMUtilCom.getLogger();

    public HFCVMUtilIsolateStatusFunc() {
        this.logger.finest("called");
        this.vmutilCom = HFCVMUtilCom.getInstance();
    }

    @Override
    public void checkParam(String[] args, int paramIndex) throws HFCVMUtilInvalidArgException {
        this.logger.finest("start");
        if (args.length > paramIndex + 2) {
            this.logger.severe("param num err:" + args.length);
            throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
        }
        this.subCmd = SubCommand.PRINT_ALL_VMHBA;
        if (args.length == paramIndex) {
            return;
        }
        if (args[paramIndex].matches(String.valueOf(HFCVMUtilCom.getHfcVmhbaNoPrefix()) + "\\d+")) {
            if (args.length > paramIndex + 1) {
                this.logger.severe("param num err:" + args.length);
                throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
            }
            this.subCmd = SubCommand.PRINT_ONE_VMHBA;
            this.targetVmhbaNo = args[paramIndex];
            this.vmhbaNoInt = this.vmutilCom.getVmhbaNo(this.targetVmhbaNo);
        } else if (args[paramIndex].equals("on")) {
            this.subCmd = SubCommand.SET_ON;
            ++paramIndex;
        } else if (args[paramIndex].equals("off")) {
            this.subCmd = SubCommand.SET_OFF;
            ++paramIndex;
        } else {
            this.logger.severe("unknown parameter:" + args[paramIndex]);
            throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
        }
        if ((this.subCmd == SubCommand.SET_ON || this.subCmd == SubCommand.SET_OFF) && args.length == paramIndex + 1) {
            if (args[paramIndex].equals("force")) {
                this.executeForce = true;
            } else {
                this.logger.severe("unknown parameter:" + args[paramIndex]);
                throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
            }
        }
        this.logger.finest("end");
    }

    @Override
    public void execCommand(URL pWbemUrl, String pUser, String pPassword, boolean ignorecert) throws HFCVMUtilException, HFCCimClientException, HFCWSAPIException {
        this.logger.finest("start");
        this.wsApi = new HFCWSAPIWrapper();
        this.wsApi.Connect(pWbemUrl, pUser, pPassword, ignorecert);
        this.cimClient = new HFCCimClientWrapper(pWbemUrl, pUser, pPassword);
        HFCVMUtilCom.printTime();
        try {
            this.execIsolateStatus();
        }
        catch (HFCVMUtilException e) {
            this.vmutilCom.doErrEndProc(this.wsApi, this.cimClient, e);
        }
        catch (HFCCimClientException e) {
            this.vmutilCom.doErrEndProc(this.wsApi, this.cimClient, e);
        }
        this.cimClient.close();
        this.wsApi.DisConnect();
        this.logger.finest("end");
    }

    private void execIsolateStatus() throws HFCVMUtilException, HFCCimClientException {
        this.logger.finest("start");
        switch (this.subCmd) {
            case PRINT_ONE_VMHBA: {
                CIMInstance fcPort = this.vmutilCom.getFCPortInstance(this.cimClient, this.vmhbaNoInt);
                if (fcPort == null) {
                    this.logger.severe(String.valueOf(this.targetVmhbaNo) + " is not exist");
                    throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_NO_VMHBA);
                }
                this.vmutilCom.displayInstanceInfo(fcPort);
                this.displayIsolateStatus(fcPort);
                break;
            }
            case PRINT_ALL_VMHBA: {
                List<CIMInstance> fcPortList = this.cimClient.enumerateInstances(HFCCimClientWrapper.getHfcnamespace(), "HFC_FCPort");
                if (fcPortList.isEmpty()) {
                    this.logger.severe("there is no HFC_FCPort instance");
                    throw new HFCVMUtilOperationException("No hfcldd port");
                }
                this.displayIsolateSupportStatus(fcPortList);
                int i = 0;
                while (i < fcPortList.size()) {
                    CIMInstance fcPort = fcPortList.get(i);
                    this.vmutilCom.displayInstanceInfo(fcPort);
                    this.displayIsolateStatus(fcPort);
                    ++i;
                }
                break;
            }
            default: {
                String[] errMSgOut;
                CIMArgument[] pOutputArg;
                List<CIMObjectPath> portCtrlServList;
                String confirmYNMsg;
                String confirmMsg;
                String methodName;
                if (this.subCmd == SubCommand.SET_ON) {
                    methodName = "StartIsolate";
                    confirmMsg = SetOnConfirmMsg;
                    confirmYNMsg = "Do you execute it?";
                } else {
                    methodName = "StopIsolate";
                    confirmMsg = SetOffConfirmMsg;
                    confirmYNMsg = "Do you execute it?";
                }
                if (!this.executeForce) {
                    System.out.printf(confirmMsg, new Object[0]);
                    if (!this.vmutilCom.confirmExecute(confirmYNMsg)) {
                        return;
                    }
                }
                if ((portCtrlServList = this.cimClient.enumerateInstanceNames(HFCCimClientWrapper.getHfcnamespace(), "HFC_PortControlService")).isEmpty()) {
                    this.logger.severe("there is no HFC_PortControlService instance");
                    throw new HFCVMUtilOperationException("No hfcldd port");
                }
                CIMObjectPath portCtrlServ = portCtrlServList.get(0);
                Object retval = this.cimClient.invokeMethod(portCtrlServ, methodName, null, pOutputArg = new CIMArgument[1]);
                if (retval.toString().equals("0")) {
                    System.out.println("Succeeded.");
                    break;
                }
                String[] stringArray = errMSgOut = (String[])pOutputArg[0].getValue();
                int n = errMSgOut.length;
                int n2 = 0;
                while (n2 < n) {
                    String errMSg = stringArray[n2];
                    System.out.println(errMSg);
                    this.logger.severe(errMSg);
                    ++n2;
                }
                System.out.println("");
                throw new HFCVMUtilOperationException("Failed.");
            }
        }
        this.logger.finest("end");
    }

    private void displayIsolateStatus(CIMInstance pFcPort) throws HFCVMUtilOperationException, HFCCimClientException {
        this.logger.finest("start");
        List<CIMInstance> portCtrlList = this.cimClient.associators(pFcPort.getObjectPath(), "HFC_ControlledBy", "HFC_PortController");
        if (portCtrlList.isEmpty()) {
            this.logger.severe("there is no HFC_PortController instance");
            throw new HFCVMUtilOperationException();
        }
        CIMInstance portCtrl = portCtrlList.get(0);
        Short ldErrLimitS = (Short)portCtrl.getProperty("LdErrLimitS").getValue();
        Short ldErrCountS = (Short)portCtrl.getProperty("LdErrCountS").getValue();
        Short ifErrLimit = (Short)portCtrl.getProperty("IfErrLimit").getValue();
        Short ifErrCount = (Short)portCtrl.getProperty("IfErrCount").getValue();
        Short toErrLimit = (Short)portCtrl.getProperty("ToErrLimit").getValue();
        Short toErrCount = (Short)portCtrl.getProperty("ToErrCount").getValue();
        Boolean rtErrEnable = (Boolean)portCtrl.getProperty("RtErrEnable").getValue();
        Short rtErrCount = (Short)portCtrl.getProperty("RtErrCount").getValue();
        System.out.printf("  Linkdown Error(S)  Limit:%-4d  Count:%-4d \n", ldErrLimitS, ldErrCountS);
        System.out.printf("  Interface Error    Limit:%-4d  Count:%-4d \n", ifErrLimit, ifErrCount);
        System.out.printf("  TimeOut Error      Limit:%-4d  Count:%-4d \n", toErrLimit, toErrCount);
        if (rtErrEnable.booleanValue()) {
            System.out.printf("  TimeOutReset Error enable %s \n\n", rtErrCount.intValue() != 0 ? "(Error occurred)" : "(No error)");
        } else {
            System.out.printf("  TimeOutReset Error disable \n\n", new Object[0]);
        }
        this.logger.finest("end");
    }

    private void displayIsolateSupportStatus(List<CIMInstance> pFcPortList) throws HFCVMUtilOperationException, HFCCimClientException {
        this.logger.finest("start");
        boolean allPortChkStop = true;
        for (CIMInstance fcPort : pFcPortList) {
            UnsignedInteger8 portStatusInt = (UnsignedInteger8)fcPort.getProperty("FCPortStatus").getValue();
            int portStatus = portStatusInt.intValue();
            if (HFCVMUtilCom.getPortstatuschkstpe() == portStatus) continue;
            allPortChkStop = false;
        }
        if (allPortChkStop) {
            System.out.printf("Error Monitoring Service : CHK-STP\n", new Object[0]);
        } else {
            CIMInstance driverSID = this.vmutilCom.getDriverSIDInstance(this.cimClient);
            if (driverSID == null) {
                this.logger.severe("there is no HFCSoftwareIdentity driver instance");
                throw new HFCVMUtilOperationException();
            }
            String hbaIsolEnable = "1";
            String hbaIsolDisable = "0";
            String hbaIsol = (String)driverSID.getProperty("HbaIsolation").getValue();
            if (hbaIsol.isEmpty()) {
                hbaIsol = "1";
            }
            if (hbaIsol.equals("1")) {
                System.out.printf("Error Monitoring Service : on\n", new Object[0]);
            } else if (hbaIsol.equals("0")) {
                System.out.printf("Error Monitoring Service : off\n", new Object[0]);
            } else {
                System.out.printf("Error Monitoring Service : -\n", new Object[0]);
            }
            System.out.printf("HBA port status\n", new Object[0]);
            for (CIMInstance fcPort : pFcPortList) {
                UnsignedInteger8 minorNo = (UnsignedInteger8)fcPort.getProperty("Minor").getValue();
                UnsignedInteger8 portStatusInt = (UnsignedInteger8)fcPort.getProperty("FCPortStatus").getValue();
                int portStatus = portStatusInt.intValue();
                if (HFCVMUtilCom.getPortstatuschkstpe() != portStatus) {
                    List<CIMInstance> portCtrlList = this.cimClient.associators(fcPort.getObjectPath(), "HFC_ControlledBy", "HFC_PortController");
                    if (portCtrlList.isEmpty()) {
                        this.logger.severe("there is no HFC_PortController instance");
                        throw new HFCVMUtilOperationException();
                    }
                    CIMInstance portCtrl = portCtrlList.get(0);
                    UnsignedInteger8 errIsFunc = (UnsignedInteger8)portCtrl.getProperty("ErrIsFunc").getValue();
                    UnsignedInteger8 errIsFwSpt = (UnsignedInteger8)portCtrl.getProperty("ErrIsFwSpt").getValue();
                    System.out.printf("   hfcldd%-2d : F/W %s (%s)\n", minorNo.intValue(), errIsFwSpt.intValue() != 0 ? "support" : "not support", errIsFunc.intValue() != 0 ? "running" : "stop");
                    continue;
                }
                System.out.printf("   hfcldd%-2d : CHK-STP\n", minorNo.intValue());
            }
        }
        this.logger.finest("end");
    }

    private static enum SubCommand {
        PRINT_ONE_VMHBA,
        PRINT_ALL_VMHBA,
        SET_ON,
        SET_OFF;

    }
}

