/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.hfc.vmutil;

import com.hitachi.hfc.CimWrapper.HFCCimClientException;
import com.hitachi.hfc.CimWrapper.HFCCimClientWrapper;
import com.hitachi.hfc.WSWrapper.HFCWSAPIException;
import com.hitachi.hfc.WSWrapper.HFCWSAPIWrapper;
import com.hitachi.hfc.vmutil.HFCVMUtilCom;
import com.hitachi.hfc.vmutil.HFCVMUtilDriverParam;
import com.hitachi.hfc.vmutil.HFCVMUtilDriverParamType;
import com.hitachi.hfc.vmutil.HFCVMUtilException;
import com.hitachi.hfc.vmutil.HFCVMUtilFunc;
import com.hitachi.hfc.vmutil.HFCVMUtilInvalidArgException;
import com.hitachi.hfc.vmutil.HFCVMUtilInvalidArgExceptionType;
import com.hitachi.hfc.vmutil.HFCVMUtilOperationException;
import java.net.URL;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.cim.CIMInstance;

class HFCVMUtilIsolatePortFunc
implements HFCVMUtilFunc {
    private static final String ParamUnsetting = "-";
    private boolean deleteForce = false;
    private int targetVmhbaNo;
    private SubCommand subCmd = SubCommand.DISP;
    private Map<HFCVMUtilDriverParamType, String> SetOptionList;
    private Set<HFCVMUtilDriverParamType> DeleteOptionList;
    private HFCWSAPIWrapper wsApi;
    private HFCCimClientWrapper cimClient;
    private HFCVMUtilCom vmutilCom;
    private Logger logger = HFCVMUtilCom.getLogger();

    public HFCVMUtilIsolatePortFunc() {
        this.logger.finest("called");
        this.vmutilCom = HFCVMUtilCom.getInstance();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void checkParam(String[] args, int paramIndex) throws HFCVMUtilInvalidArgException {
        block30: {
            this.logger.finest("start");
            if (args.length == paramIndex) {
                this.logger.severe("param num err:" + args.length);
                throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
            }
            if (args[paramIndex].equals("all")) {
                this.subCmd = SubCommand.DISPALL;
                if (args.length != ++paramIndex) {
                    this.logger.severe("param num err:" + args.length);
                    throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
                }
            } else if (args[paramIndex].matches(String.valueOf(HFCVMUtilCom.getHfcVmhbaNoPrefix()) + "\\d+")) {
                this.subCmd = SubCommand.DISP;
                this.targetVmhbaNo = this.vmutilCom.getVmhbaNo(args[paramIndex]);
                if (args.length != ++paramIndex) {
                    this.logger.severe("param num err:" + args.length);
                    throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
                }
            } else if (args[paramIndex].equals("delete")) {
                this.subCmd = SubCommand.DELETE;
                if (args.length == ++paramIndex) {
                    this.logger.severe("there is no delete parameter:" + args.length);
                    throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
                }
                this.DeleteOptionList = EnumSet.noneOf(HFCVMUtilDriverParamType.class);
            } else {
                this.subCmd = SubCommand.SET;
                this.SetOptionList = new EnumMap<HFCVMUtilDriverParamType, String>(HFCVMUtilDriverParamType.class);
            }
            if (this.subCmd != SubCommand.DELETE && this.subCmd != SubCommand.SET) break block30;
            while (paramIndex < args.length) {
                block29: {
                    block34: {
                        block33: {
                            block32: {
                                block31: {
                                    if (this.subCmd == SubCommand.SET && paramIndex + 1 == args.length) {
                                        this.logger.severe("there is no value:" + args.length);
                                        throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
                                    }
                                    if (!args[paramIndex].equals("ld")) break block31;
                                    if (this.subCmd == SubCommand.DELETE) {
                                        this.DeleteOptionList.add(HFCVMUtilDriverParamType.LdErrLimS);
                                        break block29;
                                    } else {
                                        this.vmutilCom.chkStrValRange(args[++paramIndex], 10, 0, 30);
                                        this.SetOptionList.put(HFCVMUtilDriverParamType.LdErrLimS, args[paramIndex]);
                                    }
                                    break block29;
                                }
                                if (!args[paramIndex].equals("fc")) break block32;
                                if (this.subCmd == SubCommand.DELETE) {
                                    this.DeleteOptionList.add(HFCVMUtilDriverParamType.IfErrLim);
                                    break block29;
                                } else {
                                    this.vmutilCom.chkStrValRange(args[++paramIndex], 10, 0, 2048);
                                    this.SetOptionList.put(HFCVMUtilDriverParamType.IfErrLim, args[paramIndex]);
                                }
                                break block29;
                            }
                            if (!args[paramIndex].equals("sc")) break block33;
                            if (this.subCmd == SubCommand.DELETE) {
                                this.DeleteOptionList.add(HFCVMUtilDriverParamType.ToErrLim);
                                break block29;
                            } else {
                                this.vmutilCom.chkStrValRange(args[++paramIndex], 10, 0, 2048);
                                this.SetOptionList.put(HFCVMUtilDriverParamType.ToErrLim, args[paramIndex]);
                            }
                            break block29;
                        }
                        if (!args[paramIndex].equals("rc")) break block34;
                        if (this.subCmd == SubCommand.DELETE) {
                            this.DeleteOptionList.add(HFCVMUtilDriverParamType.RtErrEnable);
                            break block29;
                        } else if (args[++paramIndex].equals("enable")) {
                            this.SetOptionList.put(HFCVMUtilDriverParamType.RtErrEnable, "1");
                            break block29;
                        } else {
                            if (!args[paramIndex].equals("disable")) {
                                this.logger.severe("rc value is out of range:" + args[paramIndex]);
                                throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
                            }
                            this.SetOptionList.put(HFCVMUtilDriverParamType.RtErrEnable, "0");
                        }
                        break block29;
                    }
                    if (args[paramIndex].equals("tl")) {
                        if (this.subCmd == SubCommand.DELETE) {
                            this.DeleteOptionList.add(HFCVMUtilDriverParamType.ToResetRetry);
                        } else {
                            this.vmutilCom.chkStrValRange(args[++paramIndex], 10, 1, 3);
                            this.SetOptionList.put(HFCVMUtilDriverParamType.ToResetRetry, args[paramIndex]);
                        }
                    } else {
                        if (!args[paramIndex].equals("force")) {
                            this.logger.severe("unknown parameter:" + args[paramIndex]);
                            throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
                        }
                        if (this.subCmd != SubCommand.DELETE || args.length != paramIndex + 1 || this.DeleteOptionList.isEmpty()) {
                            this.logger.severe("force option format error");
                            throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
                        }
                        this.deleteForce = true;
                    }
                }
                ++paramIndex;
            }
        }
        this.logger.finest("end");
    }

    @Override
    public void execCommand(URL pWbemUrl, String pUser, String pPassword, boolean ignorecert) throws HFCVMUtilException, HFCCimClientException, HFCWSAPIException {
        this.logger.finest("start");
        HFCVMUtilCom.printTime();
        this.wsApi = new HFCWSAPIWrapper();
        this.wsApi.Connect(pWbemUrl, pUser, pPassword, ignorecert);
        this.cimClient = new HFCCimClientWrapper(pWbemUrl, pUser, pPassword);
        try {
            this.execIsolatePort();
        }
        catch (HFCVMUtilException e) {
            this.vmutilCom.doErrEndProc(this.wsApi, this.cimClient, e);
        }
        catch (HFCCimClientException e) {
            this.vmutilCom.doErrEndProc(this.wsApi, this.cimClient, e);
        }
        this.cimClient.close();
        this.wsApi.DisConnect();
        this.logger.finest("end");
    }

    private void execIsolatePort() throws HFCVMUtilException, HFCCimClientException {
        this.logger.finest("start");
        switch (this.subCmd) {
            case DISP: {
                this.dispPortState();
                break;
            }
            case DISPALL: {
                this.dispDriverParam();
                break;
            }
            case SET: {
                this.setDriverParam();
                break;
            }
            case DELETE: {
                this.deleteDriverParam();
            }
        }
        this.logger.finest("end");
    }

    private void dispPortState() throws HFCVMUtilException, HFCCimClientException {
        this.logger.finest("start");
        CIMInstance fcPort = this.vmutilCom.getFCPortInstance(this.cimClient, this.targetVmhbaNo);
        if (fcPort == null) {
            this.logger.severe(String.valueOf(HFCVMUtilCom.getHfcVmhbaNoPrefix()) + this.targetVmhbaNo + " is not exist");
            throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_NO_VMHBA);
        }
        this.vmutilCom.displayInstanceInfo(fcPort);
        List<CIMInstance> portCtrlList = this.cimClient.associators(fcPort.getObjectPath(), "HFC_ControlledBy", "HFC_PortController");
        if (portCtrlList.isEmpty()) {
            this.logger.severe("there is no HFC_PortController instance");
            throw new HFCVMUtilOperationException();
        }
        CIMInstance portCtrl = portCtrlList.get(0);
        String ldErrLimitS = portCtrl.getProperty("LdErrLimitS").getValue().toString();
        String ifErrLimit = portCtrl.getProperty("IfErrLimit").getValue().toString();
        String toErrLimit = portCtrl.getProperty("ToErrLimit").getValue().toString();
        String rtErrEnable = portCtrl.getProperty("RtErrEnable").getValue().toString();
        String toResetRetry = portCtrl.getProperty("ToResetRetry").getValue().toString();
        System.out.printf("Linkdown(S) Limit        : %s\n", ldErrLimitS);
        System.out.printf("Interface Error Limit    : %s\n", ifErrLimit);
        System.out.printf("Time-Out Error Limit     : %s\n", toErrLimit);
        System.out.printf("Time-Out Reset Error     : %s\n", rtErrEnable.equals("true") ? "enable" : "disable");
        System.out.printf("Mailbox Time-Out Retry   : %s\n", toResetRetry);
        this.logger.finest("end");
    }

    private void dispDriverParam() throws HFCVMUtilOperationException, HFCCimClientException {
        String rtErrEnable;
        String toErrLimit;
        String ifErrLimit;
        this.logger.finest("start");
        CIMInstance driverSID = this.vmutilCom.getDriverSIDInstance(this.cimClient);
        if (driverSID == null) {
            this.logger.severe("there is no HFCSoftwareIdentity driver instance");
            throw new HFCVMUtilOperationException("No hfcldd port");
        }
        String ldErrLimitS = (String)driverSID.getProperty("LdErrLimitS").getValue();
        if (ldErrLimitS.isEmpty()) {
            ldErrLimitS = ParamUnsetting;
        }
        if ((ifErrLimit = (String)driverSID.getProperty("IfErrLimit").getValue()).isEmpty()) {
            ifErrLimit = ParamUnsetting;
        }
        if ((toErrLimit = (String)driverSID.getProperty("ToErrLimit").getValue()).isEmpty()) {
            toErrLimit = ParamUnsetting;
        }
        rtErrEnable = (rtErrEnable = (String)driverSID.getProperty("RtErrEnable").getValue()).equals("1") ? "enable" : (rtErrEnable.equals("0") ? "disable" : ParamUnsetting);
        String toResetRetry = (String)driverSID.getProperty("ToResetRetry").getValue();
        if (toResetRetry.isEmpty()) {
            toResetRetry = ParamUnsetting;
        }
        System.out.printf("Linkdown(S) Limit        : %s\n", ldErrLimitS);
        System.out.printf("Interface Error Limit    : %s\n", ifErrLimit);
        System.out.printf("Time-Out Error Limit     : %s\n", toErrLimit);
        System.out.printf("Time-Out Reset Error     : %s\n", rtErrEnable);
        System.out.printf("Mailbox Time-Out Retry   : %s\n", toResetRetry);
        this.logger.finest("end");
    }

    private void setDriverParam() throws HFCVMUtilOperationException, HFCCimClientException {
        this.logger.finest("start");
        HFCVMUtilDriverParam driverParam = new HFCVMUtilDriverParam();
        driverParam.setDriverParam(this.cimClient, this.SetOptionList);
        System.out.println("Succeeded.");
        System.out.println("You must reboot your host for the changes to take effect.");
        this.logger.finest("end");
    }

    private void deleteDriverParam() throws HFCVMUtilException, HFCCimClientException {
        this.logger.finest("start");
        if (!this.deleteForce && !this.vmutilCom.confirmExecute("Do you execute it?")) {
            return;
        }
        HFCVMUtilDriverParam driverParam = new HFCVMUtilDriverParam();
        driverParam.deleteDriverParam(this.cimClient, this.DeleteOptionList);
        System.out.println("Succeeded.");
        System.out.println("You must reboot your host for the changes to take effect.");
        this.logger.finest("end");
    }

    private static enum SubCommand {
        DISP,
        DISPALL,
        SET,
        DELETE;

    }
}

