/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.hfc.vmutil;

import com.hitachi.hfc.CimWrapper.HFCCimClientException;
import com.hitachi.hfc.CimWrapper.HFCCimClientWrapper;
import com.hitachi.hfc.WSWrapper.HFCWSAPIException;
import com.hitachi.hfc.WSWrapper.HFCWSAPIWrapper;
import com.hitachi.hfc.vmutil.HFCVMUtilCom;
import com.hitachi.hfc.vmutil.HFCVMUtilException;
import com.hitachi.hfc.vmutil.HFCVMUtilFunc;
import com.hitachi.hfc.vmutil.HFCVMUtilInvalidArgException;
import com.hitachi.hfc.vmutil.HFCVMUtilInvalidArgExceptionType;
import com.hitachi.hfc.vmutil.HFCVMUtilOperationException;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.UnsignedInteger8;

class HFCVMUtilIsolateCmdFunc
implements HFCVMUtilFunc {
    private static final String SetCmdConfirmMsg = "The adapter port is going to be isolated.\nThis operation may affect operations running on the adapter.\n";
    private static final String SetCmdConfirmYNMsg = "Do you really isolate the adapter port?";
    private static final String ClearCmdConfirmMsg = "The adapter port is going to be recovered.\n";
    private static final String ClearCmdConfirmYNMsg = "Do you really restore the adapter state?";
    private HFCWSAPIWrapper wsApi;
    private HFCCimClientWrapper cimClient;
    private HFCVMUtilCom vmutilCom;
    private SubCommand subCmd = SubCommand.SET;
    private boolean executeForce = false;
    private String targetVmhbaNo;
    private int vmhbaNoInt;
    private Logger logger = HFCVMUtilCom.getLogger();

    public HFCVMUtilIsolateCmdFunc() {
        this.logger.finest("called");
        this.vmutilCom = HFCVMUtilCom.getInstance();
    }

    @Override
    public void checkParam(String[] args, int paramIndex) throws HFCVMUtilInvalidArgException {
        this.logger.finest("start");
        if (args.length < paramIndex + 1 || args.length > paramIndex + 3) {
            this.logger.severe("param num err:" + args.length);
            throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
        }
        if (!args[paramIndex].matches(String.valueOf(HFCVMUtilCom.getHfcVmhbaNoPrefix()) + "\\d+")) {
            this.logger.severe(String.valueOf(args[paramIndex]) + ":vmhbaNo format err");
            throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_VMHBA);
        }
        this.targetVmhbaNo = args[paramIndex];
        this.vmhbaNoInt = this.vmutilCom.getVmhbaNo(this.targetVmhbaNo);
        this.subCmd = SubCommand.SET;
        if (args.length == ++paramIndex) {
            return;
        }
        if (args[paramIndex].equals("clear")) {
            this.subCmd = SubCommand.CLEAR;
            ++paramIndex;
        }
        if (args.length == paramIndex + 1) {
            if (args[paramIndex].equals("force")) {
                this.executeForce = true;
            } else {
                this.logger.severe("unknown parameter:" + args[paramIndex]);
                throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
            }
        }
        this.logger.finest("end");
    }

    @Override
    public void execCommand(URL pWbemUrl, String pUser, String pPassword, boolean ignorecert) throws HFCVMUtilException, HFCCimClientException, HFCWSAPIException {
        this.logger.finest("start");
        this.wsApi = new HFCWSAPIWrapper();
        this.wsApi.Connect(pWbemUrl, pUser, pPassword, ignorecert);
        this.cimClient = new HFCCimClientWrapper(pWbemUrl, pUser, pPassword);
        try {
            this.execIsolateCommand();
        }
        catch (HFCVMUtilException e) {
            this.vmutilCom.doErrEndProc(this.wsApi, this.cimClient, e);
        }
        catch (HFCCimClientException e) {
            this.vmutilCom.doErrEndProc(this.wsApi, this.cimClient, e);
        }
        this.cimClient.close();
        this.wsApi.DisConnect();
        this.logger.finest("end");
    }

    private void execIsolateCommand() throws HFCVMUtilException, HFCCimClientException {
        CIMArgument[] pInputArg;
        this.logger.finest("start");
        CIMInstance fcPort = this.vmutilCom.getFCPortInstance(this.cimClient, this.vmhbaNoInt);
        if (fcPort == null) {
            this.logger.severe(String.valueOf(this.targetVmhbaNo) + " is not exist");
            throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_NO_VMHBA);
        }
        if (!this.executeForce) {
            if (this.subCmd == SubCommand.SET) {
                System.out.printf(SetCmdConfirmMsg, new Object[0]);
                if (!this.vmutilCom.confirmExecute(SetCmdConfirmYNMsg)) {
                    return;
                }
            } else {
                System.out.printf(ClearCmdConfirmMsg, new Object[0]);
                if (!this.vmutilCom.confirmExecute(ClearCmdConfirmYNMsg)) {
                    return;
                }
            }
        }
        HFCVMUtilCom.printTime();
        String methodName = this.subCmd == SubCommand.SET ? "ForceIsolate" : "RecoverIsolate";
        UnsignedInteger8 minorNo = (UnsignedInteger8)fcPort.getProperty("Minor").getValue();
        List<CIMObjectPath> portCtrlServList = this.cimClient.enumerateInstanceNames(HFCCimClientWrapper.getHfcnamespace(), "HFC_PortControlService");
        if (portCtrlServList.isEmpty()) {
            this.logger.severe("there is no HFC_PortControlService instance");
            throw new HFCVMUtilOperationException();
        }
        CIMObjectPath portCtrlServ = portCtrlServList.get(0);
        Object retval = this.cimClient.invokeMethod(portCtrlServ, methodName, pInputArg = new CIMArgument[]{new CIMArgument("DeviceNo", CIMDataType.UINT8_T, (Object)minorNo)}, null);
        if (!retval.toString().equals("0")) {
            this.logger.severe(String.valueOf(methodName) + " method error:" + retval.toString());
            throw new HFCVMUtilOperationException("Failed.");
        }
        System.out.println("Succeeded.");
        this.logger.finest("end");
    }

    private static enum SubCommand {
        SET,
        CLEAR;

    }
}

