/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.hfc.vmutil;

import com.hitachi.hfc.CimWrapper.HFCCimClientException;
import com.hitachi.hfc.WSWrapper.HFCWSAPIException;
import com.hitachi.hfc.vmutil.HFCVMUtilCom;
import com.hitachi.hfc.vmutil.HFCVMUtilException;
import com.hitachi.hfc.vmutil.HFCVMUtilFunc;
import com.hitachi.hfc.vmutil.HFCVMUtilInvalidArgException;
import com.hitachi.hfc.vmutil.HFCVMUtilInvalidArgExceptionType;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.logging.Logger;

class HFCVMUtilHelpFunc
implements HFCVMUtilFunc {
    private Logger logger = HFCVMUtilCom.getLogger();

    public HFCVMUtilHelpFunc() {
        this.logger.finest("called");
    }

    @Override
    public void checkParam(String[] args, int paramIndex) throws HFCVMUtilInvalidArgException {
        this.logger.finest("start");
        if (args.length != paramIndex) {
            this.logger.severe("param num err:" + args.length);
            throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
        }
        this.logger.finest("end");
    }

    @Override
    public void execCommand(URL pWbemUrl, String pUser, String pPassword, boolean ignorecert) throws HFCVMUtilException, HFCCimClientException, HFCWSAPIException {
        int selectNo;
        this.logger.finest("start");
        boolean SUPPORT_ISOLATE = true;
        long PORTDEF_KEY = 1L;
        long GENERAL_KEY = 2L;
        long PORT_KEY = 4L;
        long BOOT_KEY = 8L;
        long FIRM_KEY = 16L;
        long TARGET_KEY = 32L;
        long ONLINEUP_KEY = 64L;
        long ISOSTATUS_KEY = 128L;
        long ISOPORT_KEY = 256L;
        long ISOCMD_KEY = 512L;
        long ALL_KEY = -1L;
        long TGTSCAN_KEY = 1024L;
        HFCVMUtilHelpTable[] helpTbl = new HFCVMUtilHelpTable[]{new HFCVMUtilHelpTable(1L, "Port Definition"), new HFCVMUtilHelpTable(2L, "General Information"), new HFCVMUtilHelpTable(4L, "Port Information"), new HFCVMUtilHelpTable(8L, "Boot Information"), new HFCVMUtilHelpTable(16L, "Firm Backup/Update Execution"), new HFCVMUtilHelpTable(32L, "Display Target Information"), new HFCVMUtilHelpTable(64L, "Firm Online Update Execution"), new HFCVMUtilHelpTable(128L, "Isolate Status Information"), new HFCVMUtilHelpTable(256L, "Isolate Port Information"), new HFCVMUtilHelpTable(512L, "Isolate Command Information"), new HFCVMUtilHelpTable(1024L, "Initiate Target Scan"), new HFCVMUtilHelpTable(-1L, "All Commands")};
        System.out.println("-------------------------------------------------");
        System.out.println(" Please select the number you want to refer help.");
        System.out.println("-------------------------------------------------");
        int disp_cnt = 1;
        HFCVMUtilHelpTable[] hFCVMUtilHelpTableArray = helpTbl;
        int n = helpTbl.length;
        int n2 = 0;
        while (n2 < n) {
            HFCVMUtilHelpTable helpInfo = hFCVMUtilHelpTableArray[n2];
            if (helpInfo.getKey() == -1L) {
                System.out.printf("\n %-2d : %s\n", disp_cnt, helpInfo.getMessage());
            } else {
                System.out.printf(" %-2d : %s\n", disp_cnt, helpInfo.getMessage());
            }
            ++disp_cnt;
            ++n2;
        }
        while (true) {
            String res;
            BufferedReader r = new BufferedReader(new InputStreamReader(System.in), 1);
            System.out.println();
            System.out.printf("Enter Number > ", new Object[0]);
            try {
                res = r.readLine();
            }
            catch (Exception e) {
                this.logger.severe("read input data error:" + e.toString());
                throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_READ_INPUT_DATA, (Throwable)e);
            }
            if (res == null) continue;
            if (res.isEmpty()) {
                System.out.println();
                System.out.println("Please enter number");
                continue;
            }
            if (!res.matches("\\d+")) {
                System.out.println();
                System.out.println("Please input numeral");
                continue;
            }
            try {
                selectNo = Integer.parseInt(res);
            }
            catch (NumberFormatException e) {
                this.logger.severe(String.valueOf(res) + ":input data format err");
                throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_READ_INPUT_DATA, (Throwable)e);
            }
            if (selectNo > 0 && selectNo < disp_cnt) break;
            System.out.printf("\nInvalid input value.\n", new Object[0]);
        }
        int dispCmdIndex = selectNo - 1;
        System.out.println("------------------------------------------------------");
        System.out.println("hfcvmutil [<target IP address> <username> <password> {yes|no}] <commands> [<options>]");
        System.out.println("       ex. hfcvmutil -p <vmhbaXX>");
        System.out.println();
        System.out.println("common parameters");
        System.out.println("   <target IP address> : IP address of target host.");
        System.out.println("   <username> : Username of target host.");
        System.out.println("   <password> : Password of target host.");
        System.out.println("   <target IP address> : IP address of target host.");
        System.out.println("   {yes|no}   : yes:Ignore certification; no: otherwise");
        System.out.println("   <vmhbaXX>  : Specify Each HBA Port.");
        System.out.println("   all        : Specify common setting of All HBA Port.");
        System.out.println("   delete     : Delete operation.");
        System.out.println("------------------------------------------------------");
        if (helpTbl[dispCmdIndex].needToDispComDesc(1L)) {
            System.out.println();
            System.out.println("DISPLAY PORT DEFINITION INFORMATION");
            System.out.println("   -pd                           Display Port Definition information");
        }
        if (helpTbl[dispCmdIndex].needToDispComDesc(2L)) {
            System.out.println();
            System.out.println("DISPLAY SERVER/HBA INFORMATION");
            System.out.println("   -g                            Display Server/HBA information");
        }
        if (helpTbl[dispCmdIndex].needToDispComDesc(4L)) {
            System.out.println();
            System.out.println("PORT INFORMATION");
            System.out.println("   -p {<vmhbaXX>|all}            Display Port information");
            System.out.println();
            System.out.println("   -p [delete] <options> [force]");
            System.out.println("                   Set operation specify <parameter> <value>");
            System.out.println("                   Delete operation specify <parameter> [force]");
            System.out.println();
            System.out.println("          mt {1|4|8|16|32}          # Max Transfer Size");
            System.out.println("          ld <time>                 # Link Down Time (0-60)");
            System.out.println("          rd <time>                 # Reset Delay Time (0-60)");
            System.out.println("          mc <count>                # Machine Check Retry Count (0-10)");
            System.out.println("          rt <time>                 # Reset Timeout (0-60)");
            System.out.println("          at <time>                 # Abort Timeout (0-60)");
            System.out.println("          qd <depth>                # Queue Depth (1-256)");
            System.out.println("          ir {int|msi|msix}      *1 # Interrupt Type");
            System.out.println("          lm {def|disable}       *2 # Driver Logging Mode");
            System.out.println("          tf {no|pid}            *2 # Login Target filter");
            System.out.println("          force                     # omission of confirmation message");
            System.out.println("          *1:Setting value is different by Device.");
            System.out.println("          *2:Setting value is applied immediately");
        }
        if (helpTbl[dispCmdIndex].needToDispComDesc(8L)) {
            System.out.println();
            System.out.println("BOOT INFORMATION");
            System.out.println("   -b {<vmhbaXX>|all}              Display BOOT information");
        }
        if (helpTbl[dispCmdIndex].needToDispComDesc(16L)) {
            System.out.println();
            System.out.println("FIRMWARE BACKUP/UPDATE EXECUTION");
            System.out.println("   -f <vmhbaXX> backup [force]");
            System.out.println("   -f <vmhbaXX> update <Update File> [force]");
            System.out.println();
            System.out.println("       <option>");
            System.out.println("          force                  # omission of confirmation message");
        }
        if (helpTbl[dispCmdIndex].needToDispComDesc(32L)) {
            System.out.println();
            System.out.println("DISPLAY TARGET INFORMATION");
            System.out.println("   -t                            Display Target Device Information");
            System.out.println();
            System.out.println("    This command displays Target Device WWPN and LUN(Size).");
        }
        if (helpTbl[dispCmdIndex].needToDispComDesc(64L)) {
            System.out.println();
            System.out.println("FIRMWARE ONLINE UPDATE");
            System.out.println("   -u                            Firmware Update Judgment Display");
            System.out.println();
            System.out.println("   -u <vmhbaXX> [force]          Execute Online Update");
            System.out.println();
            System.out.println("       <option>");
            System.out.println("          force                  # omission of confirmation message");
        }
        if (helpTbl[dispCmdIndex].needToDispComDesc(256L)) {
            System.out.println();
            System.out.println("SPECIFIES ERROR THRESHOLD PORT INFORMATION");
            System.out.println("   -is -p {<vmhbaXX>|all}        Display Error Threshold Port");
            System.out.println();
            System.out.println("   -is -p [delete] <options>.. [force]");
            System.out.println("                                 Set/Delete Error Threshold Port");
            System.out.println();
            System.out.println("       <options> = <parameter> <value>");
            System.out.println("                   Set operation specify <parameter> <value>");
            System.out.println("                   Delete operation specify <parameter>");
            System.out.println();
            System.out.println("          ld <short count>       # detect link down time and count");
            System.out.println("             (0-30)");
            System.out.println("          fc <count>             # FC interface failure time and count");
            System.out.println("             (0-2048)");
            System.out.println("          sc <count>             # SCSI timeout failure time and count");
            System.out.println("             (0-30)");
            System.out.println("          rc {enable|disable}    # reset failure check after SCSI timeout");
            System.out.println("          tl <count>             # LOGIN start retry count after timeout");
            System.out.println("             (1-3)");
            System.out.println("          force                  # omission of confirmation message");
        }
        if (helpTbl[dispCmdIndex].needToDispComDesc(128L)) {
            System.out.println();
            System.out.println("ERROR THRESHOLD MONITOR");
            System.out.println("   -is [<vmhbaXX>]               Display current error status");
            System.out.println("   -is {on|off} [force]          Monitoring error, change on/off");
            System.out.println("       <options>");
            System.out.println("          on                     # error threshold function enable");
            System.out.println("          off                    # error threshold function disable");
            System.out.println("          force                  # omission of confirmation message");
        }
        if (helpTbl[dispCmdIndex].needToDispComDesc(512L)) {
            System.out.println();
            System.out.println("ISOLATE/CLEAR ADAPTER OR PORT AND DISPLAY");
            System.out.println("   -is -i <vmhbaXX> [force]      Execute Isolate Port");
            System.out.println("   -is -i <vmhbaXX> clear [force]Execute Recover Isolate Port");
            System.out.println("       <options>");
            System.out.println("          clear                  # clear Isolate HBA status");
            System.out.println("          force                  # omission of confirmation message");
        }
        if (helpTbl[dispCmdIndex].needToDispComDesc(1024L)) {
            System.out.println();
            System.out.println("INITIATE TARGET SCAN");
            System.out.println("   -scan {<vmhbaXX>|all}         Initiate Target Scan");
        }
        this.logger.finest("end");
    }

    private class HFCVMUtilHelpTable {
        private long Key;
        private String Message;

        public HFCVMUtilHelpTable(long pKey, String pMessage) {
            this.Key = pKey;
            this.Message = pMessage;
        }

        public String getMessage() {
            return this.Message;
        }

        public long getKey() {
            return this.Key;
        }

        public boolean needToDispComDesc(long pKey) {
            return (this.Key & pKey) != 0L;
        }
    }
}

