/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.hfc.vmutil;

import com.hitachi.hfc.CimWrapper.HFCCimClientException;
import com.hitachi.hfc.CimWrapper.HFCCimClientWrapper;
import com.hitachi.hfc.WSWrapper.HFCWSAPIException;
import com.hitachi.hfc.WSWrapper.HFCWSAPIWrapper;
import com.hitachi.hfc.vmutil.HFCVMUtilCom;
import com.hitachi.hfc.vmutil.HFCVMUtilException;
import com.hitachi.hfc.vmutil.HFCVMUtilFunc;
import com.hitachi.hfc.vmutil.HFCVMUtilInvalidArgException;
import com.hitachi.hfc.vmutil.HFCVMUtilInvalidArgExceptionType;
import com.hitachi.hfc.vmutil.HFCVMUtilOperationException;
import com.hitachi.hfc.vmutil.HFCVMUtilVer;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger8;

class HFCVMUtilGeneralFunc
implements HFCVMUtilFunc {
    private static final int SfpStatusFWNotSupported = 1;
    private static final int SfpStatusSfpNtoExist = 2;
    private static final int SfpStatusReadError = 4;
    private static final int sIDProviderCId = 1;
    private static final int sIDDriverCId = 2;
    private static final int sIDFirmwareCId = 10;
    private CIMObjectPath installServ = null;
    private String serialNumber;
    private String typeName;
    private String dateCode;
    private int sfpStatus;
    private HFCWSAPIWrapper wsApi;
    private HFCCimClientWrapper cimClient;
    private HFCVMUtilCom vmutilCom;
    private Logger logger = HFCVMUtilCom.getLogger();

    public HFCVMUtilGeneralFunc() {
        this.logger.finest("called");
    }

    @Override
    public void checkParam(String[] args, int paramIndex) throws HFCVMUtilInvalidArgException {
        this.logger.finest("start");
        if (args.length != paramIndex) {
            this.logger.severe("param num err:" + args.length);
            throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
        }
        this.logger.finest("end");
    }

    @Override
    public void execCommand(URL pWbemUrl, String pUser, String pPassword, boolean ignorecert) throws HFCVMUtilException, HFCCimClientException, HFCWSAPIException {
        this.logger.finest("start");
        HFCVMUtilCom.printTime();
        this.wsApi = new HFCWSAPIWrapper();
        this.wsApi.Connect(pWbemUrl, pUser, pPassword, ignorecert);
        this.cimClient = new HFCCimClientWrapper(pWbemUrl, pUser, pPassword);
        this.vmutilCom = HFCVMUtilCom.getInstance();
        try {
            this.displayAdapterInfo();
        }
        catch (HFCVMUtilOperationException e) {
            this.vmutilCom.doErrEndProc(this.wsApi, this.cimClient, e);
        }
        catch (HFCCimClientException e) {
            this.vmutilCom.doErrEndProc(this.wsApi, this.cimClient, e);
        }
        this.cimClient.close();
        this.wsApi.DisConnect();
        this.logger.finest("end");
    }

    private void displayAdapterInfo() throws HFCVMUtilOperationException, HFCCimClientException {
        this.logger.finest("start");
        List<CIMInstance> compLIst = this.cimClient.enumerateInstances(HFCCimClientWrapper.getHfcnamespace(), "HFC_ComputerSystem");
        if (compLIst.isEmpty()) {
            return;
        }
        CIMInstance comp = compLIst.get(0);
        List<CIMInstance> sIDList = this.cimClient.enumerateInstances(HFCCimClientWrapper.getHfcnamespace(), "HFC_SoftwareIdentity");
        CIMInstance driverSID = null;
        CIMInstance providerSID = null;
        for (CIMInstance sIDIns : sIDList) {
            UnsignedInteger16[] classIDInt = (UnsignedInteger16[])sIDIns.getProperty("Classifications").getValue();
            int classID = classIDInt[0].intValue();
            if (classID == 2) {
                driverSID = sIDIns;
                continue;
            }
            if (classID != 1) continue;
            providerSID = sIDIns;
        }
        if (driverSID == null || providerSID == null) {
            this.logger.severe("there is no HFC_SoftwareIdentity instance");
            throw new HFCVMUtilOperationException();
        }
        List<CIMInstance> pPacList = this.cimClient.enumerateInstances(HFCCimClientWrapper.getHfcnamespace(), "HFC_PhysicalPackage");
        HashSet<String> aIDList = new HashSet<String>();
        for (CIMInstance sIDIns : pPacList) {
            aIDList.add(sIDIns.getProperty("AdapterID").getValue().toString());
        }
        System.out.println("----------------------------------------------------------------");
        System.out.println("Host Name\t\t: " + comp.getProperty("Name").getValue().toString());
        String[] idInfo = (String[])comp.getProperty("OtherIdentifyingInfo").getValue();
        if (idInfo.length == 0) {
            this.logger.severe("there is no HFC_ComputerSystem OtherIdentifyingInfo property");
            throw new HFCVMUtilOperationException();
        }
        String[] buildInfo = idInfo[0].split(" ");
        if (buildInfo.length == 0) {
            this.logger.severe("HFC_ComputerSystem OtherIdentifyingInfo property format error:" + idInfo[0]);
            throw new HFCVMUtilOperationException();
        }
        String buildDisp = idInfo[0].replaceFirst(String.valueOf(buildInfo[0]) + " ", "");
        System.out.println("Build Number            : " + buildDisp);
        System.out.println("Driver Version          : " + driverSID.getProperty("VersionString").getValue().toString());
        System.out.println("CIM Provider Version    : " + providerSID.getProperty("VersionString").getValue().toString());
        System.out.println("CIM Client Version      : " + HFCVMUtilVer.getVersion());
        System.out.println("----------------------------------------------------------------");
        for (String aID : aIDList) {
            int portNum = 0;
            for (CIMInstance sIDIns : pPacList) {
                if (!sIDIns.getProperty("AdapterID").getValue().toString().equals(aID)) continue;
                List<CIMInstance> fcPortList = this.cimClient.associators(sIDIns.getObjectPath(), "HFC_Realizes", "HFC_FCPort");
                if (fcPortList.isEmpty()) {
                    this.logger.severe("there is no HFC_FCPort instance");
                    throw new HFCVMUtilOperationException();
                }
                CIMInstance fcPort = fcPortList.get(0);
                if (portNum == 0) {
                    UnsignedInteger32 vID = (UnsignedInteger32)sIDIns.getProperty("VendorSpecID").getValue();
                    UnsignedInteger32 dID = (UnsignedInteger32)sIDIns.getProperty("DeviceID").getValue();
                    System.out.printf("Vender ID : %x\n", vID.longValue());
                    System.out.printf("Device ID : %x\n", dID.longValue());
                    System.out.println("Manufacturer ID : " + sIDIns.getProperty("Manufacturer").getValue().toString());
                    System.out.println("Parts number : " + sIDIns.getProperty("PartNumber").getValue().toString());
                    System.out.println("EC level : " + sIDIns.getProperty("EcLevel").getValue().toString());
                    System.out.println("Model name : " + sIDIns.getProperty("Model").getValue().toString());
                    List<CIMInstance> fwsIDList = this.cimClient.associators(fcPort.getObjectPath(), "HFC_FCPortSoftwareIdentity", "HFC_SoftwareIdentity");
                    if (fwsIDList.isEmpty()) {
                        this.logger.severe("there is no HFC_SoftwareIdentity instance");
                        throw new HFCVMUtilOperationException();
                    }
                    for (CIMInstance fwSid : fwsIDList) {
                        UnsignedInteger16[] classIDInt = (UnsignedInteger16[])fwSid.getProperty("Classifications").getValue();
                        if (classIDInt.length == 0) {
                            this.logger.severe("there is no HFC_SoftwareIdentity Classifications property");
                            throw new HFCVMUtilOperationException();
                        }
                        int classID = classIDInt[0].intValue();
                        if (classID != 10) continue;
                        System.out.println("Firmware : " + fwSid.getProperty("VersionString").getValue().toString());
                        break;
                    }
                }
                ++portNum;
                this.getSfpInfo(fcPort);
                UnsignedInteger8 portStatusInt = (UnsignedInteger8)fcPort.getProperty("FCPortStatus").getValue();
                int portStatus = portStatusInt.intValue();
                String portStatusStr = this.vmutilCom.getPortStatus(portStatus);
                System.out.printf("vmhba%s (hfcldd%s) WWPN:%s Location:%s Status:%s\n", fcPort.getProperty("VmhbaNo").getValue().toString(), fcPort.getProperty("Minor").getValue().toString(), fcPort.getProperty("PermanentAddress").getValue().toString(), sIDIns.getProperty("BusDevFunc").getValue().toString(), portStatusStr);
                if ((this.sfpStatus & 1) != 0) {
                    System.out.println("This Firmware version does not support hot swap feature of SFP Transceiver");
                    continue;
                }
                if ((this.sfpStatus & 2) != 0) {
                    System.out.println("SFP Part Number   : N/A");
                    System.out.println("    Serial Number : N/A");
                    System.out.println("    Date Code     : N/A");
                    System.out.println("    Transceiver Replacement : " + this.vmutilCom.getTransReplacement(portStatus));
                    continue;
                }
                if ((this.sfpStatus & 4) != 0) {
                    System.out.println("SFP Part Number   : incorrect data (" + this.typeName + ")");
                    System.out.println("    Serial Number : incorrect data (" + this.serialNumber + ")");
                    System.out.println("    Date Code     : incorrect data (" + this.dateCode + ")");
                    System.out.println("    Transceiver Replacement : " + this.vmutilCom.getTransReplacement(portStatus));
                    continue;
                }
                System.out.println("SFP Part Number   : " + this.typeName);
                System.out.println("    Serial Number : " + this.serialNumber);
                System.out.println("    Date Code     : " + this.dateCode);
                System.out.println("    Transceiver Replacement : " + this.vmutilCom.getTransReplacement(portStatus));
            }
            System.out.println("");
        }
        this.logger.finest("end");
    }

    private void getSfpInfo(CIMInstance pFcPort) throws HFCVMUtilOperationException, HFCCimClientException {
        this.logger.finest("start");
        String minorNo = pFcPort.getProperty("Minor").getValue().toString();
        if (this.installServ == null) {
            List<CIMObjectPath> installServList = this.cimClient.enumerateInstanceNames(HFCCimClientWrapper.getHfcnamespace(), "HFC_SoftwareInstallationService");
            if (installServList.isEmpty()) {
                this.logger.severe("there is no HFC_SoftwareInstallationService instance");
                throw new HFCVMUtilOperationException();
            }
            this.installServ = installServList.get(0);
        }
        CIMArgument[] pInputArg = new CIMArgument[1];
        CIMArgument[] pOutputArg = new CIMArgument[10];
        pInputArg[0] = new CIMArgument("DeviceName", CIMDataType.STRING_T, (Object)minorNo);
        Object retval = this.cimClient.invokeMethod(this.installServ, "GetSfpInfo", pInputArg, pOutputArg);
        if (!retval.toString().equals("0")) {
            this.logger.severe("GetSfpInfo error:" + retval.toString());
            throw new HFCVMUtilOperationException();
        }
        this.serialNumber = null;
        this.typeName = null;
        this.dateCode = null;
        UnsignedInteger8 sfpStatusInt = null;
        CIMArgument[] cIMArgumentArray = pOutputArg;
        int n = pOutputArg.length;
        int n2 = 0;
        while (n2 < n) {
            CIMArgument outArg = cIMArgumentArray[n2];
            if (outArg != null) {
                if (outArg.getName().equals("SerialNumber")) {
                    this.serialNumber = outArg.getValue().toString();
                } else if (outArg.getName().equals("TypeName")) {
                    this.typeName = outArg.getValue().toString();
                } else if (outArg.getName().equals("DateCode")) {
                    this.dateCode = outArg.getValue().toString();
                } else if (outArg.getName().equals("Status")) {
                    sfpStatusInt = (UnsignedInteger8)outArg.getValue();
                }
            }
            ++n2;
        }
        if (this.serialNumber == null || this.typeName == null || this.dateCode == null || sfpStatusInt == null) {
            this.logger.severe("Failed to get sfp info");
            throw new HFCVMUtilOperationException();
        }
        this.sfpStatus = sfpStatusInt.intValue();
        this.logger.finest("end");
    }
}

