/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.hfc.vmutil;

import com.hitachi.hfc.CimWrapper.HFCCimClientException;
import com.hitachi.hfc.CimWrapper.HFCCimClientWrapper;
import com.hitachi.hfc.WSWrapper.HFCWSAPIException;
import com.hitachi.hfc.WSWrapper.HFCWSAPIWrapper;
import com.hitachi.hfc.vmutil.HFCVMUtilCom;
import com.hitachi.hfc.vmutil.HFCVMUtilException;
import com.hitachi.hfc.vmutil.HFCVMUtilFunc;
import com.hitachi.hfc.vmutil.HFCVMUtilInvalidArgException;
import com.hitachi.hfc.vmutil.HFCVMUtilInvalidArgExceptionType;
import com.hitachi.hfc.vmutil.HFCVMUtilOperationException;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;

class HFCVMUtilFirmFunc
implements HFCVMUtilFunc {
    private static final String UpdateFileNameInHost = "HFCFLASH";
    private static final int FirmVerStartOff = 36;
    private static final int FirmVerEndLen = 40;
    private HFCWSAPIWrapper wsApi;
    private HFCCimClientWrapper cimClient;
    private HFCVMUtilCom vmutilCom;
    private SubCommand subCmd = SubCommand.BACKUP;
    private boolean executeForce = false;
    private String targetVmhbaNo;
    private int vmhbaNoInt;
    private String UpdateFilePath;
    private Logger logger = HFCVMUtilCom.getLogger();

    public HFCVMUtilFirmFunc() {
        this.logger.finest("called");
        this.vmutilCom = HFCVMUtilCom.getInstance();
    }

    @Override
    public void checkParam(String[] args, int paramIndex) throws HFCVMUtilInvalidArgException {
        this.logger.finest("start");
        if (args.length < paramIndex + 2 || args.length > paramIndex + 4) {
            this.logger.severe("param num err:" + args.length);
            throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
        }
        if (!args[paramIndex].matches(String.valueOf(HFCVMUtilCom.getHfcVmhbaNoPrefix()) + "\\d+")) {
            this.logger.severe(String.valueOf(args[paramIndex]) + ":vmhbaNo format err");
            throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_VMHBA);
        }
        this.targetVmhbaNo = args[paramIndex];
        this.vmhbaNoInt = this.vmutilCom.getVmhbaNo(this.targetVmhbaNo);
        if (args[++paramIndex].equals("backup")) {
            this.subCmd = SubCommand.BACKUP;
        } else if (args[paramIndex].equals("update")) {
            this.subCmd = SubCommand.UPDATE;
            if (args.length < ++paramIndex + 1) {
                this.logger.severe("param num err:" + args.length);
                throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
            }
            this.UpdateFilePath = args[paramIndex];
            File file = new File(this.UpdateFilePath);
            if (!file.isFile()) {
                this.logger.severe(String.valueOf(this.UpdateFilePath) + " is not file");
                throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_NO_FILE);
            }
        } else {
            this.logger.severe("unknown parameter:" + args[paramIndex]);
            throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
        }
        if (args.length == ++paramIndex + 1) {
            if (args[paramIndex].equals("force")) {
                this.executeForce = true;
            } else {
                this.logger.severe("unknown parameter:" + args[paramIndex]);
                throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
            }
        }
        this.logger.finest("end");
    }

    @Override
    public void execCommand(URL pWbemUrl, String pUser, String pPassword, boolean ignorecert) throws HFCVMUtilException, HFCCimClientException, HFCWSAPIException {
        this.logger.finest("start");
        this.wsApi = new HFCWSAPIWrapper();
        this.wsApi.Connect(pWbemUrl, pUser, pPassword, ignorecert);
        this.cimClient = new HFCCimClientWrapper(pWbemUrl, pUser, pPassword);
        try {
            this.execFirmCommand();
        }
        catch (HFCVMUtilException e) {
            this.vmutilCom.doErrEndProc(this.wsApi, this.cimClient, e);
        }
        catch (HFCCimClientException e) {
            this.vmutilCom.doErrEndProc(this.wsApi, this.cimClient, e);
        }
        catch (HFCWSAPIException e) {
            this.vmutilCom.doErrEndProc(this.wsApi, this.cimClient, e);
        }
        this.cimClient.close();
        this.wsApi.DisConnect();
        this.logger.finest("end");
    }

    private void execFirmCommand() throws HFCVMUtilException, HFCCimClientException, HFCWSAPIException {
        this.logger.finest("start");
        switch (this.subCmd) {
            case BACKUP: {
                this.backupFirm();
                break;
            }
            case UPDATE: {
                this.updateFirm();
            }
        }
        this.logger.finest("end");
    }

    private void backupFirm() throws HFCVMUtilException, HFCCimClientException {
        this.logger.finest("start");
        CIMInstance fcPort = this.vmutilCom.getFCPortInstance(this.cimClient, this.vmhbaNoInt);
        if (fcPort == null) {
            this.logger.severe(String.valueOf(this.targetVmhbaNo) + " is not exist");
            throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_NO_VMHBA);
        }
        System.out.println("");
        System.out.println("Port : " + this.targetVmhbaNo);
        if (!this.executeForce && !this.vmutilCom.confirmExecute("Do you execute it?")) {
            return;
        }
        HFCVMUtilCom.printTime();
        String minorNo = fcPort.getProperty("Minor").getValue().toString();
        List<CIMObjectPath> installServList = this.cimClient.enumerateInstanceNames(HFCCimClientWrapper.getHfcnamespace(), "HFC_SoftwareInstallationService");
        if (installServList.isEmpty()) {
            this.logger.severe("there is no HFC_SoftwareInstallationService instance");
            throw new HFCVMUtilOperationException();
        }
        CIMObjectPath installServ = installServList.get(0);
        CIMArgument[] pInputArg = new CIMArgument[1];
        CIMArgument[] pOutputArg = new CIMArgument[2];
        pInputArg[0] = new CIMArgument("DeviceName", CIMDataType.STRING_T, (Object)minorNo);
        Object retval = this.cimClient.invokeMethod(installServ, "BackupFlashROM", pInputArg, pOutputArg);
        if (retval.toString().equals("0")) {
            System.out.println("Success.");
            CIMArgument[] cIMArgumentArray = pOutputArg;
            int n = pOutputArg.length;
            int n2 = 0;
            while (n2 < n) {
                CIMArgument outArg = cIMArgumentArray[n2];
                if (outArg != null && outArg.getName().equals("BackupFilePath")) {
                    System.out.println("backup file is " + outArg.getValue());
                }
                ++n2;
            }
        } else {
            CIMArgument[] cIMArgumentArray = pOutputArg;
            int n = pOutputArg.length;
            int n3 = 0;
            while (n3 < n) {
                CIMArgument outArg = cIMArgumentArray[n3];
                if (outArg != null && outArg.getName().equals("ErrorMessage")) {
                    this.logger.severe(outArg.getValue().toString());
                    throw new HFCVMUtilOperationException("Failed.(" + outArg.getValue().toString().replaceAll("\n", "") + ")");
                }
                ++n3;
            }
            this.logger.severe("BackupFlashROM error:" + retval.toString());
            throw new HFCVMUtilOperationException("Failed.(Operation Failed)");
        }
        this.logger.finest("end");
    }

    private void updateFirm() throws HFCVMUtilException, HFCCimClientException, HFCWSAPIException {
        int readSize;
        this.logger.finest("start");
        System.out.println("Firmware update file : " + this.UpdateFilePath);
        System.out.println("");
        System.out.println("Port : " + this.targetVmhbaNo);
        byte[] firmVer = new byte[40];
        try {
            FileInputStream fs = new FileInputStream(this.UpdateFilePath);
            readSize = fs.read(firmVer, 0, 40);
            fs.close();
        }
        catch (Exception e) {
            this.logger.severe("failed read firm current version from update file:" + e.toString());
            throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_FILE_READ, (Throwable)e);
        }
        if (readSize != 40) {
            this.logger.severe("read size only " + String.valueOf(readSize) + " from url");
            throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_FILE_FORMAT);
        }
        long newVer = 0L;
        int i = 36;
        while (i < 40) {
            newVer = (long)(firmVer[i] & 0xFF) + (newVer << 8);
            i = (byte)(i + 1);
        }
        CIMInstance fcPort = this.vmutilCom.getFCPortInstance(this.cimClient, this.vmhbaNoInt);
        if (fcPort == null) {
            this.logger.severe(String.valueOf(this.targetVmhbaNo) + " is not exist");
            throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_NO_VMHBA);
        }
        String minorNo = fcPort.getProperty("Minor").getValue().toString();
        List<CIMObjectPath> installServList = this.cimClient.enumerateInstanceNames(HFCCimClientWrapper.getHfcnamespace(), "HFC_SoftwareInstallationService");
        if (installServList.isEmpty()) {
            this.logger.severe("there is no HFC_SoftwareInstallationService instance");
            throw new HFCVMUtilOperationException();
        }
        CIMObjectPath installServ = installServList.get(0);
        String currentVer = this.getCurrentFirmVer(installServ, minorNo);
        System.out.println("Current Version : " + currentVer);
        System.out.printf("New Version     : %x\n", newVer);
        if (!this.executeForce && !this.vmutilCom.confirmExecute("Do you execute it?")) {
            return;
        }
        HFCVMUtilCom.printTime();
        this.wsApi.PutFilesToHostTmp(this.UpdateFilePath, UpdateFileNameInHost);
        CIMArgument[] pInputArg = new CIMArgument[2];
        CIMArgument[] pOutputArg = new CIMArgument[1];
        pInputArg[0] = new CIMArgument("UpdateFilePath", CIMDataType.STRING_T, (Object)"/tmp/HFCFLASH");
        pInputArg[1] = new CIMArgument("DeviceName", CIMDataType.STRING_T, (Object)minorNo);
        Object retval = this.cimClient.invokeMethod(installServ, "UpdateFlashROM", pInputArg, pOutputArg);
        if (!retval.toString().equals("0")) {
            if (pOutputArg[0] != null) {
                this.logger.severe(pOutputArg[0].getValue().toString());
                throw new HFCVMUtilOperationException("Failed.(" + pOutputArg[0].getValue().toString().replaceAll("\n", "") + ")");
            }
            this.logger.severe("UpdateFlashROM error:" + retval.toString());
            throw new HFCVMUtilOperationException("Failed.(Operation Failed)");
        }
        System.out.println("Success.");
        this.logger.finest("end");
    }

    private String getCurrentFirmVer(CIMObjectPath installServ, String minorNo) throws HFCVMUtilOperationException, HFCCimClientException {
        this.logger.finest("start");
        CIMArgument[] pInputArg = new CIMArgument[1];
        CIMArgument[] pOutputArg = new CIMArgument[2];
        pInputArg[0] = new CIMArgument("DeviceName", CIMDataType.STRING_T, (Object)minorNo);
        Object retval = this.cimClient.invokeMethod(installServ, "GetFirmVersion", pInputArg, pOutputArg);
        if (retval.toString().equals("0")) {
            CIMArgument[] cIMArgumentArray = pOutputArg;
            int n = pOutputArg.length;
            int n2 = 0;
            while (n2 < n) {
                CIMArgument outArg = cIMArgumentArray[n2];
                if (outArg != null && outArg.getName().equals("FirmVersion")) {
                    this.logger.finest("end");
                    return outArg.getValue().toString();
                }
                ++n2;
            }
            this.logger.severe("there is no FirmVersion parameter");
            throw new HFCVMUtilOperationException();
        }
        CIMArgument[] cIMArgumentArray = pOutputArg;
        int n = pOutputArg.length;
        int n3 = 0;
        while (n3 < n) {
            CIMArgument outArg = cIMArgumentArray[n3];
            if (outArg != null && outArg.getName().equals("ErrorMessage")) {
                this.logger.severe(outArg.getValue().toString());
                throw new HFCVMUtilOperationException("Failed.(" + outArg.getValue().toString().replaceAll("\n", "") + ")");
            }
            ++n3;
        }
        this.logger.severe("FirmVersion error:" + retval.toString());
        throw new HFCVMUtilOperationException("Failed.(Operation Failed)");
    }

    private static enum SubCommand {
        BACKUP,
        UPDATE;

    }
}

