/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.hfc.vmutil;

import com.hitachi.hfc.CimWrapper.HFCCimClientException;
import com.hitachi.hfc.CimWrapper.HFCCimClientWrapper;
import com.hitachi.hfc.vmutil.HFCVMUtilCom;
import com.hitachi.hfc.vmutil.HFCVMUtilDriverParamType;
import com.hitachi.hfc.vmutil.HFCVMUtilOperationException;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMObjectPath;
import javax.cim.UnsignedInteger8;

class HFCVMUtilDriverParam {
    private Logger logger = HFCVMUtilCom.getLogger();
    private Map<HFCVMUtilDriverParamType, String> AllInsParamNameList;
    private static final String MaxTransParamName = "hfc_max_transfer";
    private static final String LinkDownParamName = "hfc_link_down";
    private static final String ResetDelayParamName = "hfc_reset_delay";
    private static final String MckRetryParamName = "hfc_mck_retry";
    private static final String ResetTimeoutParamName = "hfc_reset_timeout";
    private static final String AbortTimeoutParamName = "hfc_abort_timeout";
    private static final String QueuedepthParamName = "hfc_queue_depth";
    private static final String MsiEnableParamName = "hfc_msi_enable";
    private static final String HbaIsolationParamName = "hfc_hba_isolation";
    private static final String LdErrLimSParamName = "hfc_ld_err_limit_s";
    private static final String IfErrLimParamName = "hfc_if_err_limit";
    private static final String ToErrLimParamName = "hfc_to_err_limit";
    private static final String ToResetRetryParamName = "hfc_to_reset_retry";
    private static final String RtErrEnableParamName = "hfc_rt_err_enable";
    private static final String LimitLogParamName = "hfc_limit_log";
    private static final String FilterTargetParamName = "hfc_filter_target";

    public HFCVMUtilDriverParam() {
        this.logger.finest("start");
        this.AllInsParamNameList = new EnumMap<HFCVMUtilDriverParamType, String>(HFCVMUtilDriverParamType.class);
        this.AllInsParamNameList.put(HFCVMUtilDriverParamType.MaxTrans, MaxTransParamName);
        this.AllInsParamNameList.put(HFCVMUtilDriverParamType.LinkDown, LinkDownParamName);
        this.AllInsParamNameList.put(HFCVMUtilDriverParamType.ResetDelay, ResetDelayParamName);
        this.AllInsParamNameList.put(HFCVMUtilDriverParamType.MckRetry, MckRetryParamName);
        this.AllInsParamNameList.put(HFCVMUtilDriverParamType.ResetTimeout, ResetTimeoutParamName);
        this.AllInsParamNameList.put(HFCVMUtilDriverParamType.AbortTimeout, AbortTimeoutParamName);
        this.AllInsParamNameList.put(HFCVMUtilDriverParamType.Queuedepth, QueuedepthParamName);
        this.AllInsParamNameList.put(HFCVMUtilDriverParamType.MsiEnable, MsiEnableParamName);
        this.AllInsParamNameList.put(HFCVMUtilDriverParamType.HbaIsolation, HbaIsolationParamName);
        this.AllInsParamNameList.put(HFCVMUtilDriverParamType.LdErrLimS, LdErrLimSParamName);
        this.AllInsParamNameList.put(HFCVMUtilDriverParamType.IfErrLim, IfErrLimParamName);
        this.AllInsParamNameList.put(HFCVMUtilDriverParamType.ToErrLim, ToErrLimParamName);
        this.AllInsParamNameList.put(HFCVMUtilDriverParamType.ToResetRetry, ToResetRetryParamName);
        this.AllInsParamNameList.put(HFCVMUtilDriverParamType.RtErrEnable, RtErrEnableParamName);
        this.AllInsParamNameList.put(HFCVMUtilDriverParamType.LimitLog, LimitLogParamName);
        this.AllInsParamNameList.put(HFCVMUtilDriverParamType.FilterTarget, FilterTargetParamName);
        this.logger.finest("end");
    }

    public void setDriverParam(HFCCimClientWrapper cimClient, Map<HFCVMUtilDriverParamType, String> setParamList) throws HFCCimClientException, HFCVMUtilOperationException {
        this.logger.finest("start");
        List<CIMObjectPath> portCtrlServList = cimClient.enumerateInstanceNames(HFCCimClientWrapper.getHfcnamespace(), "HFC_PortControlService");
        if (portCtrlServList.isEmpty()) {
            this.logger.severe("there is no HFC_PortControlService instance");
            throw new HFCVMUtilOperationException("No hfcldd port");
        }
        CIMObjectPath portCtrlServ = portCtrlServList.get(0);
        CIMArgument[] pInputArg = new CIMArgument[1];
        int paramNum = setParamList.size();
        String[] param = new String[paramNum];
        Set<HFCVMUtilDriverParamType> setParamKeySet = setParamList.keySet();
        Iterator<HFCVMUtilDriverParamType> setParamKeyIte = setParamKeySet.iterator();
        int i = 0;
        while (i < paramNum && setParamKeyIte.hasNext()) {
            HFCVMUtilDriverParamType paramType = setParamKeyIte.next();
            String paramName = this.AllInsParamNameList.get((Object)paramType);
            String paramValue = setParamList.get((Object)paramType);
            param[i] = String.valueOf(paramName) + "=" + paramValue;
            ++i;
        }
        pInputArg[0] = new CIMArgument("Param", CIMDataType.STRING_ARRAY_T, (Object)param);
        Object retval = cimClient.invokeMethod(portCtrlServ, "SetDriverParam", pInputArg, null);
        if (!retval.toString().equals("0")) {
            this.logger.severe("SetDriverParam method fail ret:" + retval.toString());
            throw new HFCVMUtilOperationException();
        }
        this.logger.finest("end");
    }

    public void deleteDriverParam(HFCCimClientWrapper cimClient, Set<HFCVMUtilDriverParamType> deleteParamList) throws HFCCimClientException, HFCVMUtilOperationException {
        this.logger.finest("start");
        List<CIMObjectPath> portCtrlServList = cimClient.enumerateInstanceNames(HFCCimClientWrapper.getHfcnamespace(), "HFC_PortControlService");
        if (portCtrlServList.isEmpty()) {
            this.logger.severe("there is no HFC_PortControlService instance");
            throw new HFCVMUtilOperationException("No hfcldd port");
        }
        CIMObjectPath portCtrlServ = portCtrlServList.get(0);
        CIMArgument[] pInputArg = new CIMArgument[1];
        int paramNum = deleteParamList.size();
        String[] param = new String[paramNum];
        Iterator<HFCVMUtilDriverParamType> deleteParamIte = deleteParamList.iterator();
        int i = 0;
        while (i < paramNum && deleteParamIte.hasNext()) {
            String paramName;
            HFCVMUtilDriverParamType paramType = deleteParamIte.next();
            param[i] = paramName = this.AllInsParamNameList.get((Object)paramType);
            ++i;
        }
        pInputArg[0] = new CIMArgument("Param", CIMDataType.STRING_ARRAY_T, (Object)param);
        Object retval = cimClient.invokeMethod(portCtrlServ, "DeleteDriverParam", pInputArg, null);
        if (!retval.toString().equals("0")) {
            this.logger.severe("DeleteDriverParam method fail ret:" + retval.toString());
            throw new HFCVMUtilOperationException();
        }
        this.logger.finest("end");
    }

    public void immediateApply(HFCCimClientWrapper cimClient, short mode, short opr, short value) throws HFCCimClientException, HFCVMUtilOperationException {
        this.logger.finest("start");
        this.logger.finest("mode=" + mode + "  opr=" + opr + "  val=" + value);
        List<CIMObjectPath> portCtrlServList = cimClient.enumerateInstanceNames(HFCCimClientWrapper.getHfcnamespace(), "HFC_PortControlService");
        if (portCtrlServList.isEmpty()) {
            this.logger.severe("there is no HFC_PortControlService instance");
            throw new HFCVMUtilOperationException("No hfcldd port");
        }
        CIMObjectPath portCtrlServ = portCtrlServList.get(0);
        CIMArgument[] pInputArg = new CIMArgument[3];
        CIMArgument[] pOutputArg = new CIMArgument[2];
        pInputArg[0] = new CIMArgument("Mode", CIMDataType.UINT8_T, (Object)new UnsignedInteger8(mode));
        pInputArg[1] = new CIMArgument("Opr", CIMDataType.UINT8_T, (Object)new UnsignedInteger8(opr));
        pInputArg[2] = new CIMArgument("Val", CIMDataType.UINT8_T, (Object)new UnsignedInteger8(value));
        Object retval = cimClient.invokeMethod(portCtrlServ, "SetLoggingMode", pInputArg, pOutputArg);
        if (!retval.toString().equals("0")) {
            CIMArgument[] cIMArgumentArray = pOutputArg;
            int n = pOutputArg.length;
            int n2 = 0;
            while (n2 < n) {
                CIMArgument outArg = cIMArgumentArray[n2];
                if (outArg != null) {
                    if (outArg.getName().equals("ErrorMessage")) {
                        this.logger.severe(outArg.getValue().toString());
                        throw new HFCVMUtilOperationException("Failed.(" + outArg.getValue().toString().replaceAll("\n", "") + ")");
                    }
                    if (outArg.getName().equals("DetailedMessage")) {
                        String[] DetailedMessage;
                        String[] stringArray = DetailedMessage = (String[])outArg.getValue();
                        int n3 = DetailedMessage.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String errMsg = stringArray[n4];
                            System.out.println(errMsg);
                            this.logger.severe(errMsg);
                            ++n4;
                        }
                        System.out.println("");
                        throw new HFCVMUtilOperationException("Failed.");
                    }
                }
                ++n2;
            }
            this.logger.severe("LoggingMode or Login Target Filter error:" + retval.toString());
            throw new HFCVMUtilOperationException("Failed.(Operation Failed)");
        }
        System.out.println("Succeeded.");
        this.logger.finest("end");
    }
}

