/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.hfc.vmutil;

import com.hitachi.hfc.CimWrapper.HFCCimClientException;
import com.hitachi.hfc.CimWrapper.HFCCimClientWrapper;
import com.hitachi.hfc.WSWrapper.HFCWSAPIException;
import com.hitachi.hfc.WSWrapper.HFCWSAPIWrapper;
import com.hitachi.hfc.vmutil.HFCVMUtilException;
import com.hitachi.hfc.vmutil.HFCVMUtilInvalidArgException;
import com.hitachi.hfc.vmutil.HFCVMUtilInvalidArgExceptionType;
import com.hitachi.hfc.vmutil.HFCVMUtilOperationException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.cim.CIMInstance;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger8;

class HFCVMUtilCom {
    public static final boolean DEBUG = true;
    private static final String HfcModuleName = "hfcldd";
    private static final String HfcVmhbaNoPrefix = "vmhba";
    private static final String HfcMinorNoPrefix = "hfcldd";
    private static final int PortStatusLinkUp = 0;
    private static final int PortStatusWaitLinkUp = 1;
    private static final int PortStatusLinkDown = 2;
    private static final int PortStatusIsolateC = 3;
    private static final int PortStatusIsolateE = 4;
    private static final int PortStatusSfpFail = 5;
    private static final int PortStatusSfpNotSupport = 6;
    private static final int PortStatusSfpDown = 7;
    private static final int PortStatusChkStpE = 8;
    private static final int ConTypPtoPF = 2;
    private static final int ConTypPtoP = 3;
    private static final int ConTypFcAlF = 4;
    private static final int ConTypFcAl = 5;
    private static final int InterruptLegacyType = 0;
    private static final int InterruptMsiType = 1;
    private static final int InterruptMsiXType = 2;
    private static final int LoggingModeDefault = 0;
    private static final int LoggingModeDisable = 1;
    private static final int FilterTargetDefault = 0;
    private static final int FilterTargetPid = 1;
    private Map<Integer, String> PortStatusMap;
    private Map<Integer, String> ConTypMap;
    private Map<Integer, String> InteruptMap;
    private List<Integer> ReplaceablePortStatus;
    private Map<Integer, String> LoggingModeMap;
    private Map<Integer, String> FilteringModeMap;
    private Logger logger = Logger.getLogger("com.hitachi.hfc.vmutil");
    private static HFCVMUtilCom instance = new HFCVMUtilCom();

    private HFCVMUtilCom() {
        this.logger.finest("start");
        this.PortStatusMap = new HashMap<Integer, String>();
        this.PortStatusMap.put(new Integer(0), "LinkUp");
        this.PortStatusMap.put(new Integer(1), "WaitLinkUp");
        this.PortStatusMap.put(new Integer(2), "LinkDown");
        this.PortStatusMap.put(new Integer(3), "Isolate(C)");
        this.PortStatusMap.put(new Integer(4), "Isolate(E)");
        this.PortStatusMap.put(new Integer(5), "Isolate(SFPFail)");
        this.PortStatusMap.put(new Integer(6), "Isolate(SFPNotSupport)");
        this.PortStatusMap.put(new Integer(7), "Isolate(SFPDown)");
        this.PortStatusMap.put(new Integer(8), "Isolate(CHK-STP)");
        this.ConTypMap = new HashMap<Integer, String>();
        this.ConTypMap.put(new Integer(2), "Point to Point (fabric)");
        this.ConTypMap.put(new Integer(3), "Point to Point");
        this.ConTypMap.put(new Integer(4), "FC-AL (fabric)");
        this.ConTypMap.put(new Integer(5), "FC-AL");
        this.InteruptMap = new HashMap<Integer, String>();
        this.InteruptMap.put(new Integer(0), "Legacy Mode");
        this.InteruptMap.put(new Integer(1), "MSI Mode");
        this.InteruptMap.put(new Integer(2), "MSI-X Mode");
        this.LoggingModeMap = new HashMap<Integer, String>();
        this.LoggingModeMap.put(new Integer(0), "default");
        this.LoggingModeMap.put(new Integer(1), "disable");
        this.FilteringModeMap = new HashMap<Integer, String>();
        this.FilteringModeMap.put(new Integer(0), "none");
        this.FilteringModeMap.put(new Integer(1), "pid");
        this.ReplaceablePortStatus = new ArrayList<Integer>();
        this.ReplaceablePortStatus.add(new Integer(3));
        this.ReplaceablePortStatus.add(new Integer(8));
        this.logger.finest("end");
    }

    public static HFCVMUtilCom getInstance() {
        return instance;
    }

    public static String getHfcmodulename() {
        return "hfcldd";
    }

    public static String getHfcVmhbaNoPrefix() {
        return HfcVmhbaNoPrefix;
    }

    public static int getPortstatuschkstpe() {
        return 8;
    }

    public String getPortStatus(int portStatus) {
        this.logger.finest("called");
        if (this.PortStatusMap.containsKey(portStatus)) {
            return this.PortStatusMap.get(portStatus);
        }
        return "---";
    }

    public String getConnectionType(int connectionType) {
        this.logger.finest("called");
        if (this.ConTypMap.containsKey(connectionType)) {
            return this.ConTypMap.get(connectionType);
        }
        return "-";
    }

    public String getInterruptType(int interruptType) {
        if (this.InteruptMap.containsKey(interruptType)) {
            return this.InteruptMap.get(interruptType);
        }
        return "-";
    }

    public String getLoggingMode(int loggingMode) {
        if (this.LoggingModeMap.containsKey(loggingMode)) {
            return this.LoggingModeMap.get(loggingMode);
        }
        return "-";
    }

    public String getFilteringMode(int filteringMode) {
        if (this.FilteringModeMap.containsKey(filteringMode)) {
            return this.FilteringModeMap.get(filteringMode);
        }
        return "-";
    }

    public static Logger getLogger() {
        return Logger.getLogger("com.hitachi.hfc.vmutil");
    }

    public boolean confirmExecute(String confirmMsg) throws HFCVMUtilInvalidArgException {
        this.logger.finest("start");
        while (true) {
            String res;
            BufferedReader r = new BufferedReader(new InputStreamReader(System.in), 1);
            System.out.println();
            System.out.printf(String.valueOf(confirmMsg) + "(y/n) > ", new Object[0]);
            try {
                res = r.readLine();
            }
            catch (Exception e) {
                this.logger.severe("read input data error:" + e.toString());
                throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_READ_INPUT_DATA, (Throwable)e);
            }
            if (res.equals("y")) {
                System.out.println();
                this.logger.finest("end");
                return true;
            }
            if (res.equals("n")) {
                System.out.println("Canceled.");
                this.logger.finest("end");
                return false;
            }
            System.out.println();
            System.out.println("Invalid input value.");
        }
    }

    public static void printTime() {
        GregorianCalendar c = new GregorianCalendar();
        System.out.printf("Time:%04d/%02d/%02d %02d:%02d:%02d\n", c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13));
    }

    public String getTransReplacement(int portStatus) {
        this.logger.finest("called");
        if (this.ReplaceablePortStatus.contains(new Integer(portStatus))) {
            return "replaceable";
        }
        return "not replaceable";
    }

    public CIMInstance getFCPortInstance(HFCCimClientWrapper pCimClient, int pVmhbaNo) throws HFCCimClientException {
        this.logger.finest("called");
        List<CIMInstance> fcPortList = pCimClient.enumerateInstances(HFCCimClientWrapper.getHfcnamespace(), "HFC_FCPort");
        for (CIMInstance fcPort : fcPortList) {
            UnsignedInteger16 vmhbaNumInt = (UnsignedInteger16)fcPort.getProperty("VmhbaNo").getValue();
            int vmhbaNum = vmhbaNumInt.intValue();
            if (vmhbaNum != pVmhbaNo) continue;
            return fcPort;
        }
        return null;
    }

    public CIMInstance getDriverSIDInstance(HFCCimClientWrapper pCimClient) throws HFCCimClientException {
        this.logger.finest("called");
        int sIDDriverCId = 2;
        List<CIMInstance> sIDList = pCimClient.enumerateInstances(HFCCimClientWrapper.getHfcnamespace(), "HFC_SoftwareIdentity");
        for (CIMInstance sIDIns : sIDList) {
            UnsignedInteger16[] classIDInt = (UnsignedInteger16[])sIDIns.getProperty("Classifications").getValue();
            int classID = classIDInt[0].intValue();
            if (classID != 2) continue;
            return sIDIns;
        }
        return null;
    }

    public void displayInstanceInfo(CIMInstance pFcPort) {
        this.logger.finest("start");
        UnsignedInteger16 vmhbaNumInt = (UnsignedInteger16)pFcPort.getProperty("VmhbaNo").getValue();
        int vmhbaNum = vmhbaNumInt.intValue();
        UnsignedInteger8 minorNoInt = (UnsignedInteger8)pFcPort.getProperty("Minor").getValue();
        int minorNo = minorNoInt.intValue();
        String wwpn = pFcPort.getProperty("PermanentAddress").getValue().toString();
        UnsignedInteger8 portStatusInt = (UnsignedInteger8)pFcPort.getProperty("FCPortStatus").getValue();
        int portStatus = portStatusInt.intValue();
        String portStatusStr = this.getPortStatus(portStatus);
        System.out.println("------------------------------------------------------------");
        System.out.printf("vmhba%d (hfcldd%d)  WWPN: %s  [%s]\n", vmhbaNum, minorNo, wwpn, portStatusStr);
        System.out.println("------------------------------------------------------------");
        this.logger.finest("end");
    }

    public void chkStrValRange(String chkStr, int radix, int valMin, int valMax) throws HFCVMUtilInvalidArgException {
        int val;
        this.logger.finest("start");
        try {
            val = Integer.parseInt(chkStr, radix);
        }
        catch (NumberFormatException e) {
            this.logger.severe(String.valueOf(chkStr) + " is not numeral");
            throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_NUMERAL, (Throwable)e);
        }
        if (val < valMin || val > valMax) {
            this.logger.severe(String.valueOf(val) + " is out of range");
            throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_RANGE);
        }
        this.logger.finest("end");
    }

    public int getVmhbaNo(String pVmhbaStr) throws HFCVMUtilInvalidArgException {
        int vmhbaNoInt;
        this.logger.finest("start");
        if (!pVmhbaStr.matches("vmhba\\d+")) {
            this.logger.severe(String.valueOf(pVmhbaStr) + ":vmhbaNo format err");
            throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_VMHBA);
        }
        String vmhbaNoStr = pVmhbaStr.replaceFirst(HfcVmhbaNoPrefix, "");
        try {
            vmhbaNoInt = Integer.parseInt(vmhbaNoStr);
        }
        catch (NumberFormatException e) {
            this.logger.severe(String.valueOf(vmhbaNoStr) + ":vmhbaNo format err");
            throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_VMHBA, (Throwable)e);
        }
        this.logger.finest("end");
        return vmhbaNoInt;
    }

    public int getMinorNo(String pMinorStr) throws HFCVMUtilOperationException {
        int minorNoInt;
        this.logger.finest("start");
        if (!pMinorStr.matches("hfcldd\\d+")) {
            this.logger.severe("Minor No format error:" + pMinorStr);
            throw new HFCVMUtilOperationException();
        }
        String minorNoStr = pMinorStr.replaceFirst("hfcldd", "");
        try {
            minorNoInt = Integer.parseInt(minorNoStr);
        }
        catch (NumberFormatException e) {
            this.logger.severe("Minor No format error:" + pMinorStr);
            throw new HFCVMUtilOperationException();
        }
        this.logger.finest("end");
        return minorNoInt;
    }

    public void doErrEndProc(HFCWSAPIWrapper pWsApi, HFCCimClientWrapper pCimClient, HFCVMUtilException e) throws HFCVMUtilException {
        this.logger.finest("called");
        try {
            pCimClient.close();
            pWsApi.DisConnect();
            throw e;
        }
        catch (Exception ex) {
            throw e;
        }
    }

    public void doErrEndProc(HFCWSAPIWrapper pWsApi, HFCCimClientWrapper pCimClient, HFCCimClientException e) throws HFCCimClientException {
        this.logger.finest("called");
        try {
            pCimClient.close();
            pWsApi.DisConnect();
            throw e;
        }
        catch (Exception ex) {
            throw e;
        }
    }

    public void doErrEndProc(HFCWSAPIWrapper pWsApi, HFCCimClientWrapper pCimClient, HFCWSAPIException e) throws HFCWSAPIException {
        this.logger.finest("called");
        try {
            pCimClient.close();
            pWsApi.DisConnect();
            throw e;
        }
        catch (Exception ex) {
            throw e;
        }
    }
}

