/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.hfc.vmutil;

import com.hitachi.hfc.CimWrapper.HFCCimClientException;
import com.hitachi.hfc.CimWrapper.HFCCimClientWrapper;
import com.hitachi.hfc.WSWrapper.HFCWSAPIException;
import com.hitachi.hfc.WSWrapper.HFCWSAPIWrapper;
import com.hitachi.hfc.vmutil.HFCVMUtilCom;
import com.hitachi.hfc.vmutil.HFCVMUtilException;
import com.hitachi.hfc.vmutil.HFCVMUtilFunc;
import com.hitachi.hfc.vmutil.HFCVMUtilInvalidArgException;
import com.hitachi.hfc.vmutil.HFCVMUtilInvalidArgExceptionType;
import com.hitachi.hfc.vmutil.HFCVMUtilOperationException;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;

class HFCVMUtilBiosFunc
implements HFCVMUtilFunc {
    private static final int BootPriorityNum = 8;
    private int targetVmhbaNo;
    private boolean dispAllPort = false;
    private CIMObjectPath installServ = null;
    private Boolean bios;
    private Boolean bootPriority;
    private String[] bootDevList;
    private Boolean spinupDelay;
    private Boolean persistentBindings;
    private Boolean forcedDefaultParameter;
    private HFCWSAPIWrapper wsApi;
    private HFCCimClientWrapper cimClient;
    private HFCVMUtilCom vmutilCom;
    private Logger logger = HFCVMUtilCom.getLogger();

    public HFCVMUtilBiosFunc() {
        this.logger.finest("called");
        this.vmutilCom = HFCVMUtilCom.getInstance();
    }

    @Override
    public void checkParam(String[] args, int paramIndex) throws HFCVMUtilInvalidArgException {
        this.logger.finest("start");
        if (args.length != paramIndex + 1) {
            this.logger.severe("param num err:" + args.length);
            throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
        }
        if (args[paramIndex].equals("all")) {
            this.dispAllPort = true;
        } else if (args[paramIndex].matches(String.valueOf(HFCVMUtilCom.getHfcVmhbaNoPrefix()) + "\\d+")) {
            this.targetVmhbaNo = this.vmutilCom.getVmhbaNo(args[paramIndex]);
        } else {
            this.logger.severe("NONE device or all:" + args[paramIndex]);
            throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
        }
        this.logger.finest("end");
    }

    @Override
    public void execCommand(URL pWbemUrl, String pUser, String pPassword, boolean ignorecert) throws HFCVMUtilException, HFCCimClientException, HFCWSAPIException {
        this.logger.finest("start");
        HFCVMUtilCom.printTime();
        this.wsApi = new HFCWSAPIWrapper();
        this.wsApi.Connect(pWbemUrl, pUser, pPassword, ignorecert);
        this.cimClient = new HFCCimClientWrapper(pWbemUrl, pUser, pPassword);
        try {
            if (this.dispAllPort) {
                this.displayBiosAll();
            } else {
                this.displayBiosOne();
            }
        }
        catch (HFCVMUtilException e) {
            this.vmutilCom.doErrEndProc(this.wsApi, this.cimClient, e);
        }
        catch (HFCCimClientException e) {
            this.vmutilCom.doErrEndProc(this.wsApi, this.cimClient, e);
        }
        this.cimClient.close();
        this.wsApi.DisConnect();
        this.logger.finest("end");
    }

    private void displayBiosAll() throws HFCVMUtilOperationException, HFCCimClientException {
        this.logger.finest("start");
        List<CIMInstance> fcPortList = this.cimClient.enumerateInstances(HFCCimClientWrapper.getHfcnamespace(), "HFC_FCPort");
        for (CIMInstance fcPort : fcPortList) {
            this.displayBiosInfo(fcPort);
        }
        this.logger.finest("end");
    }

    private void displayBiosOne() throws HFCVMUtilException, HFCCimClientException {
        this.logger.finest("start");
        CIMInstance fcPort = this.vmutilCom.getFCPortInstance(this.cimClient, this.targetVmhbaNo);
        if (fcPort == null) {
            this.logger.severe(String.valueOf(HFCVMUtilCom.getHfcVmhbaNoPrefix()) + this.targetVmhbaNo + " is not exist");
            throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_NO_VMHBA);
        }
        this.displayBiosInfo(fcPort);
        this.logger.finest("end");
    }

    private void displayBiosInfo(CIMInstance pFcPort) throws HFCVMUtilOperationException, HFCCimClientException {
        this.logger.finest("start");
        this.vmutilCom.displayInstanceInfo(pFcPort);
        this.getBiosInfo(pFcPort);
        if (this.bios.booleanValue()) {
            System.out.println("BIOS                    : enable");
        } else {
            System.out.println("BIOS                    : disable");
        }
        if (this.bootPriority.booleanValue()) {
            System.out.println("Boot Priority           : enable");
        } else {
            System.out.println("Boot Priority           : disable");
        }
        System.out.println("       Target WWN         LUN   Priority");
        System.out.println("-------------------------------------------------");
        int i = 0;
        while (i < this.bootDevList.length) {
            String[] bootDevInfo = this.bootDevList[i].split(":");
            if (bootDevInfo.length != 2) {
                this.logger.severe("BootDeviceList property format error:" + this.bootDevList[i]);
                throw new HFCVMUtilOperationException();
            }
            System.out.printf("   %d   %s   %s", i + 1, bootDevInfo[0], bootDevInfo[1]);
            if (i == 0) {
                System.out.printf("    HIGH\n", new Object[0]);
            } else if (i == this.bootDevList.length - 1) {
                System.out.printf("    LOW\n", new Object[0]);
            } else {
                System.out.printf("\n", new Object[0]);
            }
            ++i;
        }
        if (this.spinupDelay.booleanValue()) {
            System.out.println("Spinup Delay            : enable");
        } else {
            System.out.println("Spinup Delay            : disable");
        }
        if (this.persistentBindings.booleanValue()) {
            System.out.println("Persistent Bindings     : enable");
        } else {
            System.out.println("Persistent Bindings     : disable");
        }
        if (this.forcedDefaultParameter.booleanValue()) {
            System.out.println("Forced Default Parameter: enable");
        } else {
            System.out.println("Forced Default Parameter: disable");
        }
        this.logger.finest("end");
    }

    private void getBiosInfo(CIMInstance pFcPort) throws HFCVMUtilOperationException, HFCCimClientException {
        this.logger.finest("start");
        String minorNo = pFcPort.getProperty("Minor").getValue().toString();
        if (this.installServ == null) {
            List<CIMObjectPath> installServList = this.cimClient.enumerateInstanceNames(HFCCimClientWrapper.getHfcnamespace(), "HFC_SoftwareInstallationService");
            if (installServList.isEmpty()) {
                this.logger.severe("there is no HFC_SoftwareInstallationService instance");
                throw new HFCVMUtilOperationException();
            }
            this.installServ = installServList.get(0);
        }
        CIMArgument[] pInputArg = new CIMArgument[1];
        CIMArgument[] pOutputArg = new CIMArgument[10];
        pInputArg[0] = new CIMArgument("DeviceName", CIMDataType.STRING_T, (Object)minorNo);
        Object retval = this.cimClient.invokeMethod(this.installServ, "GetBootInfo", pInputArg, pOutputArg);
        if (!retval.toString().equals("0")) {
            this.logger.severe("GetBootInfo error:" + retval.toString());
            throw new HFCVMUtilOperationException();
        }
        this.bios = null;
        this.bootPriority = null;
        this.bootDevList = null;
        this.spinupDelay = null;
        this.persistentBindings = null;
        this.forcedDefaultParameter = null;
        CIMArgument[] cIMArgumentArray = pOutputArg;
        int n = pOutputArg.length;
        int n2 = 0;
        while (n2 < n) {
            CIMArgument outArg = cIMArgumentArray[n2];
            if (outArg != null) {
                if (outArg.getName().equals("Bios")) {
                    this.bios = (Boolean)outArg.getValue();
                } else if (outArg.getName().equals("BootPriority")) {
                    this.bootPriority = (Boolean)outArg.getValue();
                } else if (outArg.getName().equals("BootDeviceList")) {
                    this.bootDevList = (String[])outArg.getValue();
                } else if (outArg.getName().equals("SpinupDelay")) {
                    this.spinupDelay = (Boolean)outArg.getValue();
                } else if (outArg.getName().equals("PersistentBindings")) {
                    this.persistentBindings = (Boolean)outArg.getValue();
                } else if (outArg.getName().equals("ForcedDefaultParameter")) {
                    this.forcedDefaultParameter = (Boolean)outArg.getValue();
                }
            }
            ++n2;
        }
        if (this.bios == null || this.bootPriority == null || this.bootDevList == null || this.spinupDelay == null || this.persistentBindings == null || this.forcedDefaultParameter == null) {
            this.logger.severe("Failed to get BIOS info");
            throw new HFCVMUtilOperationException();
        }
        if (this.bootDevList.length != 8) {
            this.logger.severe("Boot Priority num is out of range:" + this.bootDevList.length);
            throw new HFCVMUtilOperationException();
        }
        this.logger.finest("end");
    }
}

