/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.hfc.vmutil;

import com.hitachi.hfc.CimWrapper.HFCCimClientException;
import com.hitachi.hfc.WSWrapper.HFCWSAPIException;
import com.hitachi.hfc.vmutil.HFCVMUtilBiosFunc;
import com.hitachi.hfc.vmutil.HFCVMUtilCom;
import com.hitachi.hfc.vmutil.HFCVMUtilException;
import com.hitachi.hfc.vmutil.HFCVMUtilFirmFunc;
import com.hitachi.hfc.vmutil.HFCVMUtilFunc;
import com.hitachi.hfc.vmutil.HFCVMUtilGeneralFunc;
import com.hitachi.hfc.vmutil.HFCVMUtilHelpFunc;
import com.hitachi.hfc.vmutil.HFCVMUtilInvalidArgException;
import com.hitachi.hfc.vmutil.HFCVMUtilInvalidArgExceptionType;
import com.hitachi.hfc.vmutil.HFCVMUtilInvalidHostInfoFileException;
import com.hitachi.hfc.vmutil.HFCVMUtilIsolateCmdFunc;
import com.hitachi.hfc.vmutil.HFCVMUtilIsolatePortFunc;
import com.hitachi.hfc.vmutil.HFCVMUtilIsolateStatusFunc;
import com.hitachi.hfc.vmutil.HFCVMUtilOperationException;
import com.hitachi.hfc.vmutil.HFCVMUtilPortDefinitionFunc;
import com.hitachi.hfc.vmutil.HFCVMUtilPortFunc;
import com.hitachi.hfc.vmutil.HFCVMUtilTargetFunc;
import com.hitachi.hfc.vmutil.HFCVMUtilTargetScanFunc;
import com.hitachi.hfc.vmutil.HFCVMUtilUpdateFunc;
import java.io.BufferedReader;
import java.io.FileReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HFCVMUtil {
    private static final String CimHostProtocol = "https";
    private static final int CimHostPort = 5989;
    private static final String CimHostInfoFileName = "vmutil.conf";
    private static final String CimHostInfoPathKey = "com.hitachi.hfc.vmutil.confpath";
    private static final String CimHostInfoIpAddrTag = "ipaddr=";
    private static final String CimHostInfoUserTag = "username=";
    private static final String CimHostInfoPwdTag = "password=";
    private static final String CimHostInfoCertTag = "ignorecert=";
    private List<HFCVMUtilFuncTable> FuncTable;
    private String IPaddress = null;
    private String UserName = null;
    private String PassWord = null;
    private boolean ignoreCret = false;
    private Logger logger = HFCVMUtilCom.getLogger();

    private HFCVMUtil() {
        this.logger.finest("start");
        this.FuncTable = new ArrayList<HFCVMUtilFuncTable>();
        this.FuncTable.add(new HFCVMUtilFuncTable(new HFCVMUtilPortDefinitionFunc(), 1, "-pd", null));
        this.FuncTable.add(new HFCVMUtilFuncTable(new HFCVMUtilGeneralFunc(), 1, "-g", null));
        this.FuncTable.add(new HFCVMUtilFuncTable(new HFCVMUtilPortFunc(), 1, "-p", null));
        this.FuncTable.add(new HFCVMUtilFuncTable(new HFCVMUtilFirmFunc(), 1, "-f", null));
        this.FuncTable.add(new HFCVMUtilFuncTable(new HFCVMUtilTargetFunc(), 1, "-t", null));
        this.FuncTable.add(new HFCVMUtilFuncTable(new HFCVMUtilBiosFunc(), 1, "-b", null));
        this.FuncTable.add(new HFCVMUtilFuncTable(new HFCVMUtilUpdateFunc(), 1, "-u", null));
        this.FuncTable.add(new HFCVMUtilFuncTable(new HFCVMUtilIsolateStatusFunc(), 1, "-is", null));
        this.FuncTable.add(new HFCVMUtilFuncTable(new HFCVMUtilIsolatePortFunc(), 2, "-is", "-p"));
        this.FuncTable.add(new HFCVMUtilFuncTable(new HFCVMUtilIsolateCmdFunc(), 2, "-is", "-i"));
        this.FuncTable.add(new HFCVMUtilFuncTable(new HFCVMUtilTargetScanFunc(), 1, "-scan", null));
        this.FuncTable.add(new HFCVMUtilFuncTable(new HFCVMUtilHelpFunc(), 1, "-h", null));
        this.logger.finest("end");
    }

    private void execCommand(String[] args) {
        try {
            this.execComm(args);
        }
        catch (HFCVMUtilException e) {
            System.out.println(e.getErrorMessaage());
            this.logger.log(Level.SEVERE, e.getErrorMessaage(), e);
        }
        catch (HFCCimClientException e) {
            System.out.println(e.getErrorMessaage());
            this.logger.log(Level.SEVERE, e.getErrorMessaage(), e);
        }
        catch (HFCWSAPIException e) {
            System.out.println(e.getErrorMessaage());
            this.logger.log(Level.SEVERE, e.getErrorMessaage(), e);
        }
        catch (Exception e) {
            System.out.println("Operation Failed");
            this.logger.log(Level.SEVERE, "Operation Failed", e);
        }
    }

    private void execComm(String[] args) throws HFCVMUtilException, HFCCimClientException, HFCWSAPIException {
        StringBuilder buff = new StringBuilder(10 * args.length);
        int i = 0;
        while (i < args.length) {
            if (i != 0) {
                buff.append(" ");
            }
            buff.append(args[i]);
            ++i;
        }
        this.logger.info(buff.toString());
        if (args.length == 0) {
            this.logger.severe("param num err:" + args.length);
            throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
        }
        int paramIndex = 0;
        if (args[paramIndex].startsWith("-")) {
            this.readHostInfoFromFile();
        } else {
            if (args.length < 5) {
                this.logger.severe("param num err:" + args.length);
                throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
            }
            this.IPaddress = args[paramIndex];
            this.UserName = args[++paramIndex];
            this.PassWord = args[++paramIndex];
            if (args[++paramIndex].equals("yes")) {
                this.ignoreCret = true;
            } else if (args[paramIndex].equals("no")) {
                this.ignoreCret = false;
            } else {
                this.logger.severe("ignorecert format error");
                throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
            }
            ++paramIndex;
        }
        int i2 = 0;
        while (i2 < this.FuncTable.size()) {
            HFCVMUtilFuncTable funcTable = this.FuncTable.get(i2);
            if (funcTable.getParamNum() == 2 && args.length >= paramIndex + 2 && funcTable.getCmdArg1().equals(args[paramIndex]) && funcTable.getCmdArg2().equals(args[paramIndex + 1]) || funcTable.getParamNum() == 1 && args.length >= paramIndex + 1 && funcTable.getCmdArg1().equals(args[paramIndex]) && (args.length == paramIndex + 1 || !args[paramIndex + 1].startsWith("-"))) {
                URL HostUrl;
                HFCVMUtilFunc cmdFunc = funcTable.getCmdFunc();
                cmdFunc.checkParam(args, paramIndex += funcTable.getParamNum());
                try {
                    HostUrl = new URL(CimHostProtocol, this.IPaddress, 5989, "");
                }
                catch (MalformedURLException e) {
                    this.logger.severe("create URL err:" + e.toString());
                    throw new HFCVMUtilOperationException();
                }
                cmdFunc.execCommand(HostUrl, this.UserName, this.PassWord, this.ignoreCret);
                break;
            }
            ++i2;
        }
        if (i2 == this.FuncTable.size()) {
            this.logger.severe("command name error");
            throw new HFCVMUtilInvalidArgException(HFCVMUtilInvalidArgExceptionType.ERR_PARAM_SYNTAX);
        }
        this.logger.info("Success");
    }

    private void readHostInfoFromFile() throws HFCVMUtilInvalidHostInfoFileException {
        String str;
        this.logger.finest("start");
        String confPath = null;
        try {
            String conDirName = System.getProperty(CimHostInfoPathKey);
            confPath = conDirName != null ? String.valueOf(conDirName) + CimHostInfoFileName : CimHostInfoFileName;
            FileReader fr = new FileReader(confPath);
            BufferedReader br = new BufferedReader(fr);
            str = br.readLine();
            fr.close();
        }
        catch (Exception e) {
            this.logger.severe(String.valueOf(confPath) + " read error");
            throw new HFCVMUtilInvalidHostInfoFileException(confPath, "Read Error", e);
        }
        if (str == null) {
            this.logger.severe(String.valueOf(confPath) + " is empty");
            throw new HFCVMUtilInvalidHostInfoFileException(confPath, "NULL");
        }
        String[] hostInfo = str.split(" ");
        if (hostInfo.length != 4) {
            this.logger.severe(String.valueOf(confPath) + " Format Error:" + str);
            throw new HFCVMUtilInvalidHostInfoFileException(confPath, "Format Error:" + str);
        }
        if (!hostInfo[0].startsWith(CimHostInfoIpAddrTag)) {
            this.logger.severe(String.valueOf(confPath) + " Format Error:ipaddr");
            throw new HFCVMUtilInvalidHostInfoFileException(confPath, "Format Error:ipaddr");
        }
        this.IPaddress = hostInfo[0].substring(CimHostInfoIpAddrTag.length());
        if (!hostInfo[1].startsWith(CimHostInfoUserTag)) {
            this.logger.severe(String.valueOf(confPath) + " Format Error:username");
            throw new HFCVMUtilInvalidHostInfoFileException(confPath, "Format Error:username");
        }
        this.UserName = hostInfo[1].substring(CimHostInfoUserTag.length());
        if (!hostInfo[2].startsWith(CimHostInfoPwdTag)) {
            this.logger.severe(String.valueOf(confPath) + " Format Error:password");
            throw new HFCVMUtilInvalidHostInfoFileException(confPath, "Format Error:password");
        }
        this.PassWord = hostInfo[2].substring(CimHostInfoPwdTag.length());
        if (!hostInfo[3].startsWith(CimHostInfoCertTag)) {
            this.logger.severe(String.valueOf(confPath) + " Format Error:ignorecert");
            throw new HFCVMUtilInvalidHostInfoFileException(confPath, "Format Error:ignorecert");
        }
        String certInfo = hostInfo[3].substring(CimHostInfoCertTag.length());
        if (certInfo.equals("yes")) {
            this.ignoreCret = true;
        } else if (certInfo.equals("no")) {
            this.ignoreCret = false;
        } else {
            this.logger.severe(String.valueOf(confPath) + " Format Error:ignorecert");
            throw new HFCVMUtilInvalidHostInfoFileException(confPath, "Format Error:ignorecert");
        }
        this.logger.finest("end");
    }

    public static void main(String[] args) {
        HFCVMUtil vmutil = new HFCVMUtil();
        vmutil.execCommand(args);
    }

    private class HFCVMUtilFuncTable {
        private HFCVMUtilFunc CmdFunc;
        private int ParamNum;
        private String CmdArg1;
        private String CmdArg2;

        public HFCVMUtilFuncTable(HFCVMUtilFunc pCmdFunc, int pParamNum, String pCmdArg1, String pCmdArg2) {
            this.CmdFunc = pCmdFunc;
            this.ParamNum = pParamNum;
            this.CmdArg1 = pCmdArg1;
            this.CmdArg2 = pCmdArg2;
        }

        public HFCVMUtilFunc getCmdFunc() {
            return this.CmdFunc;
        }

        public int getParamNum() {
            return this.ParamNum;
        }

        public String getCmdArg1() {
            return this.CmdArg1;
        }

        public String getCmdArg2() {
            return this.CmdArg2;
        }
    }
}

