/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.hfc.WSWrapper;

import com.hitachi.hfc.WSWrapper.HFCWSAPIException;
import com.vmware.apputils.version.ExtendedAppUtil;
import com.vmware.vim25.VimPortType;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.apache.axis.MessageContext;
import org.apache.axis.client.Call;
import org.apache.axis.client.Stub;

public class HFCWSAPIWrapper {
    private static final boolean DEBUG = true;
    private static ExtendedAppUtil ecb = null;
    private Logger logger;

    public void PutFilesToHostTmp(String pLocalFilePath, String pName) throws HFCWSAPIException {
        block4: {
            this.logger.finest("start");
            try {
                ArrayList hmorList = ecb.getServiceUtil3().getDecendentMoRefs(null, "HostSystem");
                if (hmorList.get(0) != null) {
                    String serviceUrl = ecb.getServiceUrl();
                    serviceUrl = serviceUrl.substring(0, serviceUrl.lastIndexOf("sdk") - 1);
                    String httpUrl = String.valueOf(serviceUrl) + "/tmp/" + pName;
                    httpUrl = httpUrl.replaceAll("\\ ", "%20");
                    HttpURLConnection conn = this.getHTTPConnection(httpUrl);
                    conn.setRequestProperty("Content-Length", "1024");
                    OutputStream out = conn.getOutputStream();
                    FileInputStream in = new FileInputStream(new File(pLocalFilePath));
                    byte[] buf = new byte[1024];
                    int len = 0;
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    conn.getResponseMessage();
                    conn.disconnect();
                    out.close();
                    break block4;
                }
                this.logger.severe("there is no HostSystem");
                throw new HFCWSAPIException("Upload File Failed");
            }
            catch (Exception e) {
                this.logger.severe("Upload File Failed err:" + e.toString());
                throw new HFCWSAPIException("Upload File Failed", e);
            }
        }
        this.logger.finest("end");
    }

    private HttpURLConnection getHTTPConnection(String urlString) throws Exception {
        this.logger.finest("start");
        String cookieString = this.getCookie();
        HostnameVerifier hv = new HostnameVerifier(){

            @Override
            public boolean verify(String urlHostName, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(hv);
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoOutput(true);
        conn.setRequestProperty("Cookie", cookieString);
        conn.setRequestProperty("Content-Type", "application/octet-stream");
        conn.setRequestProperty("Expect", "100-continue");
        conn.setRequestMethod("PUT");
        this.logger.finest("end");
        return conn;
    }

    private String getCookie() {
        this.logger.finest("start");
        VimPortType test = ecb.getServiceConnection3().getService();
        Stub st = (Stub)test;
        Call callObj = st._getCall();
        MessageContext msgContext = callObj.getMessageContext();
        String cookieString = (String)msgContext.getProperty("Cookie");
        this.logger.finest("end");
        return cookieString;
    }

    public void Connect(URL pWbemUrl, String pUser, String pPassword, boolean ignorecert) throws HFCWSAPIException {
        String[] appArgs;
        this.logger = Logger.getLogger("com.hitachi.hfc.vmutil");
        this.logger.finest("start");
        if (ignorecert) {
            appArgs = new String[8];
            appArgs[6] = "--ignorecert";
            appArgs[7] = "ignorecert";
        } else {
            appArgs = new String[]{"--url", String.valueOf(pWbemUrl.getProtocol()) + "://" + pWbemUrl.getHost() + "/sdk", "--username", pUser, "--password", pPassword};
        }
        System.out.println("Connecting...");
        try {
            ecb = ExtendedAppUtil.initialize("HFCWSAPIWrapper", appArgs);
            ecb.connect();
        }
        catch (Exception e) {
            this.logger.severe("Connection Failed err:" + e.toString());
            throw new HFCWSAPIException("Connection Failed", e);
        }
        System.out.println("Connect OK");
        this.logger.finest("end");
    }

    public void DisConnect() throws HFCWSAPIException {
        this.logger.finest("start");
        try {
            ecb.disConnect();
        }
        catch (Exception e) {
            this.logger.severe("Disconnection Failed err:" + e.toString());
            throw new HFCWSAPIException("Disconnection Failed", e);
        }
        this.logger.finest("end");
    }
}

