/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.hfc.CimWrapper;

import com.hitachi.hfc.CimWrapper.HFCCimClientException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javax.cim.CIMArgument;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.security.auth.Subject;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;
import javax.wbem.client.WBEMClient;
import javax.wbem.client.WBEMClientFactory;
import org.sblim.cimclient.LogAndTraceManager;

public class HFCCimClientWrapper {
    private static final boolean DEBUG = true;
    private static final String HFCNameSPace = "hfccmpi/cimv2";
    private static final String RootNameSPace = "root/interop";
    private WBEMClient client;
    private FileOutputStream cimXmlFr;
    private Logger logger = Logger.getLogger("com.hitachi.hfc.vmutil");

    public static String getHfcnamespace() {
        return HFCNameSPace;
    }

    public static String getRootnamespace() {
        return RootNameSPace;
    }

    public HFCCimClientWrapper(URL pWbemUrl, String pUser, String pPassword) throws HFCCimClientException {
        this.logger.finest("start");
        this.SetCimXmlTraceFile();
        try {
            this.client = WBEMClientFactory.getClient((String)"CIM-XML");
        }
        catch (Exception e) {
            this.logger.severe("cimclient err:getClient:" + e.toString());
            throw new HFCCimClientException("getClient err", e);
        }
        CIMObjectPath path = new CIMObjectPath(pWbemUrl.getProtocol(), pWbemUrl.getHost(), String.valueOf(pWbemUrl.getPort()), null, null, null);
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new UserPrincipal(pUser));
        subject.getPrivateCredentials().add(new PasswordCredential(pPassword));
        try {
            this.client.initialize(path, subject, new Locale[]{Locale.US});
        }
        catch (WBEMException e) {
            this.logger.severe("cimclient err:initialize:" + e.toString());
            throw new HFCCimClientException("initialize err", e);
        }
        this.logger.finest("end");
    }

    public List<CIMObjectPath> enumerateInstanceNames(String pNamespace, String pClassName) throws HFCCimClientException {
        CloseableIterator iterator;
        this.logger.finest("start");
        try {
            iterator = this.client.enumerateInstanceNames(new CIMObjectPath(pClassName, pNamespace));
        }
        catch (WBEMException e) {
            this.logger.severe("cimclient err:enumerateInstanceNames:" + pNamespace + ":" + pClassName + ":" + e.toString());
            throw new HFCCimClientException("enumerateInstanceNames err", e);
        }
        try {
            ArrayList<CIMObjectPath> result = new ArrayList<CIMObjectPath>();
            while (iterator.hasNext()) {
                CIMObjectPath path = (CIMObjectPath)iterator.next();
                result.add(path);
            }
            ArrayList<CIMObjectPath> arrayList = result;
            return arrayList;
        }
        finally {
            iterator.close();
            this.logger.finest("end");
        }
    }

    public List<CIMInstance> enumerateInstances(String pNamespace, String pClassName) throws HFCCimClientException {
        CloseableIterator iterator;
        this.logger.finest("start");
        try {
            iterator = this.client.enumerateInstances(new CIMObjectPath(pClassName, pNamespace), true, false, false, null);
        }
        catch (WBEMException e) {
            this.logger.severe("cimclient err:enumerateInstances:" + pNamespace + ":" + pClassName + ":" + e.toString());
            throw new HFCCimClientException("enumerateInstances err", e);
        }
        try {
            ArrayList<CIMInstance> result = new ArrayList<CIMInstance>();
            while (iterator.hasNext()) {
                CIMInstance instance = (CIMInstance)iterator.next();
                result.add(instance);
            }
            ArrayList<CIMInstance> arrayList = result;
            return arrayList;
        }
        finally {
            iterator.close();
            this.logger.finest("end");
        }
    }

    public List<CIMInstance> associators(CIMObjectPath pObjectName, String pAssociationClass, String pResultClass, String pRole, String pResultRole) throws HFCCimClientException {
        CloseableIterator iterator;
        this.logger.finest("start");
        try {
            iterator = this.client.associators(pObjectName, pAssociationClass, pResultClass, pRole, pResultRole, false, true, null);
        }
        catch (WBEMException e) {
            this.logger.severe("cimclient err:associators:" + pObjectName.toString() + ":" + pAssociationClass + ":" + pResultClass + ":" + pRole + ":" + pResultRole + ":" + e.toString());
            throw new HFCCimClientException("associators err", e);
        }
        try {
            ArrayList<CIMInstance> result = new ArrayList<CIMInstance>();
            while (iterator.hasNext()) {
                CIMInstance path = (CIMInstance)iterator.next();
                result.add(path);
            }
            ArrayList<CIMInstance> arrayList = result;
            return arrayList;
        }
        finally {
            this.logger.finest("end");
            iterator.close();
        }
    }

    public List<CIMInstance> associators(CIMObjectPath pObjectName, String pAssociationClass, String pResultClass) throws HFCCimClientException {
        this.logger.finest("called");
        return this.associators(pObjectName, pAssociationClass, pResultClass, null, null);
    }

    public Object invokeMethod(CIMObjectPath pName, String pMethodName, CIMArgument<?>[] pInputArguments, CIMArgument<?>[] pOutputArguments) throws HFCCimClientException {
        Object retVal;
        this.logger.finest("start");
        try {
            retVal = this.client.invokeMethod(pName, pMethodName, pInputArguments, pOutputArguments);
        }
        catch (WBEMException e) {
            this.logger.severe("cimclient err:invokeMethod:" + pName.toString() + ":" + pMethodName + ":" + e.toString());
            throw new HFCCimClientException("invokeMethod err", e);
        }
        this.logger.finest("end");
        return retVal;
    }

    private void SetCimXmlTraceFile() {
        this.logger.finest("start");
        this.cimXmlFr = null;
        String cimxmlTracing = System.getProperty("sblim.wbem.cimxmlTracing");
        if (cimxmlTracing != null && cimxmlTracing.equals("true")) {
            String xmlLog = null;
            try {
                String xmlLogPath = System.getProperty("com.hitachi.hfc.vmutil.confpath");
                xmlLog = xmlLogPath != null ? String.valueOf(xmlLogPath) + "Cimxml.log" : "Cimxml.log";
                File file = new File(xmlLog);
                this.cimXmlFr = new FileOutputStream(file);
                LogAndTraceManager.getManager().setXmlTraceStream((OutputStream)this.cimXmlFr);
            }
            catch (Exception e) {
                this.logger.severe("create fileoutputstraem err:" + xmlLog + ":" + e.toString());
            }
        }
        this.logger.finest("end");
    }

    public void close() throws HFCCimClientException {
        if (this.cimXmlFr != null) {
            this.logger.finest("start");
            try {
                this.cimXmlFr.close();
            }
            catch (IOException e) {
                this.logger.severe("cimclient err:cimxml tarce file close:" + e.toString());
                throw new HFCCimClientException("cimxml tarce file close err", e);
            }
            this.logger.finest("end");
        }
    }
}

