/* xtouch.c 
 *
 * Copyright (C) 1999 Transmeta Corporation
 *
 * written by Nathan Laredo <nlaredo@transmeta.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* #define SAVE_FILE "/tmp/config/xtouch" */
#define SAVE_FILE "/home/user/.xtouchrc" 
#define OPTION_FILE "/home/user/.xtouch_option"

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/Intrinsic.h>
#include <X11/Xmd.h>
#include <X11/extensions/XTest.h>
#include <X11/extensions/xtestext1.h>

#include <string.h>
// #ifndef XTOUCH_FOR_USA
#include "guide.h"
// #endif

Display *mydisplay;
int myscreen, screen_width, screen_height;
unsigned char tmpbuf[16];

#ifndef XTOUCH_DRIVER_ONLY

Window mycalibrate;
int allow_recalibrate;
unsigned long myforeground, mybackground;
XWindowAttributes attribs;
XEvent myevent;
XFontStruct *font_struct;
GC mygc;
XGCValues gcvals;

#endif /* XTOUCH_DRIVER_ONLY */

struct mk712_packet {
	unsigned int header;
	unsigned int x;
	unsigned int y;
	unsigned int reserved;
};

void init_display(int argc, char **argv)
{
#ifndef XTOUCH_DRIVER_ONLY
	XSetWindowAttributes myattribs;
	XSizeHints myhint;
#endif /* XTOUCH_DRIVER_ONLY */

	if (!getenv("DISPLAY")) {
		fprintf(stderr, "DISPLAY not set.\n");
		exit(1);
	}
	if (!(mydisplay = XOpenDisplay(getenv("DISPLAY")))) {
		fprintf(stderr, "Unable to open display.\n");
		exit(1);
	}
	myscreen = DefaultScreen(mydisplay);
	screen_width = DisplayWidth(mydisplay, myscreen);
	screen_height = DisplayHeight(mydisplay, myscreen);
#ifndef XTOUCH_DRIVER_ONLY
	mybackground = WhitePixel(mydisplay, myscreen);
	myforeground = BlackPixel(mydisplay, myscreen);
	myhint.width = screen_width;
	myhint.height = screen_height;
	myhint.max_width = screen_width;
	myhint.max_height = screen_height;
	myhint.min_width = screen_width;
	myhint.min_height = screen_height;
	myhint.x = myhint.y = 0;
	myhint.flags = PSize | PMinSize | PMaxSize | PPosition;
	myattribs.event_mask = ButtonPressMask | ExposureMask | 
		StructureNotifyMask | VisibilityChangeMask;
	myattribs.background_pixel = mybackground;
	myattribs.override_redirect = True;
	mycalibrate = XCreateWindow(mydisplay, DefaultRootWindow(mydisplay),
		myhint.x, myhint.y, myhint.width, myhint.height, 0,
		attribs.depth, InputOutput, attribs.visual,
		CWEventMask | CWBackPixel | CWOverrideRedirect, &myattribs);
	strcpy(tmpbuf, "xtouch");
	myattribs.event_mask = ButtonPressMask | ExposureMask |
		StructureNotifyMask | VisibilityChangeMask;
	XSetStandardProperties(mydisplay, mycalibrate, tmpbuf, tmpbuf, None,
		argv, argc, &myhint);
	gcvals.foreground = myforeground;
	gcvals.background = mybackground;
	mygc = XCreateGC(mydisplay, mycalibrate, GCForeground | GCBackground,
		&gcvals);
	//font_struct = XLoadQueryFont(mydisplay, "-*-albany amt-*-r-*-*-*-120-*-*-*-*-*-*");
	font_struct = XLoadQueryFont(mydisplay, "fixed");
	XSetFont(mydisplay, mygc, font_struct->fid);

	if (getenv("XTOUCH_RECALIBRATE")) {
		allow_recalibrate = TRUE;
	}
#endif /* XTOUCH_DRIVER_ONLY */
}

#ifndef XTOUCH_DRIVER_ONLY

void event_wait(int eventtype)
{
	while (1) {
		XNextEvent(mydisplay, &myevent);
		if (myevent.type == eventtype) {
			return;
		}
	}
}

char *msg1= "Please Tap Center";
int msg1len = 17;
char *msg2= "of Target";
int msg2len = 9;
void draw_target(int x, int y, int size, int rot, char *below_msg)
{
// #ifndef XTOUCH_FOR_USA
        Pixmap pmMessage;
	int xbmp_org, ybmp_org;
// #endif
	int msglen;

	int k = size / 2, width;
	XFillArc(mydisplay, mycalibrate, mygc,
		x-k, y-k, size, size, (35 + rot)*64, 20*64);
	XFillArc(mydisplay, mycalibrate, mygc,
		x-k, y-k, size, size, (125 + rot)*64, 20*64);
	XFillArc(mydisplay, mycalibrate, mygc,
		x-k, y-k, size, size, (215 + rot)*64, 20*64);
	XFillArc(mydisplay, mycalibrate, mygc,
		x-k, y-k, size, size, (305 + rot)*64, 20*64);
	if (!rot) {	/* non-zero rotation to mark accuracy */
	    // #ifdef XTOUCH_FOR_USA
	    if (strcmp(getenv("LANG"), "ja_JP.eucJP") != 0){
		width = XTextWidth(font_struct, msg1, msg1len);
		XDrawString(mydisplay, mycalibrate, mygc, x - width / 2,
			y - 16 + size * 3 / 4, msg1, msg1len);
		width = XTextWidth(font_struct, msg2, msg2len);
		XDrawString(mydisplay, mycalibrate, mygc, x - width / 2,
			y + size * 3 / 4, msg2, msg2len);

		msglen = strlen(below_msg);
		width = XTextWidth(font_struct, below_msg, msglen);
		XDrawString(mydisplay, mycalibrate, mygc,
			x - width/2, y + 16 +size * 3 / 4,
			below_msg, msglen);
	    }else{	// #else
		xbmp_org = x - (guide_width / 2);
       		ybmp_org = y + (size * 9 / 20);
	        pmMessage = XCreatePixmapFromBitmapData(
			     mydisplay, mycalibrate,
                             guide_bits, guide_width, guide_height,
                             myforeground, mybackground,
                             DefaultDepth (mydisplay, 0));
		XSetFillStyle (mydisplay, mygc, FillTiled);
		XSetTile(mydisplay, mygc, pmMessage);
        	XSetTSOrigin(mydisplay, mygc, xbmp_org, ybmp_org);
		XFillRectangle (mydisplay, mycalibrate, mygc,
                                xbmp_org, ybmp_org, guide_width, guide_height);
		XSetFillStyle (mydisplay, mygc, FillSolid);

		msglen = strlen(below_msg);
		width = XTextWidth(font_struct, below_msg, msglen);
		XDrawString(mydisplay, mycalibrate, mygc,
			x - width/2, ybmp_org + guide_height + 16,
			below_msg, msglen);
	    }	// #endif
	}
	XRaiseWindow(mydisplay, mycalibrate);
	XFlush(mydisplay);	/* force draw */
}
void clear_target(void)
{
	XClearWindow(mydisplay, mycalibrate);
	XRaiseWindow(mydisplay, mycalibrate);
	XFlush(mydisplay);
}

#endif /* XTOUCH_DRIVER_ONLY */

struct mk712_packet *read_data(int fd)
{
	static struct mk712_packet inputbuf;

	if (read(fd, &inputbuf, 16) < 0) {
		fprintf(stderr, "bad mouse data packet\n"
			"buffer contents: %x %x %x %x\n"
			"please report to gulp@transmeta.com\n",
			inputbuf.header, inputbuf.x, inputbuf.y,
			inputbuf.reserved);
		exit(117);
	}
	return &inputbuf;
}

int scale_x(int x, int min, int warp)
{
	int iretx;
	if (x <= min){
		iretx =  0;
	}else{
		iretx = (((x - min) * warp)>>16);
	}

	if (iretx < 1) iretx = 1;
	else if (iretx > screen_width) iretx = screen_width;

	return iretx;
}

int scale_y(int y, int min, int warp)
{
	int irety;
	if (y <= min ){
		irety = screen_height;
	}else{
		irety = (screen_height - (((y - min) * warp)>>16));
	}

	if (irety < 1) irety = 1;
	else if (irety > screen_height) irety = screen_height;

	return irety;
}

#ifndef XTOUCH_DRIVER_ONLY

void average_press(int fd, int *penx, int *peny)
{
	struct mk712_packet *in;
	int x = 0, y = 0, count = 0;
	int pfd;

	if (fd < 0){
		pfd = open("/dev/tscreen", O_RDONLY);
	}else{
		pfd = fd;
	}

	in = read_data(pfd);	/* prime the pump */
	while ((in->header != 1 || count < 3)) {
		if (in->header != 1) {
			/* record only pen down events */
			x += in->x;
			y += in->y;
			count++;
		}
		in = read_data(pfd);
	}
	if (fd < 0){
		close(pfd);
	}
	*penx = x / count;
	*peny = y / count;
}

void do_calibrate(int fd, int *xmax, int *ymax, int *xmin, int *ymin)
{
	int ux, uy, lx, ly, cx, cy, dx, dy, sx, sy;
	int oxmin, oxmax, oymin, oymax;
	int calibrated = 0;
	FILE *save;

	XMapRaised(mydisplay, mycalibrate);
	event_wait(MapNotify);
	while (!calibrated) {
		oxmin = *xmin;
		oxmax = *xmax;
		oymin = *ymin;
		oymax = *ymax;
		clear_target();
		draw_target(100, screen_height - 100, 100, 0, "(1/3)");
		average_press(fd, &lx, &ly);
		clear_target();
		sleep(1);
		draw_target(screen_width - 100, 100, 100, 0, "(2/3)");
		average_press(fd, &ux, &uy);
		clear_target();
		sleep(1);
		draw_target(screen_width / 2, screen_height - 200, 100, 0, "(3/3)");
		average_press(fd, &cx, &cy);
		dx = screen_width - 200;
		dy = screen_height - 200;
                if(ux==lx) ux++;
                if(uy==ly) uy++;
		sx = dx * 65536 / (ux - lx);
		sy = dy * 65536 / (uy - ly);
                if(sx==0) sx=1;
                if(sy==0) sy=1;
		*xmin = (lx * sx - 65536 * 100) / sx;
		*ymin = (ly * sy - 65536 * 100) / sy;
		*xmax = *xmin + (65536 * screen_width / sx);
		*ymax = *ymin + (65536 * screen_height / sy);
		/* if old calibration is sufficiently close, avg it */
		if (abs(oxmin - *xmin) < 80)
			*xmin = (*xmin + oxmin)/2;
		if (abs(oymin - *ymin) < 80)
			*ymin = (*ymin + oymin)/2;
		if (abs(oymax - *ymax) < 80)
			*ymax = (*ymax + oymax)/2;
		if (abs(oxmax - *xmax) < 80)
			*xmax = (*xmax + oxmax)/2;
		/* calculate new scaling factors */
		sx = screen_width * 65536 / (*xmax - *xmin);
		sy = screen_height * 65536 / (*ymax - *ymin);
		cx = scale_x(cx, *xmin, sx);
		cy = scale_y(cy, *ymin, sy);
		draw_target(cx, cy, 50, 45, "");
		sleep(2);	/* allow for visual check of accuracy */
		dx = abs(cx - (screen_width / 2));
		dy = abs(cy - (screen_height - 200));
		/* require at least with 5 pixels */
		if (dx < 8 && dy < 8)
			calibrated++;
	}
	XUnmapWindow(mydisplay, mycalibrate);
	event_wait(UnmapNotify);
	if ((save = fopen(SAVE_FILE, "w")) == NULL) {
		fprintf(stderr, "xtouch: could not save calibration!\n");
		return;
	}
	fprintf(save, "%d %d %d %d\n", *xmax, *ymax, *xmin, *ymin);
	fclose(save);
}

#endif /* XTOUCH_DRIVER_ONLY */

int main(int argc, char **argv)
{
	int pfd, x, y, len;
	int xmax = 0, ymax = 0, xmin = 4096, ymin = 4096;
	int valid = 0, sx = 1, sy = 1, ox = 0, oy = 0; 
	int pendown = 0;
	struct mk712_packet *input;
	FILE *load;

	int f_ignore_unexpect_point;	//1:do, 0orOhter:not do
	int xDelta2p=20, yDelta2p=15;	//expected range between 2 point
	int xDelta3p=40, yDelta3p=30;	//expected range
	int xexpect, yexpect;		//expected point
	int xstack[3], ystack[3];	//[0]:now, [1]:one back, [2]:two back
	int f_is_expect_point[3];	//3:OK(3p) 2:OK(2p), 1:?(1p), 0:NG
	int iNGTouch = 0;		//Touch NG num
	int iMaxNGTouch = 7;		//Max Touch NG num
	int icount;			//Loop count

#ifndef XTOUCH_DRIVER_ONLY
	int strokecount = 0;	/* for recalibrate stroke */
#endif /* XTOUCH_DRIVER_ONLY */

	for (icount = 0; icount < 3 ; icount ++){
		f_is_expect_point[icount]=-1;
		xstack[icount]=-1;
		ystack[icount]=-1;
	}
	
	f_ignore_unexpect_point = 0;
	if ((load = fopen(OPTION_FILE, "r")) != NULL) {
		len = fscanf(load, "%d %d %d %d %d",
			&xDelta2p, &yDelta2p, &xDelta3p, &yDelta3p,
			&iMaxNGTouch);
		fclose(load);
		if (len == 5){
			f_ignore_unexpect_point = 1;
		}
	}

	if ((load = fopen(SAVE_FILE, "r")) != NULL) {
		len = fscanf(load, "%d %d %d %d", &xmax, &ymax, &xmin, &ymin);
		fclose(load);
		if (len < 4) {	 /* we expect at least 4 input items assigned */
			/* set values to insure calibration started */
			xmax = ymax = 0;
			xmin = ymin = 4096;
		}
	}
	if ((pfd = open("/dev/tscreen", O_RDONLY)) < 0) {
		perror("open /dev/tscreen");
		exit(1);
	}
	close(pfd);
	pfd = -1;
	init_display(argc, argv);
	if (xmin < 1500 && ymin < 1500 && xmax > 2500 && ymax > 2500) {
		valid = 1;
	}

	if (!valid) {
#ifndef XTOUCH_DRIVER_ONLY
		do_calibrate(pfd, &xmax, &ymax, &xmin, &ymin);
#else /* XTOUCH_DRIVER_ONLY */
		fprintf(stderr, "no config for touchscreen.\n");
		exit(1);
#endif /* XTOUCH_DRIVER_ONLY */
	}
        if(xmax==xmin) xmax++;
        if(ymax==ymin) ymax++;
	sx = screen_width * 65536 / (xmax - xmin);
	sy = screen_height * 65536 / (ymax - ymin);
	valid++;

	if ((pfd = open("/dev/tscreen", O_RDONLY)) < 0) {
		perror("open /dev/tscreen");
		exit(1);
	}

	input = (struct mk712_packet *) tmpbuf;
	while (1) {
		input = read_data(pfd);

		if (f_ignore_unexpect_point == 1){
		if (input->header != 0){
			if (pendown){
				for (icount=1; icount>=0; icount--){
					x = xstack[icount];
					y = ystack[icount];
					if ((f_is_expect_point[icount] > 1) &&
					    (x != ox || y != oy)){
						XTestFakeMotionEvent(
						mydisplay, myscreen, x, y ,0); 
						XFlush(mydisplay);
						oy = y;
						ox = x;
					}	
				}
			}
			for (icount = 0; icount < 3 ; icount ++){
				f_is_expect_point[icount]=-1;
				xstack[icount]=-1;
				ystack[icount]=-1;
			}
		}
		}

		if (input->header == 1) {
			if (pendown) {
				XTestFakeButtonEvent(mydisplay, 1, 0, 0);
				XFlush(mydisplay);
				pendown = 0;
#ifndef XTOUCH_DRIVER_ONLY
				strokecount = 0;
#endif /* XTOUCH_DRIVER_ONLY */
			}
			continue;
		} else if (input->header != 0)
			continue;	/* something we don't care about */
		x = scale_x(input->x, xmin, sx);
		y = scale_y(input->y, ymin, sy);

		//Check: Is the next point expected?
		if (f_ignore_unexpect_point == 1){
			f_is_expect_point[2] = f_is_expect_point[1];
			f_is_expect_point[1] = f_is_expect_point[0];
			f_is_expect_point[0] = 0;
			xstack[2]=xstack[1];
			xstack[1]=xstack[0];
			xstack[0]=x;
			ystack[2]=ystack[1];
			ystack[1]=ystack[0];
			ystack[0]=y;

			if (f_is_expect_point[2] != -1){
				if ((f_is_expect_point[2] == 3) &&
				    (f_is_expect_point[1] == 3)){
					//Check: between 3 point
					xexpect = 2 * xstack[1] - xstack[2];
					yexpect = 2 * ystack[1] - ystack[2];
					if ((((xexpect - xDelta3p) <= x) &&
					     ((xexpect + xDelta3p) >= x))
					&&  (((yexpect - yDelta3p) <= y) &&
					     ((yexpect + yDelta3p) >= y))){
						f_is_expect_point[0] = 3;
					}else{
						f_is_expect_point[2] = 2;
						f_is_expect_point[1] = 2;
					}
				}else if ((f_is_expect_point[2] == 2) &&
					  (f_is_expect_point[1] == 2)){
					//Check: between 3 point
					xexpect = 2 * xstack[1] - xstack[2];
					yexpect = 2 * ystack[1] - ystack[2];
					if ((((xexpect - xDelta3p) <= x) &&
					     ((xexpect + xDelta3p) >= x))
					&&  (((yexpect - yDelta3p) <= y) &&
					     ((yexpect + yDelta3p) >= y))){
						f_is_expect_point[2] = 3;
						f_is_expect_point[1] = 3;
						f_is_expect_point[0] = 3;
					}
				}else if ((f_is_expect_point[2] == 0) &&
					  (f_is_expect_point[1] == 2)){
					//Check: between 2 point
					if ((((xstack[1] - xDelta2p) <= x) &&
					     ((xstack[1] + xDelta2p) >= x))
					&&  (((ystack[1] - yDelta2p) <= y) &&
					     ((ystack[1] + yDelta2p) >= y))){
						f_is_expect_point[0] = 2;
					}
				}else if ((f_is_expect_point[2] == 2) &&
					  (f_is_expect_point[1] == 0)){
					//Check: between 2 point
					if ((((xstack[2] - 2*xDelta2p) <= x) &&
					     ((xstack[2] + 2*xDelta2p) >= x))
					&&  (((ystack[2] - 2*xDelta2p) <= y) &&
					     ((ystack[2] + 2*yDelta2p) >= y))){
						f_is_expect_point[0] = 2;
					}
				}else if ((f_is_expect_point[2] == 1) &&
					  (f_is_expect_point[1] == 1)){
					//Check: between 3 point
					xexpect = 2 * xstack[1] - xstack[2];
					yexpect = 2 * ystack[1] - ystack[2];
					if ((((xexpect - xDelta3p) <= x) &&
					     ((xexpect + xDelta3p) >= x))
					&&  (((yexpect - yDelta3p) <= y) &&
					     ((yexpect + yDelta3p) >= y))){
						f_is_expect_point[2] = 3;
						f_is_expect_point[1] = 3;
						f_is_expect_point[0] = 3;
					}else
					//Check: between 2 point
					if ((((xstack[2] - 2*xDelta2p) <= x) &&
					     ((xstack[2] + 2*xDelta2p) >= x))
					&&  (((ystack[2] - 2*xDelta2p) <= y) &&
					     ((ystack[2] + 2*yDelta2p) >= y))){
						f_is_expect_point[2] = 2;
						f_is_expect_point[1] = 0;
						f_is_expect_point[0] = 2;
					}else				
					//Check: between 2 point
					if ((((xstack[1] - 2*xDelta2p) <= x) &&
					     ((xstack[1] + 2*xDelta2p) >= x))
					&&  (((ystack[1] - 2*xDelta2p) <= y) &&
					     ((ystack[1] + 2*yDelta2p) >= y))){
						f_is_expect_point[2] = 0;
						f_is_expect_point[1] = 2;
						f_is_expect_point[0] = 2;
					}
				}else{
					f_is_expect_point[0] = 1;
				}
			}else{
				f_is_expect_point[0] = 1;
			}

			if ((f_is_expect_point[2] == 0) ||
			    (f_is_expect_point[2] == 1)){
				iNGTouch++;
			}else{
				iNGTouch = 0;
			}
			if (iNGTouch >= iMaxNGTouch){
				f_is_expect_point[2] = -1;
				f_is_expect_point[1] = -1;
				f_is_expect_point[0] = -1;
			}				
			if (f_is_expect_point[2] > 1){
				x = xstack[2];
				y = ystack[2];	
			}else{
				continue;
			}
		}

		if (x != ox || y != oy) {
			XTestFakeMotionEvent(mydisplay, myscreen,
				x, y, 0);
			if (!pendown) {
				XTestFakeButtonEvent(mydisplay, 1, 1, 0);
				pendown = 1;
			}
			XFlush(mydisplay);
#ifndef XTOUCH_DRIVER_ONLY
			goto skip_recalibrate;
			/* top of screen left to right stroke: recalibrate */
			if (ox < x && y < 40) {
				if (++strokecount > 60) {
					/* dummy to wait for release */
					average_press(pfd, &valid, &valid);
					if (allow_recalibrate) {
						do_calibrate(pfd, &xmax, &ymax,
							&xmin, &ymin);
                                                if(xmax==xmin) xmax++;
                                                if(ymax==ymin) ymax++;
						sx = screen_width * 65536 /
							(xmax - xmin);
						sy = screen_height * 65536 /
							(ymax - ymin);
					}
					strokecount = 0;
				}
			} else
				strokecount = 0;
skip_recalibrate:
			oy = y;
			ox = x;
#endif /* XTOUCH_DRIVER_ONLY */
		}
	}
	XCloseDisplay(mydisplay);
	exit(0);
}
