/*
 * Copyright (C) 2000  Transmeta Corporation
 *
 * written by Daniel Quinlan <quinlan@transmeta.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>

struct mk712_packet {
        unsigned int header;
        unsigned int x;
        unsigned int y;
        unsigned int reserved;
};

int main (int argc, char **argv) {
  int pfd;
  int len;
  unsigned char tmpbuf[16];
  struct mk712_packet *in;

  if (argc > 1) {
    if ((pfd = open(argv[1], O_RDONLY)) < 0) {
      fprintf(stderr, "%s: ", argv[1]);
      perror("open failed");
      exit(1);
    }
  }
  else if ((pfd = open("/dev/tscreen", O_RDONLY)) < 0) {
    perror("/dev/tscreen: open failed");
    exit(1);
  }

  in = malloc(16);

  for (;;) {
    len = read(pfd, tmpbuf, 16);
    in = (struct mk712_packet *) tmpbuf;
    if (len < 16) {
      fprintf(stderr, "bad mouse data packet, only got %d bytes\n", len);
      fprintf(stderr, "buffer contents: %x %x %x %x\n",
	      in->header, in->x, in->y, in->reserved);
      exit(1);
      break;
    }
    printf("%d %d %d %d\n", in->header, in->x, in->y, in->reserved);
  }
  return(0);
}
