/***********************************************************/
/* Copyright (C) Hitachi, Ltd. 2000. All rights reserved.  */
/* Purpose: check INTERNET button push                     */
/* return : 0 = button push                                */
/*          1 = button release                             */
/*         -1 = error occured                              */
/* history: 2000/11/29 T.Arai (first release)              */
/***********************************************************/
#undef PRINT_MESSAGE_FOR_MESSAGE

#ifdef PRINT_MESSAGE_FOR_MESSAGE
#include<stdio.h>
#define debug_print(message)	printf(message);
#else
#define debug_print(message)
#endif
#include<unistd.h>
#include<sys/io.h>

int main(int argc, char **argv)
{
  long data;
  int f_arg_error = 0;

  /* I/O Port Access OK? */
  f_arg_error = iopl(3);
  if (f_arg_error != 0){
    debug_print("iopl error! You must be super user!!\n");
    exit(-1);
  }

  /* WRITE TO CONFIG_ADDRESS REGISTER (0xCF8) */ 
  outl(0x80008898,0xCF8);/*bit=1|000,0000|0000,0000|1000,1|000|1001,10|00*/
  /* for WAIT */ 
  outb(0x00,0xED);
  /* READ FROM CONFIG_DATA REGISTER (0xCFC) */ 
  data=inl(0xCFC);

  /*Get Button State*/
#ifdef BUTTON_MAIL
  /*Get RUN_ENT18/EGPI02 for MAIL Button */
  data=data&0x000000400;
#endif
#ifdef BUTTON_INTERNET
  /*Get RUN_ENT19/EGPI03 for INTERNET Button */
  data=data&0x000000800;
#endif
#ifdef BUTTON_P1
  /*Get RUN_ENT20/EGPI04 for P1 Button */
  data=data&0x000001000;
#endif

  if (data == 0){
    debug_print("Detect Button Push!\n");
    exit(0);
  }else{
    debug_print("Detect Button Release!\n");
    exit(1);
  }

}

